---
generated_at: 2026-01-22 21:25:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.diagnosis 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：45 / 45、根拠なし：0
- 優先レビュー（高）
  1. **権限チェック関連テスト（UT-JDIAG-036, 038, 044）**：Jenkins権限モデルの理解確認
  2. **ファイルスキャンロジック（UT-JDIAG-016-018）**：Jenkins所有判定の重要ロジック
  3. **OS依存処理（UT-JDIAG-003, 004）**：実行環境による挙動差異

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/diagnosis/HsErrPidList.java`
- E-02: `core/src/main/java/jenkins/diagnosis/HsErrPidFile.java`
- E-03: `core/src/main/java/jenkins/diagnosis/MemoryUsageMonitorAction.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### HsErrPidListクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユニットテスト環境ではスキャンがスキップされる | E-01 (L50-52): `if (Functions.getIsUnitTest()) { return; }` | ○ |
| C-02 | デフォルトパス ./hs_err_pid%p.log がスキャンされる | E-01 (L60): `scan("./hs_err_pid%p.log");` | ○ |
| C-03 | Windows環境で一時ディレクトリがスキャンされる | E-01 (L61-65): `if (Functions.isWindows()) { ... Kernel32Utils.getTempDir() ... }` | ○ |
| C-04 | 非Windows環境で /tmp がスキャンされる | E-01 (L66-68): `else { scan("/tmp/hs_err_pid%p.log"); }` | ○ |
| C-05 | -XX:ErrorFile オプションで指定されたパスがスキャンされる | E-01 (L72-77): `if (a.startsWith(ERROR_FILE_OPTION)) { scan(a.substring(...)); }` | ○ |
| C-06 | UnsupportedOperationException は無視される | E-01 (L78-79): `catch (UnsupportedOperationException e) { // ignore }` | ○ |
| C-07 | その他の例外はログ出力される | E-01 (L80-82): `catch (Throwable e) { LOGGER.log(Level.WARNING, ...); }` | ○ |
| C-08 | getDisplayName() は Messages から値を返す | E-01 (L87): `return Messages.HsErrPidList_DisplayName();` | ○ |
| C-09 | getFiles() は files リストを返す | E-01 (L94-96): `return files;` | ○ |
| C-10 | scan() で %p が * に置換される | E-01 (L102): `pattern = pattern.replace("%p", "*")...` | ○ |
| C-11 | scan() で %% が % に置換される | E-01 (L102): `...replace("%%", "%");` | ○ |
| C-12 | ワイルドカードなしパターンで scanFile() が直接呼ばれる | E-01 (L104-105): `if (!pattern.contains("*")) scanFile(f);` | ○ |
| C-13 | GLOB パターンで DirectoryScanner が使用される | E-01 (L106-121): `else { ... DirectoryScanner ds = fs.getDirectoryScanner(...); ... }` | ○ |
| C-14 | 共通親が見つからない場合に警告ログが出力される | E-01 (L111-114): `if (commonParent == null) { LOGGER.warning(...); return; }` | ○ |
| C-15 | scanFile() で有効なファイルが files に追加される | E-01 (L139-141): `if (line.contains(secretKey)) { files.add(...); return; }` | ○ |
| C-16 | ヘッダーが見つからないファイルは追加されない | E-01 (L130-131): `if (!findHeader(r)) return;` | ○ |
| C-17 | secret.key パスを含まないファイルは追加されない | E-01 (L137-143): while ループで secretKey を検索、見つからなければ return なし | ○ |
| C-18 | IOException 発生時に FINE レベルでログ出力される | E-01 (L144-147): `catch (IOException ... e) { LOGGER.log(Level.FINE, ...); }` | ○ |
| C-19 | InvalidPathException 発生時に FINE レベルでログ出力される | E-01 (L144-147): `catch (... InvalidPathException e) { LOGGER.log(Level.FINE, ...); }` | ○ |
| C-20 | getSecretKeyFile() は Jenkins ルート配下の secret.key を返す | E-01 (L150-152): `return new File(Jenkins.get().getRootDir(), "secret.key");` | ○ |
| C-21 | findHeader() で有効なヘッダーが見つかれば true を返す | E-01 (L158-160): `if (line.startsWith("# A fatal error...")) return true;` | ○ |
| C-22 | findHeader() でヘッダーが見つからなければ false を返す | E-01 (L162): `return false;` | ○ |
| C-23 | findHeader() は最初の5行のみチェックする | E-01 (L155): `for (int i = 0; i < 5; i++)` | ○ |
| C-24 | isActivated() は files が空でなければ true を返す | E-01 (L166-168): `return !files.isEmpty();` | ○ |

### HsErrPidFileクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | コンストラクタで owner と file が設定される | E-02 (L22-25): `this.owner = owner; this.file = file;` | ○ |
| C-26 | getName() は file.getName() を返す | E-02 (L27-29): `return file.getName();` | ○ |
| C-27 | getPath() は file.getPath() を返す | E-02 (L31-33): `return file.getPath();` | ○ |
| C-28 | getLastModified() は file.lastModified() を返す | E-02 (L35-37): `return file.lastModified();` | ○ |
| C-29 | getLastModifiedDate() は Date オブジェクトを返す | E-02 (L39-41): `return new Date(file.lastModified());` | ○ |
| C-30 | getTimeSpanString() は経過時間文字列を返す | E-02 (L43-45): `return Util.getTimeSpanString(System.currentTimeMillis() - getLastModified());` | ○ |
| C-31 | doDownload() は ADMINISTER 権限をチェックする | E-02 (L48): `Jenkins.get().checkPermission(Jenkins.ADMINISTER);` | ○ |
| C-32 | doDownload() は staticResource を返す | E-02 (L49): `return HttpResponses.staticResource(file);` | ○ |
| C-33 | doDelete() は ADMINISTER 権限をチェックする | E-02 (L54): `Jenkins.get().checkPermission(Jenkins.ADMINISTER);` | ○ |
| C-34 | doDelete() は Files.deleteIfExists() を使用する | E-02 (L55): `Files.deleteIfExists(Util.fileToPath(file));` | ○ |
| C-35 | doDelete() は owner.files から自身を削除する | E-02 (L56): `owner.files.remove(this);` | ○ |
| C-36 | doDelete() は上位へリダイレクトする | E-02 (L57): `return HttpResponses.redirectTo("../..");` | ○ |
| C-37 | doDelete() は @RequirePOST アノテーションを持つ | E-02 (L52): `@RequirePOST` | ○ |

### MemoryUsageMonitorActionクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | getUrlName() はクラス名を返す | E-03 (L45-47): `return MemoryUsageMonitorAction.class.getName();` | ○ |
| C-39 | getHeap() は SYSTEM_READ または MANAGE 権限をチェックする | E-03 (L50): `Jenkins.get().checkAnyPermission(Jenkins.SYSTEM_READ, Jenkins.MANAGE);` | ○ |
| C-40 | getHeap() は MemoryUsageMonitor.heap を返す | E-03 (L51): `return ExtensionList.lookupSingleton(MemoryUsageMonitor.class).heap;` | ○ |
| C-41 | クラスは @Extension アノテーションを持つ | E-03 (L41): `@Extension` | ○ |
| C-42 | クラスは @Restricted(NoExternalUse.class) アノテーションを持つ | E-03 (L42): `@Restricted(NoExternalUse.class)` | ○ |
| C-43 | クラスは InvisibleAction を継承する | E-03 (L43): `extends InvisibleAction` | ○ |
| C-44 | クラスは RootAction を実装する | E-03 (L43): `implements RootAction` | ○ |
| C-45 | @since 2.505 で追加された機能である | E-03 (L39): `@since 2.505` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードから直接根拠を確認できました。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードに明確に対応しており、信頼度は高い

### 特記事項
1. **OS依存処理**: Windows/非Windows の分岐処理があるため、クロスプラットフォームでのテスト実行が推奨される
2. **権限モデル**: Jenkins.ADMINISTER, Jenkins.SYSTEM_READ, Jenkins.MANAGE の権限チェックがあり、セキュリティテストとして重要
3. **ファイルシステム操作**: 実ファイルへのアクセスがあるため、テスト時のモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] HsErrPidList のコンストラクタにおける例外ハンドリングパターンが適切か確認
- [ ] OS依存処理（Windows/非Windows分岐）のテストカバレッジが十分か確認
- [ ] 権限チェック（ADMINISTER, SYSTEM_READ, MANAGE）のテストケースが漏れなく定義されているか確認
- [ ] ファイルI/O操作における例外ケースが網羅されているか確認
- [ ] findHeader() の5行制限の境界値テストが適切か確認
- [ ] MemoryUsageMonitorAction の Extension 連携テストが適切か確認
