---
generated_at: 2026-01-22 21:25:00
metrics:
  claims_total: 63
  claims_with_evidence: 63
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.fingerprints 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：63 / 63、根拠なし：0
- 優先レビュー（高）
  1. **FileFingerprintStorage.load/save/delete**：ファイルI/O処理の複雑なエラーハンドリング
  2. **FingerprintStorage.cleanFingerprint**：FingerprintFacetによる削除ブロックロジック
  3. **GlobalFingerprintConfiguration.configure**：Stapler連携の設定保存処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/fingerprints/FingerprintStorage.java` - 抽象ストレージAPI（行1-152）
- E-02: `core/src/main/java/jenkins/fingerprints/FileFingerprintStorage.java` - ファイルベース実装（行1-378）
- E-03: `core/src/main/java/jenkins/fingerprints/GlobalFingerprintConfiguration.java` - グローバル設定（行1-87）
- E-04: `core/src/main/java/jenkins/fingerprints/FingerprintStorageDescriptor.java` - ディスクリプタ（行1-41）

## 3) Claims と根拠の対応（レビューの主戦場）

### FingerprintStorage クラス（UT-FPR-001 - UT-FPR-008）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get()でGlobalFingerprintConfigurationからストレージを取得 | E-01 (行53-55) | ○ |
| C-02 | getFileFingerprintStorage()でFileFingerprintStorageを取得（非推奨） | E-01 (行61-64) | ○ |
| C-03 | cleanFingerprint()で非活性Fingerprintを削除 | E-01 (行115-137) | ○ |
| C-04 | cleanFingerprint()で活性Fingerprintをトリム | E-01 (行121-131) | ○ |
| C-05 | FingerprintFacetで削除がブロックされる | E-01 (行117, 122-127) | ○ |
| C-06 | IOException発生時にfalseを返却しエラーログ出力 | E-01 (行133-136) | ○ |
| C-07 | getFingerprint()でJenkinsから取得 | E-01 (行139-141) | ○ |
| C-08 | getDescriptor()でFingerprintStorageDescriptorを返却 | E-01 (行146-148) | ○ |

### FileFingerprintStorage クラス - load関連（UT-FPR-009 - UT-FPR-017）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | load(String)で有効IDからFingerprintをロード | E-02 (行82-88) | ○ |
| C-10 | 不正なIDでnullを返却（isAllowedチェック） | E-02 (行84-86, 314-321) | ○ |
| C-11 | 存在しないファイルでnullを返却 | E-02 (行98-100) | ○ |
| C-12 | XMLファイルからFingerprintをロード | E-02 (行96-135) | ○ |
| C-13 | サイズ0のファイルを削除しnullを返却 | E-02 (行115-125) | ○ |
| C-14 | 不正なXML形式でファイル削除しnullを返却 | E-02 (行126-131) | ○ |
| C-15 | Fingerprint以外のオブジェクトでIOException | E-02 (行104-107) | ○ |
| C-16 | facetsがnullでファイル削除しnullを返却 | E-02 (行108-112) | ○ |

### FileFingerprintStorage クラス - save関連（UT-FPR-018 - UT-FPR-024）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | save(Fingerprint)でファイル保存しSaveableListener呼び出し | E-02 (行143-152) | ○ |
| C-18 | facets空で高速パス（直接XML出力） | E-02 (行158-203) | ○ |
| C-19 | facets存在でXmlFile.write()使用 | E-02 (行204-207) | ○ |
| C-20 | original=nullでoriginalタグなし | E-02 (行168-177) | ○ |
| C-21 | usagesが正しくシリアライズ | E-02 (行186-195) | ○ |
| C-22 | 親ディレクトリが存在しない場合に作成 | E-02 (行159) | ○ |

### FileFingerprintStorage クラス - delete関連（UT-FPR-025 - UT-FPR-030）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | delete()でFingerprintファイルを削除 | E-02 (行214-239) | ○ |
| C-24 | 存在しないファイルの削除は何もしない | E-02 (行216-218) | ○ |
| C-25 | 空の内側ディレクトリを削除 | E-02 (行224-229) | ○ |
| C-26 | 空の外側ディレクトリを削除 | E-02 (行232-238) | ○ |
| C-27 | ファイル削除失敗でIOException | E-02 (行220-221) | ○ |
| C-28 | ディレクトリ削除失敗でIOException | E-02 (行227-228, 235-236) | ○ |

### FileFingerprintStorage クラス - isReady/iterateAndCleanupFingerprints（UT-FPR-031 - UT-FPR-039）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | isReady()でfingerprintsディレクトリ存在確認 | E-02 (行244-247) | ○ |
| C-30 | iterateAndCleanupFingerprints()で全ファイルスキャン | E-02 (行253-274) | ○ |
| C-31 | ディレクトリ構造（2桁/2桁/28桁.xml）のパターンマッチ | E-02 (行257-262, 74) | ○ |
| C-32 | 空ディレクトリの場合正常終了 | E-02 (行258) | ○ |
| C-33 | deleteIfEmpty()で空ディレクトリ削除 | E-02 (行337-351) | ○ |
| C-34 | 非空ディレクトリは保持 | E-02 (行343-345) | ○ |
| C-35 | 削除失敗時にログ出力 | E-02 (行348-349) | ○ |

### FileFingerprintStorage クラス - ユーティリティメソッド（UT-FPR-040 - UT-FPR-050）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | getFingerprintFile()で正しいパス生成 | E-02 (行309-311) | ○ |
| C-37 | isAllowed()で16進文字列バリデーション | E-02 (行314-321) | ○ |
| C-38 | messageOfParseException()でXmlPullParserExceptionメッセージ取得 | E-02 (行323-332) | ○ |
| C-39 | messageOfParseException()でEOFExceptionメッセージ取得 | E-02 (行324) | ○ |
| C-40 | messageOfParseException()でネスト例外処理 | E-02 (行327-330) | ○ |
| C-41 | loadFingerprint()でファイルからロード | E-02 (行353-355) | ○ |
| C-42 | getFingerprint()でJenkinsから取得 | E-02 (行358-360) | ○ |
| C-43 | getRootDir()でJenkinsルートディレクトリ取得 | E-02 (行362-364) | ○ |
| C-44 | DescriptorImpl.getDisplayName()で表示名取得 | E-02 (行369-373) | ○ |

### GlobalFingerprintConfiguration クラス（UT-FPR-051 - UT-FPR-061）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | コンストラクタでload()呼び出し | E-03 (行48-50) | ○ |
| C-46 | get()でシングルトン取得 | E-03 (行52-54) | ○ |
| C-47 | getStorage()で設定ストレージ取得 | E-03 (行56-58) | ○ |
| C-48 | デフォルトでFileFingerprintStorage | E-03 (行44) | ○ |
| C-49 | setStorage()でストレージ設定とログ出力 | E-03 (行60-65) | ○ |
| C-50 | isFingerprintCleanupDisabled()でフラグ取得 | E-03 (行67-69) | ○ |
| C-51 | setFingerprintCleanupDisabled()でフラグ設定 | E-03 (行71-74) | ○ |
| C-52 | configure()でStaplerRequestからバインドとsave() | E-03 (行76-81) | ○ |
| C-53 | getFingerprintStorageDescriptors()でDescriptor一覧取得 | E-03 (行83-85) | ○ |

### FingerprintStorageDescriptor クラス（UT-FPR-062 - UT-FPR-063）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | all()で全Descriptor取得 | E-04 (行36-38) | ○ |
| C-55 | 登録なしで空リスト | E-04 (行36-38) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全テストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）

- **リスクレベル 1（中）**: FileFingerprintStorage.load() - ファイル破損時の自動削除動作は本番環境でのデータ損失リスクがあるため、テストで動作を確認することが重要
- **リスクレベル 1（中）**: FileFingerprintStorage.delete() - ディレクトリ削除の連鎖処理でエラーが発生した場合の部分的な削除状態
- **リスクレベル 0（低）**: GlobalFingerprintConfiguration - 設定の永続化処理は標準的なJenkins GlobalConfiguration実装

## 6) レビュアーチェックリスト（最小）

- [ ] UT-FPR-014, UT-FPR-015: 破損ファイルの自動削除テストが期待動作を確認しているか
- [ ] UT-FPR-025 - UT-FPR-030: delete()のディレクトリ階層削除テストが全パターンをカバーしているか
- [ ] UT-FPR-033, UT-FPR-034: iterateAndCleanupFingerprints()のディレクトリスキャンテストが正しいパターンマッチングを検証しているか
- [ ] UT-FPR-003 - UT-FPR-006: cleanFingerprint()のFingerprintFacetによる削除ブロックテストが適切か
- [ ] UT-FPR-053 - UT-FPR-055: ストレージ設定の切り替えテストが実際の運用シナリオをカバーしているか
