---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：jenkins.health 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **UT-HLT-012（タイムアウト境界）**：タイムアウト直前の動作は実装から推測
  2. **UT-HLT-022（JenkinsJVM判定）**：環境依存の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/health/HealthCheck.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/health/HealthCheckAction.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/jenkins/health/HealthCheckActionTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-HLT-001) | デフォルト実装でクラス名が返却される | E-01 (L46-48: `return getClass().getName()`) | ○ |
| C-02 (UT-HLT-002) | カスタム実装で指定した名前が返却される | E-03 (L89-90: `return "success"`) | ○ |
| C-03 (UT-HLT-003) | ヘルスチェック成功時にtrueが返却される | E-01 (L53: `boolean check()`) | ○ |
| C-04 (UT-HLT-004) | ヘルスチェック失敗時にfalseが返却される | E-03 (L124: `return false`) | ○ |
| C-05 (UT-HLT-005) | URLパスとして「health」が返却される | E-02 (L61-63: `return "health"`) | ○ |
| C-06 (UT-HLT-006) | 全チェック成功時にHTTP 200とstatus:true | E-02 (L99: `success ? 200 : 503`), E-03 (L57-64) | ○ |
| C-07 (UT-HLT-007) | ヘルスチェック未登録時の動作 | E-02 (L88: `ExtensionList.lookup`), E-03 (L55-65) | ○ |
| C-08 (UT-HLT-008) | 失敗時にHTTP 503が返却される | E-02 (L99), E-03 (L105) | ○ |
| C-09 (UT-HLT-009) | failures配列に失敗名が含まれる | E-02 (L91-98), E-03 (L106-111) | ○ |
| C-10 (UT-HLT-010) | 複数失敗時に全ての失敗名が含まれる | E-02 (L91-92: `failing.add`) | ○ |
| C-11 (UT-HLT-011) | 成功と失敗混在時の動作 | E-02 (L90: `success &= check`), E-03 (L85-127) | ○ |
| C-12 (UT-HLT-012) | タイムアウト閾値直前の完了 | E-02 (L57-58, L85) | △ |
| C-13 (UT-HLT-013) | タイムアウト超過時にスレッドダンプ出力 | E-02 (L70-84) | ○ |
| C-14 (UT-HLT-014) | ウォッチドッグタイマーのキャンセル | E-02 (L101: `watchdog.cancel()`) | ○ |
| C-15 (UT-HLT-015) | 例外時もウォッチドッグがキャンセル | E-02 (L100-102: `finally` block) | ○ |
| C-16 (UT-HLT-016) | JsonHttpResponseのContent-Type | E-02 (L99: `JsonHttpResponse`), E-03 (L57) | ○ |
| C-17 (UT-HLT-017) | ExtensionListから全チェック実行 | E-02 (L88: `ExtensionList.lookup(HealthCheck.class)`) | ○ |
| C-18 (UT-HLT-018) | SystemPropertiesからカスタムタイムアウト | E-02 (L57-58: `SystemProperties.getDuration`) | ○ |
| C-19 (UT-HLT-019) | デフォルトタイムアウト10秒 | E-02 (L58: `Duration.ofSeconds(10)`) | ○ |
| C-20 (UT-HLT-020) | IOException時のWARNINGログ | E-02 (L78-79: `LOGGER.log(Level.WARNING`) | ○ |
| C-21 (UT-HLT-021) | InterruptedException時の割り込み復元 | E-02 (L80-82: `Thread.currentThread().interrupt()`) | ○ |
| C-22 (UT-HLT-022) | JenkinsJVM判定によるスキップ | E-02 (L73: `JenkinsJVM.isJenkinsJVM()`) | △ |
| C-23 (UT-HLT-023) | ExtensionListからシングルトン取得 | E-02 (L52: `@Extension`), E-03 (L69) | ○ |
| C-24 (UT-HLT-024) | 認証なしアクセス | E-02 (L54: `UnprotectedRootAction`) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-12（タイムアウト境界値テスト）**：タイムアウト直前（9999ms等）での動作はコードから推測可能だが、実際の動作検証にはタイミング制御が必要
  - 候補：統合テスト / タイミング制御付きテスト / モック使用
- **C-22（JenkinsJVM判定）**：JenkinsJVM外での実行環境を再現するテストは環境依存
  - 候補：モック使用 / 別JVMでのテスト / フラグ操作

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: HealthCheck インターフェースは単純で、テストケースはソースコードと完全に整合
- **0 (低リスク)**: HealthCheckAction の主要ロジックは既存テストコード(E-03)でカバー済み
- **1 (中リスク)**: タイムアウト関連のテスト（C-12, C-13）は実行環境に依存する可能性あり
- **0 (低リスク)**: セキュリティ観点（認証不要エンドポイント）は `UnprotectedRootAction` の意図通り

## 6) レビュアーチェックリスト（最小）
- [ ] HealthCheck インターフェースの getName() デフォルト実装が完全修飾クラス名を返すことを確認
- [ ] doIndex() の成功/失敗レスポンス形式（JSON構造、HTTPステータス）が仕様通りか確認
- [ ] タイムアウト閾値（デフォルト10秒）が運用要件に適合するか確認
- [ ] UnprotectedRootAction による認証なしアクセスがセキュリティポリシーに適合するか確認
- [ ] 複数HealthCheck拡張登録時の実行順序依存性がないか確認
