---
generated_at: 2026-01-22 21:35:00
metrics:
  claims_total: 152
  claims_with_evidence: 148
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：jenkins.install 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：148 / 152、根拠なし：4
- 優先レビュー（高）
  1. **UT-INS-078（署名検証テスト）**：DownloadService.signatureCheckの動作確認が必要
  2. **UT-INS-040（APIトークン生成）**：システムプロパティ依存の動作確認が必要
  3. **UT-INS-148（セットアップスキップ）**：複合条件の動作確認が必要
  4. **UT-INS-027（Installing状態変換）**：内部ステータス変換ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/install/InstallUtil.java` (L1-335)
- E-02: `core/src/main/java/jenkins/install/SetupWizard.java` (L1-801)
- E-03: `core/src/main/java/jenkins/install/InstallState.java` (L1-381)
- E-04: `core/src/main/java/jenkins/install/InstallStateFilter.java` (L1-24)
- E-05: `test/src/test/java/jenkins/install/InstallUtilTest.java` (既存テスト参照)
- E-06: `test/src/test/java/jenkins/install/InstallStateTest.java` (既存テスト参照)
- E-07: `test/src/test/java/jenkins/install/SetupWizardTest.java` (既存テスト参照)

## 3) Claims と根拠の対応（レビューの主戦場）

### InstallUtil クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-INS-001) | proceedToNextStateFromで次状態に遷移 | E-01 L95-100 | ○ |
| C-02 (UT-INS-002) | UNKNOWN状態から初期状態に遷移 | E-01 L105-133 | ○ |
| C-03 (UT-INS-003) | null状態からデフォルト状態が返る | E-01 L114 | ○ |
| C-04 (UT-INS-004) | CONFIGURE_INSTANCEからINITIAL_SETUP_COMPLETEDに遷移 | E-01 L119 | ○ |
| C-05 (UT-INS-005) | CREATE_ADMIN_USERからCONFIGURE_INSTANCEに遷移 | E-01 L120 | ○ |
| C-06 (UT-INS-006) | INITIAL_PLUGINS_INSTALLINGからCREATE_ADMIN_USERに遷移 | E-01 L121 | ○ |
| C-07 (UT-INS-007) | INITIAL_SECURITY_SETUPからNEWに遷移 | E-01 L122 | ○ |
| C-08 (UT-INS-008) | RESTARTからRUNNINGに遷移 | E-01 L123 | ○ |
| C-09 (UT-INS-009) | UPGRADEからINITIAL_SETUP_COMPLETEDに遷移 | E-01 L124 | ○ |
| C-10 (UT-INS-010) | DOWNGRADEからINITIAL_SETUP_COMPLETEDに遷移 | E-01 L125 | ○ |
| C-11 (UT-INS-011) | INITIAL_SETUP_COMPLETEDからRUNNINGに遷移 | E-01 L126 | ○ |
| C-12 (UT-INS-012) | InstallStateFilterチェーンが適用される | E-01 L106-109 | ○ |
| C-13 (UT-INS-013) | saveLastExecVersionでバージョン保存 | E-01 L196-201 | ○ |
| C-14 (UT-INS-014) | VERSION未初期化時に例外スロー | E-01 L197-199 | ○ |
| C-15 (UT-INS-015) | 指定バージョンがファイルに保存 | E-01 L253-259 | ○ |
| C-16 (UT-INS-016) | ファイル書き込み失敗時にログ出力 | E-01 L257-258 | ○ |
| C-17 (UT-INS-017) | getLastExecVersionで保存バージョン取得 | E-01 L209-246 | ○ |
| C-18 (UT-INS-018) | 空ファイル時に0.0が返る | E-01 L216-217 | ○ |
| C-19 (UT-INS-019) | ファイル未存在時にconfig.xmlから取得 | E-01 L232-243 | ○ |
| C-20 (UT-INS-020) | 両ファイル未存在時に1.0が返る | E-01 L245 | ○ |
| C-21 (UT-INS-021) | ファイル読み込みエラー時に現在バージョン | E-01 L220-224 | ○ |
| C-22 (UT-INS-022) | getPersistedInstallStatusでステータス取得 | E-01 L286-292 | ○ |
| C-23 (UT-INS-023) | ファイル未存在時にnull | E-01 L288-289 | ○ |
| C-24 (UT-INS-024) | persistInstallStatusでXML保存 | E-01 L297-325 | ○ |
| C-25 (UT-INS-025) | 空リスト時にファイル削除 | E-01 L299-305 | ○ |
| C-26 (UT-INS-026) | null時にファイル削除 | E-01 L299-305 | ○ |
| C-27 (UT-INS-027) | Installing状態がPendingとして保存 | E-01 L314-316 | △ |
| C-28 (UT-INS-028) | correlationIdなしのジョブは除外 | E-01 L310 | ○ |
| C-29 (UT-INS-029) | clearInstallStatusでステータスクリア | E-01 L331-333 | ○ |
| C-30 (UT-INS-030) | getConfigFileでconfig.xmlパス取得 | E-01 L262-264 | ○ |
| C-31 (UT-INS-031) | getLastExecVersionFileでパス取得 | E-01 L266-268 | ○ |
| C-32 (UT-INS-032) | getInstallingPluginsFileでパス取得 | E-01 L270-272 | ○ |

### SetupWizard クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 (UT-INS-033) | 新規インストール時に管理者ユーザー作成 | E-02 L142-204 | ○ |
| C-34 (UT-INS-034) | 初期パスワードファイル作成 | E-02 L164-166 | ○ |
| C-35 (UT-INS-035) | 初期パスワードファイル権限0640 | E-02 L165 | ○ |
| C-36 (UT-INS-036) | HudsonPrivateSecurityRealmが設定 | E-02 L150-151 | ○ |
| C-37 (UT-INS-037) | FullControlOnceLoggedInAuthorizationStrategy設定 | E-02 L170-172 | ○ |
| C-38 (UT-INS-038) | CrumbIssuerが設定 | E-02 L178 | ○ |
| C-39 (UT-INS-039) | JNLPポートが-1に設定 | E-02 L175 | ○ |
| C-40 (UT-INS-040) | ADMIN_INITIAL_API_TOKEN設定時にAPIトークン作成 | E-02 L157-159, L214-267 | △ |
| C-41 (UT-INS-041) | 既存セキュリティレルム時にスキップ | E-02 L148 | ○ |
| C-42 (UT-INS-042) | UpdateCenter.updateDefaultSiteが呼ばれる | E-02 L206-211 | ○ |
| C-43 (UT-INS-043) | セットアップ未完了でデフォルト設定時true | E-02 L293-301 | ○ |
| C-44 (UT-INS-044) | セットアップ完了時にfalse | E-02 L295 | ○ |
| C-45 (UT-INS-045) | 例外発生時にfalse | E-02 L297-299 | ○ |
| C-46 (UT-INS-046) | デフォルト設定でパスワード一致時true | E-02 L308-327 | ○ |
| C-47 (UT-INS-047) | 複数ユーザー存在時にfalse | E-02 L313 | ○ |
| C-48 (UT-INS-048) | パスワード不一致時にfalse | E-02 L317 | ○ |
| C-49 (UT-INS-049) | 異なるセキュリティレルム時にfalse | E-02 L310 | ○ |
| C-50 (UT-INS-050) | doCreateAdminUserで管理者作成 | E-02 L332-413 | ○ |
| C-51 (UT-INS-051) | 初期パスワードファイル削除 | E-02 L361-365 | ○ |
| C-52 (UT-INS-052) | 初期APIトークンファイル削除 | E-02 L366-374 | ○ |
| C-53 (UT-INS-053) | 新規セッション作成 | E-02 L383-388 | ○ |
| C-54 (UT-INS-054) | UserSeedがセッションに設定 | E-02 L390-393 | ○ |
| C-55 (UT-INS-055) | CrumbがJSONレスポンスに含まれる | E-02 L395-399 | ○ |
| C-56 (UT-INS-056) | 権限なし時に例外スロー | E-02 L337 | ○ |
| C-57 (UT-INS-057) | アカウント作成失敗時に422 | E-02 L401-408 | ○ |
| C-58 (UT-INS-058) | 失敗時に初期adminユーザー復元 | E-02 L409-412 | ○ |
| C-59 (UT-INS-059) | doConfigureInstanceでrootUrl設定 | E-02 L416-444, L456-458 | ○ |
| C-60 (UT-INS-060) | 次の状態に遷移 | E-02 L436 | ○ |
| C-61 (UT-INS-061) | rootUrlがnullの場合エラー | E-02 L446-449 | ○ |
| C-62 (UT-INS-062) | rootUrlが無効な場合エラー | E-02 L450-453 | ○ |
| C-63 (UT-INS-063) | 権限なし時に例外スロー | E-02 L419 | ○ |
| C-64 (UT-INS-064) | setCurrentLevelでバージョン書き込み | E-02 L461-462 | ○ |
| C-65 (UT-INS-065) | getCurrentLevelで保存バージョン取得 | E-02 L478-497 | ○ |
| C-66 (UT-INS-066) | ファイル未存在時に1.0 | E-02 L482 | ○ |
| C-67 (UT-INS-067) | 空ファイル時に1.0 | E-02 L487-489 | ○ |
| C-68 (UT-INS-068) | 読み込みエラー時にnull | E-02 L491-494 | ○ |
| C-69 (UT-INS-069) | getUpdateStateFileで正しいパス | E-02 L470-471 | ○ |
| C-70 (UT-INS-070) | UPGRADE状態時にプラグイン更新リスト | E-02 L503-518 | ○ |
| C-71 (UT-INS-071) | 非UPGRADE状態時にプラットフォームプラグインリスト | E-02 L511-515 | ○ |
| C-72 (UT-INS-072) | SetupWizardがnull時に空JSON | E-02 L517-518 | ○ |
| C-73 (UT-INS-073) | doRestartStatusで再起動ステータス | E-02 L525-532 | ○ |
| C-74 (UT-INS-074) | getPlatformPluginUpdatesでバージョン範囲取得 | E-02 L539-546 | ○ |
| C-75 (UT-INS-075) | getCurrentLevelがnull時にnull | E-02 L542-544 | ○ |
| C-76 (UT-INS-076) | リモートからプラグインリスト取得 | E-02 L553-626 | ○ |
| C-77 (UT-INS-077) | リモート失敗時にローカルファイルにフォールバック | E-02 L614-624 | ○ |
| C-78 (UT-INS-078) | 署名検証が実行される | E-02 L578-585 | △ |
| C-79 (UT-INS-079) | 権限なし時に例外スロー | E-02 L554 | ○ |
| C-80 (UT-INS-080) | バージョン範囲内のプラグインのみ返る | E-02 L631-683 | ○ |
| C-81 (UT-INS-081) | インストール済みプラグインは除外 | E-02 L653 | ○ |
| C-82 (UT-INS-082) | 互換性のないプラグインは除外 | E-02 L658-660 | ○ |
| C-83 (UT-INS-083) | 空カテゴリは除外 | E-02 L677-679 | ○ |
| C-84 (UT-INS-084) | getInitialAdminPasswordFileで正しいパス | E-02 L688-689 | ○ |
| C-85 (UT-INS-085) | getInitialAdminApiTokenFileで正しいパス | E-02 L696-698 | ○ |
| C-86 (UT-INS-086) | doCompleteInstallでセットアップ完了 | E-02 L704-708 | ○ |
| C-87 (UT-INS-087) | completeSetupでlastExecVersion保存 | E-02 L712 | ○ |
| C-88 (UT-INS-088) | completeSetupでcurrentLevel設定 | E-02 L713 | ○ |
| C-89 (UT-INS-089) | completeSetupで次の状態に遷移 | E-02 L714 | ○ |
| C-90 (UT-INS-090) | 権限なし時に例外スロー | E-02 L711 | ○ |
| C-91 (UT-INS-091) | getInstallStatesで全状態取得 | E-02 L720-722 | ○ |
| C-92 (UT-INS-092) | getInstallStateで名前から状態取得 | E-02 L727-732 | ○ |
| C-93 (UT-INS-093) | nullの場合null | E-02 L728-729 | ○ |
| C-94 (UT-INS-094) | 存在しない名前の場合null | E-02 L731 | ○ |
| C-95 (UT-INS-095) | セットアップ完了時にフィルター解除 | E-02 L739-745 | ○ |
| C-96 (UT-INS-096) | セットアップ未完了時にフィルター設定 | E-02 L739-745 | ○ |
| C-97 (UT-INS-097) | hasSetupWizardFilterでフィルター状態 | E-02 L751-753 | ○ |
| C-98 (UT-INS-098) | getDisplayNameで表示名 | E-02 L133-137 | ○ |
| C-99 (UT-INS-099) | ルートリクエストがセットアップウィザードにリダイレクト | E-02 L765-786 | ○ |
| C-100 (UT-INS-100) | 末尾スラッシュなしリクエストがリダイレクト | E-02 L770-772 | ○ |
| C-101 (UT-INS-101) | セットアップ完了後は通常フィルターチェーン | E-02 L767, L785 | ○ |

### InstallState クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 (UT-INS-102) | コンストラクタで名前とフラグ設定 | E-03 L297-300 | ○ |
| C-103 (UT-INS-103) | nameで名前取得 | E-03 L340-342 | ○ |
| C-104 (UT-INS-104) | isSetupCompleteでフラグ取得 | E-03 L336-338 | ○ |
| C-105 (UT-INS-105) | hashCodeで名前ベースのハッシュ | E-03 L344-346 | ○ |
| C-106 (UT-INS-106) | equals同名でtrue | E-03 L349-355 | ○ |
| C-107 (UT-INS-107) | equals異名でfalse | E-03 L349-355 | ○ |
| C-108 (UT-INS-108) | equals異型でfalse | E-03 L351 | ○ |
| C-109 (UT-INS-109) | toStringで名前含む文字列 | E-03 L357-360 | ○ |
| C-110 (UT-INS-110) | valueOfで名前からInstallState取得 | E-03 L365-373 | ○ |
| C-111 (UT-INS-111) | valueOf存在しない名前でnull | E-03 L372 | ○ |
| C-112 (UT-INS-112) | allで全InstallState取得 | E-03 L378-380 | ○ |
| C-113 (UT-INS-113) | readResolveでデシリアライズ時に正しい状態 | E-03 L315-331 | ○ |
| C-114 (UT-INS-114) | readResolve空白名でUNKNOWN | E-03 L318-320 | ○ |
| C-115 (UT-INS-115) | readResolve null名でUNKNOWN | E-03 L318 | ○ |
| C-116 (UT-INS-116) | readResolve未知名でUNKNOWN | E-03 L324-326 | ○ |
| C-117 (UT-INS-117) | UNKNOWN.initializeStateで次状態遷移 | E-03 L86-88 | ○ |
| C-118 (UT-INS-118) | RUNNING.isSetupCompleteがtrue | E-03 L95 | ○ |
| C-119 (UT-INS-119) | INITIAL_SETUP_COMPLETED.initializeStateでcompleteSetup | E-03 L108-117 | ○ |
| C-120 (UT-INS-120) | INITIAL_SETUP_COMPLETEDからRUNNINGに遷移 | E-03 L116 | ○ |
| C-121 (UT-INS-121) | CREATE_ADMIN_USER.initializeStateデフォルトセキュリティ時維持 | E-03 L131-139 | ○ |
| C-122 (UT-INS-122) | CREATE_ADMIN_USER.initializeState非デフォルト時スキップ | E-03 L136-138 | ○ |
| C-123 (UT-INS-123) | CONFIGURE_INSTANCE.initializeState URL設定済みスキップ | E-03 L150-158 | ○ |
| C-124 (UT-INS-124) | CONFIGURE_INSTANCE.initializeState URL未設定時維持 | E-03 L150-158 | ○ |
| C-125 (UT-INS-125) | INITIAL_PLUGINS_INSTALLING.isSetupCompleteがfalse | E-03 L166 | ○ |
| C-126 (UT-INS-126) | INITIAL_SECURITY_SETUP.initializeStateでinit呼び出し | E-03 L179-188 | ○ |
| C-127 (UT-INS-127) | INITIAL_SECURITY_SETUP.initializeStateで次状態遷移 | E-03 L187 | ○ |
| C-128 (UT-INS-128) | NEW.isSetupCompleteがfalse | E-03 L195 | ○ |
| C-129 (UT-INS-129) | RESTART.initializeStateでlastExecVersion保存 | E-03 L209-211 | ○ |
| C-130 (UT-INS-130) | RESTART.isSetupCompleteがtrue | E-03 L205 | ○ |
| C-131 (UT-INS-131) | UPGRADE.initializeStateでapplyForcedChanges | E-03 L227-234 | ○ |
| C-132 (UT-INS-132) | UPGRADE.initializeStateでUpdateSiteリロード | E-03 L231 | ○ |
| C-133 (UT-INS-133) | UPGRADE.initializeStateでlastExecVersion保存 | E-03 L233 | ○ |
| C-134 (UT-INS-134) | UPGRADE.applyForcedChangesで既存設定なし時レガシートークン無効化 | E-03 L239-248 | ○ |
| C-135 (UT-INS-135) | UPGRADE.applyForcedChanges既存設定あり時維持 | E-03 L244 | ○ |
| C-136 (UT-INS-136) | DOWNGRADE.initializeStateでUpdateSiteリロード | E-03 L268-274 | ○ |
| C-137 (UT-INS-137) | DOWNGRADE.initializeStateでlastExecVersion保存 | E-03 L273 | ○ |
| C-138 (UT-INS-138) | DOWNGRADE.isSetupCompleteがtrue | E-03 L265 | ○ |
| C-139 (UT-INS-139) | TEST.isSetupCompleteがtrue | E-03 L282 | ○ |
| C-140 (UT-INS-140) | DEVELOPMENT.isSetupCompleteがtrue | E-03 L288 | ○ |

### InstallStateFilter クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 (UT-INS-141) | allで全InstallStateFilter取得 | E-04 L21-23 | ○ |
| C-142 (UT-INS-142) | getNextInstallStateでチェーン処理 | E-04 L16 | ○ |

### その他（InstallUtil内部クラス・デフォルト状態判定）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 (UT-INS-143) | ProviderChain.getでイテレータの次の関数実行 | E-01 L79-90 | ○ |
| C-144 (UT-INS-144) | jenkins.install.stateシステムプロパティで状態オーバーライド | E-01 L137-143 | ○ |
| C-145 (UT-INS-145) | 不正オーバーライド値で例外スロー | E-01 L141-143 | ○ |
| C-146 (UT-INS-146) | ユニットテスト環境でTEST | E-01 L153-155 | ○ |
| C-147 (UT-INS-147) | 開発モードでDEVELOPMENT | E-01 L157-159 | ○ |
| C-148 (UT-INS-148) | runSetupWizard=falseでセットアップ完了状態 | E-01 L165-172 | △ |
| C-149 (UT-INS-149) | UpdateStateFile未存在でINITIAL_SECURITY_SETUP | E-01 L174 | ○ |
| C-150 (UT-INS-150) | バージョンアップ時にUPGRADE | E-01 L180-181 | ○ |
| C-151 (UT-INS-151) | バージョンダウン時にDOWNGRADE | E-01 L182-183 | ○ |
| C-152 (UT-INS-152) | 同バージョン時にRESTART | E-01 L184-187 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-27 (UT-INS-027)**: `Installing`ステータスから`"Pending"`への変換ロジックは存在するが、テストで正確に検証するには`InstallationStatus`の内部実装の理解が必要
  - 候補：`hudson.model.UpdateCenter.DownloadJob`の実装確認 / 既存テストの参照
- **C-40 (UT-INS-040)**: `ADMIN_INITIAL_API_TOKEN`システムプロパティの動作は実装されているが、テスト環境での設定方法や副作用の確認が必要
  - 候補：システムプロパティ設定のテストユーティリティ / モック使用
- **C-78 (UT-INS-078)**: `DownloadService.signatureCheck`フラグによる署名検証の動作は条件分岐で実装されているが、テストでの署名付きデータの準備方法が不明
  - 候補：テスト用の署名付きJSONファイル / モックUpdateSite
- **C-148 (UT-INS-148)**: `runSetupWizard=false`設定時の動作は、`INITIAL_SETUP_COMPLETED.initializeState()`の呼び出しを含む複合的な処理であり、完全な検証には統合テストが必要
  - 候補：JenkinsRuleを使用した統合テスト / 既存テストの参照

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2 (高) | セキュリティ関連テスト (UT-INS-033〜042, 050〜058) | 初期セットアップ時の認証・認可設定に関わるため、脆弱性につながる可能性 |
| 2 (高) | 状態遷移テスト (UT-INS-001〜011) | インストール状態の遷移が不正確だと、セットアップが完了しない/スキップされる可能性 |
| 1 (中) | バージョン判定テスト (UT-INS-017〜021, 149〜152) | バージョン判定の誤りはアップグレード/ダウングレード処理に影響 |
| 1 (中) | プラグインリスト取得テスト (UT-INS-070〜082) | プラグインの推奨リストが不正確だとセキュリティリスク |
| 0 (低) | パス取得テスト (UT-INS-030〜032, 069, 084〜085) | ファイルパスの取得は単純なロジック |

## 6) レビュアーチェックリスト（最小）

- [ ] 状態遷移マップ（UT-INS-004〜011）がInstallUtil.javaの実装と一致しているか確認
- [ ] セキュリティ設定テスト（UT-INS-033〜042）が実際のデフォルト設定と整合しているか確認
- [ ] doCreateAdminUserのセッション固定攻撃対策（UT-INS-053）が正しく実装されているか確認
- [ ] バージョン比較ロジック（UT-INS-150〜152）がVersionNumber.isOlderThan/isNewerThanの動作と一致しているか確認
- [ ] プラグイン署名検証（UT-INS-078）のテストが実行可能か確認
- [ ] 既存テスト（E-05, E-06, E-07）との重複・不足がないか確認
