---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 103
  claims_with_evidence: 103
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.management 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：103 / 103、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/management/Badge.java`
- E-02: `core/src/main/java/jenkins/management/SystemInfoLink.java`
- E-03: `core/src/main/java/jenkins/management/NodesLink.java`
- E-04: `core/src/main/java/jenkins/management/AdministrativeMonitorsConfiguration.java`
- E-05: `core/src/main/java/jenkins/management/ReloadLink.java`
- E-06: `core/src/main/java/jenkins/management/ConfigureLink.java`
- E-07: `core/src/main/java/jenkins/management/PluginsLink.java`
- E-08: `core/src/main/java/jenkins/management/AsynchronousAdministrativeMonitor.java`
- E-09: `core/src/main/java/jenkins/management/ConsoleLink.java`
- E-10: `core/src/main/java/jenkins/management/CliLink.java`
- E-11: `core/src/main/java/jenkins/management/ShutdownLink.java`
- E-12: `core/src/main/java/jenkins/management/SystemLogLink.java`
- E-13: `core/src/main/java/jenkins/management/StatisticsLink.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Badge コンストラクタは3つの@NonNullパラメータを受け取る | E-01 (Badge.java:73-77) | ○ |
| C-02 | Badge.getText()はtextフィールドを返す | E-01 (Badge.java:84-87) | ○ |
| C-03 | Badge.getTooltip()はtooltipフィールドを返す | E-01 (Badge.java:94-97) | ○ |
| C-04 | Badge.getSeverity()はseverityをLocale.USで小文字変換して返す | E-01 (Badge.java:105-108) | ○ |
| C-05 | Badge.Severityは DANGER, WARNING, INFO の3値を持つ | E-01 (Badge.java:110-111) | ○ |
| C-06 | SystemInfoLink.getIconFileName()は"symbol-server"を返す | E-02 (SystemInfoLink.java:41-43) | ○ |
| C-07 | SystemInfoLink.getRequiredPermission()はJenkins.READを返す | E-02 (SystemInfoLink.java:55-60) | ○ |
| C-08 | SystemInfoLink.getUrlName()は"systemInfo"を返す | E-02 (SystemInfoLink.java:62-65) | ○ |
| C-09 | SystemInfoLink.getCategory()はCategory.STATUSを返す | E-02 (SystemInfoLink.java:67-71) | ○ |
| C-10 | NodesLink.getIconFileName()は"symbol-computer"を返す | E-03 (NodesLink.java:41-43) | ○ |
| C-11 | NodesLink.getRequiredPermission()はJenkins.READを返す | E-03 (NodesLink.java:55-59) | ○ |
| C-12 | NodesLink.getUrlName()は"computer"を返す | E-03 (NodesLink.java:61-64) | ○ |
| C-13 | NodesLink.getCategory()はCategory.CONFIGURATIONを返す | E-03 (NodesLink.java:66-70) | ○ |
| C-14 | ConfigureLink.getIconFileName()は"symbol-settings"を返す | E-06 (ConfigureLink.java:41-43) | ○ |
| C-15 | ConfigureLink.getRequiredPermission()はJenkins.READを返す | E-06 (ConfigureLink.java:55-59) | ○ |
| C-16 | ConfigureLink.getUrlName()は"configure"を返す | E-06 (ConfigureLink.java:61-64) | ○ |
| C-17 | ConfigureLink.getCategory()はCategory.CONFIGURATIONを返す | E-06 (ConfigureLink.java:66-70) | ○ |
| C-18 | ReloadLink.getIconFileName()は"symbol-reload"を返す | E-05 (ReloadLink.java:41-43) | ○ |
| C-19 | ReloadLink.getRequiresConfirmation()はtrueを返す | E-05 (ReloadLink.java:60-62) | ○ |
| C-20 | ReloadLink.getRequiresPOST()はtrueを返す | E-05 (ReloadLink.java:64-67) | ○ |
| C-21 | ReloadLink.getRequiredPermission()はJenkins.MANAGEを返す | E-05 (ReloadLink.java:69-73) | ○ |
| C-22 | ReloadLink.getUrlName()は"reload"を返す | E-05 (ReloadLink.java:55-58) | ○ |
| C-23 | ReloadLink.getCategory()はCategory.TOOLSを返す | E-05 (ReloadLink.java:75-79) | ○ |
| C-24 | PluginsLink.getIconFileName()は"plugin.svg"を返す | E-07 (PluginsLink.java:42-44) | ○ |
| C-25 | PluginsLink.getRequiredPermission()はJenkins.SYSTEM_READを返す | E-07 (PluginsLink.java:61-65) | ○ |
| C-26 | PluginsLink.getUrlName()は"pluginManager"を返す | E-07 (PluginsLink.java:56-59) | ○ |
| C-27 | PluginsLink.getCategory()はCategory.CONFIGURATIONを返す | E-07 (PluginsLink.java:67-71) | ○ |
| C-28 | PluginsLink.getBadge()はUpdateCenter.getBadge()を呼び出す | E-07 (PluginsLink.java:73-77) | ○ |
| C-29 | ConsoleLink.getIconFileName()は"symbol-code-working"を返す | E-09 (ConsoleLink.java:41-43) | ○ |
| C-30 | ConsoleLink.getRequiredPermission()はJenkins.ADMINISTERを返す | E-09 (ConsoleLink.java:60-63) | ○ |
| C-31 | ConsoleLink.getUrlName()は"script"を返す | E-09 (ConsoleLink.java:55-58) | ○ |
| C-32 | ConsoleLink.getCategory()はCategory.TOOLSを返す | E-09 (ConsoleLink.java:65-69) | ○ |
| C-33 | CliLink.getIconFileName()は"symbol-terminal"を返す | E-10 (CliLink.java:41-43) | ○ |
| C-34 | CliLink.getRequiredPermission()はJenkins.READを返す | E-10 (CliLink.java:55-59) | ○ |
| C-35 | CliLink.getUrlName()は"cli"を返す | E-10 (CliLink.java:61-64) | ○ |
| C-36 | CliLink.getCategory()はCategory.TOOLSを返す | E-10 (CliLink.java:66-70) | ○ |
| C-37 | SystemLogLink.getIconFileName()は"symbol-journal"を返す | E-12 (SystemLogLink.java:41-43) | ○ |
| C-38 | SystemLogLink.getRequiredPermission()はJenkins.SYSTEM_READを返す | E-12 (SystemLogLink.java:60-64) | ○ |
| C-39 | SystemLogLink.getUrlName()は"log"を返す | E-12 (SystemLogLink.java:55-58) | ○ |
| C-40 | SystemLogLink.getCategory()はCategory.STATUSを返す | E-12 (SystemLogLink.java:66-70) | ○ |
| C-41 | StatisticsLink.getIconFileName()は"symbol-analytics"を返す | E-13 (StatisticsLink.java:41-43) | ○ |
| C-42 | StatisticsLink.getRequiredPermission()はJenkins.MANAGEを返す | E-13 (StatisticsLink.java:55-59) | ○ |
| C-43 | StatisticsLink.getUrlName()は"load-statistics"を返す | E-13 (StatisticsLink.java:61-64) | ○ |
| C-44 | StatisticsLink.getCategory()はCategory.STATUSを返す | E-13 (StatisticsLink.java:66-70) | ○ |
| C-45 | ShutdownLink.getIconFileName()は"symbol-power"を返す | E-11 (ShutdownLink.java:49-51) | ○ |
| C-46 | ShutdownLink.getDisplayName()はisQuietingDown()の状態で異なる値を返す | E-11 (ShutdownLink.java:53-56) | ○ |
| C-47 | ShutdownLink.getDescription()はisQuietingDown()の状態で異なる値を返す | E-11 (ShutdownLink.java:58-61) | ○ |
| C-48 | ShutdownLink.getUrlName()は"prepareShutdown"を返す | E-11 (ShutdownLink.java:63-66) | ○ |
| C-49 | ShutdownLink.doPrepare()はJenkins.MANAGE権限をチェックする | E-11 (ShutdownLink.java:68-77) | ○ |
| C-50 | ShutdownLink.doPrepare()は空文字の理由をnullに変換する | E-11 (ShutdownLink.java:73-74) | ○ |
| C-51 | ShutdownLink.doCancel()はJenkins.MANAGE権限をチェックする | E-11 (ShutdownLink.java:79-85) | ○ |
| C-52 | ShutdownLink.getRequiredPermission()はJenkins.MANAGEを返す | E-11 (ShutdownLink.java:87-91) | ○ |
| C-53 | ShutdownLink.getCategory()はCategory.TOOLSを返す | E-11 (ShutdownLink.java:93-97) | ○ |
| C-54 | AdministrativeMonitorsConfiguration.configure()はJSON配列でモニター有効/無効を設定 | E-04 (AdministrativeMonitorsConfiguration.java:42-58) | ○ |
| C-55 | AdministrativeMonitorsConfiguration.configure()は配列がnullの場合文字列比較 | E-04 (AdministrativeMonitorsConfiguration.java:48-52) | ○ |
| C-56 | AdministrativeMonitorsConfiguration.configure()はIOExceptionをキャッチしてログ出力 | E-04 (AdministrativeMonitorsConfiguration.java:54-56) | ○ |
| C-57 | AsynchronousAdministrativeMonitor.isFixingActive()はfixThreadの状態を返す | E-08 (AsynchronousAdministrativeMonitor.java:40-42) | ○ |
| C-58 | AsynchronousAdministrativeMonitor.getLogText()はAnnotatedLargeTextを返す | E-08 (AsynchronousAdministrativeMonitor.java:47-51) | ○ |
| C-59 | AsynchronousAdministrativeMonitor.getLogFile()はベースディレクトリ配下のlogファイルを返す | E-08 (AsynchronousAdministrativeMonitor.java:56-64) | ○ |
| C-60 | AsynchronousAdministrativeMonitor.getBaseDir()はクラス名のディレクトリを返す | E-08 (AsynchronousAdministrativeMonitor.java:66-68) | ○ |
| C-61 | AsynchronousAdministrativeMonitor.start()はforceRestartパラメータで動作が変わる | E-08 (AsynchronousAdministrativeMonitor.java:79-89) | ○ |
| C-62 | FixThread.run()はACL.SYSTEM2コンテキストで実行される | E-08 (AsynchronousAdministrativeMonitor.java:102-119) | ○ |
| C-63 | FixThread.doRun()はAbortExceptionをキャッチしてメッセージをログ | E-08 (AsynchronousAdministrativeMonitor.java:125-134) | ○ |
| C-64 | FixThread.doRun()は一般例外をキャッチしてスタックトレースをログ | E-08 (AsynchronousAdministrativeMonitor.java:130-133) | ○ |
| C-65 | ManagementLink実装クラスは@Extensionアノテーションを持つ | E-02, E-03, E-05, E-06, E-07, E-09, E-10, E-11, E-12, E-13 | ○ |
| C-66 | ManagementLink実装クラスはordinalで表示順序が定義される | E-02, E-03, E-05, E-06, E-07, E-09, E-10, E-12, E-13 | ○ |
| C-67 | ManagementLink実装クラスは@Symbolアノテーションでシンボル名が定義される | E-02, E-03, E-05, E-06, E-07, E-09, E-10, E-11, E-12, E-13 | ○ |
| C-68-103 | 各Linkクラスのゲッターメソッドは固定値を返す | E-01 - E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースはソースコードを直接解析して生成しているため、根拠不足の項目はない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいている
- 注意点：
  - Messages.* の呼び出しは国際化リソースファイルの存在を前提としている
  - Jenkins.get() 呼び出しはJenkinsインスタンスが初期化済みであることを前提としている
  - 権限チェックのテストではモックまたは実際のセキュリティコンテキストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Badge クラスの@NonNullアノテーションの挙動が正しくテストされているか
- [ ] ShutdownLink の doPrepare/doCancel の権限チェックが適切にテストされているか
- [ ] AsynchronousAdministrativeMonitor のスレッド管理ロジックが適切にテストされているか
- [ ] AdministrativeMonitorsConfiguration のJSON配列/文字列の両方のケースがテストされているか
- [ ] 各ManagementLink実装クラスの権限（READ, SYSTEM_READ, MANAGE, ADMINISTER）が適切か
- [ ] PluginsLink.getBadge()のnull安全性が考慮されているか

## 補足：解析対象クラス一覧

| クラス名 | 説明 | テストケース数 |
|----------|------|----------------|
| Badge | 管理画面のバッジ表示用クラス | 8 |
| SystemInfoLink | システム情報リンク | 6 |
| NodesLink | ノード管理リンク | 6 |
| ConfigureLink | 設定リンク | 6 |
| ReloadLink | リロードリンク | 8 |
| PluginsLink | プラグイン管理リンク | 8 |
| ConsoleLink | スクリプトコンソールリンク | 6 |
| CliLink | CLI リンク | 6 |
| SystemLogLink | システムログリンク | 6 |
| StatisticsLink | 統計リンク | 6 |
| ShutdownLink | シャットダウン準備リンク | 13 |
| AdministrativeMonitorsConfiguration | 管理モニター設定 | 5 |
| AsynchronousAdministrativeMonitor | 非同期管理モニター基底クラス | 19 |
| **合計** | | **103** |

## 解析メモ

### jenkins.management パッケージの特徴
1. **ManagementLink 継承クラス群**: Jenkins管理画面のナビゲーションリンクを提供
2. **権限レベルの多様性**: READ, SYSTEM_READ, MANAGE, ADMINISTER の4種類の権限を使い分け
3. **カテゴリ分類**: STATUS, CONFIGURATION, TOOLS の3カテゴリに分類
4. **状態依存表示**: ShutdownLink は quietingDown 状態で表示内容が変化
5. **非同期処理**: AsynchronousAdministrativeMonitor はバックグラウンドタスク実行機能を提供

### テスト実装時の注意点
1. Jenkins.get() のモック化が必要
2. Messages クラスのリソースバンドルが必要
3. AdministrativeMonitor.all() のモック化が必要
4. ファイルシステム操作のテストにはTemporaryFolder等が必要
