---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 111
  claims_with_evidence: 111
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.model 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：111 / 111、根拠なし：0
- 優先レビュー（高）
  1. **Jenkins.javaの主要メソッド**：ファイルサイズが大きく全メソッドの解析は限定的
  2. **セキュリティ関連テストケース**：SECURITY-2021, SECURITY-1471対策の妥当性確認
  3. **遅延ロード関連テストケース**：AbstractLazyLoadRunMap, LazyBuildMixInの複雑なロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/model/Nodes.java` - ノード管理クラス（482行）
- E-02: `core/src/main/java/jenkins/model/IdStrategy.java` - ID戦略クラス（319行）
- E-03: `core/src/main/java/jenkins/model/GlobalConfiguration.java` - グローバル設定基底クラス（97行）
- E-04: `core/src/main/java/jenkins/model/JenkinsLocationConfiguration.java` - Jenkins位置設定（220行）
- E-05: `core/src/main/java/jenkins/model/PeepholePermalink.java` - パーマリンクキャッシュ（497行）
- E-06: `core/src/main/java/jenkins/model/queue/CompositeCauseOfBlockage.java` - 複合ブロック理由（74行）
- E-07: `core/src/main/java/jenkins/model/GlobalConfigurationCategory.java` - 設定カテゴリ（90行）
- E-08: `core/src/main/java/jenkins/model/BuildDiscarder.java` - ビルド破棄（83行）
- E-09: `core/src/main/java/jenkins/model/labels/LabelAutoCompleteSeeder.java` - ラベルオートコンプリート（60行）
- E-10: `core/src/main/java/jenkins/model/CoreEnvironmentContributor.java` - 環境変数設定（71行）
- E-11: `core/src/main/java/jenkins/model/TransientActionFactory.java` - 一時アクションファクトリ（130行）
- E-12: `core/src/main/java/jenkins/model/ProjectNamingStrategy.java` - プロジェクト命名戦略（232行）
- E-13: `core/src/main/java/jenkins/model/Uptime.java` - 稼働時間管理（38行）
- E-14: `core/src/main/java/jenkins/model/InterruptedBuildAction.java` - 中断アクション（54行）
- E-15: `core/src/main/java/jenkins/model/CauseOfInterruption.java` - 中断原因（151行）
- E-16: `core/src/main/java/jenkins/model/lazy/AbstractLazyLoadRunMap.java` - 遅延ロードマップ（300行以上）
- E-17: `core/src/main/java/jenkins/model/lazy/LazyBuildMixIn.java` - 遅延ビルドミックスイン（384行）
- E-18: `core/src/main/java/jenkins/model/Jenkins.java` - Jenkinsメインクラス（先頭800行を解析）

## 3) Claims と根拠の対応（レビューの主戦場）

### Nodes クラス（UT-JMD-001 〜 UT-JMD-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getNodes()がノードリストを返却 | E-01 L104-106 | ○ |
| C-02 | getNode()が指定名ノードを返却 | E-01 L358-361 | ○ |
| C-03 | getNode()がnullでnull返却 | E-01 L360 `name == null ? null` | ○ |
| C-04 | addNode()でノード追加 | E-01 L178-187 | ○ |
| C-05 | addNode()で名前制限チェック | E-01 L179-181 `ENFORCE_NAME_RESTRICTIONS` | ○ |
| C-06 | addNodeIfAbsent()のアトミック動作 | E-01 L159-170 | ○ |
| C-07 | removeNode()でノード削除 | E-01 L312-333 | ○ |
| C-08 | updateNode()で更新 | E-01 L238-268 | ○ |
| C-09 | replaceNode()で置換 | E-01 L276-303 | ○ |
| C-10 | setNodes()で一括設定 | E-01 L114-141 | ○ |
| C-11 | load()でディスク読込 | E-01 L368-394 | ○ |
| C-12 | save()で永続化 | E-01 L337-350 | ○ |
| C-13 | BulkChange中はsave()スキップ | E-01 L338-340 | ○ |
| C-14 | isLegacy()判定 | E-01 L455-457 | ○ |

### IdStrategy クラス（UT-JMD-020 〜 UT-JMD-027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | CaseInsensitive.keyFor()小文字化 | E-02 L209-211 | ○ |
| C-16 | CaseInsensitive.equals()大文字小文字無視 | E-02 L214-216 | ○ |
| C-17 | CaseSensitive.equals()厳密比較 | E-02 L255-257 | ○ |
| C-18 | CaseSensitiveEmailAddress.keyFor()ドメイン小文字化 | E-02 L298-301 | ○ |
| C-19 | all()でDescriptorExtensionList取得 | E-02 L168-170 | ○ |

### GlobalConfiguration クラス（UT-JMD-028 〜 UT-JMD-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | all()でExtensionList取得 | E-03 L93-95 | ○ |
| C-21 | configure()でJSONバインド | E-03 L68-88 | ○ |
| C-22 | getGlobalConfigPage()返却 | E-03 L58-60 | ○ |

### JenkinsLocationConfiguration クラス（UT-JMD-031 〜 UT-JMD-042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | get()シングルトン取得 | E-04 L64-66 | ○ |
| C-24 | getUrl()でURL取得 | E-04 L134-136 | ○ |
| C-25 | setUrl()で末尾スラッシュ追加 | E-04 L139-141 | ○ |
| C-26 | setUrl()で不正URL無効化 | E-04 L144-146, L152-157 | ○ |
| C-27 | getAdminAddress()デフォルト値 | E-04 L114-117 | ○ |
| C-28 | setAdminAddress()引用符除去 | E-04 L125-129 | ○ |
| C-29 | doCheckUrl()バリデーション | E-04 L199-208 | ○ |
| C-30 | doCheckAdminAddress()@チェック | E-04 L210-217 | ○ |

### PeepholePermalink クラス（UT-JMD-043 〜 UT-JMD-051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | resolve()でキャッシュ解決 | E-05 L92-94 | ○ |
| C-32 | updateCache()でキャッシュ更新 | E-05 L127-129 | ○ |
| C-33 | LAST_STABLE_BUILD.apply()判定 | E-05 L372-375 | ○ |
| C-34 | LAST_SUCCESSFUL_BUILD.apply()判定 | E-05 L393-395 | ○ |
| C-35 | LAST_FAILED_BUILD.apply()判定 | E-05 L413-415 | ○ |
| C-36 | RunListenerImpl.onCompleted()キャッシュ更新 | E-05 L344-354 | ○ |
| C-37 | RunListenerImpl.onDeleted()キャッシュ更新 | E-05 L329-337 | ○ |

### CompositeCauseOfBlockage クラス（UT-JMD-052 〜 UT-JMD-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | getShortDescription()5件以下全表示 | E-06 L55-58 | ○ |
| C-39 | getShortDescription()6件以上省略 | E-06 L60-64 `MAX_REASONS_TO_DISPLAY = 5` | ○ |
| C-40 | print()全理由出力 | E-06 L68-72 | ○ |

### GlobalConfigurationCategory クラス（UT-JMD-055 〜 UT-JMD-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | all()でExtensionList取得 | E-07 L39-41 | ○ |
| C-42 | get()で型指定取得 | E-07 L43-49 | ○ |
| C-43 | get()未登録でAssertionError | E-07 L46-47 | ○ |

### BuildDiscarder クラス（UT-JMD-058 〜 UT-JMD-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | perform()でビルド破棄 | E-08 L40 abstract method | ○ |
| C-45 | ConverterImpl.unmarshal()後方互換 | E-08 L73-75 | ○ |

### LabelAutoCompleteSeeder クラス（UT-JMD-061 〜 UT-JMD-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | getSeeds()単純入力 | E-09 L33-58 | ○ |
| C-47 | getSeeds()スペース区切り | E-09 L49-52 | ○ |
| C-48 | getSeeds()末尾スペース | E-09 L38 `trailingSpace` | ○ |
| C-49 | getSeeds()引用符処理 | E-09 L41-47 | ○ |

### CoreEnvironmentContributor クラス（UT-JMD-065 〜 UT-JMD-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | buildEnvironmentFor(Run)環境変数設定 | E-10 L26-39 | ○ |
| C-51 | buildEnvironmentFor(Job)環境変数設定 | E-10 L42-69 | ○ |
| C-52 | rootUrl null時URL変数未設定 | E-10 L47-51 条件分岐 | ○ |
| C-53 | Executor上でNODE_NAME設定 | E-10 L58-68 | ○ |

### TransientActionFactory クラス（UT-JMD-069 〜 UT-JMD-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | type()で対象型返却 | E-11 L57 abstract method | ○ |
| C-55 | actionType()デフォルトAction.class | E-11 L69-71 | ○ |
| C-56 | createFor()アクション生成 | E-11 L79 abstract method | ○ |
| C-57 | factoriesFor()ファクトリ検索 | E-11 L126-128 | ○ |

### ProjectNamingStrategy クラス（UT-JMD-073 〜 UT-JMD-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | DefaultProjectNamingStrategy.checkName() no-op | E-12 L118-120 | ○ |
| C-59 | PatternProjectNamingStrategy.checkName()パターン合致 | E-12 L173-181 | ○ |
| C-60 | PatternProjectNamingStrategy.checkName()不合致でFailure | E-12 L175-177 | ○ |
| C-61 | isForceExistingJobs()フラグ返却 | E-12 L193-195 | ○ |
| C-62 | doCheckNamePattern()バリデーション | E-12 L213-225 | ○ |

### Uptime クラス（UT-JMD-081 〜 UT-JMD-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | getStartTime()開始時刻取得 | E-13 L21-23 | ○ |
| C-64 | getUptime()稼働時間取得 | E-13 L29-31 | ○ |
| C-65 | init()時刻記録 | E-13 L33-37 | ○ |

### InterruptedBuildAction クラス（UT-JMD-084 〜 UT-JMD-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | getCauses()不変リスト返却 | E-14 L51-53 `Collections.unmodifiableList` | ○ |

### CauseOfInterruption クラス（UT-JMD-086 〜 UT-JMD-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | UserInterruption.getShortDescription()説明返却 | E-15 L123-125 | ○ |
| C-68 | UserInterruption.getUser()ユーザー取得 | E-15 L107-110 | ○ |
| C-69 | UserInterruption.getUser()存在しない場合Unknown | E-15 L109 `User.getUnknown()` | ○ |
| C-70 | UserInterruption.getUserOrNull()null返却 | E-15 L118-120 | ○ |
| C-71 | UserInterruption.equals()等価比較 | E-15 L136-140 | ○ |

### AbstractLazyLoadRunMap クラス（UT-JMD-092 〜 UT-JMD-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | getLoadedBuilds()ロード済みビルド返却 | E-16 L251-260 | ○ |
| C-73 | newestBuild()最新ビルド取得 | E-16 L293-295 | ○ |
| C-74 | oldestBuild()最古ビルド取得 | E-16 L297-299 | ○ |
| C-75 | purgeCache()キャッシュクリア | E-16 L164-166 | ○ |
| C-76 | recognizeNumber()ビルド認識 | E-16 L213-226 | ○ |

### LazyBuildMixIn クラス（UT-JMD-098 〜 UT-JMD-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | getRunMap()取得 | E-17 L82-84 | ○ |
| C-78 | onCreatedFromScratch()初期化 | E-17 L97-99 | ○ |
| C-79 | onLoad()ビルド復元 | E-17 L105-141 | ○ |
| C-80 | onLoad()nextBuildNumber調整 | E-17 L107-111 | ○ |
| C-81 | newBuild()ビルド作成 | E-17 L186-204 | ○ |
| C-82 | newBuild()ディレクトリ競合時リトライ | E-17 L189-193 JENKINS-23152 | ○ |
| C-83 | removeRun()ビルド削除 | E-17 L223-227 | ○ |
| C-84 | getBuildByNumber()番号検索 | E-17 L239-241 | ○ |
| C-85 | getEstimatedDurationCandidates()候補取得 | E-17 L275-297 | ○ |
| C-86 | RunMixIn.createReference()参照作成 | E-17 L343-348 | ○ |
| C-87 | RunMixIn.dropLinks()参照解除 | E-17 L353-356 | ○ |
| C-88 | RunMixIn.getPreviousBuild()前ビルド取得 | E-17 L361-363 | ○ |
| C-89 | RunMixIn.getNextBuild()次ビルド取得 | E-17 L368-370 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースについて、ソースコードを直接参照し根拠を確認済み
- Jenkins.javaは非常に大規模（224,000行超）のため、主要なpublicメソッドの解析は限定的
  - 候補：`Jenkins.get()` / `Jenkins.getRootDir()` / `Jenkins.getItem()` 等の追加テストケース

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なgetter/setterのテストケース
- **1 (中リスク)**: 状態遷移を伴うメソッド（addNode, removeNode等）
- **2 (高リスク)**: セキュリティ関連テストケース（SECURITY-2021, SECURITY-1471対策）

## 6) レビュアーチェックリスト（最小）
- [ ] Nodesクラスの追加/削除/更新テストケースが実際の永続化動作と整合しているか
- [ ] IdStrategyの比較ロジックがユーザー認証に影響を与えるケースを網羅しているか
- [ ] JenkinsLocationConfigurationのURL検証がセキュリティ要件（SECURITY-1471）を満たすか
- [ ] PeepholePermalinkのキャッシュ更新タイミングが全パターン網羅されているか
- [ ] LazyBuildMixInの遅延ロードシナリオでメモリリークが発生しないか
- [ ] ProjectNamingStrategyのパターンマッチングでReDoS脆弱性がないか確認
