---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：jenkins.monitor 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-MON-007**: Messages.JavaLevelAdminMonitor_DisplayName()の戻り値（リソースファイル未確認）
  2. **UT-MON-025**: isEnabled()による最適化動作（Jenkins初期化状態に依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/monitor/JavaVersionRecommendationAdminMonitor.java`
- E-02: `core/src/main/java/jenkins/monitor/OperatingSystemEndOfLifeAdminMonitor.java`
- E-03: `core/src/test/java/jenkins/monitor/OperatingSystemEndOfLifeAdminMonitorTest.java`
- E-04: JavaDoc コメント（SUPPORTED_JAVA_VERSIONS説明）
- E-05: @Restricted, @RequirePOST, @NonNull等のアノテーション

## 3) Claims と根拠の対応（レビューの主戦場）

### JavaVersionRecommendationAdminMonitor

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでgetId()で生成されたIDが設定される | E-01 L86-88 | ○ |
| C-02 | getId()がクラス名-Javaバージョン-EOL日-重要度を含むIDを返す | E-01 L98-111 | ○ |
| C-03 | EOL日がLocalDate.MAXの場合クラス名のみが返却される | E-01 L102-110 | ○ |
| C-04 | deprecation期間が12か月未満の場合isActivated()がtrueを返す | E-01 L116-118 | ○ |
| C-05 | deprecation期間が12か月以上の場合isActivated()がfalseを返す | E-01 L117 | ○ |
| C-06 | disabledがtrueの場合isActivated()がfalseを返す | E-01 L113, L117 | ○ |
| C-07 | getDisplayName()がMessages.JavaLevelAdminMonitor_DisplayName()を返す | E-01 L121-123 | △ |
| C-08 | getRequiredPermission()がJenkins.SYSTEM_READを返す | E-01 L125-128 | ○ |
| C-09 | doAct()でnoがnull以外の場合disable(true)が呼ばれる | E-01 L135-139 | ○ |
| C-10 | doAct()でnoがnullの場合HttpRedirectが返される | E-01 L140-142 | ○ |
| C-11 | doAct()でADMINISTER権限がチェックされる | E-01 L137 | ○ |
| C-12 | getEndOfLife()がサポートバージョンのEOL日を返す | E-01 L146-149 | ○ |
| C-13 | getEndOfLife()がサポート外の場合LocalDate.MAXを返す | E-01 L148 | ○ |
| C-14 | getDeprecationPeriod()が現在日とEOL日の差分を返す | E-01 L152-154 | ○ |
| C-15 | getSeverity()がEOL3か月未満でDANGERを返す | E-01 L157-159 | ○ |
| C-16 | getSeverity()がEOL3か月以上でWARNINGを返す | E-01 L158 | ○ |
| C-17 | getJavaVersion()がRuntime.version().feature()を返す | E-01 L166-168 | ○ |
| C-18 | getEndOfLifeAsDate()がDate型でEOL日を返す | E-01 L174-176 | ○ |
| C-19 | getSeverityAsString()が小文字文字列を返す | E-01 L182-184 | ○ |
| C-20 | SUPPORTED_JAVA_VERSIONSがunmodifiableMapである | E-01 L83 | ○ |
| C-21 | Java 21のEOL日が2027-09-30である | E-01 L81 | ○ |
| C-22 | Java 25のEOL日が2029-09-30である | E-01 L82 | ○ |

### OperatingSystemEndOfLifeAdminMonitor

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | デフォルトコンストラクタでfillOperatingSystemList()が呼ばれる | E-02 L89-91 | ○ |
| C-24 | ID指定コンストラクタで親クラスが初期化される | E-02 L84-87 | ○ |
| C-25 | fillOperatingSystemList()がJSONデータを読み込む | E-02 L93-103 | ○ |
| C-26 | isEnabled()がfalseの場合データ読み込みがスキップされる | E-02 L94-98 | △ |
| C-27 | readOperatingSystemList()が空JSON配列で例外をスロー | E-02 L108-110, E-03 L138-140 | ○ |
| C-28 | readOperatingSystemList()がpattern欠落で例外をスロー | E-02 L117-119, E-03 L149-152 | ○ |
| C-29 | readOperatingSystemList()がendOfLife欠落で例外をスロー | E-02 L122-124, E-03 L144-147 | ○ |
| C-30 | startが未指定の場合EOL6か月前がデフォルトになる | E-02 L128 | ○ |
| C-31 | EOL日が過去の場合afterEndOfLifeDateがtrueになる | E-02 L152-155 | ○ |
| C-32 | JSONにfileが指定されている場合そのパスが返される | E-02 L174-176 | ○ |
| C-33 | JSONにfileが未指定の場合/etc/os-releaseが返される | E-02 L173 | ○ |
| C-34 | readOperatingSystemName()がPRETTY_NAMEを抽出する | E-02 L183-205 | ○ |
| C-35 | ファイルが存在しない場合空文字が返される | E-02 L184-186, E-03 L184-185 | ○ |
| C-36 | dataFileがnullの場合空文字が返される | E-02 L184 | ○ |
| C-37 | パターン不一致時に空文字が返される | E-02 L191-195 | ○ |
| C-38 | 同じファイルへの2回目アクセスでキャッシュが使用される | E-02 L190, L197-200 | ○ |
| C-39 | getOperatingSystemName()がフィールド値を返す | E-02 L208-210 | ○ |
| C-40 | getEndOfLifeDate()がフィールド値を返す | E-02 L213-215 | ○ |
| C-41 | getAfterEndOfLifeDate()がフィールド値を返す | E-02 L217-219 | ○ |
| C-42 | getDocumentationUrl()がフィールド値を返す | E-02 L222-224 | ○ |
| C-43 | readDocumentationUrl()がOS名からURLを生成する | E-02 L228-234 | ○ |
| C-44 | buildDocumentationUrl()がスペースをハイフンに置換する | E-02 L240 | ○ |
| C-45 | buildDocumentationUrl()がスラッシュをハイフンに置換する | E-02 L240 | ○ |
| C-46 | buildDocumentationUrl()が括弧を削除する | E-02 L240 | ○ |
| C-47 | doAct()でnoがnull以外の場合disable(true)が呼ばれる | E-02 L258-262 | ○ |
| C-48 | doAct()でnoがnullの場合documentationUrlへリダイレクトする | E-02 L263-265 | ○ |
| C-49 | doAct()でADMINISTER権限がチェックされる | E-02 L259 | ○ |
| C-50 | isActivated()でignoreEndOfLifeがtrueの場合falseを返す | E-02 L271-274 | ○ |
| C-51 | isActivated()で現在日が警告開始日より前の場合falseを返す | E-02 L275-278 | ○ |
| C-52 | isActivated()で現在日が警告開始日以降の場合trueを返す | E-02 L279-280 | ○ |
| C-53 | getRequiredPermission()がJenkins.SYSTEM_READを返す | E-02 L284-286 | ○ |
| C-54 | getDisplayName()が固定文字列を返す | E-02 L289-291, E-03 L68-69 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-07 (UT-MON-007)**: Messages.JavaLevelAdminMonitor_DisplayName()の実際の戻り値を確認するにはリソースファイル（Messages.properties）の参照が必要
  - 候補：`core/src/main/resources/jenkins/monitor/Messages.properties`
- **C-26 (UT-MON-025)**: isEnabled()メソッドの動作はAdministrativeMonitor親クラスの実装に依存しており、Jenkins初期化状態との組み合わせでの動作確認が必要

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能
- **1: 中リスク** - 以下の項目は実行環境依存のテストが必要
  - Java実行バージョンに依存するテスト（UT-MON-002, UT-MON-012等）
  - OS情報ファイル（/etc/os-release）に依存するテスト（UT-MON-034等）
  - Jenkins実行環境（権限チェック）に依存するテスト（UT-MON-011, UT-MON-051等）

## 6) レビュアーチェックリスト（最小）
- [ ] Messages.properties内のJavaLevelAdminMonitor_DisplayNameキーの値を確認
- [ ] AdministrativeMonitor.isEnabled()のデフォルト実装を確認
- [ ] 既存テストクラス（OperatingSystemEndOfLifeAdminMonitorTest）との整合性を確認
- [ ] Java 21およびJava 25のEOL日が最新の情報と一致するか確認
- [ ] 権限チェック関連のテストがJenkinsRule使用を前提としているか確認
