---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：jenkins.org 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-92, C-93**：ドメイン長境界値テストの具体的な253文字ドメイン生成方法が未定義
  2. **IPv6のゾーンID・プレフィックス長テスト**：実装詳細の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/org/apache/commons/validator/routines/InetAddressValidator.java`
- E-02: `core/src/main/java/jenkins/org/apache/commons/validator/routines/RegexValidator.java`
- E-03: `core/src/main/java/jenkins/org/apache/commons/validator/routines/UrlValidator.java`
- E-04: `core/src/main/java/jenkins/org/apache/commons/validator/routines/DomainValidator.java`
- E-05: Apache Commons Validator 1.7 ドキュメント（参考）
- E-06: RFC 2396 - Uniform Resource Identifiers (URI): Generic Syntax
- E-07: RFC 1034 - Domain Names - Concepts and Facilities
- E-08: RFC 1123 - Requirements for Internet Hosts

## 3) Claims と根拠の対応（レビューの主戦場）

### InetAddressValidator 関連（C-01 〜 C-25）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getInstance()がシングルトンインスタンスを返す | E-01 L65, L74-76 | ○ |
| C-02 | isValid()が有効なIPv4でtrueを返す | E-01 L83-85 | ○ |
| C-03 | isValid()が有効なIPv6でtrueを返す | E-01 L83-85 | ○ |
| C-04 | isValid()が無効なIPでfalseを返す | E-01 L83-85 | ○ |
| C-05 | isValid()がnullでfalseを返す | E-01 L83-85 (isValidInet4Address/isValidInet6Addressがnullをfalseとする) | ○ |
| C-06 | isValidInet4Address()が正常IPv4でtrueを返す | E-01 L92-125 | ○ |
| C-07 | isValidInet4Address()がオクテット0でtrueを返す | E-01 L92-125 | ○ |
| C-08 | isValidInet4Address()がオクテット255でtrueを返す | E-01 L45, L114 | ○ |
| C-09 | isValidInet4Address()がオクテット256でfalseを返す | E-01 L45, L114 | ○ |
| C-10 | isValidInet4Address()が先頭0パディングでfalseを返す | E-01 L118-120 | ○ |
| C-11 | isValidInet4Address()がオクテット不足でfalseを返す | E-01 L53-54, L96-98 | ○ |
| C-12 | isValidInet4Address()がオクテット過剰でfalseを返す | E-01 L53-54, L96-98 | ○ |
| C-13 | isValidInet4Address()が空オクテットでfalseを返す | E-01 L102-104 | ○ |
| C-14 | isValidInet6Address()がフルフォーマットでtrueを返す | E-01 L134-223 | ○ |
| C-15 | isValidInet6Address()が圧縮形式でtrueを返す | E-01 L163-166, L172-180 | ○ |
| C-16 | isValidInet6Address()がループバックでtrueを返す | E-01 L134-223 | ○ |
| C-17 | isValidInet6Address()がIPv4マップドでtrueを返す | E-01 L197-202 | ○ |
| C-18 | isValidInet6Address()がゾーンID付きでtrueを返す | E-01 L152-161 | ○ |
| C-19 | isValidInet6Address()がプレフィックス長付きでtrueを返す | E-01 L137-150 | ○ |
| C-20 | isValidInet6Address()がプレフィックス長0でtrueを返す | E-01 L144 | ○ |
| C-21 | isValidInet6Address()がプレフィックス長128でtrueを返す | E-01 L144 | ○ |
| C-22 | isValidInet6Address()がプレフィックス長129でfalseを返す | E-01 L144-146 | ○ |
| C-23 | isValidInet6Address()が複数::でfalseを返す | E-01 L164-166 | ○ |
| C-24 | isValidInet6Address()が9グループ以上でfalseを返す | E-01 L57, L182-184 | ○ |
| C-25 | isValidInet6Address()が5桁以上16進数でfalseを返す | E-01 L60, L204-206 | ○ |

### RegexValidator 関連（C-26 〜 C-42）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | RegexValidator(String)が単一パターンで生成 | E-02 L90-92 | ○ |
| C-27 | RegexValidator(String)がnullで例外 | E-02 L103-104, L128-129 | ○ |
| C-28 | RegexValidator(String)が空文字で例外 | E-02 L134-136 | ○ |
| C-29 | RegexValidator(String[])が複数パターンで生成 | E-02 L114-116 | ○ |
| C-30 | RegexValidator(String[])が空配列で例外 | E-02 L128 | ○ |
| C-31 | RegexValidator(String,boolean)でケースインセンシティブ | E-02 L103-105, L132 | ○ |
| C-32 | isValid()がマッチでtrue | E-02 L148-158 | ○ |
| C-33 | isValid()がアンマッチでfalse | E-02 L148-158 | ○ |
| C-34 | isValid()がnullでfalse | E-02 L149-151 | ○ |
| C-35 | isValid()が複数パターンでOR条件 | E-02 L152-156 | ○ |
| C-36 | match()がグループ抽出 | E-02 L168-184 | ○ |
| C-37 | match()がアンマッチでnull | E-02 L183 | ○ |
| C-38 | match()がnullでnull | E-02 L169-171 | ○ |
| C-39 | validate()がグループ連結 | E-02 L195-217 | ○ |
| C-40 | validate()が単一グループで値返却 | E-02 L203-205 | ○ |
| C-41 | validate()がアンマッチでnull | E-02 L216 | ○ |
| C-42 | toString()がパターン情報含む | E-02 L224-235 | ○ |

### UrlValidator 関連（C-43 〜 C-83）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | getInstance()がシングルトン | E-03 L182, L188-190 | ○ |
| C-44 | UrlValidator()がデフォルト設定 | E-03 L177, L197-199 | ○ |
| C-45 | UrlValidator(String[])がカスタムスキーム | E-03 L209-211 | ○ |
| C-46 | UrlValidator(long)がオプション設定 | E-03 L219-221 | ○ |
| C-47 | isValid()が有効HTTP URLでtrue | E-03 L306-349 | ○ |
| C-48 | isValid()が有効HTTPS URLでtrue | E-03 L306-349 | ○ |
| C-49 | isValid()が有効FTP URLでtrue | E-03 L177, L306-349 | ○ |
| C-50 | isValid()がパス付きでtrue | E-03 L336-338 | ○ |
| C-51 | isValid()がクエリ付きでtrue | E-03 L340-342 | ○ |
| C-52 | isValid()がフラグメント付きでtrue | E-03 L344-346 | ○ |
| C-53 | isValid()がポート付きでtrue | E-03 L422-432 | ○ |
| C-54 | isValid()がIPv4 URLでtrue | E-03 L416-420 | ○ |
| C-55 | isValid()がIPv6 URLでtrue | E-03 L404-409 | ○ |
| C-56 | isValid()がnullでfalse | E-03 L307-309 | ○ |
| C-57 | isValid()が無効スキームでfalse | E-03 L320-322, L360-374 | ○ |
| C-58 | isValid()が無効ホストでfalse | E-03 L331-333 | ○ |
| C-59 | isValid()がスキームなしでfalse | E-03 L320-322 | ○ |
| C-60 | isValid()がポート0でtrue | E-03 L426 | ○ |
| C-61 | isValid()がポート65535でtrue | E-03 L88, L426 | ○ |
| C-62 | isValid()がポート65536でfalse | E-03 L88, L426 | ○ |
| C-63 | isValid()がfile://空authorityでtrue | E-03 L325-326 | ○ |
| C-64 | isValid()がALLOW_2_SLASHESで二重スラッシュ許可 | E-03 L99, L469-472 | ○ |
| C-65 | isValid()がデフォルトで二重スラッシュ禁止 | E-03 L469-472 | ○ |
| C-66 | isValid()がNO_FRAGMENTSでフラグメントなしtrue | E-03 L104, L495-501 | ○ |
| C-67 | isValid()がNO_FRAGMENTSでフラグメント付きfalse | E-03 L104, L495-501 | ○ |
| C-68 | isValid()がALLOW_LOCAL_URLSでlocalhost許可 | E-03 L112, L257 | ○ |
| C-69 | isValid()がALLOW_ALL_SCHEMESで任意スキーム | E-03 L94, L281-282, L369 | ○ |
| C-70 | isValid()がパストラバーサルでfalse | E-03 L461-464 | ○ |
| C-71 | isValidScheme()がhttpでtrue | E-03 L360-374 | ○ |
| C-72 | isValidScheme()がnullでfalse | E-03 L361-363 | ○ |
| C-73 | isValidScheme()が数字開始でfalse | E-03 L117, L365-367 | ○ |
| C-74 | isValidAuthority()が有効ホストでtrue | E-03 L386-441 | ○ |
| C-75 | isValidAuthority()がnullでfalse | E-03 L387-389 | ○ |
| C-76 | isValidAuthority()がユーザー情報付きでtrue | E-03 L131-135, L137 | ○ |
| C-77 | isValidPath()が有効パスでtrue | E-03 L448-475 | ○ |
| C-78 | isValidPath()がnullでfalse | E-03 L449-451 | ○ |
| C-79 | isValidQuery()が有効クエリでtrue | E-03 L482-488 | ○ |
| C-80 | isValidQuery()がnullでtrue | E-03 L483-485 | ○ |
| C-81 | isValidFragment()が任意フラグメントでtrue | E-03 L495-501 | ○ |
| C-82 | isValidFragment()がnullでtrue | E-03 L496-498 | ○ |
| C-83 | countToken()がトークンカウント | E-03 L509-520 | ○ |

### DomainValidator 関連（C-84 〜 C-120）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | getInstance()がシングルトン | E-04 L140-143 | ○ |
| C-85 | getInstance(boolean)がローカル許可版 | E-04 L151-157 | ○ |
| C-86 | isValid()が有効ドメインでtrue | E-04 L278-295 | ○ |
| C-87 | isValid()がサブドメイン付きでtrue | E-04 L278-295 | ○ |
| C-88 | isValid()が末尾ドット付きでtrue | E-04 L95-96 | ○ |
| C-89 | isValid()がnullでfalse | E-04 L279-281 | ○ |
| C-90 | isValid()が無効TLDでfalse | E-04 L291-294 | ○ |
| C-91 | isValid()が不正文字含むでfalse | E-04 L84, L290 | ○ |
| C-92 | isValid()が253文字でtrue | E-04 L76, L287-289 | △ |
| C-93 | isValid()が254文字以上でfalse | E-04 L76, L287-289 | △ |
| C-94 | isValid()がlocalhost（ローカル許可）でtrue | E-04 L294, L328-330 | ○ |
| C-95 | isValid()がlocalhost（ローカル禁止）でfalse | E-04 L294 | ○ |
| C-96 | isValid()がIDNドメインでtrue | E-04 L282, L2254-2285 | ○ |
| C-97 | isValidTld()が有効TLDでtrue | E-04 L327-334 | ○ |
| C-98 | isValidTld()が先頭ドット付きでtrue | E-04 L397-402 | ○ |
| C-99 | isValidInfrastructureTld()がarpaでtrue | E-04 L343-346, L420-422 | ○ |
| C-100 | isValidInfrastructureTld()がcomでfalse | E-04 L343-346 | ○ |
| C-101 | isValidGenericTld()がcomでtrue | E-04 L355-359, L425 | ○ |
| C-102 | isValidGenericTld()がorgでtrue | E-04 L355-359 | ○ |
| C-103 | isValidGenericTld()がjpでfalse | E-04 L355-359 | ○ |
| C-104 | isValidCountryCodeTld()がjpでtrue | E-04 L368-372 | ○ |
| C-105 | isValidCountryCodeTld()がukでtrue | E-04 L368-372 | ○ |
| C-106 | isValidCountryCodeTld()がcomでfalse | E-04 L368-372 | ○ |
| C-107 | isValidLocalTld()がlocalhostでtrue | E-04 L381-385 | ○ |
| C-108 | isValidLocalTld()がlocaldomainでtrue | E-04 L381-385 | ○ |
| C-109 | isValidLocalTld()がcomでfalse | E-04 L381-385 | ○ |
| C-110 | isAllowLocal()が設定取得 | E-04 L393-395 | ○ |
| C-111 | unicodeToASCII()がASCIIそのまま | E-04 L2254-2257 | ○ |
| C-112 | unicodeToASCII()がUnicode変換 | E-04 L2258-2281 | ○ |
| C-113 | unicodeToASCII()が末尾ドット保持 | E-04 L2260-2281 | ○ |
| C-114 | unicodeToASCII()が変換失敗時元値返却 | E-04 L2282-2284 | ○ |
| C-115 | updateTLDOverride()が設定可能 | E-04 L2124-2161 | ○ |
| C-116 | updateTLDOverride()がgetInstance後例外 | E-04 L2125-2127 | ○ |
| C-117 | updateTLDOverride()が読取専用で例外 | E-04 L2153-2157 | ○ |
| C-118 | getTLDEntries()がコピー取得 | E-04 L2170-2207 | ○ |
| C-119 | getOverrides()がオーバーライド取得 | E-04 L2216-2241 | ○ |
| C-120 | getOverrides()が読取専用で例外 | E-04 L2237-2238 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-92, C-93**：ドメイン最大長（253文字）の境界値テストにおいて、具体的な253文字のドメイン文字列の生成方法が未定義
  - 候補：`MAX_DOMAIN_LENGTH`定数値（253）に基づく動的生成 / 固定の長大ドメイン文字列のハードコーディング

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接導出可能
- **1: 中リスク** - IPv6関連のテスト（ゾーンID、プレフィックス長）は実装の詳細確認推奨
- **0: 低リスク** - DomainValidatorのTLD検証は外部データ（IANA TLDリスト）に依存するが、コード内に静的リストとして保持

## 6) レビュアーチェックリスト（最小）
- [ ] InetAddressValidatorのIPv4/IPv6検証ロジックが RFC準拠か確認
- [ ] UrlValidatorのパストラバーサル検証が十分か確認
- [ ] DomainValidatorのTLDリストが最新か確認（GENERIC_TLDS配列）
- [ ] 境界値テスト（ポート番号、ドメイン長）の値が正確か確認
- [ ] 各クラスのnullハンドリングが網羅されているか確認
- [ ] シングルトンパターンのスレッドセーフティが考慮されているか確認
