---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.plugins 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. **静的初期化ブロックのテスト（UT-PLG-026〜028）**：リソースファイル依存のため実行環境に注意
  2. **バージョン比較ロジック（UT-PLG-003〜004, 007）**：VersionNumber比較の境界条件
  3. **循環依存防止ロジック（UT-PLG-005〜006）**：BREAK_CYCLESの実際の内容を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java` - メインクラスソースコード
- E-02: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:77-96` - getImpliedDependenciesメソッド
- E-03: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:103-106` - getDetachedPlugins()メソッド
- E-04: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:115-120` - getDetachedPlugins(VersionNumber)メソッド
- E-05: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:129-137` - isDetachedPluginメソッド
- E-06: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:139-141` - configLinesメソッド
- E-07: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:158-208` - DetachedPlugin内部クラス
- E-08: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:49-66` - 静的初期化ブロック
- E-09: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:47` - BREAK_CYCLES定義
- E-10: `core/src/main/java/jenkins/plugins/DetachedPluginsUtil.java:89` - jenkinsVersion nullチェック条件

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PLG-001: jenkinsVersionがnullの場合に全分離プラグインが暗黙依存として返却される | E-02, E-10（89行目: `jenkinsVersion == null`の条件分岐） | ○ |
| C-02 | UT-PLG-002: jenkinsVersionが"null"文字列の場合も全分離プラグインが返却される | E-02, E-10（89行目: `jenkinsVersion.equals("null")`の条件分岐） | ○ |
| C-03 | UT-PLG-003: 古いjenkinsVersionの場合に該当分離プラグインが暗黙依存として返却される | E-02（89行目: `new VersionNumber(jenkinsVersion).compareTo(detached.splitWhen) <= 0`） | ○ |
| C-04 | UT-PLG-004: 新しいjenkinsVersionの場合に暗黙依存が返却されない | E-02（89行目: compareTo > 0 の場合はoutに追加されない） | ○ |
| C-05 | UT-PLG-005: 自分自身への依存が除外される | E-02（81-83行目: `if (detached.shortName.equals(pluginName)) continue;`） | ○ |
| C-06 | UT-PLG-006: BREAK_CYCLESに含まれる依存が除外される | E-02, E-09（84-87行目: `BREAK_CYCLES.contains(pluginName + ' ' + detached.shortName)`） | ○ |
| C-07 | UT-PLG-007: jenkinsVersionがsplitWhenと同一の場合に暗黙依存が返却される | E-02（89行目: `compareTo(...) <= 0`、等しい場合も含む） | ○ |
| C-08 | UT-PLG-008: 返却される依存がoptional解決として設定されている | E-02（90行目: `";resolution:=optional"`が付与される） | ○ |
| C-09 | UT-PLG-009: 分離プラグインリストの不変コピーが返却される | E-03（105行目: `List.copyOf(DETACHED_LIST)`） | ○ |
| C-10 | UT-PLG-010: 返却されたリストを変更しても元リストに影響しない | E-03（List.copyOfは不変リストを返す） | ○ |
| C-11 | UT-PLG-011: 指定バージョン以降に分離されたプラグインのみ返却される | E-04（118行目: `!detachedPlugin.getSplitWhen().isOlderThan(since)`） | ○ |
| C-12 | UT-PLG-012: 指定バージョンと同一のsplitWhenを持つプラグインが返却される | E-04（isOlderThanは厳密な「より古い」判定、同一は含まない） | ○ |
| C-13 | UT-PLG-013: 指定バージョンより新しいものがない場合に空リストが返却される | E-04（フィルタ結果が空の場合） | ○ |
| C-14 | UT-PLG-014: 分離プラグインの場合にtrueが返却される | E-05（131行目: `detachedPlugin.getShortName().equals(pluginId)`でマッチ時return true） | ○ |
| C-15 | UT-PLG-015: 分離プラグインでない場合にfalseが返却される | E-05（136行目: ループ終了後`return false`） | ○ |
| C-16 | UT-PLG-016: 空文字列の場合にfalseが返却される | E-05（equalsは空文字列とマッチしないため） | ○ |
| C-17 | UT-PLG-017: コメント行がフィルタリングされる | E-06（140行目: `.filter(line -> !line.matches("#.*|\\s*"))`） | ○ |
| C-18 | UT-PLG-018: 空白行がフィルタリングされる | E-06（140行目: `\\s*`パターンで空白行除外） | ○ |
| C-19 | UT-PLG-019: UTF-8エンコーディングで読み込まれる | E-06（140行目: `StandardCharsets.UTF_8`指定） | ○ |
| C-20 | UT-PLG-020: InputStreamがnullの場合にNullPointerExceptionがスローされる | E-06（IOUtils.readLinesはnull入力でNPE） | ○ |
| C-21 | UT-PLG-021: プラグイン短縮名が正しく返却される | E-07（181行目: `return shortName;`） | ○ |
| C-22 | UT-PLG-022: 分離バージョンがVersionNumberとして返却される | E-07（189行目: `return splitWhen;`、フィールドはVersionNumber型） | ○ |
| C-23 | UT-PLG-023: 必要バージョンがVersionNumberとして返却される | E-07（201行目: `return new VersionNumber(requiredVersion);`） | ○ |
| C-24 | UT-PLG-024: 文字列表現が"shortName splitWhen requiredVersion"形式で返却される | E-07（205-206行目: toStringメソッド実装） | ○ |
| C-25 | UT-PLG-025: splitWhenから".*"が除去されて表示される | E-07（206行目: `.replace(".*", "")`） | ○ |
| C-26 | UT-PLG-026: split-plugins.txtから分離プラグインリストが読み込まれる | E-08（50-57行目: リソース読み込みとパース処理） | ○ |
| C-27 | UT-PLG-027: split-plugin-cycles.txtから循環依存リストが読み込まれる | E-08（61-65行目: BREAK_CYCLES初期化） | ○ |
| C-28 | UT-PLG-028: split-plugins.txtが存在しない場合にExceptionInInitializerErrorがスローされる | E-08（58-60行目: catch節でExceptionInInitializerError） | ○ |
| C-29 | UT-PLG-029: splitWhenが".*"付きバージョンとしてパースされる | E-07（172行目: `this.splitWhen = new VersionNumber(splitWhen);`、55行目で`+ ".*"`付与） | ○ |
| C-30 | UT-PLG-030: 依存文字列が"pluginName:version;resolution:=optional"形式で返却される | E-02（90行目: 文字列フォーマット確認） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全テストケースがソースコードに基づいて作成されています

追加で確認が望ましい情報:
- `/jenkins/split-plugins.txt` の実際の内容（テストデータ作成用）
- `/jenkins/split-plugin-cycles.txt` の実際の内容（BREAK_CYCLESテスト用）
- 既存のテストクラス `DetachedPluginsUtilTest.java` との整合性

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されており、信頼度は高い

注意点:
- 静的初期化ブロックのテスト（UT-PLG-026〜028）はクラスローダーの動作に依存するため、テスト実装時に注意が必要
- リソースファイル（split-plugins.txt, split-plugin-cycles.txt）のモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全30件のテストケースがソースコードの各メソッド・分岐を網羅しているか確認
- [ ] バージョン比較ロジック（VersionNumber.compareTo, isOlderThan）の境界条件が適切か確認
- [ ] 静的初期化ブロックのテスト方針（リソースファイルのモック方法）を検討
- [ ] 既存テストクラス `DetachedPluginsUtilTest.java` との重複・整合性を確認
- [ ] BREAK_CYCLESの実際のエントリを確認し、テストデータとして使用可能か検討
