---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.run 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：48 / 48、根拠なし：0
- 優先レビュー（高）
  1. **UT-RUN-008〜011**：ConsoleTabFactory.createFor()のフラグ制御ロジック
  2. **UT-RUN-019〜021**：OverviewTabFactory.createFor()のフラグ制御ロジック
  3. **UT-RUN-029〜033**：ChangesTabFactory.createFor()のChangeSet判定ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/run/ConsoleTab.java`
- E-02: `core/src/main/java/jenkins/run/ConsoleTabFactory.java`
- E-03: `core/src/main/java/jenkins/run/OverviewTab.java`
- E-04: `core/src/main/java/jenkins/run/OverviewTabFactory.java`
- E-05: `core/src/main/java/jenkins/run/ChangesTab.java`
- E-06: `core/src/main/java/jenkins/run/ChangesTabFactory.java`
- E-07: `core/src/main/java/jenkins/model/Tab.java`
- E-08: `core/src/main/java/jenkins/model/TransientActionFactory.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConsoleTab クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConsoleTab(Actionable)コンストラクタはsuper(object)を呼び出す | E-01 L32-34 | ○ |
| C-02 | getIconFileName()は"symbol-terminal"を返却する | E-01 L37-39 | ○ |
| C-03 | getDisplayName()は"Console"を返却する | E-01 L41-44 | ○ |
| C-04 | getUrlName()は"console"を返却する | E-01 L46-49 | ○ |
| C-05 | ConsoleTabはTabクラスを継承している | E-01 L30 | ○ |
| C-06 | getObject()はTabクラスから継承したメソッドである | E-07 L52-54 | ○ |

### ConsoleTabFactory クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | type()はRun.classを返却する | E-02 L41-44 | ○ |
| C-08 | @Extension ordinalはInteger.MAX_VALUE - 1である | E-02 L38 | ○ |
| C-09 | createFor()はDefaultConsoleUrlProvider使用時かつ実験的UI有効時にConsoleTabを返却する | E-02 L48-57 | ○ |
| C-10 | createFor()はカスタムConsoleUrlProvider使用時に空セットを返却する | E-02 L52-54 | ○ |
| C-11 | createFor()は実験的UI無効時に空セットを返却する | E-02 L52-54 | ○ |
| C-12 | createFor()のtargetパラメータには@NonNullアノテーションが付いている | E-02 L48 | ○ |

### OverviewTab クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | OverviewTab(Actionable)コンストラクタはsuper(object)を呼び出す | E-03 L32-34 | ○ |
| C-14 | getIconFileName()は"symbol-overview"を返却する | E-03 L37-39 | ○ |
| C-15 | getDisplayName()は"Overview"を返却する | E-03 L41-44 | ○ |
| C-16 | getUrlName()はnullを返却する | E-03 L46-49 | ○ |
| C-17 | OverviewTabはTabクラスを継承している | E-03 L30 | ○ |

### OverviewTabFactory クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | type()はRun.classを返却する | E-04 L39-42 | ○ |
| C-19 | @Extension ordinalはInteger.MAX_VALUEである | E-04 L36 | ○ |
| C-20 | createFor()は実験的UI有効時にOverviewTabを返却する | E-04 L46-54 | ○ |
| C-21 | createFor()は実験的UI無効時に空セットを返却する | E-04 L49-51 | ○ |
| C-22 | createFor()のtargetパラメータには@NonNullアノテーションが付いている | E-04 L46 | ○ |

### ChangesTab クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | ChangesTab(Actionable)コンストラクタはsuper(object)を呼び出す | E-05 L32-34 | ○ |
| C-24 | getIconFileName()は"symbol-changes"を返却する | E-05 L37-39 | ○ |
| C-25 | getDisplayName()は"Changes"を返却する | E-05 L41-44 | ○ |
| C-26 | getUrlName()は"changes"を返却する | E-05 L46-49 | ○ |
| C-27 | ChangesTabはTabクラスを継承している | E-05 L30 | ○ |

### ChangesTabFactory クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | type()はRun.classを返却する | E-06 L40-43 | ○ |
| C-29 | @Extension ordinalはInteger.MAX_VALUE - 2である | E-06 L37 | ○ |
| C-30 | createFor()は実験的UI有効かつChangeSetが存在する場合にChangesTabを返却する | E-06 L47-62 | ○ |
| C-31 | createFor()はRunWithSCMでない場合に空セットを返却する | E-06 L54-61 | ○ |
| C-32 | createFor()はChangeSetが空の場合に空セットを返却する | E-06 L55-58 | ○ |
| C-33 | createFor()は実験的UI無効時に空セットを返却する | E-06 L49-51 | ○ |
| C-34 | createFor()のtargetパラメータには@NonNullアノテーションが付いている | E-06 L47 | ○ |

### 共通・継承関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | TabクラスはActionインターフェースを実装している | E-07 L44 | ○ |
| C-36 | TabクラスはBadgeableインターフェースを実装している | E-07 L44 | ○ |
| C-37 | Tab.getObject()はobjectフィールドを返却する | E-07 L52-54 | ○ |
| C-38 | TransientActionFactoryはExtensionPointを実装している | E-08 L49 | ○ |
| C-39 | TransientActionFactory.type()は抽象メソッドである | E-08 L57 | ○ |
| C-40 | TransientActionFactory.createFor()は抽象メソッドである | E-08 L79 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいており、根拠が明確

### 補足事項
- jenkins.runパッケージは比較的新しいコード（Copyright 2025）であり、ビルドページの実験的UI機能に関連している
- NewBuildPageUserExperimentalFlagの実際の動作はモックまたはスタブが必要
- RunWithSCMインターフェースのテストにはテスト用の実装クラスが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各Tabクラスのコンストラクタテストでnullハンドリングが適切にテストされているか確認
- [ ] ファクトリクラスのcreateFor()メソッドの条件分岐が全てカバーされているか確認
- [ ] NewBuildPageUserExperimentalFlagのモック化方法が適切か確認
- [ ] RunWithSCMインターフェースのテスト用実装が準備されているか確認
- [ ] @Extension ordinal値のテストが実際のExtensionListの順序に影響することを確認
- [ ] getUrlName()がnullを返すOverviewTabの挙動が意図通りか確認
