---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.scm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：45 / 45、根拠なし：0
- 優先レビュー（高）
  1. なし（全てのClaimに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/scm/SCMCheckoutStrategy.java`
- E-02: `core/src/main/java/jenkins/scm/SCMCheckoutStrategyDescriptor.java`
- E-03: `core/src/main/java/jenkins/scm/SCMDecisionHandler.java`
- E-04: `core/src/main/java/jenkins/scm/DefaultSCMCheckoutStrategyImpl.java`
- E-05: `core/src/main/java/jenkins/scm/RunWithSCM.java`
- E-06: `test/src/test/java/jenkins/scm/SCMCheckoutStrategyTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SCMCheckoutStrategy関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | preCheckoutメソッドでBuildableItemWithBuildWrappersの場合にBuildWrapper.preCheckoutが呼び出される | E-01 (L70-77) | ○ |
| C-02 | preCheckoutメソッドでBuildableItemWithBuildWrappers以外の場合は処理をスキップ | E-01 (L72 instanceof判定) | ○ |
| C-03 | preCheckoutがIOExceptionをthrows宣言している | E-01 (L70) | ○ |
| C-04 | preCheckoutがInterruptedExceptionをthrows宣言している | E-01 (L70) | ○ |
| C-05 | checkoutメソッドでexecution.defaultCheckout()が呼び出される | E-01 (L84-86) | ○ |
| C-06 | checkoutがIOExceptionをthrows宣言している | E-01 (L84) | ○ |
| C-07 | checkoutがInterruptedExceptionをthrows宣言している | E-01 (L84) | ○ |
| C-08 | getDescriptorがSCMCheckoutStrategyDescriptor型を返却する | E-01 (L88-91) | ○ |

### SCMCheckoutStrategyDescriptor関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | Class引数のコンストラクタが存在する | E-02 (L15-17) | ○ |
| C-10 | 引数なしコンストラクタが存在する | E-02 (L19-20) | ○ |
| C-11 | isApplicableメソッドが抽象メソッドとして定義されている | E-02 (L26) | ○ |
| C-12 | all()メソッドがDescriptorExtensionListを返却する | E-02 (L31-33) | ○ |
| C-13 | _for()メソッドがisApplicable=trueのDescriptorのみをフィルタリングする | E-02 (L35-42) | ○ |
| C-14 | _for()メソッドの戻り値がListである | E-02 (L35) | ○ |
| C-15 | all()が空の場合は_for()も空リストを返す | E-02 (L36-42 ループロジック) | ○ |
| C-16 | 全Descriptorがapplicableの場合は全て返却される | E-02 (L38-39 条件判定) | ○ |

### SCMDecisionHandler関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | shouldPollメソッドが抽象メソッドとして定義されている | E-03 (L47) | ○ |
| C-18 | all()メソッドがExtensionListを返却する | E-03 (L52-55) | ○ |
| C-19 | firstShouldPollVetoがshouldPoll=falseの最初のハンドラーを返す | E-03 (L63-70) | ○ |
| C-20 | firstShouldPollVetoが全trueの場合nullを返す | E-03 (L69 return null) | ○ |
| C-21 | firstShouldPollVetoでハンドラー未登録時はnullを返す | E-03 (L64-69 ループ終了後return null) | ○ |
| C-22 | listShouldPollVetosが全Vetoハンドラーをリストで返す | E-03 (L78-86) | ○ |
| C-23 | listShouldPollVetosが全trueの場合空リストを返す | E-03 (L85 return result) | ○ |
| C-24 | listShouldPollVetosでハンドラー未登録時は空リストを返す | E-03 (L79, L85) | ○ |

### DefaultSCMCheckoutStrategyImpl関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | DataBoundConstructorアノテーションが付与されている | E-04 (L14-15) | ○ |
| C-26 | DescriptorImpl.getDisplayNameが"Default"を返却する | E-04 (L21-23) | ○ |
| C-27 | DescriptorImpl.isApplicableが常にtrueを返す | E-04 (L26-28) | ○ |
| C-28 | isApplicableがnull入力でもtrueを返す可能性 | E-04 (L27 project未使用) | ○ |

### RunWithSCM関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | getChangeSetsがChangeLogSetのリストを返却する | E-05 (L57-59) | ○ |
| C-30 | getChangeSetsが空リストを返す可能性がある（@NonNull） | E-05 (L58 @NonNull) | ○ |
| C-31 | getCulpritIdsがユーザーIDのSetを返却する | E-05 (L67-68) | ○ |
| C-32 | getCulpritIdsがnullを返す可能性がある（@CheckForNull） | E-05 (L67 @CheckForNull) | ○ |
| C-33 | shouldCalculateCulpritsがboolean値を返却する | E-05 (L75-76) | ○ |
| C-34 | getCulpritsでshouldCalculateCulprits=trueならcalculateCulpritsを呼ぶ | E-05 (L92-93) | ○ |
| C-35 | getCulpritsでshouldCalculateCulprits=falseならキャッシュから取得 | E-05 (L96-114) | ○ |
| C-36 | getCulpritsでCulpritIdsが空なら空Setを返す | E-05 (L111 size()が0) | ○ |
| C-37 | calculateCulpritsで前回失敗時に前回Culpritsを継承する | E-05 (L128-134) | ○ |
| C-38 | calculateCulpritsで前回成功時は今回の変更者のみ | E-05 (L130 isWorseThan判定) | ○ |
| C-39 | calculateCulpritsで前回ビルドnullなら今回変更者のみ | E-05 (L128 null check) | ○ |
| C-40 | calculateCulpritsで前回Result nullなら今回変更者のみ | E-05 (L130 pr != null判定) | ○ |
| C-41 | calculateCulpritsでChangeSets空なら前回Culpritsのみ | E-05 (L136-140 ループ) | ○ |
| C-42 | hasParticipantでユーザーがコミッターならtrueを返す | E-05 (L152-155) | ○ |
| C-43 | hasParticipantでユーザーが非コミッターならfalseを返す | E-05 (L162 return false) | ○ |
| C-44 | hasParticipantでChangeSets空ならfalseを返す | E-05 (L150-162 ループ) | ○ |
| C-45 | hasParticipantでgetAuthor例外時はfalse返却＋ログ出力 | E-05 (L156-159 catch句) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのClaimにソースコード上の根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードの実装に基づいて作成されている
- 注意点:
  - RunWithSCMインターフェースのdefaultメソッドは実装クラスでオーバーライドされる可能性がある
  - Jenkins環境依存のテスト（all(), _for()等）は統合テスト環境が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全publicメソッドをカバーしているか確認
- [ ] 異常系テストケースが例外処理ロジックを適切にカバーしているか確認
- [ ] 境界値テストケースがnull/空コレクション等のエッジケースをカバーしているか確認
- [ ] RunWithSCMのdefaultメソッドに対するテストが十分か確認
- [ ] Jenkins環境依存のテストケースに対する実行環境を検討
