---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 137
  claims_with_evidence: 137
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.search 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・分岐が存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードのロジックと矛盾していないか
3. **網羅性**：全クラス・メソッドの主要なパスをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：137 / 137、根拠なし：0
- 優先レビュー（高）
  1. **権限チェックテスト（UT-SRC-038, 039, 040）**：実際のJenkins環境でのテストが必要
  2. **検索処理テスト（UT-SRC-009, 010）**：StaplerRequest/Responseのモック設計が必要
  3. **階層構築テスト（UT-SRC-061）**：ItemGroupの複雑な階層構造のテストデータ設計が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/search/SearchGroup.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/Search.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchIndex.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SuggestedItem.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchItem.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchResult.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchIndexBuilder.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchableModelObject.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/UnionSearchIndex.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/CollectionSearchIndex.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/FixedSet.java`
- E-12: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchItems.java`
- E-13: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/UserSearchProperty.java`
- E-14: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/QuickSilver.java`
- E-15: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/ParsedQuickSilver.java`
- E-16: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchFactory.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### jenkins.search.SearchGroup（UT-SRC-001〜008）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | all()でExtensionList<SearchGroup>取得 | E-01 L17-19 | ○ |
| C-02 | get()で型指定取得 | E-01 L21-27 | ○ |
| C-03 | 未登録時AssertionError | E-01 L23-25 | ○ |
| C-04 | UnclassifiedSearchGroup表示名 | E-01 L30-36 | ○ |
| C-05 | ItemSearchGroup表示名 | E-01 L38-45 | ○ |
| C-06 | ComputerSearchGroup表示名 | E-01 L47-54 | ○ |
| C-07 | ViewSearchGroup表示名 | E-01 L56-63 | ○ |
| C-08 | UserSearchGroup表示名 | E-01 L65-72 | ○ |

### hudson.search.Search（UT-SRC-009〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | doIndex正常リダイレクト | E-02 L114-140 | ○ |
| C-10 | doIndex404返却 | E-02 L138-139 | ○ |
| C-11 | 空クエリ処理 | E-02 L126 | ○ |
| C-12 | nullクエリ処理 | E-02 L126 | ○ |
| C-13 | doSuggestOpenSearchのJSON出力 | E-02 L151-162 | ○ |
| C-14 | doSuggestのResult返却 | E-02 L167-201 | ○ |
| C-15 | symbolタイプ判定 | E-02 L178-180 | ○ |
| C-16 | imageタイプ判定 | E-02 L181-182 | ○ |
| C-17 | デフォルトアイコン | E-02 L172-176 | ○ |
| C-18 | グループ順ソート | E-02 L186-198 | ○ |
| C-19 | 最大件数制限(100) | E-02 L229-231 | ○ |
| C-20 | maxパラメータ | E-02 L230 | ○ |
| C-21 | MAX_SEARCH_SIZE制限(500) | E-02 L87, L231 | ○ |
| C-22 | hasMoreResults | E-02 L236-237, L280 | ○ |
| C-23 | 重複パス除外 | E-02 L239 | ○ |
| C-24 | getMaxSearchSize | E-02 L245-247 | ○ |
| C-25 | findClosestSuggestedItem URL一致 | E-02 L368-381 | ○ |
| C-26 | findClosestSuggestedItem フォールバック | E-02 L380 | ○ |
| C-27 | find単一マッチ | E-02 L396-410 | ○ |
| C-28 | find複数マッチ | E-02 L404-408 | ○ |
| C-29 | findマッチなし | E-02 L398-400 | ○ |
| C-30 | suggest編集距離ソート | E-02 L423-457 | ○ |
| C-31 | 前方一致優先 | E-02 L434, L439-440 | ○ |
| C-32 | TokenListトークン分割 | E-02 L463 | ○ |
| C-33 | TokenList null処理 | E-02 L463 | ○ |
| C-34 | TokenList空文字処理 | E-02 L463 | ○ |
| C-35 | TokenList length | E-02 L466 | ○ |
| C-36 | TokenList subSequence | E-02 L473-488 | ○ |
| C-37 | TokenList toString | E-02 L491-501 | ○ |
| C-38 | getTarget権限あり | E-02 L547-554 | ○ |
| C-39 | getTarget権限なし | E-02 L551 | ○ |
| C-40 | SKIP_PERMISSION_CHECK | E-02 L550, L559-561 | ○ |
| C-41 | Result初期化 | E-02 L286-289 | ○ |
| C-42 | Item全フィールドコンストラクタ | E-02 L309-316 | ○ |
| C-43 | Item簡易コンストラクタ | E-02 L305-307 | ○ |
| C-44 | Item.getUrl | E-02 L318-321 | ○ |
| C-45 | Item.getIcon | E-02 L323-326 | ○ |
| C-46 | Item.getType | E-02 L328-331 | ○ |
| C-47 | Item.getGroup | E-02 L333-336 | ○ |

### hudson.search.SearchIndex（UT-SRC-048〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | find契約 | E-03 L37 | ○ |
| C-49 | suggest契約 | E-03 L43 | ○ |
| C-50 | EMPTY.find | E-03 L48-52 | ○ |
| C-51 | EMPTY.suggest | E-03 L54-57 | ○ |

### hudson.search.SuggestedItem（UT-SRC-052〜061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | コンストラクタ(親なし) | E-04 L40-42 | ○ |
| C-53 | コンストラクタ(親あり) | E-04 L44-47 | ○ |
| C-54 | getPath(ルート) | E-04 L49-57 | ○ |
| C-55 | getPath(子) | E-04 L60-67 | ○ |
| C-56 | パスキャッシュ | E-04 L50 | ○ |
| C-57 | getUrl相対URL | E-04 L77-81, L105-118 | ○ |
| C-58 | getUrl絶対URL | E-04 L110-112 | ○ |
| C-59 | URL末尾スラッシュ | E-04 L114-115 | ○ |
| C-60 | build(SearchItem) | E-04 L98-103 | ○ |
| C-61 | build(Item)階層 | E-04 L83-90 | ○ |

### hudson.search.SearchItem（UT-SRC-062〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | getSearchName契約 | E-05 L47 | ○ |
| C-63 | getSearchUrl契約 | E-05 L57 | ○ |
| C-64 | getSearchIcon(IconSpec) | E-05 L59-62 | ○ |
| C-65 | getSearchIconデフォルト | E-05 L64 | ○ |
| C-66 | getSearchGroupデフォルト | E-05 L67-69 | ○ |
| C-67 | getSearchIndex契約 | E-05 L78 | ○ |

### hudson.search.SearchResult（UT-SRC-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | hasMoreResults契約 | E-06 L10 | ○ |

### hudson.search.SearchIndexBuilder（UT-SRC-069〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | コンストラクタ初期化 | E-07 L41-43 | ○ |
| C-70 | addAllAnnotations | E-07 L48-51 | ○ |
| C-71 | add(String) | E-07 L56-58 | ○ |
| C-72 | add(String,String) | E-07 L66-69 | ○ |
| C-73 | add(String,String[]) | E-07 L71-75 | ○ |
| C-74 | add(SearchItem) | E-07 L77-80 | ○ |
| C-75 | add(String,SMO,String) | E-07 L82-85 | ○ |
| C-76 | add(SearchIndex) | E-07 L93-96 | ○ |
| C-77 | add(SearchIndexBuilder) | E-07 L98-100 | ○ |
| C-78 | make | E-07 L102-107 | ○ |
| C-79 | make空 | E-07 L103 | ○ |

### hudson.search.SearchableModelObject（UT-SRC-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | getSearch契約 | E-08 L44 | ○ |

### hudson.search.UnionSearchIndex（UT-SRC-081〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | combine合成 | E-09 L35-48 | ○ |
| C-82 | combine null処理 | E-09 L40 | ○ |
| C-83 | combine EMPTY処理 | E-09 L40 | ○ |
| C-84 | combine全空 | E-09 L36 | ○ |
| C-85 | コンストラクタ | E-09 L52-55 | ○ |
| C-86 | find委譲 | E-09 L57-61 | ○ |
| C-87 | suggest委譲 | E-09 L63-67 | ○ |

### hudson.search.CollectionSearchIndex（UT-SRC-088〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | get契約 | E-10 L42 | ○ |
| C-89 | all契約 | E-10 L48 | ○ |
| C-90 | allAsIterable null | E-10 L51-54 | ○ |
| C-91 | allAsIterable非null | E-10 L53 | ○ |
| C-92 | findヒット | E-10 L57-61 | ○ |
| C-93 | findヒットなし | E-10 L58-60 | ○ |
| C-94 | suggest大文字小文字区別なし | E-10 L64-76 | ○ |
| C-95 | suggest大文字小文字区別あり | E-10 L65-73 | ○ |
| C-96 | suggest null要素 | E-10 L73 | ○ |
| C-97 | getName | E-10 L78-80 | ○ |

### hudson.search.FixedSet（UT-SRC-098〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | コンストラクタ(Collection) | E-11 L41-43 | ○ |
| C-99 | コンストラクタ(varargs) | E-11 L45-47 | ○ |
| C-100 | find大文字小文字区別なし | E-11 L50-58 | ○ |
| C-101 | find大文字小文字区別あり | E-11 L54 | ○ |
| C-102 | find null name | E-11 L53 | ○ |
| C-103 | suggest大文字小文字区別なし | E-11 L61-69 | ○ |
| C-104 | suggest大文字小文字区別あり | E-11 L65 | ○ |
| C-105 | suggest null name | E-11 L64 | ○ |

### hudson.search.SearchItems（UT-SRC-106〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | create(String,String) | E-12 L31-33 | ○ |
| C-107 | create EMPTY返却 | E-12 L32 | ○ |
| C-108 | create(String,String,SearchIndex) | E-12 L35-52 | ○ |
| C-109 | create(String,String,SMO) | E-12 L54-71 | ○ |

### hudson.search.UserSearchProperty（UT-SRC-110〜117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | コンストラクタ | E-13 L20-22 | ○ |
| C-111 | getInsensitiveSearch | E-13 L24-27 | ○ |
| C-112 | isCaseInsensitiveユーザー設定 | E-13 L29-37 | ○ |
| C-113 | isCaseInsensitiveデフォルト | E-13 L32-33 | ○ |
| C-114 | DescriptorImpl.getDisplayName | E-13 L42-46 | ○ |
| C-115 | DescriptorImpl.newInstance(User) | E-13 L48-51 | ○ |
| C-116 | DescriptorImpl.newInstance(Request) | E-13 L53-56 | ○ |
| C-117 | getUserPropertyCategory | E-13 L58-61 | ○ |

### hudson.search.QuickSilver（UT-SRC-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | valueデフォルト | E-14 L54 | ○ |

### hudson.search.ParsedQuickSilver（UT-SRC-119〜135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | getキャッシュ取得 | E-15 L45-50 | ○ |
| C-120 | get2回目キャッシュ | E-15 L46 | ○ |
| C-121 | メソッドパース | E-15 L57-67 | ○ |
| C-122 | フィールドパース | E-15 L69-79 | ○ |
| C-123 | value空時名前生成 | E-15 L61-62 | ○ |
| C-124 | valueカスタム名前 | E-15 L63-66 | ○ |
| C-125 | splitName | E-15 L85-92 | ○ |
| C-126 | stripGetPrefix除去 | E-15 L94-99 | ○ |
| C-127 | stripGetPrefixなし | E-15 L95-98 | ○ |
| C-128 | MethodGetter.get | E-15 L122-136 | ○ |
| C-129 | MethodGetter IllegalAccess | E-15 L126-127 | ○ |
| C-130 | MethodGetter Error伝播 | E-15 L130-131 | ○ |
| C-131 | MethodGetter RuntimeException伝播 | E-15 L132-133 | ○ |
| C-132 | FieldGetter.get | E-15 L148-154 | ○ |
| C-133 | FieldGetter IllegalAccess | E-15 L151-153 | ○ |
| C-134 | addTo | E-15 L163-183 | ○ |
| C-135 | addTo null処理 | E-15 L178-179 | ○ |

### hudson.search.SearchFactory（UT-SRC-136〜137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | createFor契約 | E-16 L36 | ○ |
| C-137 | all | E-16 L41-43 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全テストケースがソースコードの実装に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全テストケースがソースコード分析に基づいており、実装との整合性が確認されています
- **注意点**：
  - 一部のテストケース（権限チェック、StaplerRequest/Response関連）は実際のJenkins環境またはモックを必要とします
  - ParsedQuickSilverのリフレクション関連テストでは適切なテストクラスの作成が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースのテスト観点（正常系/異常系/境界値）が適切か
- [ ] 優先度の設定が妥当か（金額計算、認証認可は高優先度）
- [ ] 期待結果がソースコードの実装と整合しているか
- [ ] 前提条件が現実的にテスト環境で再現可能か
- [ ] 権限チェック関連テスト（UT-SRC-038〜040）のモック設計が適切か
- [ ] Stapler関連テスト（UT-SRC-009〜018）のリクエスト/レスポンスモックが十分か
