---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 134
  claims_with_evidence: 134
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.security 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：134 / 134、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースがソースコードに基づいて生成されており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/security/ConfidentialKey.java`
- E-02: `core/src/main/java/jenkins/security/ConfidentialStore.java`
- E-03: `core/src/main/java/jenkins/security/DefaultConfidentialStore.java`
- E-04: `core/src/main/java/jenkins/security/CryptoConfidentialKey.java`
- E-05: `core/src/main/java/jenkins/security/HMACConfidentialKey.java`
- E-06: `core/src/main/java/jenkins/security/HexStringConfidentialKey.java`
- E-07: `core/src/main/java/jenkins/security/RSAConfidentialKey.java`
- E-08: `core/src/main/java/jenkins/security/RSADigitalSignatureConfidentialKey.java`
- E-09: `core/src/main/java/jenkins/security/ApiTokenProperty.java`
- E-10: `core/src/main/java/jenkins/security/apitoken/ApiTokenStore.java`
- E-11: `core/src/main/java/jenkins/security/SecurityListener.java`
- E-12: `core/src/main/java/jenkins/security/UserDetailsCache.java`
- E-13: `core/src/main/java/jenkins/security/BasicHeaderProcessor.java`
- E-14: `core/src/main/java/jenkins/security/SuspiciousRequestFilter.java`
- E-15: `core/src/main/java/jenkins/security/FIPS140.java`
- E-16: `core/src/main/java/jenkins/security/QueueItemAuthenticator.java`
- E-17: `core/src/main/java/jenkins/security/ImpersonatingExecutorService.java`
- E-18: `core/src/main/java/jenkins/security/csp/CspBuilder.java`
- E-19: `core/src/main/java/jenkins/security/stapler/StaticRoutingDecisionProvider.java`
- E-20: `core/src/main/java/jenkins/security/stapler/TypedFilter.java`
- E-21: `core/src/main/java/jenkins/security/CustomClassFilter.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfidentialKey 関連（UT-SEC-001〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfidentialKey.getId()でIDが取得できる | E-01: L53-55 | ○ |
| C-02 | ConfidentialKey.load()でデータがロードできる | E-01: L45-47 | ○ |
| C-03 | データが存在しない場合nullが返却される | E-01: L45-47, E-02: L57-58 | ○ |
| C-04 | ConfidentialKey.store()でデータが保存できる | E-01: L49-51 | ○ |

### ConfidentialStore 関連（UT-SEC-005〜011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | シングルトンインスタンスが取得できる | E-02: L73-102 | ○ |
| C-06 | Jenkinsインスタンスがない場合Mockが返却される | E-02: L74-77 | ○ |
| C-07 | randomBytes()で指定サイズの配列が生成される | E-02: L68 | ○ |
| C-08 | サイズ0で空配列が返却される | E-02: L148-153 | ○ |
| C-09 | Mock.store()でデータが保存される | E-02: L128-132 | ○ |
| C-10 | Mock.load()で保存済みデータが取得できる | E-02: L135-141 | ○ |
| C-11 | Mock.clear()で全データがクリアされる | E-02: L124-126 | ○ |

### DefaultConfidentialStore 関連（UT-SEC-012〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | master.keyが自動生成される | E-03: L83-91 | ○ |
| C-13 | 既存のmaster.keyが読み込まれる | E-03: L93 | ○ |
| C-14 | readOnlyモードでmaster.key不在時に例外 | E-03: L85-86 | ○ |
| C-15 | データが暗号化されて保存される | E-03: L99-114 | ○ |
| C-16 | 暗号化データが復号化されて読み込まれる | E-03: L122-146 | ○ |
| C-17 | ファイル不存在時にnullが返却される | E-03: L125-126 | ○ |
| C-18 | 破損データでnullが返却される | E-03: L139-145 | ○ |
| C-19 | MAGICトレーラーが検証される | E-03: L151-162 | ○ |
| C-20 | MAGIC不正でnullが返却される | E-03: L155-157 | ○ |

### CryptoConfidentialKey 関連（UT-SEC-021〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | ID指定でインスタンスが生成される | E-04: L27-29 | ○ |
| C-22 | クラスと短縮名でインスタンスが生成される | E-04: L31-33 | ○ |
| C-23 | SecretKeyが生成される | E-04: L35-52 | ○ |
| C-24 | 鍵がキャッシュされる | E-04: L37-38 | ○ |
| C-25 | 暗号化用Cipherが取得できる（非推奨） | E-04: L57-67 | ○ |
| C-26 | IV付き暗号化用Cipherが取得できる | E-04: L74-84 | ○ |
| C-27 | IV付き復号化用Cipherが取得できる | E-04: L91-100 | ○ |
| C-28 | デフォルト長のIVが生成される | E-04: L119-122 | ○ |
| C-29 | 指定長のIVが生成される | E-04: L108-111 | ○ |

### HMACConfidentialKey 関連（UT-SEC-030〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | ID指定でインスタンスが生成される | E-05: L50-52 | ○ |
| C-31 | 長さ指定でインスタンスが生成される | E-05: L42-45 | ○ |
| C-32 | バイト配列のMACが計算される | E-05: L69-76 | ○ |
| C-33 | 文字列のMACが16進数で返却される | E-05: L89-91 | ○ |
| C-34 | 正しいMACが検証に成功する | E-05: L81-83 | ○ |
| C-35 | 不正なMACが検証に失敗する | E-05: L81-83 | ○ |
| C-36 | 文字列MACの検証が成功する | E-05: L96-98 | ○ |
| C-37 | MACが指定長に切り詰められる | E-05: L100-111 | ○ |
| C-38 | MACが指定長より短い場合そのまま返却 | E-05: L106 | ○ |
| C-39 | FIPSモードで短い長さ指定時に例外 | E-05: L103-105 | ○ |
| C-40 | Macインスタンスが生成される | E-05: L116-125 | ○ |

### HexStringConfidentialKey 関連（UT-SEC-041〜045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 偶数長でインスタンスが生成される | E-06: L26-31 | ○ |
| C-42 | 奇数長で例外がスローされる | E-06: L28-29 | ○ |
| C-43 | 16進数文字列が返却される | E-06: L46-62 | ○ |
| C-44 | キャッシュされた値が返却される | E-06: L48-49 | ○ |
| C-45 | 新規生成値がストアに保存される | E-06: L53-54 | ○ |

### RSAConfidentialKey 関連（UT-SEC-046〜049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | RSA秘密鍵が生成される | E-07: L74-100 | ○ |
| C-47 | 保存済み鍵がロードされる | E-07: L87-94 | ○ |
| C-48 | RSA公開鍵が取得できる | E-07: L102-105 | ○ |
| C-49 | Base64エンコード公開鍵が取得できる | E-07: L110-112 | ○ |

### RSADigitalSignatureConfidentialKey 関連（UT-SEC-050〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | メッセージが署名される | E-08: L50-60 | ○ |
| C-51 | 同じメッセージで同じ署名が生成される | E-08: L50-60 | ○ |

### ApiTokenProperty 関連（UT-SEC-052〜062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | 有効なトークンで認証成功 | E-09: L192-205 | ○ |
| C-53 | 無効なトークンで認証失敗 | E-09: L193-195 | ○ |
| C-54 | null/空文字で認証失敗 | E-09: L193-195 | ○ |
| C-55 | 空白文字のみで認証失敗 | E-09: L193 | ○ |
| C-56 | レガシートークン存在時にtrue | E-09: L171-174 | ○ |
| C-57 | レガシートークン不在時にfalse | E-09: L171-174 | ○ |
| C-58 | 新しいトークンが生成される | E-09: L434-438 | ○ |
| C-59 | トークンが無効化される | E-09: L458-468 | ○ |
| C-60 | 全トークンが無効化される | E-09: L442-446 | ○ |
| C-61 | 指定トークン以外が無効化される | E-09: L450-455 | ○ |
| C-62 | 固定値トークンが追加される | E-09: L426-430 | ○ |

### ApiTokenStore 関連（UT-SEC-063〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | ランダムトークンが生成される | E-10: L174-186 | ○ |
| C-64 | トークンが34文字 | E-10: L65, L181 | ○ |
| C-65 | 固定値トークンが追加される | E-10: L197-217 | ○ |
| C-66 | 不正な長さで例外 | E-10: L198-200 | ○ |
| C-67 | 不正バージョンで例外 | E-10: L203-205 | ○ |
| C-68 | 非16進数文字で例外 | E-10: L209-211 | ○ |
| C-69 | 一致するトークンが見つかる | E-10: L253-262 | ○ |
| C-70 | 一致しない場合null | E-10: L290-299 | ○ |
| C-71 | トークンが削除される | E-10: L307-318 | ○ |
| C-72 | 存在しないトークンでnull | E-10: L307-318 | ○ |
| C-73 | トークン名が変更される | E-10: L332-342 | ○ |
| C-74 | 存在しないトークンでfalse | E-10: L340-341 | ○ |
| C-75 | 名前順ソートリストが返却される | E-10: L89-93 | ○ |
| C-76 | レガシートークンが変換される | E-10: L124-137 | ○ |
| C-77 | ハッシュ一致時にtrue | E-10: L420-431 | ○ |
| C-78 | ハッシュ不一致時にfalse | E-10: L420-431 | ○ |
| C-79 | レガシートークン判定true | E-10: L456-458 | ○ |
| C-80 | 新形式トークン判定false | E-10: L456-458 | ○ |

### SecurityListener 関連（UT-SEC-081〜086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | 認証イベントが通知される | E-11: L106-119 | ○ |
| C-82 | 認証失敗イベントが通知される | E-11: L139-144 | ○ |
| C-83 | ログインイベントが通知される | E-11: L147-152 | ○ |
| C-84 | ログアウトイベントが通知される | E-11: L163-168 | ○ |
| C-85 | ユーザー作成イベントが通知される | E-11: L131-136 | ○ |
| C-86 | ログイン失敗イベントが通知される | E-11: L155-160 | ○ |

### UserDetailsCache 関連（UT-SEC-087〜093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | キャッシュされたユーザー詳細が取得できる | E-12: L99-107 | ○ |
| C-88 | キャッシュミス時にnull | E-12: L104-106 | ○ |
| C-89 | 存在しないユーザーで例外 | E-12: L101-103 | ○ |
| C-90 | SecurityRealmからロードされる | E-12: L120-136 | ○ |
| C-91 | 存在しないユーザーで例外 | E-12: L128-134 | ○ |
| C-92 | 全キャッシュがクリアされる | E-12: L141-144 | ○ |
| C-93 | 特定ユーザーのキャッシュがクリアされる | E-12: L150-153 | ○ |

### BasicHeaderProcessor 関連（UT-SEC-094〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | Basic認証ヘッダーが処理される | E-13: L66-108 | ○ |
| C-95 | 不正な認証情報で失敗 | E-13: L100 | ○ |
| C-96 | ヘッダーなしで通過 | E-13: L104-107 | ○ |
| C-97 | 不正なBase64でエラーにならない | E-13: L74-79 | ○ |
| C-98 | 未認証でtrue | E-13: L118-142 | ○ |
| C-99 | 同一ユーザー認証済みでfalse | E-13: L130-132 | ○ |

### SuspiciousRequestFilter 関連（UT-SEC-100〜102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | セミコロンなしURLが通過 | E-14: L29-39 | ○ |
| C-101 | セミコロン含むURLが拒否 | E-14: L32-36 | ○ |
| C-102 | allowSemicolonsInPath=trueで許可 | E-14: L32 | ○ |

### FIPS140 関連（UT-SEC-103〜104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | システムプロパティtrueでtrue | E-15: L41, L56-58 | ○ |
| C-104 | システムプロパティfalseでfalse | E-15: L56-58 | ○ |

### QueueItemAuthenticator 関連（UT-SEC-105〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | キューアイテムの認証情報取得 | E-16: L43-55 | ○ |
| C-106 | タスクの認証情報取得 | E-16: L69-82 | ○ |

### ImpersonatingExecutorService 関連（UT-SEC-107〜108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | Runnableが認証コンテキストで実行 | E-17: L63-72 | ○ |
| C-108 | Callableが認証コンテキストで実行 | E-17: L74-84 | ○ |

### CspBuilder 関連（UT-SEC-109〜117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | ディレクティブが追加される | E-18: L102-128 | ○ |
| C-110 | 既存ディレクティブに値がマージ | E-18: L107, L120-125 | ○ |
| C-111 | 禁止ディレクティブが無視 | E-18: L103-106 | ○ |
| C-112 | 'none'値が無視 | E-18: L109-112 | ○ |
| C-113 | ディレクティブが削除される | E-18: L138-155 | ○ |
| C-114 | 特定値のみ削除 | E-18: L144-151 | ○ |
| C-115 | フェッチディレクティブが初期化 | E-18: L168-177 | ○ |
| C-116 | CSP文字列が生成される | E-18: L224-231 | ○ |
| C-117 | 空ディレクティブで'none'設定 | E-18: L242-244 | ○ |

### StaticRoutingDecisionProvider 関連（UT-SEC-118〜124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | ホワイトリストで許可 | E-19: L87-105 | ○ |
| C-119 | ブラックリストで拒否 | E-19: L96-98 | ○ |
| C-120 | リストにない場合UNKNOWN | E-19: L104 | ○ |
| C-121 | ホワイトリストに追加 | E-19: L146-155 | ○ |
| C-122 | ブラックリストに追加 | E-19: L157-166 | ○ |
| C-123 | ホワイトリストから削除 | E-19: L168-178 | ○ |
| C-124 | 設定がリロード | E-19: L107-112 | ○ |

### TypedFilter 関連（UT-SEC-125〜129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | @StaplerDispatchable付きで許可 | E-20: L129-131 | ○ |
| C-126 | @StaplerNotDispatchable付きで拒否 | E-20: L124-127 | ○ |
| C-127 | ルータブルメソッドの戻り値型が許可 | E-20: L186-189 | ○ |
| C-128 | getDynamicメソッドが拒否 | E-20: L228-236 | ○ |
| C-129 | getTargetメソッドが拒否 | E-20: L245-250 | ○ |

### CustomClassFilter 関連（UT-SEC-130〜134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | ホワイトリストクラスが許可 | E-21: L96-119 | ○ |
| C-131 | ブラックリストクラスが拒否 | E-21: L100-101 | ○ |
| C-132 | 未設定クラスでnull | E-21: L116-118 | ○ |
| C-133 | プラグインホワイトリストが適用 | E-21: L144-151 | ○ |
| C-134 | プラグインからクラスフィルタロード | E-21: L153-173 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全テストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードを直接参照して生成されており、根拠が明確です

## 6) レビュアーチェックリスト（最小）
- [ ] 暗号化関連クラス（CryptoConfidentialKey, HMACConfidentialKey等）のテストケースが暗号強度要件を満たしているか
- [ ] FIPS140モードのテストケースがコンプライアンス要件を網羅しているか
- [ ] APIトークン関連のテストケースがセキュリティベストプラクティスに準拠しているか
- [ ] Basic認証処理のテストケースが認証バイパスの可能性を考慮しているか
- [ ] CSPビルダーのテストケースがXSS対策要件を満たしているか
- [ ] Staplerフィルタのテストケースがリモートコード実行防止を考慮しているか
- [ ] CustomClassFilterのテストケースがデシリアライゼーション脆弱性対策を網羅しているか
