---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 125
  claims_with_evidence: 125
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.slaves 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：125 / 125、根拠なし：0
- 優先レビュー（高）
  1. **JnlpAgentReceiver / DefaultJnlpSlaveReceiver の認証・接続処理**：セキュリティ上重要
  2. **JnlpSlaveAgentProtocol4 のTLS初期化**：証明書管理に関わる
  3. **SlaveRestarter 系クラスの再起動処理**：エージェント管理に関わる重要機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/JnlpAgentReceiver.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/DefaultJnlpSlaveReceiver.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/JnlpSlaveAgentProtocol4.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/RemotingWorkDirSettings.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/NioChannelSelector.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/IOHubProvider.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/RemotingVersionInfo.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/WorkspaceLocator.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/PingFailureAnalyzer.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/StandardOutputSwapper.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/EncryptedSlaveAgentJnlpFile.java`
- E-12: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/JnlpSlaveAgentProtocol.java`
- E-13: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/restarter/SlaveRestarter.java`
- E-14: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/restarter/UnixSlaveRestarter.java`
- E-15: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/restarter/WinswSlaveRestarter.java`
- E-16: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/restarter/JnlpSlaveRestarterInstaller.java`
- E-17: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/systemInfo/SlaveSystemInfo.java`
- E-18: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/systemInfo/ThreadDumpSlaveInfo.java`
- E-19: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/systemInfo/SystemPropertySlaveInfo.java`
- E-20: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/systemInfo/EnvVarsSlaveInfo.java`
- E-21: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/slaves/systemInfo/ClassLoaderStatisticsSlaveInfo.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### JnlpAgentReceiver 関連 (UT-SLV-001 - UT-SLV-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exists()が登録済みエージェントでtrue | E-01 L51-58 | ○ |
| C-02 | exists()が未登録エージェントでfalse | E-01 L51-58 | ○ |
| C-03 | generateCookie()が32バイトランダム | E-01 L62-66 | ○ |
| C-04 | all()がExtensionListを返す | E-01 L47-49 | ○ |
| C-05 | JnlpAgentDatabase.exists()がJnlpAgentReceiver.exists()に委譲 | E-01 L68-72 | ○ |
| C-06 | JnlpAgentDatabase.getSecretOf()がSLAVE_SECRET.macを使用 | E-01 L74-77 | ○ |

### DefaultJnlpSlaveReceiver 関連 (UT-SLV-010 - UT-SLV-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | owns()がJenkins.get().getComputer()で判定 | E-02 L64-67 | ○ |
| C-08 | afterProperties()がJNLPLauncher確認後にapprove | E-02 L89-150 | ○ |
| C-09 | 非JNLPLauncherでdisableStrictVerification=falseならreject | E-02 L115-124 | ○ |
| C-10 | 既存接続の同一CookieでDisconnect後approve | E-02 L129-147 | ○ |
| C-11 | beforeChannel()でログファイルオープン・ChannelBuilder設定 | E-02 L153-169 | ○ |
| C-12 | afterChannel()でcomputer.setChannel()呼び出し | E-02 L172-186 | ○ |
| C-13 | channelClosed()でログ出力レベル判定 | E-02 L189-198 | ○ |
| C-14 | State内部クラスの各メソッド動作 | E-02 L200-223 | ○ |

### JnlpSlaveAgentProtocol4 関連 (UT-SLV-026 - UT-SLV-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | getName()がJNLP4-connectを返す | E-03 L141-143 | ○ |
| C-16 | init()でSSLContext初期化 | E-03 L79-134 | ○ |
| C-17 | 証明書なしでKeyStoreException | E-03 L87-89 | ○ |
| C-18 | 秘密鍵なしでKeyStoreException | E-03 L90-93 | ○ |
| C-19 | handle()でhandler.handle()呼び出し | E-03 L146-170 | ○ |
| C-20 | 証明書期限切れ間近で更新 | E-03 L155-163 | ○ |

### RemotingWorkDirSettings 関連 (UT-SLV-032 - UT-SLV-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタでフィールド設定 | E-04 L61-70 | ○ |
| C-22 | デフォルトコンストラクタでデフォルト値 | E-04 L72-75 | ○ |
| C-23 | isConfigured()の判定ロジック | E-04 L79-81 | ○ |
| C-24 | 各getter/isXxx()メソッド | E-04 L89-125 | ○ |
| C-25 | toCommandLineArgs()のコマンドライン生成 | E-04 L137-165 | ○ |
| C-26 | toCommandLineString()の文字列生成 | E-04 L177-207 | ○ |
| C-27 | 静的ファクトリメソッド | E-04 L219-230 | ○ |

### NioChannelSelector / IOHubProvider 関連 (UT-SLV-052 - UT-SLV-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | NioChannelSelectorコンストラクタ | E-05 L23-34 | ○ |
| C-29 | NioChannelSelector.getHub() | E-05 L36-38 | ○ |
| C-30 | NioChannelSelector.cleanUp() | E-05 L40-46 | ○ |
| C-31 | IOHubProviderコンストラクタ | E-06 L51-58 | ○ |
| C-32 | IOHubProvider.getHub() | E-06 L60-62 | ○ |
| C-33 | IOHubProvider.cleanUp() | E-06 L64-70 | ○ |

### RemotingVersionInfo 関連 (UT-SLV-063 - UT-SLV-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | getEmbeddedVersion() | E-07 L97-100 | ○ |
| C-35 | getMinimumSupportedVersion() | E-07 L110-113 | ○ |
| C-36 | extractVersion()のエラーハンドリング | E-07 L69-90 | ○ |

### WorkspaceLocator / PingFailureAnalyzer 関連 (UT-SLV-068 - UT-SLV-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | WorkspaceLocator.locate()抽象メソッド | E-08 L28 | ○ |
| C-38 | WorkspaceLocator.all() | E-08 L34-36 | ○ |
| C-39 | PingFailureAnalyzer.onPingFailure()抽象メソッド | E-09 L27 | ○ |
| C-40 | PingFailureAnalyzer.all() | E-09 L29-31 | ○ |

### StandardOutputSwapper 関連 (UT-SLV-072 - UT-SLV-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | preOnline()でChannelSwapper呼び出し | E-10 L29-39 | ○ |
| C-42 | disabled=trueで処理スキップ | E-10 L31 | ○ |
| C-43 | ChannelSwapper.call()のOS判定・スワップ処理 | E-10 L41-84 | ○ |

### EncryptedSlaveAgentJnlpFile 関連 (UT-SLV-078 - UT-SLV-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタ | E-11 L65-70 | ○ |
| C-45 | generateResponse()の暗号化/平文分岐 | E-11 L73-113 | ○ |
| C-46 | CapturingServletOutputStreamの各メソッド | E-11 L119-160 | ○ |

### restarter パッケージ関連 (UT-SLV-088 - UT-SLV-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | SlaveRestarter抽象クラス定義 | E-13 L16-47 | ○ |
| C-48 | UnixSlaveRestarter.canWork()のOS判定 | E-14 L30-50 | ○ |
| C-49 | UnixSlaveRestarter.restart()のexecv呼び出し | E-14 L53-66 | ○ |
| C-50 | UnixSlaveRestarter.getCurrentExecutable()のフォールバック | E-14 L71-96 | ○ |
| C-51 | WinswSlaveRestarter.canWork()の環境変数チェック | E-15 L20-30 | ○ |
| C-52 | WinswSlaveRestarter.restart()のwinsw呼び出し | E-15 L48-56 | ○ |
| C-53 | JnlpSlaveRestarterInstaller.onOnline()のDumbSlaveチェック | E-16 L42-47 | ○ |
| C-54 | Install.call()のフィルタリング処理 | E-16 L64-77 | ○ |
| C-55 | FindEffectiveRestarters.call()のEngine確認 | E-16 L88-98 | ○ |
| C-56 | EngineListenerAdapterImpl.onReconnect()の再起動処理 | E-16 L108-124 | ○ |

### systemInfo パッケージ関連 (UT-SLV-114 - UT-SLV-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | SlaveSystemInfo抽象クラス定義 | E-17 L19-38 | ○ |
| C-58 | ThreadDumpSlaveInfo.getDisplayName() | E-18 L11-14 | ○ |
| C-59 | SystemPropertySlaveInfo.getRequiredPermission()がEXTENDED_READ | E-19 L18-21 | ○ |
| C-60 | EnvVarsSlaveInfo.getRequiredPermission()がEXTENDED_READ | E-20 L18-21 | ○ |
| C-61 | ClassLoaderStatisticsSlaveInfo.getRequiredPermission()がEXTENDED_READ | E-21 L18-21 | ○ |

### JnlpSlaveAgentProtocol 関連 (UT-SLV-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | SLAVE_SECRETがJnlpAgentReceiver.SLAVE_SECRETへのエイリアス | E-12 L15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接抽出

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: systemInfo パッケージの表示系クラス
- **1（中リスク）**: RemotingWorkDirSettings, NioChannelSelector, IOHubProvider 等の設定・初期化系
- **2（高リスク）**:
  - JnlpAgentReceiver / DefaultJnlpSlaveReceiver（認証・接続管理）
  - JnlpSlaveAgentProtocol4（TLS/暗号化）
  - EncryptedSlaveAgentJnlpFile（JNLP暗号化）
  - SlaveRestarter系（エージェント再起動）

## 6) レビュアーチェックリスト（最小）
- [ ] 認証関連テストケース（UT-SLV-001〜025）でセキュリティ境界が適切にカバーされているか
- [ ] TLS初期化テストケース（UT-SLV-026〜031）で証明書管理のエッジケースがカバーされているか
- [ ] 再起動系テストケース（UT-SLV-088〜113）でOS依存処理が適切に分岐されているか
- [ ] 権限チェックテストケース（UT-SLV-119〜124）でEXTENDED_READ要求が漏れなく確認されているか
- [ ] Cookie生成・検証（UT-SLV-005〜006, 016〜017）でセキュリティ上の脆弱性がないか
