---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 96
  claims_with_evidence: 96
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.tasks 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：96 / 96、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードによる根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/tasks/SimpleBuildStep.java`
- E-02: `core/src/main/java/jenkins/tasks/SimpleBuildWrapper.java`
- E-03: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterLocalRule.java`
- E-04: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterGlobalRule.java`
- E-05: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterRule.java`
- E-06: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterRuleContext.java`
- E-07: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterException.java`
- E-08: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterGlobalConfiguration.java`
- E-09: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterLocalRuleDescriptor.java`
- E-10: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterRuleWrapper.java`
- E-11: `core/src/main/java/jenkins/tasks/filters/EnvVarsFilterableBuilder.java`
- E-12: `core/src/main/java/jenkins/tasks/filters/impl/RetainVariablesLocalRule.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SimpleBuildStep インターフェース（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | perform(Run, FilePath, Launcher, TaskListener) デフォルト実装が perform(Run, FilePath, EnvVars, Launcher, TaskListener) を呼び出す | E-01: 88-92行目 | ○ |
| C-02 | requiresWorkspace=false の場合に perform(Run, EnvVars, TaskListener) が呼ばれる | E-01: 114-117行目 | ○ |
| C-03 | 未実装の場合に AbstractMethodError がスローされる | E-01: 121-126行目 | ○ |
| C-04 | requiresWorkspace=true で perform(Run, EnvVars, TaskListener) を呼ぶと IllegalStateException | E-01: 146-148行目 | ○ |
| C-05 | requiresWorkspace=false で未実装の場合に AbstractMethodError | E-01: 150行目 | ○ |
| C-06 | requiresWorkspace() のデフォルト値は true | E-01: 162-164行目 | ○ |
| C-07 | LastBuildActionFactory.type() は Job.class を返す | E-01: 190-191行目 | ○ |
| C-08 | createFor() が LastBuildAction から ProjectActions を収集する | E-01: 196-207行目 | ○ |
| C-09 | 最終成功ビルドがない場合は空リストを返す | E-01: 198-199行目 | ○ |

### SimpleBuildWrapper 抽象クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | requiresWorkspace() のデフォルト値は true | E-02: 78-80行目 | ○ |
| C-11 | setUp() の requiresWorkspace=false 時の委譲動作 | E-02: 101-104行目 | ○ |
| C-12 | setUp() 未実装時の AbstractMethodError | E-02: 105-106行目 | ○ |
| C-13 | requiresWorkspace=true で setUp(Context, Run, TaskListener, EnvVars) を呼ぶと IllegalStateException | E-02: 126-128行目 | ○ |
| C-14 | setUp(Context, Run, TaskListener, EnvVars) 未実装時の AbstractMethodError | E-02: 130-131行目 | ○ |
| C-15 | createContext() が新しい Context を生成する | E-02: 139-141行目 | ○ |
| C-16 | runPreCheckout() のデフォルト値は false | E-02: 285-287行目 | ○ |
| C-17 | setUp(AbstractBuild, Launcher, BuildListener) が EnvironmentWrapper を返す | E-02: 289-297行目 | ○ |
| C-18 | runPreCheckout=true の場合に空の Environment を返す | E-02: 290-291行目 | ○ |
| C-19 | preCheckout() が環境をビルドに追加する | E-02: 299-305行目 | ○ |
| C-20 | createLoggerDecorator() のデフォルト値は null | E-02: 338-340行目 | ○ |
| C-21 | decorateLogger() が null の場合に入力をそのまま返す | E-02: 342-345行目 | ○ |
| C-22 | decorateLogger() がフィルタで装飾する | E-02: 344行目 | ○ |
| C-23 | getProjectActions() が空のセットを返す | E-02: 388-390行目 | ○ |

### Context 内部クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | env() が環境変数を追加する | E-02: 177-181行目 | ○ |
| C-25 | env() で同一キーを2回呼ぶと IllegalStateException | E-02: 178-180行目 | ○ |
| C-26 | getDisposer() が設定された Disposer を返す | E-02: 184-186行目 | ○ |
| C-27 | getDisposer() が未設定の場合に null を返す | E-02: 184-186行目 (CheckForNull annotation) | ○ |
| C-28 | getEnv() が環境変数マップを返す | E-02: 188-190行目 | ○ |
| C-29 | setDisposer() が Disposer を設定する | E-02: 196-204行目 | ○ |
| C-30 | setDisposer() を2回呼ぶと IllegalStateException | E-02: 197-199行目 | ○ |

### Disposer 抽象クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | requiresWorkspace() が wrapperRequiresWorkspace に基づいて値を返す | E-02: 227-229行目 | ○ |
| C-32 | wrapperRequiresWorkspace=null の場合に true を返す | E-02: 228行目 | ○ |
| C-33 | tearDown() の requiresWorkspace=false 時の委譲動作 | E-02: 247-251行目 | ○ |
| C-34 | tearDown() 未実装時の AbstractMethodError | E-02: 252行目 | ○ |
| C-35 | requiresWorkspace=true で tearDown(Run, TaskListener) を呼ぶと IllegalStateException | E-02: 271-273行目 | ○ |
| C-36 | tearDown(Run, TaskListener) 未実装時の AbstractMethodError | E-02: 275行目 | ○ |

### EnvironmentWrapper 内部クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | buildEnvVars() が EnvVars 型の場合に overrideAll を使用 | E-02: 317-318行目 | ○ |
| C-38 | buildEnvVars() が EnvVars 以外の場合に putAll を使用 | E-02: 319-320行目 | ○ |
| C-39 | tearDown() が Disposer の tearDown を呼び出す | E-02: 324-328行目 | ○ |
| C-40 | tearDown() が Disposer なしの場合に true を返す | E-02: 324-328行目 | ○ |

### EnvVarsFilterLocalRule インターフェース（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | getDescriptor() が EnvVarsFilterLocalRuleDescriptor を返す | E-03: 44-47行目 | ○ |

### EnvVarsFilterGlobalRule インターフェース（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | getDescriptor() が Descriptor を返す | E-04: 49-53行目 | ○ |
| C-43 | isApplicable() が適用可否を判定する | E-04: 61行目 | ○ |

### EnvVarsFilterRule インターフェース（E-05）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | filter() がフィルタ処理を実行する | E-05: 46行目 | ○ |
| C-45 | filter() が違反検出時に EnvVarsFilterException をスローする | E-05: 43-44行目 (Javadoc) | ○ |
| C-46 | getDisplayName() が Describable の場合に Descriptor の displayName を返す | E-05: 49-53行目 | ○ |
| C-47 | getDisplayName() が非 Describable の場合にクラス名を返す | E-05: 55行目 | ○ |

### EnvVarsFilterRuleContext クラス（E-06）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | コンストラクタが Launcher と TaskListener を設定する | E-06: 43-46行目 | ○ |
| C-49 | getLauncher() が Launcher を返す | E-06: 48-50行目 | ○ |
| C-50 | getTaskListener() が TaskListener を返す | E-06: 52-54行目 | ○ |

### EnvVarsFilterException クラス（E-07）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | コンストラクタがメッセージを設定する | E-07: 43-45行目 | ○ |
| C-52 | withRule() がルールを設定して自身を返す | E-07: 47-51行目 | ○ |
| C-53 | withVariable() が変数名を設定して自身を返す | E-07: 53-56行目 | ○ |
| C-54 | getRule() が設定されたルールを返す | E-07: 58-60行目 | ○ |
| C-55 | getRule() が未設定の場合に null を返す | E-07: 58行目 (CheckForNull annotation) | ○ |
| C-56 | getMessage() が変数名とルール情報を含むメッセージを返す | E-07: 63-77行目 | ○ |
| C-57 | getMessage() が GlobalRule の場合に "global rule" を含む | E-07: 70-72行目 | ○ |

### EnvVarsFilterGlobalConfiguration クラス（E-08）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタが load() を呼び出す | E-08: 55-57行目 | ○ |
| C-59 | get() がシングルトンインスタンスを返す | E-08: 59-61行目 | ○ |
| C-60 | getAllGlobalRules() がグローバルルールの Descriptor リストを返す | E-08: 64-66行目 | ○ |
| C-61 | getAllActivatedGlobalRules() がアクティブルールリストを返す | E-08: 68-70行目 | ○ |
| C-62 | getCategory() が Unclassified カテゴリを返す | E-08: 73-75行目 | ○ |
| C-63 | configure() が設定を更新して保存する | E-08: 78-88行目 | ○ |
| C-64 | configure() が IOException 時に FormException をスローする | E-08: 81-83行目 | ○ |

### EnvVarsFilterLocalRuleDescriptor クラス（E-09）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | isApplicable() が適用可否を判定する | E-09: 45行目 | ○ |
| C-66 | allApplicableFor() が適用可能な Descriptor リストを返す | E-09: 47-54行目 | ○ |
| C-67 | allApplicableFor() が適用可能なルールがない場合に空リストを返す | E-09: 51-53行目 (filter logic) | ○ |

### EnvVarsFilterRuleWrapper クラス（E-10）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | コンストラクタがルールリストを設定する | E-10: 50-52行目 | ○ |
| C-69 | createRuleWrapper() がローカルとグローバルルールを結合する | E-10: 54-68行目 | ○ |
| C-70 | createRuleWrapper() が適用可能なグローバルルールのみをフィルタする | E-10: 60-62行目 | ○ |
| C-71 | filter() が全ルールを順番に実行する | E-10: 71-82行目 | ○ |
| C-72 | filter() がルール違反時にエラーメッセージを出力して例外をスローする | E-10: 76-79行目 | ○ |

### EnvVarsFilterableBuilder インターフェース（E-11）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | buildEnvVarsFilterRules() がデフォルトで空リストを返す | E-11: 47-50行目 | ○ |

### RetainVariablesLocalRule クラス（E-12）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | コンストラクタがデフォルト値で初期化する | E-12: 72-74, 76-78行目 | ○ |
| C-75 | setVariables() が変数リストを設定する | E-12: 80-83行目 | ○ |
| C-76 | getVariables() が変数文字列を返す | E-12: 99-102行目 | ○ |
| C-77 | setRetainCharacteristicEnvVars() がフラグを設定する | E-12: 104-107行目 | ○ |
| C-78 | isRetainCharacteristicEnvVars() がフラグ値を返す | E-12: 116-118行目 | ○ |
| C-79 | setProcessVariablesHandling() が処理方法を設定する | E-12: 179-182行目 | ○ |
| C-80 | getProcessVariablesHandling() が処理方法を返す | E-12: 175-177行目 | ○ |
| C-81 | filter() が保持対象でない変数を削除する | E-12: 135-163行目 | ○ |
| C-82 | filter() が保持対象の変数を保持する | E-12: 140行目 (contains check) | ○ |
| C-83 | filter() が特性環境変数を保持する | E-12: 122-124行目, 68行目 | ○ |
| C-84 | filter() が特性環境変数保持=false で削除する | E-12: 122行目 | ○ |
| C-85 | filter() が RESET モードでシステム値にリセットする | E-12: 149-152行目 | ○ |
| C-86 | filter() が REMOVE モードでシステム変数を削除する | E-12: 154-156行目 | ○ |
| C-87 | filter() が削除メッセージをログに出力する | E-12: 165-167行目 | ○ |
| C-88 | filter() がリセットメッセージをログに出力する | E-12: 168-172行目 | ○ |
| C-89 | filter() が大文字小文字を区別しない | E-12: 90行目, 140行目 (toLowerCase) | ○ |

### RetainVariablesLocalRule.DescriptorImpl クラス（E-12）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | コンストラクタが load() を呼び出す | E-12: 190-192行目 | ○ |
| C-91 | doCheckRetainCharacteristicEnvVars() が false 時に警告を返す | E-12: 195-198行目 | ○ |
| C-92 | doCheckRetainCharacteristicEnvVars() が true 時に OK を返す | E-12: 199行目 | ○ |
| C-93 | getDisplayName() がローカライズされた表示名を返す | E-12: 203-205行目 | ○ |
| C-94 | isApplicable() が常に true を返す | E-12: 207-210行目 | ○ |

### ProcessVariablesHandling enum（E-12）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | RESET の getDisplayName() が表示名を返す | E-12: 214, 222-224行目 | ○ |
| C-96 | REMOVE の getDisplayName() が表示名を返す | E-12: 215, 222-224行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに直接的な根拠があります。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードの実装に基づいており、根拠が明確です。
- 注意点：
  - テストケースの実装時に、実際のJenkins環境との統合テストが必要な箇所があります（特にE-08のGlobalConfiguration関連）
  - RemotingChannelでの実行を想定したシリアライズ関連のテストは追加検討が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] SimpleBuildStep/SimpleBuildWrapper のワークスペース要否判定ロジックのテストケースが網羅されているか
- [ ] Context の環境変数上書きロジック（EnvVars.overrideAll vs putAll）のテストケースが適切か
- [ ] EnvVarsFilterRuleWrapper のローカル/グローバルルール結合順序のテストケースが正確か
- [ ] RetainVariablesLocalRule の CHARACTERISTIC_ENV_VARS リストとの整合性が取れているか
- [ ] 例外処理（IllegalStateException、AbstractMethodError、EnvVarsFilterException）のテストケースが適切か
