---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 78
  claims_with_evidence: 75
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：jenkins.triggers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：75 / 78、根拠なし：3
- 優先レビュー（高）
  1. **UT-JTR-077**：設定ラウンドトリップテスト - 実際のUI動作確認が必要
  2. **UT-JTR-078**：スレッドセーフティテスト - 並行処理のテスト設計詳細は推測
  3. **UT-JTR-066**：MultiSCMリフレクションエラー - プラグイン実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/triggers/ReverseBuildTrigger.java`
- E-02: `core/src/main/java/jenkins/triggers/SCMTriggerItem.java`
- E-03: `core/src/main/java/jenkins/triggers/TriggeredItem.java`
- E-04: `core/src/test/java/jenkins/triggers/SCMTriggerItemTest.java`
- E-05: `test/src/test/java/jenkins/triggers/ReverseBuildTriggerTest.java`
- E-06: `test/src/test/java/jenkins/triggers/ReverseBuildTriggerAfterRestartTest.java`
- E-07: `test/src/test/java/jenkins/triggers/TriggerTest.java`
- E-08: JENKINS-29876（Jiraチケット - NPE問題）
- E-09: JENKINS-39044（Jiraチケット - null threshold問題）
- E-10: JENKINS-45909（Jiraチケット - null upstreamProjects問題）
- E-11: JENKINS-46161（Jiraチケット - getUpstreamProjects null safe）
- E-12: JENKINS-36232（Jiraチケット - veto delegation問題）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-JTR-001: コンストラクタで上流プロジェクト名が正しく設定される | E-01 (line 106-108) | ○ |
| C-02 | UT-JTR-002: コンストラクタにnullが渡された場合 | E-01, E-10 | ○ |
| C-03 | UT-JTR-003: コンストラクタに空文字が渡された場合 | E-01, E-05 (line 250-251) | ○ |
| C-04 | UT-JTR-004: レガシーコンストラクタで閾値が設定される | E-01 (line 99-103) | ○ |
| C-05 | UT-JTR-005: 上流プロジェクト名が取得できる | E-01 (line 115-117) | ○ |
| C-06 | UT-JTR-006: upstreamProjectsがnullの場合に空文字返却 | E-01, E-05, E-11 (line 241-253) | ○ |
| C-07 | UT-JTR-007: 閾値が取得できる | E-01 (line 119-121) | ○ |
| C-08 | UT-JTR-008: 閾値が設定できる | E-01 (line 123-126) | ○ |
| C-09 | UT-JTR-009: 閾値にnullを設定した場合 | E-01, E-05, E-09 (line 213-214) | ○ |
| C-10 | UT-JTR-010: ビルド結果が閾値以上でtrue返却 | E-01 (line 168-169), E-05 | ○ |
| C-11 | UT-JTR-011: UNSTABLE閾値判定 | E-01 (line 168-169) | ○ |
| C-12 | UT-JTR-012: 閾値未満でfalse返却 | E-01 (line 168-169) | ○ |
| C-13 | UT-JTR-013: jobがnullでfalse返却 | E-01 (line 130-132), E-08, E-05 (line 192-222) | ○ |
| C-14 | UT-JTR-014: 下流プロジェクト不可視でfalse | E-01 (line 138-143, 158-166), E-05 (line 87-190) | ○ |
| C-15 | UT-JTR-015: 上流プロジェクト不可視でfalse | E-01 (line 149-167), E-05 (line 87-190) | ○ |
| C-16 | UT-JTR-016: ビルド結果nullでfalse | E-01 (line 168-169) | ○ |
| C-17 | UT-JTR-017: 閾値nullでデフォルトSUCCESS使用 | E-01 (line 169), E-09 | ○ |
| C-18 | UT-JTR-018: 依存関係グラフ追加 | E-01 (line 172-180) | ○ |
| C-19 | UT-JTR-019: 存在しない上流プロジェクト | E-01 (line 173) | ○ |
| C-20 | UT-JTR-020: upstreamProjectsがnullでNPEなし | E-01, E-05, E-10 (line 226-237) | ○ |
| C-21 | UT-JTR-021: 複数上流プロジェクト | E-01 (line 173) | ○ |
| C-22 | UT-JTR-022: start時キャッシュ無効化 | E-01 (line 182-185) | ○ |
| C-23 | UT-JTR-023: stop時キャッシュ無効化 | E-01 (line 187-190) | ○ |
| C-24 | UT-JTR-024: 表示名返却 | E-01 (line 195-198) | ○ |
| C-25 | UT-JTR-025: isApplicable - JobかつParameterizedJob | E-01 (line 200-202) | ○ |
| C-26 | UT-JTR-026: isApplicable - Job以外はfalse | E-01 (line 200-202) | ○ |
| C-27 | UT-JTR-027: オートコンプリート候補 | E-01 (line 204-206) | ○ |
| C-28 | UT-JTR-028: 存在プロジェクトでOK | E-01 (line 208-231) | ○ |
| C-29 | UT-JTR-029: 存在しないプロジェクトでエラー | E-01 (line 217-222) | ○ |
| C-30 | UT-JTR-030: 空文字でエラー | E-01 (line 226-228) | ○ |
| C-31 | UT-JTR-031: CONFIGURE権限なしでOK | E-01 (line 209-211) | ○ |
| C-32 | UT-JTR-032: 複数プロジェクト検証 | E-01 (line 212-225) | ○ |
| C-33 | UT-JTR-033: シングルトン取得 | E-01 (line 237-239) | ○ |
| C-34 | UT-JTR-034: キャッシュ無効化 | E-01 (line 243-245) | ○ |
| C-35 | UT-JTR-035: キャッシュ計算 | E-01 (line 247-270) | ○ |
| C-36 | UT-JTR-036: 空キャッシュ | E-01 (line 247-270) | ○ |
| C-37 | UT-JTR-037: AbstractProject除外 | E-01 (line 260-262) | ○ |
| C-38 | UT-JTR-038: 上流完了時に下流トリガー | E-01 (line 272-302) | ○ |
| C-39 | UT-JTR-039: キャッシュnullで再計算 | E-01 (line 275-277) | ○ |
| C-40 | UT-JTR-040: トリガーなしで正常終了 | E-01 (line 279-282) | ○ |
| C-41 | UT-JTR-041: 無効ジョブでメッセージ出力 | E-01 (line 290-292) | ○ |
| C-42 | UT-JTR-042: キュー内でメッセージ出力 | E-01 (line 297-299) | ○ |
| C-43 | UT-JTR-043: リネーム時の参照更新 | E-01 (line 306-330) | ○ |
| C-44 | UT-JTR-044: 無関係リネーム | E-01 (line 316-317) | ○ |
| C-45 | UT-JTR-045: 保存IOExceptionハンドリング | E-01 (line 319-323) | ○ |
| C-46 | UT-JTR-046: asItem | E-02 (line 54) | ○ |
| C-47 | UT-JTR-047: getNextBuildNumber | E-02 (line 57) | ○ |
| C-48 | UT-JTR-048: getQuietPeriod | E-02 (line 60) | ○ |
| C-49 | UT-JTR-049: scheduleBuild2 | E-02 (line 63) | ○ |
| C-50 | UT-JTR-050: poll - 変更あり | E-02 (line 75) | ○ |
| C-51 | UT-JTR-051: poll - 変更なし | E-02 (line 75) | ○ |
| C-52 | UT-JTR-052: getSCMTrigger | E-02 (line 77) | ○ |
| C-53 | UT-JTR-053: getSCMTrigger - null | E-02 (line 77) | ○ |
| C-54 | UT-JTR-054: getSCMs | E-02 (line 84) | ○ |
| C-55 | UT-JTR-055: getSCMs - 空 | E-02 (line 84) | ○ |
| C-56 | UT-JTR-056: schedulePolling - 成功 | E-02 (line 89-99) | ○ |
| C-57 | UT-JTR-057: schedulePolling - 無効ジョブ | E-02 (line 90-92) | ○ |
| C-58 | UT-JTR-058: schedulePolling - トリガーなし | E-02 (line 93-96) | ○ |
| C-59 | UT-JTR-059: asSCMTriggerItem - SCMTriggerItem | E-02 (line 113-114) | ○ |
| C-60 | UT-JTR-060: asSCMTriggerItem - SCMedItem | E-02 (line 115-116) | ○ |
| C-61 | UT-JTR-061: asSCMTriggerItem - その他 | E-02 (line 117-118) | ○ |
| C-62 | UT-JTR-062: resolveMultiScmIfConfigured - 単一SCM | E-02 (line 173-175) | ○ |
| C-63 | UT-JTR-063: resolveMultiScmIfConfigured - null | E-02 (line 164-165) | ○ |
| C-64 | UT-JTR-064: resolveMultiScmIfConfigured - NullSCM | E-02 (line 164-165) | ○ |
| C-65 | UT-JTR-065: resolveMultiScmIfConfigured - MultiSCM | E-02 (line 166-171) | ○ |
| C-66 | UT-JTR-066: resolveMultiScmIfConfigured - リフレクションエラー | E-02 (line 169-171) | △ |
| C-67 | UT-JTR-067: Bridge.asItem | E-02 (line 129-131) | ○ |
| C-68 | UT-JTR-068: Bridge.getNextBuildNumber | E-02 (line 133-135) | ○ |
| C-69 | UT-JTR-069: Bridge.getQuietPeriod | E-02 (line 137-139) | ○ |
| C-70 | UT-JTR-070: Bridge.scheduleBuild2 | E-02 (line 141-143) | ○ |
| C-71 | UT-JTR-071: Bridge.poll - veto=null | E-02 (line 145-152), E-04, E-12 | ○ |
| C-72 | UT-JTR-072: Bridge.poll - veto | E-02 (line 147-150) | ○ |
| C-73 | UT-JTR-073: Bridge.getSCMTrigger | E-02 (line 154-156) | ○ |
| C-74 | UT-JTR-074: Bridge.getSCMs | E-02 (line 158-160) | ○ |
| C-75 | UT-JTR-075: TriggeredItem.getTriggers | E-03 (line 43) | ○ |
| C-76 | UT-JTR-076: TriggeredItem.getTriggers - 空 | E-03 (line 43) | ○ |
| C-77 | UT-JTR-077: 設定ラウンドトリップ | E-05 (line 67-84) | △ |
| C-78 | UT-JTR-078: スレッドセーフティ | E-01 (synchronized blocks), **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-JTR-066（MultiSCMリフレクションエラー）**: MultiSCMプラグインの実装詳細に依存するため、実際のエラーケースを確認するにはプラグインのソースコードが必要
  - 候補：jenkins-plugins/multiple-scms-plugin / プラグイン互換性テスト
- **UT-JTR-077（設定ラウンドトリップ）**: 既存テストは参照したが、UI全体の動作確認は手動テストが必要
  - 候補：JenkinsRule.configRoundtrip / Selenium UIテスト
- **UT-JTR-078（スレッドセーフティ）**: コード内のsynchronizedブロックは確認できるが、並行性テストの具体的なシナリオ設計は推測に基づく
  - 候補：JenkinsRule並列ビルドテスト / JCStressテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - C-01〜C-08, C-22〜C-27, C-33〜C-34, C-46〜C-55, C-67〜C-76
  - ゲッター/セッター、単純なインターフェースメソッドのテスト
- **1: 中リスク** - C-09〜C-21, C-28〜C-32, C-35〜C-45, C-56〜C-66
  - ビジネスロジック、バリデーション、キャッシュ管理のテスト
  - 既存テストやJiraチケットで動作が確認されているが、エッジケースは要注意
- **2: 高リスク** - C-77, C-78
  - UI統合テスト、並行処理テストは実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テスト（UT-JTR-014, 015, 031）の権限パターンが網羅されているか
- [ ] JENKINS-29876, 39044, 45909, 46161の回帰テストケースが含まれているか（含まれている）
- [ ] キャッシュの無効化タイミング（start/stop/onLocationChanged）が適切か
- [ ] SCMTriggerItemインターフェースの全メソッドにテストケースがあるか（ある）
- [ ] Bridge（アダプター）パターンのテストが十分か
- [ ] MultiSCM対応のリフレクション処理のエラーハンドリングテストが必要か検討
- [ ] 並行処理テスト（UT-JTR-078）の実装可否を確認
