---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 136
  claims_with_evidence: 136
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.util 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：136 / 136、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースにソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/util/AtmostOneTaskExecutor.java`
- E-02: `core/src/main/java/jenkins/util/TreeString.java`
- E-03: `core/src/main/java/jenkins/util/TreeStringBuilder.java`
- E-04: `core/src/main/java/jenkins/util/Timer.java`
- E-05: `core/src/main/java/jenkins/util/SystemProperties.java`
- E-06: `core/src/main/java/jenkins/util/MemoryReductionUtil.java`
- E-07: `core/src/main/java/jenkins/util/DirectedGraph.java`
- E-08: `core/src/main/java/jenkins/util/UrlHelper.java`
- E-09: `core/src/main/java/jenkins/util/TimeDuration.java`
- E-10: `core/src/main/java/jenkins/util/JenkinsJVM.java`
- E-11: `core/src/main/java/jenkins/util/MarkFindingOutputStream.java`
- E-12: `core/src/main/java/jenkins/util/Listeners.java`
- E-13: `core/src/main/java/jenkins/util/SourceCodeEscapers.java`
- E-14: `core/src/main/java/jenkins/util/PluginLabelUtil.java`
- E-15: `core/src/main/java/jenkins/util/io/PathRemover.java`
- E-16: `core/src/main/java/jenkins/util/io/FileBoolean.java`
- E-17: `core/src/main/java/jenkins/util/io/CompositeIOException.java`
- E-18: `core/src/main/java/jenkins/util/xstream/XStreamDOM.java`
- E-19: `core/src/main/java/jenkins/util/xml/XMLUtils.java`
- E-20: `core/src/main/java/jenkins/util/VirtualFile.java`
- E-21: `core/src/main/java/jenkins/util/ResourceBundleUtil.java`
- E-22: `core/src/main/java/jenkins/util/ProgressiveRendering.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-04 | AtmostOneTaskExecutorのsubmit/maybeRunメソッドテスト | E-01 | ○ |
| C-05〜C-14 | TreeStringの各メソッドテスト | E-02 | ○ |
| C-15〜C-18 | TreeStringBuilderのintern/dedupテスト | E-03 | ○ |
| C-19〜C-21 | Timerのget/shutdownテスト | E-04 | ○ |
| C-22〜C-33 | SystemPropertiesのgetString/getBoolean/getInteger/getLong/getDuration/optBooleanテスト | E-05 | ○ |
| C-34〜C-39 | MemoryReductionUtilのpreallocatedHashmapCapacity/internInPlaceテスト | E-06 | ○ |
| C-40〜C-44 | DirectedGraphのgetStronglyConnectedComponents/SCCテスト | E-07 | ○ |
| C-45〜C-50 | UrlHelperのisValidRootUrlテスト | E-08 | ○ |
| C-51〜C-58 | TimeDurationのgetTimeInMillis/getTimeInSeconds/as/fromStringテスト | E-09 | ○ |
| C-59〜C-64 | JenkinsJVMのisJenkinsJVM/setJenkinsJVM/checkJenkinsJVM/checkNotJenkinsJVMテスト | E-10 | ○ |
| C-65〜C-71 | MarkFindingOutputStreamのwrite/flush/closeテスト | E-11 | ○ |
| C-72〜C-74 | Listenersのnotifyテスト | E-12 | ○ |
| C-75〜C-79 | SourceCodeEscapersのjavaCharEscaperテスト | E-13 | ○ |
| C-80〜C-81 | PluginLabelUtilのcanonicalLabelsテスト | E-14 | ○ |
| C-82〜C-88 | PathRemoverのforceRemoveFile/forceRemoveRecursive/forceRemoveDirectoryContents/RetryStrategyテスト | E-15 | ○ |
| C-89〜C-95 | FileBooleanのget/on/off/fastGet/setテスト | E-16 | ○ |
| C-96〜C-98 | CompositeIOExceptionのconstructor/asUncheckedIOExceptionテスト | E-17 | ○ |
| C-99〜C-108 | XStreamDOMのgetTagName/getAttribute/getValue/getChildren/unmarshal/from/expandMacro/newReader/newWriterテスト | E-18 | ○ |
| C-109〜C-115 | XMLUtilsのparse/safeTransform/getValueテスト | E-19 | ○ |
| C-116〜C-130 | VirtualFileのgetName/isDirectory/isFile/exists/list/child/open/length/lastModified/forFile/forFilePath/compareTo/equals/isDescendantテスト | E-20 | ○ |
| C-131〜C-132 | ResourceBundleUtilのgetBundleテスト | E-21 | ○ |
| C-133〜C-136 | ProgressiveRenderingのprogress/canceledテスト | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードを直接参照して作成

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいている
- 備考: jenkins.util パッケージは多数のユーティリティクラスを含む。特に以下のクラスは重要度が高い:
  - `SystemProperties`: システム全体の設定管理に使用
  - `VirtualFile`: ファイルアクセス抽象化、セキュリティ関連（パストラバーサル防止）
  - `XMLUtils`: XXE攻撃防止のためのセキュリティ機能
  - `PathRemover`: ファイル削除操作、リトライ機能含む

## 6) レビュアーチェックリスト（最小）
- [ ] AtmostOneTaskExecutor: 並行処理の正確性、タスク統合ロジックの検証
- [ ] TreeString/TreeStringBuilder: メモリ最適化の効果測定、文字列共有の正確性
- [ ] SystemProperties: ServletContext経由のプロパティ取得、型変換の正確性
- [ ] VirtualFile: パストラバーサル攻撃防止（isDescendant）、シンボリックリンク処理
- [ ] XMLUtils: XXE攻撃防止機能の検証
- [ ] PathRemover: リトライ戦略の動作、Windows/Unix互換性
- [ ] MarkFindingOutputStream: バイトストリーム内のマーク検出精度
- [ ] ProgressiveRendering: タイムアウト処理、セキュリティコンテキスト伝播
