---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 44
  claims_with_evidence: 44
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.views 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：44 / 44、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/views/Header.java`
- E-02: `core/src/main/java/jenkins/views/JenkinsHeader.java`
- E-03: `core/src/main/java/jenkins/views/PartialHeader.java`
- E-04: `core/src/main/java/jenkins/views/FullHeader.java`
- E-05: `core/src/main/java/jenkins/views/ViewsTabBarUserProperty.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### Header クラス関連 (UT-VIW-001 ~ UT-VIW-016)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Header.isAvailable()はisCompatible()とisEnabled()の両方がtrueの場合にtrueを返す | E-01 L46-48: `return isCompatible() && isEnabled();` | ○ |
| C-02 | Header.isAvailable()はisCompatible()がfalseの場合にfalseを返す | E-01 L46-48: AND条件による | ○ |
| C-03 | Header.isAvailable()はisEnabled()がfalseの場合にfalseを返す | E-01 L46-48: AND条件による | ○ |
| C-04 | Header.isAvailable()は両方falseの場合にfalseを返す | E-01 L46-48: AND条件による | ○ |
| C-05 | Header.get()は利用可能なHeaderを返す | E-01 L63-66: `ExtensionList.lookup(Header.class).stream().filter(Header::isAvailable).findFirst()` | ○ |
| C-06 | Header.get()はHeaderが存在しない場合にJenkinsHeaderを返す | E-01 L65: `header.orElseGet(JenkinsHeader::new)` | ○ |
| C-07 | Header.get()は最初の利用可能なHeaderを返す | E-01 L64: `findFirst()` | ○ |
| C-08 | Header.getActions()はアイコンファイル名を持つActionを返す | E-01 L87: `e.getIconFileName() != null` | ○ |
| C-09 | Header.getActions()はIconSpecを実装しアイコンクラス名を持つActionを返す | E-01 L87: `e instanceof IconSpec is && is.getIconClassName() != null` | ○ |
| C-10 | Header.getActions()はaction.jellyを持つレガシーActionを返す | E-01 L87: `hasLegacyView(e)` | ○ |
| C-11 | Header.getActions()はordinalでソートされる | E-01 L88-90: `sorted(Comparator.comparingDouble(...).reversed())` | ○ |
| C-12 | Header.getActions()はActionが存在しない場合に空リストを返す | E-01 L84-91: streamパイプラインによる | ○ |
| C-13 | Header.getActions()はアイコン情報を持たないActionを除外する | E-01 L87: filterによる除外 | ○ |
| C-14 | hasLegacyView()はaction.jellyが存在する場合にtrueを返す | E-01 L101: `Functions.hasView(action, "action")` | ○ |
| C-15 | hasLegacyView()はaction.jellyが存在しない場合にfalseを返す | E-01 L101: Functions.hasViewの戻り値 | ○ |
| C-16 | hasLegacyView()はIOException発生時にfalseを返す | E-01 L102-104: `catch (IOException ignored) { return false; }` | ○ |

### FullHeader クラス関連 (UT-VIW-017)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | FullHeader.isCompatible()は常にtrueを返す | E-04 L13-15: `public boolean isCompatible() { return true; }` | ○ |

### JenkinsHeader クラス関連 (UT-VIW-018 ~ UT-VIW-021)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | JenkinsHeader.isEnabled()は常にtrueを返す | E-02 L14-16: `public boolean isEnabled() { return true; }` | ○ |
| C-19 | JenkinsHeader.isCompatible()はFullHeaderを継承しているためtrueを返す | E-02 L11: `extends FullHeader`, E-04 L13-15 | ○ |
| C-20 | JenkinsHeader.isAvailable()は常にtrueを返す | E-02: isEnabled()=true, isCompatible()=true (継承) | ○ |
| C-21 | JenkinsHeaderのordinalはInteger.MIN_VALUE | E-02 L10: `@Extension(ordinal = Integer.MIN_VALUE)` | ○ |

### PartialHeader クラス関連 (UT-VIW-022 ~ UT-VIW-030)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | PartialHeader.isCompatible()はサポートバージョンが一致する場合にtrueを返す | E-03 L31-33: `return compatibilityHeaderVersion == getSupportedHeaderVersion();` | ○ |
| C-23 | PartialHeader.isCompatible()はサポートバージョンが一致しない場合にfalseを返す | E-03 L31-33: 等価比較による | ○ |
| C-24 | PartialHeader.isCompatible()はサポートバージョン0でfalseを返す | E-03 L28, L31-33: `compatibilityHeaderVersion = 2` | ○ |
| C-25 | PartialHeader.isCompatible()は負の値でfalseを返す | E-03 L28, L31-33: `compatibilityHeaderVersion = 2` | ○ |
| C-26 | incompatibleHeaders()は非互換ヘッダーに対してAdministrativeErrorを作成する | E-03 L49-54: `new AdministrativeError(...)` | ○ |
| C-27 | incompatibleHeaders()は非互換ヘッダーに対して警告ログを出力する | E-03 L44-48: `LOGGER.warning(...)` | ○ |
| C-28 | incompatibleHeaders()は互換ヘッダーに対してAdministrativeErrorを作成しない | E-03 L43: `filter(h -> !h.isCompatible())` | ○ |
| C-29 | incompatibleHeaders()はPartialHeaderが存在しない場合に何も起こらない | E-03 L43: streamフィルタによる | ○ |
| C-30 | incompatibleHeaders()はJOB_LOADEDの後JOB_CONFIG_ADAPTEDの前に実行される | E-03 L40: `@Initializer(after = InitMilestone.JOB_LOADED, before = InitMilestone.JOB_CONFIG_ADAPTED)` | ○ |

### ViewsTabBarUserProperty クラス関連 (UT-VIW-031 ~ UT-VIW-044)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | ViewsTabBarUserPropertyはデフォルトコンストラクタでインスタンス生成可能 | E-05 L46-48: `@DataBoundConstructor public ViewsTabBarUserProperty() {}` | ○ |
| C-32 | setViewsTabBar()はViewsTabBarを正しく設定する | E-05 L50-53: `this.viewsTabBar = viewsTabBar;` | ○ |
| C-33 | setViewsTabBar()はnullを設定できる | E-05 L50-53: 型チェックなし | ○ |
| C-34 | getViewsTabBar()は設定されたViewsTabBarを取得できる | E-05 L56-58: `return viewsTabBar;` | ○ |
| C-35 | getViewsTabBar()は未設定の場合にnullを返す | E-05 L44: フィールド初期値null, E-05 L55: `@CheckForNull` | ○ |
| C-36 | DescriptorImpl.getDisplayName()は表示名を返す | E-05 L64-67: `return Messages.ViewsTabBarUserProperty_DisplayName();` | ○ |
| C-37 | DescriptorImpl.newInstance()は新しいインスタンスを生成する | E-05 L70-72: `return new ViewsTabBarUserProperty();` | ○ |
| C-38 | DescriptorImpl.newInstance()はUserがnullでもインスタンス生成可能 | E-05 L70-72: userパラメータ未使用 | ○ |
| C-39 | DescriptorImpl.getUserPropertyCategory()はPreferencesカテゴリを返す | E-05 L75-77: `return UserPropertyCategory.get(UserPropertyCategory.Preferences.class);` | ○ |
| C-40 | DescriptorImplには@Symbol("viewsTabBar")が設定されている | E-05 L61: `@Symbol("viewsTabBar")` | ○ |
| C-41 | DescriptorImplには@Extensionが設定されている | E-05 L60: `@Extension` | ○ |
| C-42 | ViewsTabBarUserPropertyには@DataBoundConstructorが設定されている | E-05 L46: `@DataBoundConstructor` | ○ |
| C-43 | setViewsTabBarには@DataBoundSetterが設定されている | E-05 L50: `@DataBoundSetter` | ○ |
| C-44 | ViewsTabBarUserPropertyには@Restricted(NoExternalUse.class)が設定されている | E-05 L41: `@Restricted(NoExternalUse.class)` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースに対応するソースコードが存在

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：
  - すべてのテストケースがソースコードに基づいて生成されており、根拠が明確
  - jenkins.viewsモジュールは5つのJavaファイルで構成される比較的小規模なモジュール
  - Header抽象クラスを中心とした拡張ポイントの設計パターンが明確

## 6) レビュアーチェックリスト（最小）
- [ ] Header.get()のフォールバック動作（JenkinsHeaderへの切り替え）が正しいか確認
- [ ] PartialHeaderのバージョン互換性チェックロジックが現在のcompatibilityHeaderVersion=2と整合しているか確認
- [ ] incompatibleHeaders()の初期化タイミング（JOB_LOADED後、JOB_CONFIG_ADAPTED前）が適切か確認
- [ ] ViewsTabBarUserPropertyのUserProperty継承階層が正しくテストされているか確認
- [ ] getActions()のordinalソート順（降順）が期待通りか確認
