---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 51
  claims_with_evidence: 51
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.websocket 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：51 / 51、根拠なし：0
- 優先レビュー（高）
  1. **セキュリティテスト（UT-WS-003）**：管理者権限チェックの動作確認
  2. **接続ライフサイクル（UT-WS-039, 041）**：WebSocket接続・切断時のコールバック処理
  3. **エラーハンドリング（UT-WS-035, 038）**：プロバイダ不在時・例外発生時の処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/websocket/WebSocketEcho.java`
- E-02: `core/src/main/java/jenkins/websocket/WebSocketSession.java`
- E-03: `core/src/main/java/jenkins/websocket/WebSockets.java`
- E-04: `websocket/spi/src/main/java/jenkins/websocket/Provider.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### WebSocketEchoクラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getUrlNameメソッドが「wsecho」を返す | E-01 L42-44 | ○ |
| C-02 | doIndexメソッドがADMINISTER権限をチェックする | E-01 L47 | ○ |
| C-03 | textメソッドが「hello 」をプレフィックスとして追加する | E-01 L50-52 | ○ |
| C-04 | binaryメソッドが小文字を大文字に変換する | E-01 L55-64 | ○ |
| C-05 | binaryメソッドがoffset/lenパラメータを使用する | E-01 L55-56 | ○ |

### WebSocketSessionクラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | PING_INTERVALのデフォルト値が30秒 | E-02 L61 | ○ |
| C-07 | startPingsがPING_INTERVAL > 0の場合のみスケジュールを作成 | E-02 L71 | ○ |
| C-08 | startPingsがPING_INTERVAL/2秒後に開始し、PING_INTERVAL秒間隔で実行 | E-02 L80 | ○ |
| C-09 | startPings内で例外発生時にerrorが呼ばれpingsがキャンセルされる | E-02 L77-78 | ○ |
| C-10 | stopPingsがpingsをキャンセルする | E-02 L85-88 | ○ |
| C-11 | openedメソッドがデフォルトで空実装 | E-02 L91-92 | ○ |
| C-12 | closedメソッドがデフォルトで空実装 | E-02 L94-95 | ○ |
| C-13 | errorメソッドがWARNINGレベルでログ出力 | E-02 L97-99 | ○ |
| C-14 | binaryメソッドがWARNING「unexpected binary frame」を出力 | E-02 L101-103 | ○ |
| C-15 | textメソッドがWARNING「unexpected text frame」を出力 | E-02 L105-107 | ○ |
| C-16 | sendBinary(ByteBuffer)がhandler.sendBinaryを呼び出す | E-02 L109-111 | ○ |
| C-17 | sendBinary(ByteBuffer, boolean)がhandler.sendBinaryを呼び出す | E-02 L113-115 | ○ |
| C-18 | sendTextがhandler.sendTextを呼び出す | E-02 L117-119 | ○ |
| C-19 | closeがhandler.closeを呼び出す | E-02 L121-123 | ○ |

### WebSocketsクラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | findProviderがServiceLoaderを使用してProviderをロード | E-03 L54-64 | ○ |
| C-21 | ServiceConfigurationError発生時にFINEレベルでログ出力 | E-03 L59-60 | ○ |
| C-22 | Providerが見つからない場合にnullを返す | E-03 L63 | ○ |
| C-23 | upgradeがHttpResponseを返す | E-03 L68-75 | ○ |
| C-24 | upgradeResponse内でprovider==nullの場合404を返す | E-03 L82-85 | ○ |
| C-25 | IOException/ServletExceptionはそのままスロー | E-03 L136-137 | ○ |
| C-26 | その他の例外は500を返しWARNINGログを出力 | E-03 L138-140 | ○ |
| C-27 | onWebSocketConnectでstartPingsとopenedが呼ばれる | E-03 L93-94 | ○ |
| C-28 | onWebSocketCloseでstopPingsとclosedが呼ばれる | E-03 L103-105 | ○ |
| C-29 | ClosedChannelException発生時はonWebSocketCloseを呼び出す | E-03 L109-111 | ○ |
| C-30 | その他の例外でsession.errorを呼び出す | E-03 L112-113 | ○ |
| C-31 | onWebSocketBinaryでsession.binaryを呼び出す | E-03 L118-120 | ○ |
| C-32 | session.binaryでIOException発生時にsession.errorを呼び出す | E-03 L121-123 | ○ |
| C-33 | onWebSocketTextでsession.textを呼び出す | E-03 L127-129 | ○ |
| C-34 | session.textでIOException発生時にsession.errorを呼び出す | E-03 L130-132 | ○ |
| C-35 | isSupportedがprovider != nullの場合trueを返す | E-03 L144-146 | ○ |

### Providerインターフェース（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | Provider.handleがHandlerを返す | E-04 L46 | ○ |
| C-37 | Handler.sendBinaryがFuture<Void>を返す | E-04 L66-68 | ○ |
| C-38 | Handler.sendTextがFuture<Void>を返す | E-04 L70 | ○ |
| C-39 | Handler.sendPingがFuture<Void>を返す | E-04 L72 | ○ |
| C-40 | Listenerの各メソッドシグネチャが定義されている | E-04 L48-61 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースがソースコードから直接導出可能）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: テストケースは全てソースコードに基づいて作成されており、推測に基づく主張はない
- **注意点**:
  - WebSocketの統合テストは実際のサーブレットコンテナが必要なため、モック化が必要
  - PING_INTERVALはSystemPropertiesから読み込まれるため、テスト時にシステムプロパティの制御が必要
  - Provider実装は外部モジュール（jetty12-ee9等）に依存するため、SPIのモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティテスト（UT-WS-003）の権限チェックロジックが適切か確認
- [ ] WebSocket接続のライフサイクル（開始・終了）のテストケースが網羅されているか確認
- [ ] エラーハンドリングのテストケースが実際の例外パターンを網羅しているか確認
- [ ] 境界値テスト（空データ、offset指定等）が適切か確認
- [ ] Provider/Handlerのモック化戦略がテスト実装時に適切に行えるか確認
