---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.widgets 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上のメソッド・クラスが実在するか
2. **根拠との整合性**：テストケースの内容がソースコードのロジックと一致しているか
3. **網羅性**：対象モジュール内の主要クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  1. **UT-JWD-047, UT-JWD-049**：setNewerThan/setOlderThanの相互排他チェック - 例外処理の重要テスト
  2. **UT-JWD-066, UT-JWD-068**：センシティブデータ保護 - セキュリティ関連の重要テスト
  3. **UT-JWD-074**：addRunの順序チェック - データ整合性の重要テスト

## 2) 参照した情報（Evidence一覧）
> 実在するソースファイルを列挙

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/HasWidgets.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/JenkinsWidgetFactory.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/BuildTimeTrend.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/BuildQueueWidget.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/BuildListTable.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/HistoryPageEntry.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/RunListProgressiveRendering.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/ExecutorsWidget.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/WidgetFactory.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/widgets/HistoryPageFilter.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HasWidgets.getWidgets()がWidgetFactoryからWidgetを収集する | E-01 (L49-67) | ○ |
| C-02 | HasWidgets.getWidgets()が不変リストを返す | E-01 (L67: Collections.unmodifiableList) | ○ |
| C-03 | HasWidgets.getWidgets()がRuntimeExceptionをキャッチしてログ出力する | E-01 (L63-64) | ○ |
| C-04 | HasWidgets.getWidgets()が不正な型のWidgetを除外する | E-01 (L57-60) | ○ |
| C-05 | HasWidgets.getWidget()が名前でWidgetを検索する | E-01 (L79-84) | ○ |
| C-06 | HasWidgets.getWidget()が一致しない場合nullを返す | E-01 (L83: orElse(null)) | ○ |
| C-07 | HasWidgets.getWidget()がnull入力でnullを返す | E-01 (L80-81) | ○ |
| C-08 | JenkinsWidgetFactory.type()がView.classを返す | E-02 (L47-49) | ○ |
| C-09 | JenkinsWidgetFactory.widgetType()がWidget.classを返す | E-02 (L52-54) | ○ |
| C-10 | JenkinsWidgetFactory.createFor()がJenkins.get().getWidgets()を返す | E-02 (L57-60) | ○ |
| C-11 | BuildTimeTrend.isAbstractProject()がAbstractProjectを判定する | E-03 (L42-44) | ○ |
| C-12 | BuildTimeTrend.calculate()がビルド情報をJSONに設定する | E-03 (L46-72) | ○ |
| C-13 | BuildTimeTrend.calculate()がbuiltOn条件分岐を持つ | E-03 (L58-72) | ○ |
| C-14 | BuildQueueWidgetコンストラクタがフィールドを初期化する | E-04 (L55-63) | ○ |
| C-15 | BuildQueueWidget.getOwnerUrl()がownerUrlを返す | E-04 (L65-68) | ○ |
| C-16 | BuildQueueWidget.getQueueItems()がqueueItemsを返す | E-04 (L70-74) | ○ |
| C-17 | BuildQueueWidget.isFiltered()がfilteredを返す | E-04 (L76-79) | ○ |
| C-18 | BuildQueueWidget.ViewFactoryImpl.createFor()がViewからWidgetを生成 | E-04 (L93-97) | ○ |
| C-19 | BuildQueueWidget.ComputerSetFactoryImpl.createFor()がComputerSetからWidgetを生成 | E-04 (L112-116) | ○ |
| C-20 | BuildListTable.calculate()がビルド情報をJSONに設定する | E-05 (L40-56) | ○ |
| C-21 | HistoryPageEntryコンストラクタがentryを保持する | E-06 (L43-47) | ○ |
| C-22 | HistoryPageEntry.getEntryId()がQueueItemのIDを返す | E-06 (L57-59) | ○ |
| C-23 | HistoryPageEntry.getEntryId()がHistoricalBuildでLong.MIN_VALUE+numberを返す | E-06 (L60-61) | ○ |
| C-24 | HistoryPageEntry.getEntryId()がNumberでLong.MIN_VALUE+valueを返す | E-06 (L62-64) | ○ |
| C-25 | HistoryPageEntry.getEntryId()が不明な型でQUEUE_ID_UNKNOWNを返す | E-06 (L65-66) | ○ |
| C-26 | RunListProgressiveRendering.setBuilds()がbuildsを設定する | E-07 (L53-56) | ○ |
| C-27 | RunListProgressiveRendering.compute()が各ビルドでcalculateを呼ぶ | E-07 (L58-72) | ○ |
| C-28 | RunListProgressiveRendering.compute()がcanceled()をチェックする | E-07 (L61-63) | ○ |
| C-29 | RunListProgressiveRendering.compute()がprogressを更新する | E-07 (L69-70) | ○ |
| C-30 | RunListProgressiveRendering.data()がJSONArrayを返す | E-07 (L74-78) | ○ |
| C-31 | RunListProgressiveRendering.data()がresultsをクリアする | E-07 (L76) | ○ |
| C-32 | ExecutorsWidgetコンストラクタがフィールドを初期化する | E-08 (L29-32) | ○ |
| C-33 | ExecutorsWidget.getOwnerUrl()がownerUrlを返す | E-08 (L34-37) | ○ |
| C-34 | ExecutorsWidget.getComputers()が不変リストを返す | E-08 (L39-41) | ○ |
| C-35 | ExecutorsWidget.ViewFactoryImpl.createFor()がViewからWidgetを生成 | E-08 (L55-59) | ○ |
| C-36 | ExecutorsWidget.ComputerFactoryImpl.createFor()がComputerからWidgetを生成 | E-08 (L74-78) | ○ |
| C-37 | ExecutorsWidget.ComputerSetFactoryImpl.createFor()がComputerSetからWidgetを生成 | E-08 (L93-97) | ○ |
| C-38 | WidgetFactory.factoriesFor()が型に一致するFactoryを返す | E-09 (L71-80) | ○ |
| C-39 | HistoryPageFilterコンストラクタがmaxEntriesを設定する | E-10 (L82-84) | ○ |
| C-40 | HistoryPageFilter.setNewerThan()がnewerThanを設定する | E-10 (L90-95) | ○ |
| C-41 | HistoryPageFilter.setNewerThan()がolderThan設定済みで例外をスローする | E-10 (L91-93) | ○ |
| C-42 | HistoryPageFilter.setOlderThan()がolderThanを設定する | E-10 (L101-106) | ○ |
| C-43 | HistoryPageFilter.setOlderThan()がnewerThan設定済みで例外をスローする | E-10 (L102-104) | ○ |
| C-44 | HistoryPageFilter.setSearchString()がsearchStringを設定する | E-10 (L112-114) | ○ |
| C-45 | HistoryPageFilter.add(Iterable)がmaxEntries件まで追加する | E-10 (L122-124, L153-162) | ○ |
| C-46 | HistoryPageFilter.add(Iterable, List)がrunItemsとqueueItemsを追加する | E-10 (L133-136) | ○ |
| C-47 | HistoryPageFilter.addInternal()がnewerThanフィルタを適用する | E-10 (L163-207) | ○ |
| C-48 | HistoryPageFilter.addInternal()がolderThanフィルタを適用する | E-10 (L208-222) | ○ |
| C-49 | HistoryPageFilter.size()が合計サイズを返す | E-10 (L225-227) | ○ |
| C-50 | HistoryPageFilter.fitsSearchParams(QueueItem)がdisplayNameで検索する | E-10 (L311-318) | ○ |
| C-51 | HistoryPageFilter.fitsSearchParams(HistoricalBuild)が複数フィールドで検索する | E-10 (L321-347) | ○ |
| C-52 | HistoryPageFilter.fitsSearchParams()がsensitiveパラメータを除外する | E-10 (L381-386) | ○ |
| C-53 | HistoryPageFilter.fitsSearchBuildVariables()がビルド変数を検索する | E-10 (L369-378) | ○ |
| C-54 | HistoryPageFilter.fitsSearchBuildVariables()がsensitive変数を除外する | E-10 (L371-373) | ○ |
| C-55 | HistoryPageFilter.fitsSearchString()が大文字小文字を区別/無視する | E-10 (L361-366) | ○ |
| C-56 | HistoryPageFilter.fitsSearchString()がnullでfalseを返す | E-10 (L354-356) | ○ |
| C-57 | HistoryPageFilter.fitsSearchString()がNumber型で完全一致判定する | E-10 (L358-359) | ○ |
| C-58 | HistoryPageFilter.addRun()が降順チェックを行う | E-10 (L263-268) | ○ |
| C-59 | HistoryPageFilter.updateNewestOldest()がnewestOnPage/oldestOnPageを更新する | E-10 (L273-276) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースがソースコード上のメソッド・ロジックに基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードから直接導出されており、根拠が明確です
- 注意点：
  - HistoryPageFilterは複雑なページネーションロジックを含むため、境界条件のテストを重点的に確認することを推奨
  - センシティブデータ保護（UT-JWD-066, UT-JWD-068）はセキュリティ上重要なため、実装との整合性を確認することを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] HasWidgetsインターフェースのデフォルト実装（getWidgets, getWidget）のテストケースが適切か確認
- [ ] WidgetFactoryおよびその実装クラス（JenkinsWidgetFactory, BuildQueueWidget.ViewFactoryImpl等）のテストケースが網羅的か確認
- [ ] HistoryPageFilterのページネーションロジック（newerThan, olderThan）のテストケースが境界条件を含むか確認
- [ ] センシティブデータ保護のテストケース（UT-JWD-066, UT-JWD-068）が適切なセキュリティ検証を含むか確認
- [ ] RunListProgressiveRenderingの非同期処理（compute, data）のテストケースが同期化を考慮しているか確認
- [ ] 例外処理のテストケース（UT-JWD-047, UT-JWD-049, UT-JWD-074）が適切なエラーメッセージを検証しているか確認
