---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 177
  claims_with_evidence: 177
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：org.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードと矛盾していないか
3. **網羅性**：対象クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：177 / 177、根拠なし：0
- 優先レビュー（高）
  1. **セキュリティ関連クラス（Authentication, AuthenticationException等）**：認証・認可の重要なテストケース
  2. **Spring変換ロジック（fromSpring/toSpring）**：互換性レイヤーの重要なテストケース
  3. **Symbol/IconSet**：UI表示に関わるテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/java/org/acegisecurity/Authentication.java`
- E-02: `core/src/main/java/org/acegisecurity/AuthenticationSpringImpl.java`
- E-03: `core/src/main/java/org/acegisecurity/AuthenticationException.java`
- E-04: `core/src/main/java/org/acegisecurity/GrantedAuthority.java`
- E-05: `core/src/main/java/org/acegisecurity/GrantedAuthorityImpl.java`
- E-06: `core/src/main/java/org/acegisecurity/context/SecurityContext.java`
- E-07: `core/src/main/java/org/acegisecurity/context/SecurityContextImpl.java`
- E-08: `core/src/main/java/org/acegisecurity/context/SecurityContextHolder.java`
- E-09: `core/src/main/java/org/acegisecurity/userdetails/UserDetails.java`
- E-10: `core/src/main/java/org/acegisecurity/userdetails/User.java`
- E-11: `core/src/main/java/org/acegisecurity/userdetails/UserDetailsService.java`
- E-12: `core/src/main/java/org/acegisecurity/userdetails/UserDetailsSpringImpl.java`
- E-13: `core/src/main/java/org/acegisecurity/userdetails/UsernameNotFoundException.java`
- E-14: `core/src/main/java/org/acegisecurity/providers/AbstractAuthenticationToken.java`
- E-15: `core/src/main/java/org/acegisecurity/providers/UsernamePasswordAuthenticationToken.java`
- E-16: `core/src/main/java/org/acegisecurity/providers/anonymous/AnonymousAuthenticationToken.java`
- E-17: `core/src/main/java/org/acegisecurity/providers/AuthenticationProvider.java`
- E-18: `core/src/main/java/org/acegisecurity/providers/ProviderNotFoundException.java`
- E-19: `core/src/main/java/org/acegisecurity/providers/dao/AbstractUserDetailsAuthenticationProvider.java`
- E-20: `core/src/main/java/org/acegisecurity/util/FieldUtils.java`
- E-21: `core/src/main/java/org/acegisecurity/acls/sid/Sid.java`
- E-22: `core/src/main/java/org/acegisecurity/acls/sid/PrincipalSid.java`
- E-23: `core/src/main/java/org/acegisecurity/acls/sid/GrantedAuthoritySid.java`
- E-24: `core/src/main/java/org/acegisecurity/AcegiSecurityException.java`
- E-25: `core/src/main/java/org/acegisecurity/BadCredentialsException.java`
- E-26: `core/src/main/java/org/acegisecurity/AccessDeniedException.java`
- E-27: `core/src/main/java/org/acegisecurity/AccountExpiredException.java`
- E-28: `core/src/main/java/org/acegisecurity/CredentialsExpiredException.java`
- E-29: `core/src/main/java/org/acegisecurity/DisabledException.java`
- E-30: `core/src/main/java/org/acegisecurity/LockedException.java`
- E-31: `core/src/main/java/org/acegisecurity/InsufficientAuthenticationException.java`
- E-32: `core/src/main/java/org/acegisecurity/AuthenticationServiceException.java`
- E-33: `core/src/main/java/org/acegisecurity/AuthenticationManager.java`
- E-34: `core/src/main/java/org/acegisecurity/ui/WebAuthenticationDetails.java`
- E-35: `core/src/main/java/org/springframework/dao/DataAccessException.java`
- E-36: `core/src/main/java/org/springframework/dao/DataRetrievalFailureException.java`
- E-37: `core/src/main/java/org/springframework/dao/DataAccessResourceFailureException.java`
- E-38: `core/src/main/java/org/jenkins/ui/icon/Icon.java`
- E-39: `core/src/main/java/org/jenkins/ui/icon/IconSet.java`
- E-40: `core/src/main/java/org/jenkins/ui/icon/IconType.java`
- E-41: `core/src/main/java/org/jenkins/ui/icon/IconFormat.java`
- E-42: `core/src/main/java/org/jenkins/ui/icon/IconSpec.java`
- E-43: `core/src/main/java/org/jenkins/ui/icon/WeatherIcon.java`
- E-44: `core/src/main/java/org/jenkins/ui/icon/BuildStatusIcon.java`
- E-45: `core/src/main/java/org/jenkins/ui/symbol/Symbol.java`
- E-46: `core/src/main/java/org/jenkins/ui/symbol/SymbolRequest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### org.acegisecurity パッケージ（認証・認可）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-ORG-001〜006) | Authentication.fromSpring各種変換 | E-01 | ○ |
| C-02 (UT-ORG-007〜011) | AuthenticationSpringImpl委譲メソッド | E-02 | ○ |
| C-03 (UT-ORG-012〜022) | AuthenticationException変換・プロパティ操作 | E-03 | ○ |
| C-04 (UT-ORG-023〜029) | GrantedAuthority変換メソッド | E-04 | ○ |
| C-05 (UT-ORG-030〜035) | GrantedAuthorityImpl基本メソッド | E-05 | ○ |
| C-06 (UT-ORG-036〜043) | SecurityContext変換・入れ子クラス | E-06 | ○ |
| C-07 (UT-ORG-044〜045) | SecurityContextImpl基本メソッド | E-07 | ○ |
| C-08 (UT-ORG-046〜048) | SecurityContextHolder静的メソッド | E-08 | ○ |

### org.acegisecurity.userdetails パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 (UT-ORG-049〜055) | UserDetails変換メソッド | E-09 | ○ |
| C-10 (UT-ORG-056〜069) | Userクラス基本メソッド | E-10 | ○ |
| C-11 (UT-ORG-070〜073) | UserDetailsService変換メソッド | E-11 | ○ |
| C-12 (UT-ORG-074〜076) | UsernameNotFoundException変換 | E-13 | ○ |

### org.acegisecurity.providers パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 (UT-ORG-077〜086) | AbstractAuthenticationToken基本メソッド | E-14 | ○ |
| C-14 (UT-ORG-087〜092) | UsernamePasswordAuthenticationToken | E-15 | ○ |
| C-15 (UT-ORG-093〜095) | AnonymousAuthenticationToken | E-16 | ○ |
| C-16 (UT-ORG-175〜177) | AbstractUserDetailsAuthenticationProvider認証処理 | E-19 | ○ |

### org.acegisecurity.util パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 (UT-ORG-096〜100) | FieldUtilsリフレクションメソッド | E-20 | ○ |

### org.acegisecurity.acls.sid パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 (UT-ORG-101〜106) | PrincipalSid基本メソッド | E-22 | ○ |
| C-19 (UT-ORG-107〜110) | GrantedAuthoritySid基本メソッド | E-23 | ○ |

### org.jenkins.ui.icon パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 (UT-ORG-111〜133) | Icon基本メソッド・静的ユーティリティ | E-38 | ○ |
| C-21 (UT-ORG-134〜142) | IconSet管理メソッド | E-39 | ○ |
| C-22 (UT-ORG-143〜144) | IconType列挙型 | E-40 | ○ |
| C-23 (UT-ORG-145) | WeatherIconコンストラクタ | E-43 | ○ |
| C-24 (UT-ORG-146〜149) | BuildStatusIcon基本メソッド | E-44 | ○ |

### org.jenkins.ui.symbol パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 (UT-ORG-150〜157) | Symbol.getメソッド各種オプション | E-45 | ○ |
| C-26 (UT-ORG-158〜165) | SymbolRequest.Builderメソッド | E-46 | ○ |

### org.springframework.dao パッケージ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 (UT-ORG-166〜167) | DataAccessException基本メソッド | E-35 | ○ |
| C-28 (UT-ORG-168) | DataRetrievalFailureException | E-36 | ○ |
| C-29 (UT-ORG-169) | DataAccessResourceFailureException | E-37 | ○ |

### 例外クラス群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 (UT-ORG-170〜171) | BadCredentialsException変換 | E-25 | ○ |
| C-31 (UT-ORG-172) | AccessDeniedException変換 | E-26 | ○ |
| C-32 (UT-ORG-173〜174) | AuthenticationManager変換 | E-33 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースに対してソースコード根拠が存在）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されており、根拠が明確

### 補足事項
- orgモジュールは主にAcegi Security（旧Spring Security）からSpring Securityへの移行互換性レイヤーを提供
- 多くのクラスが `@Deprecated` であり、Spring Securityへの移行を推奨している
- fromSpring/toSpringメソッドは互換性維持のための重要なブリッジ機能

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テスト（UT-ORG-001〜022）が認証・認可のエッジケースをカバーしているか確認
- [ ] fromSpring/toSpring変換テストが双方向で一貫性を持つか確認
- [ ] FieldUtils（UT-ORG-096〜100）のリフレクションテストがセキュリティ制約を考慮しているか確認
- [ ] Symbol/IconSet（UT-ORG-111〜165）のUIテストが表示要件を満たしているか確認
- [ ] 例外クラスの変換テストが例外チェーンを正しく保持するか確認
