---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **UAT-017 検索機能**：フロントエンドのみの確認、バックエンド検索ロジックの詳細確認が必要
  2. **UAT-025 システム情報**：具体的なJavaクラスの特定が不完全

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main/js/pluginSetupWizardGui.js` - 初期セットアップウィザードUI
- E-02: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` - ユーザー認証・セキュリティレルム
- E-03: `core/src/main/java/hudson/model/User.java` - ユーザーモデル
- E-04: `core/src/main/java/hudson/model/Job.java` - ジョブ基底クラス
- E-05: `core/src/main/java/hudson/model/Project.java` - プロジェクト実装
- E-06: `core/src/main/java/hudson/model/View.java` - ビュー管理
- E-07: `core/src/main/java/jenkins/model/Jenkins.java` - Jenkinsコア機能
- E-08: `core/src/main/java/hudson/security/Permission.java` - 権限定義
- E-09: `src/main/js/api/pluginManager.js` - プラグイン管理API
- E-10: `core/src/main/java/hudson/security/AuthorizationStrategy.java` - 認可戦略
- E-11: `core/src/main/java/hudson/slaves/Slave.java` - ビルドエージェント
- E-12: `core/src/main/java/hudson/model/Run.java` - ビルド実行記録
- E-13: `core/src/main/java/hudson/triggers/Trigger.java` - ビルドトリガー
- E-14: `core/src/main/java/hudson/model/AbstractItem.java` - アイテム基底クラス
- E-15: `core/src/main/java/jenkins/security/ApiTokenProperty.java` - APIトークン
- E-16: `core/src/main/java/hudson/model/ParameterDefinition.java` - パラメータ定義
- E-17: `core/src/main/java/hudson/tasks/ArtifactArchiver.java` - 成果物アーカイブ
- E-18: `core/src/main/java/jenkins/security/SecurityListener.java` - セキュリティイベント
- E-19: `src/main/js/components/search-bar/index.js` - 検索バーUI

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 初期セットアップウィザードでプラグイン選択・ユーザー作成が可能 | E-01 | ○ |
| C-02 | HudsonPrivateSecurityRealmで正常なユーザー認証が行われる | E-02 | ○ |
| C-03 | 不正な認証情報でBadCredentialsExceptionが発生する | E-02 | ○ |
| C-04 | Projectクラスでフリースタイルプロジェクトの作成が可能 | E-05 | ○ |
| C-05 | Jobクラスでビルド実行が管理される | E-04 | ○ |
| C-06 | Viewクラスで新規ビューの作成が可能 | E-06 | ○ |
| C-07 | Userクラスで新規ユーザーの作成が可能 | E-03 | ○ |
| C-08 | プラグイン管理APIでプラグインのインストールが可能 | E-09 | ○ |
| C-09 | AuthorizationStrategyで認可戦略の変更が可能 | E-10 | ○ |
| C-10 | Slaveクラスで新規ビルドエージェントの追加が可能 | E-11 | ○ |
| C-11 | Runクラスでビルド履歴とコンソール出力の確認が可能 | E-12 | ○ |
| C-12 | Triggerクラスでビルドトリガーの設定が可能 | E-13 | ○ |
| C-13 | Permissionクラスで権限制御が行われる | E-08 | ○ |
| C-14 | AbstractItemでジョブのコピーが可能 | E-14 | ○ |
| C-15 | AbstractItemでジョブの削除が可能 | E-14 | ○ |
| C-16 | Jenkinsクラスでシステム設定の変更が可能 | E-07 | ○ |
| C-17 | 検索バーでジョブの検索が可能 | E-19 | △ |
| C-18 | ApiTokenPropertyでAPIアクセスの認証が可能 | E-15 | ○ |
| C-19 | ParameterDefinitionでパラメータ付きビルドの設定が可能 | E-16 | ○ |
| C-20 | ArtifactArchiverで成果物のアーカイブが可能 | E-17 | ○ |
| C-21 | User.doSubmitDescriptionでプロファイル更新が可能 | E-03 | ○ |
| C-22 | SecurityListenerでログアウトイベントが処理される | E-18 | ○ |
| C-23 | View.getItemsでジョブ一覧の取得が可能 | E-06 | ○ |
| C-24 | Run.doStopでビルドの中断が可能 | E-12 | ○ |
| C-25 | システム情報画面でシステム情報の確認が可能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **UAT-017 検索機能**：フロントエンドの検索バーUIは確認できたが、バックエンドの検索ロジック（SearchIndex等）の詳細な動作確認が必要
  - 候補：`hudson/search/SearchIndex.java` / `hudson/search/SearchIndexBuilder.java` / `jenkins/search/SearchGroup.java`
- **UAT-025 システム情報**：システム情報画面の具体的な実装クラスの特定が不完全
  - 候補：`pages/manage-jenkins/system-information/index.js` / `ManagementLink` 拡張

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：E2Eテストとしての網羅性は十分。主要な業務フローをカバーしている。
- **1（中リスク）**：セキュリティ関連テストケース（UAT-002, UAT-003, UAT-009, UAT-013）は実際の環境での動作検証が重要。
- **0（低リスク）**：プラグイン依存機能（一部のビルドステップ等）は標準機能の範囲でテスト設計している。

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの前提条件が現実的かどうか確認
- [ ] テスト手順の具体性が十分か確認（特にUIの操作手順）
- [ ] 期待結果が検証可能な形式で記述されているか確認
- [ ] 優先度の設定が適切か確認（高：認証・認可・主要業務フロー、中：管理機能、低：補助機能）
- [ ] 根拠不足のテストケース（UAT-017, UAT-025）の詳細確認
- [ ] ユーザーロール（管理者、開発者、一般ユーザー、閲覧のみユーザー）の区分が適切か確認
