---
generated_at: 2026-01-22 19:18:00
metrics:
  claims_total: 5
  claims_with_evidence: 5
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：5 / 5、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/LoadStatistics.java`
- E-02: `core/src/main/java/hudson/model/MultiStageTimeSeries.java`
- E-03: `core/src/main/java/hudson/util/Graph.java`
- E-04: `core/src/main/java/hudson/util/ChartUtil.java`
- E-05: `core/src/main/java/hudson/model/HealthReport.java`
- E-06: `core/src/main/java/hudson/model/HealthReportingAction.java`
- E-07: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-08: `core/src/main/java/hudson/console/AnnotatedLargeText.java`
- E-09: `core/src/main/java/hudson/console/ConsoleNote.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 負荷統計トレンドチャート：エグゼキュータの使用状況やキュー長などの負荷統計を時系列グラフとして生成 | E-01, E-02 | ○ |
| C-02 | 汎用グラフ：JFreeChartを使用した汎用的なグラフ生成機能（PNG形式の画像とクリッカブルマップを生成） | E-03, E-04 | ○ |
| C-03 | ヘルスレポート：ジョブやビルドの健全性をスコア（0-100）とアイコンで表示 | E-05, E-06 | ○ |
| C-04 | メモリ使用量モニター：JVMのメモリ使用量を監視しグラフとして表示 | E-07 | ○ |
| C-05 | ビルドコンソールログ：ビルド実行時のコンソール出力を保存・表示（アノテーション対応） | E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- プラグインによる帳票機能は本一覧に含まれていません
  - 候補：JUnit Plugin（テストレポート）/ HTML Publisher Plugin（HTMLレポート）/ Cobertura Plugin（カバレッジレポート）
- PDF/Excel等のエクスポート機能はJenkinsコアには存在しません
  - これらの機能はプラグインとして提供されます

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての帳票機能はソースコードから直接確認
- 注意点：Jenkinsはプラグインアーキテクチャのため、コアに含まれる帳票機能は限定的です。実運用環境では多数のプラグインによりレポート機能が拡張されることが一般的です。

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票一覧の5件がソースコードと整合しているか確認
- [ ] LoadStatistics.javaのdoGraph()メソッドがトレンドチャート生成を行うことを確認
- [ ] Graph.javaのdoPng()/doMap()メソッドがPNG/Map出力を行うことを確認
- [ ] HealthReport.javaのスコア範囲（0-100）とアイコン対応を確認
- [ ] プラグインによる追加の帳票機能が必要な場合は別途調査が必要
