# 帳票設計書 1-負荷統計トレンドチャート

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける負荷統計トレンドチャート機能の帳票設計書である。エグゼキュータの使用状況やキュー長などの負荷統計を時系列グラフとして可視化する機能について記述する。

### 本帳票の処理概要

この帳票は、Jenkinsシステムの負荷状況を時系列グラフとして可視化する機能を提供する。JFreeChartライブラリを使用してPNG形式の画像を生成し、WebUI上で表示する。

**業務上の目的・背景**：Jenkinsサーバーの運用において、エグゼキュータの使用率やビルドキューの長さを監視することは、システムのキャパシティプランニングやボトルネックの特定に不可欠である。管理者がシステムの負荷傾向を把握し、必要に応じてエージェントの追加やリソースの再配分を行うための判断材料を提供する。

**帳票の利用シーン**：システム管理者がJenkinsのマスターノード全体、特定のラベル、またはエージェント単位での負荷状況を確認したい場合に利用される。定期的なキャパシティレビューやパフォーマンス監視ダッシュボードの一部として活用される。

**主要な出力内容**：
1. オンラインエグゼキュータ数の時系列推移（青色の線）
2. ビジーエグゼキュータ数の時系列推移（赤色の線）
3. ビルドキュー長の時系列推移（グレーの線）
4. 利用可能エグゼキュータ数の時系列推移（黄色の線）

**帳票の出力タイミング**：ユーザーが `/load-statistics` URLにアクセスした際、または各ラベル・エージェントの負荷統計ページにアクセスした際にリアルタイムで生成される。

**帳票の利用者**：Jenkinsシステム管理者、DevOpsエンジニア、インフラ担当者

## 帳票種別

統計グラフ（時系列チャート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | 負荷統計画面 | `/load-statistics` | ページアクセス時に自動表示 |
| - | ラベル詳細画面 | `/label/{ラベル名}/load-statistics` | ページアクセス時に自動表示 |
| - | エージェント詳細画面 | `/computer/{エージェント名}/load-statistics` | ページアクセス時に自動表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PNG（画像） |
| 用紙サイズ | 500x400 ピクセル（デフォルト） |
| 向き | 横 |
| ファイル名 | 動的生成（ストリームとして出力） |
| 出力方法 | HTTP レスポンスとして直接配信 |
| 文字コード | - |

### PNG固有設定

| 項目 | 内容 |
|-----|------|
| 背景色 | 白（#FFFFFF） |
| グリッド線 | 黒（横方向のみ） |
| フォント | Sans-Serif 10pt |

## 帳票レイアウト

### レイアウト概要

時系列折れ線グラフの形式で、複数のメトリクスを同一グラフ上に色分けして表示する。

```
┌─────────────────────────────────────┐
│            凡例（Legend）            │
├─────────────────────────────────────┤
│  Y軸                                │
│  (数値)    ┌────────────────────┐   │
│           │   折れ線グラフ領域    │   │
│           │                    │   │
│           │                    │   │
│           └────────────────────┘   │
│                X軸（時刻）          │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 凡例 | 各データ系列の名称と色 | MultiStageTimeSeries.title | テキスト+色見本 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | オンラインエグゼキュータ | オンライン状態のエグゼキュータ数 | LoadStatistics.onlineExecutors | 折れ線（青） | - |
| 2 | ビジーエグゼキュータ | 実行中のエグゼキュータ数 | LoadStatistics.busyExecutors | 折れ線（赤） | - |
| 3 | キュー長 | ビルドキューで待機中のアイテム数 | LoadStatistics.queueLength | 折れ線（グレー） | - |
| 4 | 利用可能エグゼキュータ | タスクを受け入れ可能なエグゼキュータ数 | LoadStatistics.availableExecutors | 折れ線（黄） | - |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | X軸ラベル | 時刻表示 | System.currentTimeMillis() | 時間スケールに応じた形式 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| type | 時間スケール（SEC10/MIN/HOUR） | No（デフォルト: MIN） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 時刻 | 昇順（古い→新しい） |

### 改ページ条件

単一画像のため改ページなし

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照せず、JVM内のメモリ上に保持されたTimeSeries データを使用する。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| MultiStageTimeSeries | 時系列データの保持 | 3段階の時間解像度でデータを保持 |
| TimeSeries | 単一時間スケールのデータ | 指数移動平均によるスムージング |

### テーブル別参照項目詳細

#### MultiStageTimeSeries

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| sec10 | 10秒間隔データ | TimeScale.SEC10 | 最大6時間分保持 |
| min | 1分間隔データ | TimeScale.MIN | 最大2日間分保持 |
| hour | 1時間間隔データ | TimeScale.HOUR | 最大8週間分保持 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| データポイント値 | 指数移動平均（decay=0.9） | なし（float） | 10秒ごとに更新 |
| X軸時刻 | currentTime - (tick * index) | - | 時間スケールに応じた間隔 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTPリクエスト /doGraph] --> B[TimeScaleパラメータ解析]
    B --> C[TrendChart生成]
    C --> D[CategoryDataset作成]
    D --> E[JFreeChartでグラフ生成]
    E --> F[PNG画像をレスポンスに書き込み]
    F --> G[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| HeadlessException | GUIサポートなしの環境 | /images/headless.png へリダイレクト | java.awt.headlessモードの設定確認 |
| フォントエラー | システムフォントが見つからない | /images/headless.png へリダイレクト | システムにフォントをインストール |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | SEC10: 2160点、MIN: 2880点、HOUR: 1344点 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 特に制限なし（メモリ依存） |

## セキュリティ考慮事項

- 本機能はJenkinsにログインしたユーザーであれば誰でもアクセス可能
- 機密性の高いデータは含まれない
- システムの負荷状況という運用情報のため、必要に応じてアクセス制御の検討が望ましい

## 備考

- データは10秒間隔で `LoadStatisticsUpdater` により自動更新される
- decay値（0.9）により、古いデータは徐々に影響が減少する
- 時間スケールはクエリパラメータ `type` で切り替え可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、時系列データを保持するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | 3段階の時間解像度でデータを保持する仕組み |
| 1-2 | TimeSeries.java | `core/src/main/java/hudson/model/TimeSeries.java` | 個別の時系列データの保持方法 |

**読解のコツ**: `MultiStageTimeSeries` は `sec10`, `min`, `hour` の3つの `TimeSeries` を内包している。`update()` メソッド（行119-124）でカウンタを使い分けて各解像度のデータを更新している点に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるHTTPリクエストハンドラを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | `doGraph()` メソッドがエントリーポイント |

**主要処理フロー**:
1. **行246-248**: `doGraph(@QueryParameter String type)` でHTTPリクエストを受け付け
2. **行247**: `TimeScale.parse(type)` で時間スケールを解析
3. **行247**: `createTrendChart(TimeScale)` でグラフ生成を委譲

#### Step 3: グラフ生成ロジックを理解する

TrendChartクラスでの実際のグラフ生成処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | TrendChart内部クラスの`createChart()`メソッド |

**主要処理フロー**:
- **行195-306**: `TrendChart` クラス全体
- **行209-230**: `createDataset()` でJFreeChart用のデータセット作成
- **行235-257**: `createChart()` でグラフオブジェクト生成
- **行302-305**: `generateResponse()` でHTTPレスポンスとして出力

#### Step 4: 統計データの収集を理解する

データがどのように収集・更新されるかを把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | `LoadStatisticsUpdater` 内部クラス |

**主要処理フロー**:
- **行351-385**: `LoadStatisticsUpdater` がPeriodicWorkとして定期実行
- **行354-356**: `getRecurrencePeriod()` で10秒間隔を返却
- **行358-372**: `doRun()` で全ラベルとシステム全体の統計を更新

### プログラム呼び出し階層図

```
LoadStatistics.doGraph(type)
    │
    ├─ TimeScale.parse(type)
    │
    └─ MultiStageTimeSeries.createTrendChart(timeScale, series...)
           │
           └─ TrendChart(timeScale, series)
                  │
                  ├─ createDataset()
                  │      └─ TimeSeries.getHistory()
                  │
                  └─ generateResponse(req, rsp)
                         │
                         ├─ createChart()
                         │      └─ ChartFactory.createLineChart()
                         │
                         └─ ChartUtil.generateGraph()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト ──────▶ LoadStatistics.doGraph()
   (type=MIN)                    │
                                 ▼
                         TimeScale.parse()
                                 │
                                 ▼
                    MultiStageTimeSeries.pick()
                                 │
                                 ▼
                      TimeSeries.getHistory() ─────▶ float[] データ配列
                                 │
                                 ▼
                    TrendChart.createDataset()
                                 │
                                 ▼
                    ChartFactory.createLineChart()
                                 │
                                 ▼
                    ChartUtil.generateGraph() ────────▶ PNG画像
                                                       (HTTPレスポンス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | ソース | 負荷統計のメインクラス、グラフ生成エントリーポイント |
| MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | ソース | 3段階時間解像度の時系列データ管理、TrendChart生成 |
| TimeSeries.java | `core/src/main/java/hudson/model/TimeSeries.java` | ソース | 単一時系列データの保持 |
| LoadStatisticsSnapshot.java | `core/src/main/java/hudson/model/LoadStatistics.java` | ソース（内部クラス） | 統計のスナップショット |
| ColorPalette.java | `core/src/main/java/hudson/util/ColorPalette.java` | ソース | グラフの色定義 |
| ChartUtil.java | `core/src/main/java/hudson/util/ChartUtil.java` | ソース | グラフ出力ユーティリティ |
| NoOverlapCategoryAxis.java | `core/src/main/java/hudson/util/NoOverlapCategoryAxis.java` | ソース | X軸ラベルの重複防止 |
| OverallLoadStatistics.java | `core/src/main/java/hudson/model/OverallLoadStatistics.java` | ソース | システム全体の負荷統計 |
