# 帳票設計書 3-ヘルスレポート

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおけるヘルスレポート機能の帳票設計書である。ジョブやビルドの健全性をスコア（0-100）とアイコンで視覚的に表示するレポート機能について記述する。

### 本帳票の処理概要

この帳票は、Jenkinsジョブの「健全性（Health）」を数値スコアとアイコンで表現する機能を提供する。複数の `HealthReportingAction` からの情報を集約し、最も低いスコアを持つレポートをジョブの代表的な健全性として表示する。

**業務上の目的・背景**：CI/CDパイプラインにおいて、ジョブの状態を一目で把握できることは運用効率の向上に不可欠である。単に「成功/失敗」だけでなく、過去のビルド履歴に基づく安定性や、テストカバレッジ、静的解析の結果など、複合的な要素を統合してジョブの「健康状態」を可視化することで、問題の早期発見と対応を促進する。

**帳票の利用シーン**：Viewページ（ダッシュボード）でジョブ一覧を表示する際に、各ジョブの横にヘルスアイコンとして表示される。ジョブ詳細ページでも健全性レポートが表示される。

**主要な出力内容**：
1. ヘルススコア（0-100の整数値）
2. ヘルスアイコン（5段階：0-20, 21-40, 41-60, 61-80, 81-100）
3. 説明テキスト（ツールチップとして表示）
4. 複数のHealthReportがある場合、全てのレポートをリスト表示

**帳票の出力タイミング**：ビルドが完了するたびにキャッシュが更新され、View画面表示時にHTMLとしてレンダリングされる。

**帳票の利用者**：開発者、QAエンジニア、プロジェクトマネージャー、Jenkins管理者

## 帳票種別

ステータスレポート（インライン表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | View（ダッシュボード） | `/view/{viewName}/` | ページ表示時に自動表示 |
| - | ジョブ詳細画面 | `/job/{jobName}/` | ページ表示時に自動表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（インライン表示）/ JSON（REST API） |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | - |
| 出力方法 | Web UI表示 / REST API |
| 文字コード | UTF-8 |

### アイコン設定

| スコア範囲 | アイコンクラス | 画像ファイル |
|-----------|--------------|-------------|
| 81-100 | icon-health-80plus | health-80plus.png |
| 61-80 | icon-health-60to79 | health-60to79.png |
| 41-60 | icon-health-40to59 | health-40to59.png |
| 21-40 | icon-health-20to39 | health-20to39.png |
| 0-20 | icon-health-00to19 | health-00to19.png |

## 帳票レイアウト

### レイアウト概要

ヘルスレポートはジョブ一覧のテーブル内でアイコンとして表示される。マウスオーバーでツールチップとして説明が表示される。

```
┌──────────────────────────────────────────────────────┐
│ View: All Jobs                                        │
├──────────────────────────────────────────────────────┤
│ [Health] | Job Name      | Last Build | Last Success │
│──────────┼───────────────┼────────────┼──────────────│
│ [☀️]     | my-project    | #123       | 2h ago       │
│ [🌤]     | another-job   | #45        | 1d ago       │
│ [☁️]     | failing-job   | #67        | 5d ago       │
└──────────────────────────────────────────────────────┘
```

### ヘッダー部

なし（インライン表示）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ヘルスアイコン | 健全性を示すアイコン | HealthReport.iconClassName | 画像（16x16/24x24/32x32） | 32px |
| 2 | スコア | 健全性スコア（0-100） | HealthReport.score | 数値（REST APIのみ） | - |
| 3 | 説明 | 健全性の説明文 | HealthReport.description | テキスト（ツールチップ） | - |

### フッター部

なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ビルド履歴 | 最低1つのビルドが存在 | Yes |
| ビルド状態 | ビルド中でない最新ビルド | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | スコア | 昇順（低いスコア=悪い状態が先頭） |

### 改ページ条件

なし

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照せず、ビルドオブジェクトのアクションとビルド履歴から情報を取得する。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| HealthReportingAction | 各種ヘルス情報の提供 | プラグインが実装 |
| Run履歴 | ビルド安定性計算 | 過去5ビルドを参照 |

### テーブル別参照項目詳細

#### HealthReportingAction

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| getBuildHealth() | HealthReport | 最新ビルドから取得 | nullの場合はスキップ |

#### ビルド安定性計算

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| lastBuild.getIconColor() | ビルド結果の判定 | 過去5ビルド | BLUE/YELLOW=成功、RED=失敗 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ビルド安定性スコア | (totalCount - failCount) / totalCount * 100 | int変換（切り捨て） | 過去5ビルドから計算 |
| 代表ヘルススコア | min(全HealthReport.score) | - | ソートにより最小値が先頭 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[View表示リクエスト] --> B[Job.getBuildHealthReports]
    B --> C{キャッシュ有効?}
    C -->|Yes| D[キャッシュから取得]
    C -->|No| E[HealthReportingAction取得]
    E --> F[各Actionからレポート収集]
    F --> G[ビルド安定性レポート計算]
    G --> H[スコアでソート]
    H --> I[キャッシュ更新]
    I --> J[HTML/JSON出力]
    D --> J
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ビルド履歴がない | デフォルトHealthReport（score=100） | - |
| HealthReportがnull | HealthReportingActionがnullを返却 | スキップして次へ | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ジョブあたり数個のHealthReport |
| 目標出力時間 | 100ms以内 |
| 同時出力数上限 | View内のジョブ数に依存 |
| キャッシュ | ビルド番号ベースのキャッシュあり |

## セキュリティ考慮事項

- ヘルスレポートはジョブの閲覧権限を持つユーザーに表示される
- description フィールドは Localizable 型でXSS対策済み
- REST API経由でも同様の情報を取得可能（/api/json）

## 備考

- HealthReportingAction はプラグインの拡張ポイントであり、テストカバレッジ、静的解析、コード複雑度など様々なメトリクスを追加可能
- アイコンの境界値は歴史的理由により 80plus, 60to79... と名付けられているが、実際は 81+, 61-80... のスコア範囲に対応
- キャッシュはビルド番号でキーイングされ、新しいビルドが完了すると自動的に無効化される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、HealthReport クラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HealthReport.java | `core/src/main/java/hudson/model/HealthReport.java` | フィールド定義（score, iconClassName, iconUrl, description） |
| 1-2 | HealthReportingAction.java | `core/src/main/java/hudson/model/HealthReportingAction.java` | インターフェース定義 |

**読解のコツ**: `HealthReport` は `Comparable<HealthReport>` を実装しており、スコアによる自然順序付けが可能。`min()` と `max()` 静的メソッド（行335-351）でレポートの比較が可能。

#### Step 2: エントリーポイントを理解する

レポート取得の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | `getBuildHealth()` メソッド（行1273-1276） |
| 2-2 | Job.java | `core/src/main/java/hudson/model/Job.java` | `getBuildHealthReports()` メソッド（行1278-1326） |

**主要処理フロー**:
1. **行1273-1276**: `getBuildHealth()` は最初のレポートを返却（最低スコア）
2. **行1279**: `@Exported(name = "healthReport")` でREST API公開
3. **行1283-1287**: ビルド中の場合は前のビルドを使用
4. **行1290-1295**: キャッシュチェックと再利用
5. **行1297-1308**: 全HealthReportingActionからレポート収集
6. **行1309-1316**: ビルド安定性レポートを追加
7. **行1318**: スコアでソート（昇順）

#### Step 3: ビルド安定性計算を理解する

過去のビルド履歴からスコアを計算するロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | `getBuildStabilityHealthReport()` メソッド（行1328-1388） |

**主要処理フロー**:
- **行1330-1331**: failCount と totalCount を初期化
- **行1334-1336**: 失敗がない場合は100点を返却
- **行1353-1370**: 過去5ビルドを走査してカウント
- **行1354-1368**: BLUE/YELLOW は成功、RED は失敗としてカウント
- **行1372**: スコア計算: `(totalCount - failCount) / totalCount * 100`

#### Step 4: アイコン決定ロジックを理解する

スコアに応じたアイコン選択。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HealthReport.java | `core/src/main/java/hudson/model/HealthReport.java` | コンストラクタ（行144-174） |

**主要処理フロー**:
- **行146-156**: スコア範囲に応じて iconClassName を設定
- **行157-171**: スコア範囲に応じて iconUrl を設定（nullの場合のデフォルト）

### プログラム呼び出し階層図

```
View表示 (Jelly/Groovy)
    │
    └─ Job.getBuildHealth()
           │
           └─ Job.getBuildHealthReports()
                  │
                  ├─ キャッシュチェック
                  │      └─ [キャッシュヒット] → キャッシュ済みリストを返却
                  │
                  ├─ lastBuild.getActions(HealthReportingAction.class)
                  │      │
                  │      └─ healthReportingAction.getBuildHealth()
                  │             └─ HealthReport
                  │
                  ├─ getBuildStabilityHealthReport()
                  │      │
                  │      └─ 過去5ビルドからスコア計算
                  │             └─ HealthReport
                  │
                  └─ Collections.sort(reports)
```

### データフロー図

```
[入力]                        [処理]                         [出力]

ビルド履歴 ────────────▶ getBuildHealthReports()
                               │
                               ▼
HealthReportingAction ────▶ getBuildHealth()
(テストカバレッジ等)                │
                               ▼
過去5ビルド ─────────────▶ getBuildStabilityHealthReport()
                               │
                               ▼
                        Collections.sort()
                               │
                               ▼
                        List<HealthReport> ─────────▶ HTML表示
                               │                      (アイコン+ツールチップ)
                               │
                               └────────────────────▶ JSON API
                                                      (スコア+説明)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HealthReport.java | `core/src/main/java/hudson/model/HealthReport.java` | ソース | ヘルスレポートのデータクラス |
| HealthReportingAction.java | `core/src/main/java/hudson/model/HealthReportingAction.java` | ソース | ヘルスレポート提供者のインターフェース |
| Job.java | `core/src/main/java/hudson/model/Job.java` | ソース | ヘルスレポート取得・キャッシュ・集約ロジック |
| Messages.java | `core/src/main/java/hudson/model/Messages.java` | ソース（生成） | ローカライズメッセージ |
| health-*.png | `war/src/main/webapp/images/` | リソース | ヘルスアイコン画像 |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド結果の取得元 |
