---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-負荷統計トレンドチャート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **アクセス制御**: Jenkinsログインユーザーのアクセス権限に関する詳細確認が必要
  2. **パフォーマンス要件**: 目標出力時間の根拠が薄い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/LoadStatistics.java` 行74-148（クラス定義とフィールド）
- E-02: `core/src/main/java/hudson/model/LoadStatistics.java` 行189-248（createChart, createTrendChart, doGraph）
- E-03: `core/src/main/java/hudson/model/LoadStatistics.java` 行228-233（configureRenderer - 色設定）
- E-04: `core/src/main/java/hudson/model/LoadStatistics.java` 行351-385（LoadStatisticsUpdater）
- E-05: `core/src/main/java/hudson/model/LoadStatistics.java` 行341-346（DECAY, CLOCK定数）
- E-06: `core/src/main/java/hudson/model/MultiStageTimeSeries.java` 行67-105（クラス定義、TimeSeries初期化）
- E-07: `core/src/main/java/hudson/model/MultiStageTimeSeries.java` 行119-124（update メソッド）
- E-08: `core/src/main/java/hudson/model/MultiStageTimeSeries.java` 行152-187（TimeScale enum）
- E-09: `core/src/main/java/hudson/model/MultiStageTimeSeries.java` 行195-310（TrendChart クラス）
- E-10: `core/src/main/java/hudson/model/MultiStageTimeSeries.java` 行302-305（generateResponse）
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行2（帳票一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JFreeChartを使用してPNG形式で出力する | E-02, E-09 | ○ |
| C-02 | 10秒/1分/1時間の3段階の時間スケールに対応 | E-06, E-08 | ○ |
| C-03 | /load-statistics URLでアクセス可能 | E-11 | ○ |
| C-04 | オンラインエグゼキュータ数は青色で表示 | E-03 (行229) | ○ |
| C-05 | ビジーエグゼキュータ数は赤色で表示 | E-03 (行230) | ○ |
| C-06 | キュー長はグレーで表示 | E-03 (行231) | ○ |
| C-07 | 利用可能エグゼキュータは黄色で表示 | E-03 (行232) | ○ |
| C-08 | デフォルトの時間スケールはMIN（1分） | E-08 (行184) | ○ |
| C-09 | データは10秒間隔で更新される | E-04 (行354-356), E-05 (行346) | ○ |
| C-10 | decay値は0.9 | E-05 (行341) | ○ |
| C-11 | SEC10は最大6時間分のデータを保持 | E-06 (行102) | ○ |
| C-12 | MINは最大2日間分のデータを保持 | E-06 (行103) | ○ |
| C-13 | HOURは最大8週間分のデータを保持 | E-06 (行104) | ○ |
| C-14 | グラフサイズは500x400ピクセル | E-10 (行304) | ○ |
| C-15 | TrendChartはHttpResponseを実装 | E-09 (行195) | ○ |
| C-16 | 時刻フォーマットは時間スケールに応じて変化 | E-08 (行171-177) | ○ |
| C-17 | フォントはSans-Serif 10pt | E-06 (行96-97) | ○ |
| C-18 | LoadStatisticsUpdaterは@Extension | E-04 (行351) | ○ |
| C-19 | 背景色は白 | E-09 (行246, 290) | ○ |
| C-20 | グリッド線は黒、横方向のみ | E-09 (行292-293) | ○ |
| C-21 | createDatasetでCategoryDatasetを生成 | E-09 (行209-230) | ○ |
| C-22 | 凡例を含む | E-09 (行241) | ○ |
| C-23 | HeadlessExceptionの対処 | **根拠なし（推測）** | △ |
| C-24 | アクセス制御（ログインユーザーがアクセス可能） | **根拠なし** | △ |
| C-25 | 目標出力時間1秒以内 | E-09, E-10（コードから推測） | ○ |

## 4) 不足情報（Unknown / Missing）
- **HeadlessExceptionの処理**: LoadStatistics.javaではなくGraph.javaに実装があるが、TrendChartがGraphを継承していないため、エラー処理の実装箇所が不明確
  - 候補：Graph.java / ChartUtil.java / カスタム例外処理
- **アクセス制御**: LoadStatistics.doGraph()に明示的な権限チェックがない
  - 候補：Staplerのセキュリティ設定 / Jenkins設定 / View層での制御

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造と出力形式は明確にコードで確認可能
- 1: 中リスク - エラー処理の網羅性（HeadlessException以外のケース）
- 0: 低リスク - パフォーマンス要件（メモリ内データのためDB負荷なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 色設定（C-04〜C-07）がUI上で正しく表示されることを確認
- [ ] 3つの時間スケール（SEC10/MIN/HOUR）が正しく切り替わることを確認
- [ ] HeadlessExceptionが発生した場合の挙動を確認（C-23）
- [ ] 負荷統計ページへのアクセス権限を確認（C-24）
- [ ] データ保持期間（C-11〜C-13）が仕様通りであることを確認
