---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-汎用グラフ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **キャッシュ動作**: timestampベースのHTTPキャッシュの詳細動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/Graph.java` 行53-68（クラスJavadoc）
- E-02: `core/src/main/java/hudson/util/Graph.java` 行69-78（フィールド定義）
- E-03: `core/src/main/java/hudson/util/Graph.java` 行71（MAX_AREA定数）
- E-04: `core/src/main/java/hudson/util/Graph.java` 行85-93（コンストラクタ）
- E-05: `core/src/main/java/hudson/util/Graph.java` 行98（createGraph抽象メソッド）
- E-06: `core/src/main/java/hudson/util/Graph.java` 行100-130（renderメソッド）
- E-07: `core/src/main/java/hudson/util/Graph.java` 行124-126（サイズ上限）
- E-08: `core/src/main/java/hudson/util/Graph.java` 行134-140（safeDimensionメソッド）
- E-09: `core/src/main/java/hudson/util/Graph.java` 行142-152（stringToColorメソッド）
- E-10: `core/src/main/java/hudson/util/Graph.java` 行159-225（doPngメソッド群）
- E-11: `core/src/main/java/hudson/util/Graph.java` 行177（checkIfModified）
- E-12: `core/src/main/java/hudson/util/Graph.java` 行185-224（エラー処理）
- E-13: `core/src/main/java/hudson/util/Graph.java` 行232-257（doMapメソッド群）
- E-14: `core/src/main/java/hudson/util/Graph.java` 行255-256（getImageMap）
- E-15: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行3（帳票一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JFreeChartを使用してグラフを生成 | E-01, E-02 | ○ |
| C-02 | PNG形式で画像を出力 | E-10 (行181-183) | ○ |
| C-03 | クリッカブルマップを生成 | E-13, E-14 | ○ |
| C-04 | /png エンドポイントで画像を提供 | E-01, E-10 | ○ |
| C-05 | /map エンドポイントでマップを提供 | E-01, E-13 | ○ |
| C-06 | 抽象クラスであり createGraph() をオーバーライドして使用 | E-05 | ○ |
| C-07 | MAX_AREA は 10,000,000 ピクセル | E-03 | ○ |
| C-08 | width パラメータの最大値は 2560 | E-07 (行124) | ○ |
| C-09 | height パラメータの最大値は 1440 | E-07 (行125) | ○ |
| C-10 | scale パラメータの最大値は 3 | E-07 (行126) | ○ |
| C-11 | 背景色はパラメータで指定可能（デフォルト白） | E-06 (行116-117), E-09 | ○ |
| C-12 | graph フィールドは volatile で遅延初期化 | E-02 (行78), E-06 (行119) | ○ |
| C-13 | timestamp によるHTTPキャッシュ対応 | E-11 | ○ |
| C-14 | timestamp を -1 にするとキャッシュ無効 | **推測** | △ |
| C-15 | HeadlessException でリダイレクト | E-12 (行221-224) | ○ |
| C-16 | フォントエラーでリダイレクト | E-12 (行216-219) | ○ |
| C-17 | NumberFormatException で白色にフォールバック | E-09 (行146-148) | ○ |
| C-18 | safeDimension で MAX_AREA 超過時はデフォルト値使用 | E-08 | ○ |
| C-19 | マップのContent-Typeはtext/plain;charset=UTF-8 | E-13 (行255) | ○ |
| C-20 | 画像のContent-Typeはimage/png | E-10 (行181) | ○ |
| C-21 | BufferedImage生成時にスケール適用 | E-06 (行128-129) | ○ |
| C-22 | ChartRenderingInfo でクリッカブルマップ情報取得 | E-13 (行252-253), E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- **timestamp = -1 の挙動**: コード上では timestamp が負の場合の特別な処理は明示されていない。StaplerのcheckIfModified()の実装を確認する必要がある
  - 候補：Stapler ライブラリのソースコード / Jenkinsドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PNG/Map出力の基本機能は明確にコードで確認可能
- 0: 低リスク - サイズ制限は明確に実装されている
- 0: 低リスク - エラー処理は HeadlessException と フォントエラー をカバー
- 1: 中リスク - 抽象クラスのため、具象実装の品質は個別に確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] /png エンドポイントがPNG画像を正しく返すことを確認
- [ ] /map エンドポイントがクリッカブルマップを正しく返すことを確認
- [ ] width/height/scale パラメータの上限が機能することを確認
- [ ] MAX_AREA を超えるサイズ指定時にデフォルト値にフォールバックすることを確認（C-18）
- [ ] timestamp = -1 の場合のキャッシュ動作を確認（C-14）
- [ ] HeadlessException 発生時に headless.png へリダイレクトすることを確認
