---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ヘルスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、高優先度のレビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/HealthReport.java` 行48-50（クラス定義、Javadoc）
- E-02: `core/src/main/java/hudson/model/HealthReport.java` 行52-63（アイコン定数定義）
- E-03: `core/src/main/java/hudson/model/HealthReport.java` 行79-107（フィールド定義）
- E-04: `core/src/main/java/hudson/model/HealthReport.java` 行144-174（コンストラクタ、アイコン決定ロジック）
- E-05: `core/src/main/java/hudson/model/HealthReport.java` 行211-214, 253-261（getScore, getIconUrl）
- E-06: `core/src/main/java/hudson/model/HealthReport.java` 行277-279（getDescription）
- E-07: `core/src/main/java/hudson/model/HealthReport.java` 行328-330（compareTo）
- E-08: `core/src/main/java/hudson/model/HealthReport.java` 行335-351（min, maxメソッド）
- E-09: `core/src/main/java/hudson/model/HealthReportingAction.java` 行41-51（インターフェース定義）
- E-10: `core/src/main/java/hudson/model/Job.java` 行191-192（キャッシュフィールド）
- E-11: `core/src/main/java/hudson/model/Job.java` 行1273-1276（getBuildHealth）
- E-12: `core/src/main/java/hudson/model/Job.java` 行1278-1326（getBuildHealthReports）
- E-13: `core/src/main/java/hudson/model/Job.java` 行1283-1287（ビルド中チェック）
- E-14: `core/src/main/java/hudson/model/Job.java` 行1290-1295（キャッシュ利用）
- E-15: `core/src/main/java/hudson/model/Job.java` 行1297-1308（HealthReportingAction取得）
- E-16: `core/src/main/java/hudson/model/Job.java` 行1318（ソート）
- E-17: `core/src/main/java/hudson/model/Job.java` 行1328-1388（getBuildStabilityHealthReport）
- E-18: `core/src/main/java/hudson/model/Job.java` 行1353-1370（過去5ビルド走査）
- E-19: `core/src/main/java/hudson/model/Job.java` 行1372（スコア計算式）
- E-20: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行4（帳票一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スコアは0-100の整数値 | E-01, E-03 (行79) | ○ |
| C-02 | 5段階のアイコン（0-20, 21-40, 41-60, 61-80, 81-100） | E-02, E-04 | ○ |
| C-03 | icon-health-80plus は 81-100 の範囲 | E-04 (行154-155) | ○ |
| C-04 | icon-health-60to79 は 61-80 の範囲 | E-04 (行152-153) | ○ |
| C-05 | icon-health-40to59 は 41-60 の範囲 | E-04 (行150-151) | ○ |
| C-06 | icon-health-20to39 は 21-40 の範囲 | E-04 (行148-149) | ○ |
| C-07 | icon-health-00to19 は 0-20 の範囲 | E-04 (行146-147) | ○ |
| C-08 | 複数のHealthReportから最低スコアを選択 | E-11, E-16 | ○ |
| C-09 | HealthReportingAction インターフェースがある | E-09 | ○ |
| C-10 | getBuildHealth() がエントリーポイント | E-11 | ○ |
| C-11 | REST APIで healthReport として公開 | E-12 (行1278) | ○ |
| C-12 | ビルド中は前のビルドを使用 | E-13 | ○ |
| C-13 | ビルド番号ベースのキャッシュあり | E-10, E-14 | ○ |
| C-14 | スコアでソート（昇順） | E-16 | ○ |
| C-15 | ビルド安定性は過去5ビルドから計算 | E-17, E-18 | ○ |
| C-16 | BLUE/YELLOW は成功、RED は失敗としてカウント | E-18 (行1354-1368) | ○ |
| C-17 | スコア計算式: (totalCount - failCount) / totalCount * 100 | E-19 | ○ |
| C-18 | 失敗がない場合は100点 | E-17 (行1334-1336) | ○ |
| C-19 | ビルド履歴がない場合はデフォルトHealthReport | E-12 (行1280-1286) | ○ |
| C-20 | description は Localizable 型 | E-03 (行107), E-06 | ○ |
| C-21 | Comparable を実装 | E-07 | ○ |
| C-22 | min(), max() 静的メソッドがある | E-08 | ○ |
| C-23 | iconUrl は null の場合デフォルト値 | E-04 (行157-171) | ○ |
| C-24 | View ページでアイコンとして表示 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認されたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造とロジックは明確にコードで確認可能
- 0: 低リスク - スコア計算ロジックは単純で理解しやすい
- 0: 低リスク - キャッシュ機構は明確に実装されている
- 0: 低リスク - エラー処理（null チェック）が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 5段階のアイコンが正しいスコア範囲で表示されることを確認
- [ ] ビルド中のジョブで前のビルドのヘルスレポートが表示されることを確認
- [ ] REST API（/api/json）でhealthReportが取得できることを確認
- [ ] 複数のHealthReportがある場合に最低スコアが代表として選ばれることを確認
- [ ] 過去5ビルドから正しくスコアが計算されることを確認
- [ ] キャッシュが新しいビルド完了時に正しく更新されることを確認
