---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-メモリ使用量モニター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、高優先度のレビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行50-51（@Extension、クラス定義）
- E-02: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行55-100（MemoryGroup内部クラス）
- E-03: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行62-66（used, max TimeSeries定義）
- E-04: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行68-73（コンストラクタ、メモリタイプ分類）
- E-05: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行75-91（update()メソッド）
- E-06: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行79-80（getCollectionUsage、null チェック）
- E-07: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行86-87（KB変換）
- E-08: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行96-99（doGraph()メソッド）
- E-09: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行97（権限チェック）
- E-10: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行102-109（heap, nonHeap フィールド、コンストラクタ）
- E-11: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行111-114（getRecurrencePeriod、10秒）
- E-12: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` 行116-120（doRun()メソッド）
- E-13: `core/src/main/java/jenkins/diagnosis/MemoryUsageMonitorAction.java` 行41-47（RootAction、@Restricted）
- E-14: `core/src/main/java/jenkins/diagnosis/MemoryUsageMonitorAction.java` 行49-52（getHeap()メソッド）
- E-15: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行5（帳票一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JMXを使用してメモリ情報を取得 | E-04, E-05, E-10 | ○ |
| C-02 | ヒープと非ヒープを別々のMemoryGroupで管理 | E-04, E-10 | ○ |
| C-03 | 使用量は赤色で表示（ColorPalette.RED） | E-03 (行62) | ○ |
| C-04 | 最大値は青色で表示（ColorPalette.BLUE） | E-03 (行66) | ○ |
| C-05 | 10秒ごとにデータ収集 | E-11 | ○ |
| C-06 | バイトからKBへ変換（/1024） | E-07 | ○ |
| C-07 | getCollectionUsage()でGC後の値を取得 | E-05 (行79), E-06 | ○ |
| C-08 | getCollectionUsage()がnullの場合はスキップ | E-06 (行80) | ○ |
| C-09 | SYSTEM_READ または MANAGE 権限が必要 | E-09 | ○ |
| C-10 | @Extension として自動登録 | E-01 | ○ |
| C-11 | @Restricted(NoExternalUse.class) で外部利用制限 | E-13 (行42) | ○ |
| C-12 | PeriodicWork を継承 | E-01 | ○ |
| C-13 | doGraph() がエントリーポイント | E-08 | ○ |
| C-14 | MultiStageTimeSeries.createTrendChart() でグラフ生成 | E-08 (行98) | ○ |
| C-15 | RootAction を実装してURLルーティング | E-13 | ○ |
| C-16 | heap.update() と nonHeap.update() を呼び出し | E-12 | ○ |
| C-17 | ManagementFactory.getMemoryPoolMXBeans() で取得 | E-10 (行106) | ○ |
| C-18 | MemoryType.HEAP でフィルタ | E-04 (行70), E-10 (行107) | ○ |
| C-19 | MemoryType.NON_HEAP でフィルタ | E-04 (行70), E-10 (行108) | ○ |
| C-20 | MultiStageTimeSeries で3段階の時間解像度 | E-03, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認されたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JMX APIの使用は標準的
- 0: 低リスク - 権限チェックは明確に実装されている
- 0: 低リスク - データ収集ロジックは単純で理解しやすい
- 0: 低リスク - @Restricted によるアクセス制限が適切

## 6) レビュアーチェックリスト（最小）
- [ ] 管理画面からメモリ使用量グラフにアクセスできることを確認
- [ ] SYSTEM_READ または MANAGE 権限がないユーザーがアクセスできないことを確認
- [ ] ヒープと非ヒープの両方のグラフが表示されることを確認
- [ ] 使用量（赤）と最大値（青）が正しい色で表示されることを確認
- [ ] 10秒ごとにデータが更新されることを確認
- [ ] KB単位で値が表示されることを確認
