---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：5-ビルドコンソールログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **ログ自動圧縮**: gzip圧縮のタイミングに関する詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行64-80（クラスJavadoc）
- E-02: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行81-100（コンストラクタ）
- E-03: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行105-125（doProgressiveHtml）
- E-04: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行176-178（setContentType）
- E-05: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行180-207（createAnnotator）
- E-06: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行243-263（writeHtmlTo）
- E-07: `core/src/main/java/hudson/console/AnnotatedLargeText.java` 行268（PASSING_ANNOTATOR）
- E-08: `core/src/main/java/hudson/console/ConsoleNote.java` 行63-139（クラスJavadoc、仕様説明）
- E-09: `core/src/main/java/hudson/console/ConsoleNote.java` 行142-150（MAC, INSECURE フラグ）
- E-10: `core/src/main/java/hudson/console/ConsoleNote.java` 行167（annotate 抽象メソッド）
- E-11: `core/src/main/java/hudson/console/ConsoleNote.java` 行182-230（encode, encodeTo）
- E-12: `core/src/main/java/hudson/console/ConsoleNote.java` 行240-297（readFrom）
- E-13: `core/src/main/java/hudson/console/ConsoleNote.java` 行272-278（MAC検証）
- E-14: `core/src/main/java/hudson/console/ConsoleNote.java` 行325-338（PREAMBLE, POSTAMBLE）
- E-15: `core/src/main/java/hudson/model/Run.java` 行1513-1515（getLogText）
- E-16: `core/src/main/java/hudson/model/Run.java` 行1402-1428（getLogFile, getLogInputStream）
- E-17: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行6（帳票一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnnotatedLargeText は LargeText を拡張 | E-01 (行65), E-02 | ○ |
| C-02 | ConsoleNote によるアノテーション機能 | E-01, E-08 | ○ |
| C-03 | HTML形式とプレーンテキスト形式を提供 | E-03, E-04 | ○ |
| C-04 | doProgressiveHtml() がエントリーポイント | E-03 | ○ |
| C-05 | Run.getLogText() で AnnotatedLargeText を取得 | E-15 | ○ |
| C-06 | Content-Type は text/html または text/plain | E-04 (行177) | ○ |
| C-07 | ConsoleAnnotator の状態をHTTPヘッダで管理 | E-05, E-06 (行257-261) | ○ |
| C-08 | X-ConsoleAnnotator ヘッダを使用 | E-05 (行182), E-06 (行260) | ○ |
| C-09 | ConsoleNote はGZIP圧縮・Base64エンコード | E-11 (行203-221) | ○ |
| C-10 | MAC で署名・検証 | E-09 (行142), E-11 (行213-215), E-13 | ○ |
| C-11 | PREAMBLE/POSTAMBLE で ConsoleNote を囲む | E-14 | ○ |
| C-12 | PREAMBLE は ANSI エスケープシーケンス | E-14 (行325-326) | ○ |
| C-13 | 1時間以上前のタイムスタンプは拒否 | E-05 (行190-192) | ○ |
| C-14 | INSECURE フラグで署名チェックを無効化可能 | E-09 (行148-150), E-13 (行272) | ○ |
| C-15 | ConsoleNote は Jenkins マスターで生成が必要 | E-08 (行115-124), E-11 (行212) | ○ |
| C-16 | PlainTextConsoleOutputStream で Note を除去 | E-01 (行224-231) | ○ |
| C-17 | writeHtmlTo() がHTML出力のメイン処理 | E-06 | ○ |
| C-18 | ConsoleAnnotationOutputStream を使用 | E-06 (行246-247) | ○ |
| C-19 | annotate() メソッドでマークアップ生成 | E-10 | ○ |
| C-20 | ログファイルは log または log.gz | E-16 (行1402-1428) | ○ |
| C-21 | 文字セットはビルド設定による（デフォルトUTF-8） | E-02, E-15 | ○ |
| C-22 | HyperlinkNote でリンク化 | E-08 (Javadoc), E-17 | ○ |
| C-23 | ExpandableDetailsNote で折りたたみ | E-08 (Javadoc), E-17 | ○ |
| C-24 | プラグインは ConsoleNote を拡張可能 | E-08 (行140) | ○ |
| C-25 | CryptoConfidentialKey で暗号化 | E-07 | ○ |
| C-26 | ログは完了後に自動gzip圧縮される | **推測** | △ |

## 4) 不足情報（Unknown / Missing）
- **ログ自動圧縮のタイミング**: Run.java の getLogInputStream() で GZIPInputStream を使用しているが、圧縮のトリガーとなる処理の明確な記述が見つからない
  - 候補：BuildDiscarder / ログローテーション設定 / 別のクラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アノテーション処理のフローは明確
- 0: 低リスク - セキュリティ機構（MAC、タイムスタンプ検証）は明確に実装
- 1: 中リスク - ログ圧縮のタイミングは要確認
- 0: 低リスク - Progressive読み込みの仕組みは明確

## 6) レビュアーチェックリスト（最小）
- [ ] コンソールページでHTMLアノテーションが正しく表示されることを確認
- [ ] Progressive HTML が正しく動作し、リアルタイム更新されることを確認
- [ ] プレーンテキスト形式でダウンロードすると ConsoleNote が除去されることを確認
- [ ] MAC 検証が機能し、改ざんされた ConsoleNote が拒否されることを確認
- [ ] 1時間以上前のタイムスタンプを持つ Annotator が拒否されることを確認
- [ ] HyperlinkNote によるリンクが正しく生成されることを確認
- [ ] ログ圧縮（log.gz）のタイミングを確認（C-26）
