---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **BR-028 ビルド結果の通知**：メール通知の具体的実装はプラグイン依存のため根拠不足
  2. **BR-040 Cloudによる動的ノードプロビジョニング**：具体的なクラウド実装はプラグイン依存
  3. **BR-027 Mavenプロジェクトのビルド**：Maven連携の詳細はプラグインで拡張される

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Queue.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Job.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Run.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Node.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Slave.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/User.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/security/AuthorizationStrategy.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/security/ACL.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/PluginManager.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/UpdateCenter.java`
- E-12: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/View.java`
- E-13: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/triggers/SCMTrigger.java`
- E-14: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/model/Jenkins.java`
- E-15: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/tasks/Shell.java`
- E-16: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/tasks/ArtifactArchiver.java`
- E-17: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/ParameterDefinition.java`
- E-18: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/FreeStyleProject.java`
- E-19: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Fingerprint.java`
- E-20: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/security/csrf/CrumbIssuer.java`
- E-21: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/util/Secret.java`
- E-22: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/jenkins/install/SetupWizard.java`
- E-23: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/ManagementLink.java`
- E-24: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-25: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Computer.java`
- E-26: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Executor.java`
- E-27: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/Label.java`
- E-28: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/slaves/Cloud.java`
- E-29: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/model/LoadBalancer.java`
- E-30: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/cli/CLI.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001: ジョブの作成と設定 | E-02, E-18 | ○ |
| C-02 | BR-002: ジョブのビルド実行 | E-01, E-03 | ○ |
| C-03 | BR-003: ビルド結果の記録と表示 | E-03 | ○ |
| C-04 | BR-004: ビルドパラメータの定義 | E-17 | ○ |
| C-05 | BR-005: ビルドトリガーの設定 | E-13 | ○ |
| C-06 | BR-006: ビルドキューの管理 | E-01 | ○ |
| C-07 | BR-007: ビルドのキャンセル | E-01, E-03 | ○ |
| C-08 | BR-008: エージェント（ノード）の登録 | E-04, E-05 | ○ |
| C-09 | BR-009: ノードのラベル管理 | E-27 | ○ |
| C-10 | BR-010: ノードのオンライン/オフライン制御 | E-25 | ○ |
| C-11 | BR-011: エグゼキュータの管理 | E-26, E-04 | ○ |
| C-12 | BR-012: ユーザーアカウントの作成 | E-06, E-07 | ○ |
| C-13 | BR-013: ユーザー認証 | E-07, E-08 | ○ |
| C-14 | BR-014: ユーザープロパティの管理 | E-06 | ○ |
| C-15 | BR-015: アクセス制御リスト（ACL）の適用 | E-09 | ○ |
| C-16 | BR-016: 認可戦略の設定 | E-08 | ○ |
| C-17 | BR-017: 権限グループの定義 | E-09 | ○ |
| C-18 | BR-018: プラグインのインストール | E-10, E-11 | ○ |
| C-19 | BR-019: プラグインの更新 | E-11 | ○ |
| C-20 | BR-020: プラグインの依存関係管理 | E-10 | ○ |
| C-21 | BR-021: ビューの作成と設定 | E-12 | ○ |
| C-22 | BR-022: ビューでのジョブ表示 | E-12 | ○ |
| C-23 | BR-023: 成果物のアーカイブ | E-16 | ○ |
| C-24 | BR-024: フィンガープリントの管理 | E-19 | ○ |
| C-25 | BR-025: SCMポーリングによるビルドトリガー | E-13 | ○ |
| C-26 | BR-026: シェルスクリプトの実行 | E-15 | ○ |
| C-27 | BR-027: Mavenプロジェクトのビルド | **根拠不足** | △ |
| C-28 | BR-028: ビルド結果の通知 | **根拠不足** | △ |
| C-29 | BR-029: CSRF対策 | E-20 | ○ |
| C-30 | BR-030: 機密情報の暗号化 | E-21 | ○ |
| C-31 | BR-031: Jenkinsの設定管理 | E-14 | ○ |
| C-32 | BR-032: 設定の永続化 | E-14 | ○ |
| C-33 | BR-033: Jenkinsの再起動 | E-14 | ○ |
| C-34 | BR-034: コンソールログの表示 | E-03 | ○ |
| C-35 | BR-035: ビルド履歴の保持ポリシー | E-02 | ○ |
| C-36 | BR-036: 拡張ポイントの提供 | E-14 | ○ |
| C-37 | BR-037: Descriptor/Describableパターン | E-02 | ○ |
| C-38 | BR-038: ビルドツールのインストール | E-14 | ○ |
| C-39 | BR-039: ロードバランシング | E-29 | ○ |
| C-40 | BR-040: Cloudによる動的ノードプロビジョニング | **根拠不足** | △ |
| C-41 | BR-041: コマンドラインインターフェース | E-30 | ○ |
| C-42 | BR-042: REST APIの提供 | E-14 | ○ |
| C-43 | BR-043: セットアップウィザード | E-22 | ○ |
| C-44 | BR-044: システム管理リンクの表示 | E-23 | ○ |
| C-45 | BR-045: 管理モニターによる警告 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-027 Mavenプロジェクトのビルド**：コアにMaven基本クラスは存在するが、完全なMaven連携機能はmavenプラグインで提供される
  - 候補：maven-plugin / maven-integration-plugin
- **BR-028 ビルド結果の通知**：Publisherインターフェースは存在するが、メール通知の実装はmailerプラグインに依存
  - 候補：mailer-plugin / email-ext-plugin
- **BR-040 Cloudによる動的ノードプロビジョニング**：Cloudインターフェースは存在するが、具体的なクラウド連携はプラグインに依存
  - 候補：docker-plugin / kubernetes-plugin / amazon-ec2-plugin

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - BR-001〜BR-026：コアソースコードに明確な実装根拠あり
- **1: 中リスク** - BR-027, BR-028, BR-040：プラグイン依存のため、コア機能としての説明に限界あり
- **0: 低リスク** - BR-029〜BR-045：コアソースコードに明確な実装根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] BR-027〜BR-028, BR-040のプラグイン依存機能について、プラグイン側の実装を確認する必要があるか検討
- [ ] 各業務要件の優先度が実際のプロジェクト要件と一致しているか確認
- [ ] 関連機能として記載されたクラス名が最新のソースコードと一致しているか確認
- [ ] カテゴリの分類が業務観点で適切か確認
- [ ] 備考欄の実装クラス情報が正確か、サンプリングで確認
