---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  - 全ての機能にソースコードの根拠が存在するため、高優先度のレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/model/Jenkins.java` - Jenkinsコア
- E-02: `core/src/main/java/hudson/PluginManager.java` - プラグイン管理
- E-03: `core/src/main/java/hudson/model/UpdateCenter.java` - アップデートセンター
- E-04: `core/src/main/java/hudson/model/Job.java` - ジョブ管理
- E-05: `core/src/main/java/hudson/model/FreeStyleProject.java` - フリースタイルプロジェクト
- E-06: `core/src/main/java/hudson/model/Build.java` - ビルド
- E-07: `core/src/main/java/hudson/model/Run.java` - ビルド実行
- E-08: `core/src/main/java/hudson/model/Queue.java` - キュー管理
- E-09: `core/src/main/java/hudson/model/Executor.java` - エグゼキューター
- E-10: `core/src/main/java/hudson/model/Slave.java` - エージェントノード
- E-11: `core/src/main/java/hudson/model/Node.java` - ノード
- E-12: `core/src/main/java/hudson/slaves/Cloud.java` - クラウド連携
- E-13: `core/src/main/java/hudson/slaves/NodeProvisioner.java` - ノードプロビジョニング
- E-14: `core/src/main/java/hudson/model/Computer.java` - コンピューター管理
- E-15: `core/src/main/java/hudson/model/ComputerSet.java` - コンピューターセット
- E-16: `core/src/main/java/hudson/node_monitors/NodeMonitor.java` - ノードモニター
- E-17: `core/src/main/java/hudson/tasks/BuildStep.java` - ビルドステップ
- E-18: `core/src/main/java/hudson/tasks/Builder.java` - ビルダー
- E-19: `core/src/main/java/hudson/tasks/Shell.java` - シェル実行
- E-20: `core/src/main/java/hudson/tasks/BatchFile.java` - バッチファイル実行
- E-21: `core/src/main/java/hudson/tasks/Maven.java` - Mavenビルド
- E-22: `core/src/main/java/hudson/tasks/ArtifactArchiver.java` - 成果物アーカイブ
- E-23: `core/src/main/java/hudson/tasks/Fingerprinter.java` - フィンガープリント
- E-24: `core/src/main/java/hudson/model/Fingerprint.java` - フィンガープリントモデル
- E-25: `core/src/main/java/hudson/tasks/BuildTrigger.java` - ビルドトリガー
- E-26: `core/src/main/java/hudson/tasks/BuildWrapper.java` - ビルドラッパー
- E-27: `core/src/main/java/hudson/tasks/LogRotator.java` - ログローテーション
- E-28: `core/src/main/java/hudson/triggers/SCMTrigger.java` - SCMトリガー
- E-29: `core/src/main/java/hudson/triggers/TimerTrigger.java` - タイマートリガー
- E-30: `core/src/main/java/hudson/scm/SCM.java` - SCM基盤
- E-31: `core/src/main/java/hudson/scm/ChangeLogSet.java` - 変更ログ
- E-32: `core/src/main/java/hudson/scm/RepositoryBrowser.java` - リポジトリブラウザ
- E-33: `core/src/main/java/hudson/security/SecurityRealm.java` - セキュリティレルム
- E-34: `core/src/main/java/hudson/security/AuthorizationStrategy.java` - 認可戦略
- E-35: `core/src/main/java/hudson/model/User.java` - ユーザー管理
- E-36: `core/src/main/java/hudson/security/Permission.java` - 権限
- E-37: `core/src/main/java/hudson/security/ACL.java` - アクセス制御リスト
- E-38: `core/src/main/java/jenkins/security/ApiTokenProperty.java` - APIトークン
- E-39: `core/src/main/java/hudson/security/csrf/CrumbIssuer.java` - CSRF保護
- E-40: `core/src/main/java/jenkins/security/ConfidentialStore.java` - 機密情報管理
- E-41: `core/src/main/java/hudson/model/View.java` - ビュー
- E-42: `core/src/main/java/hudson/model/ListView.java` - リストビュー
- E-43: `core/src/main/java/hudson/model/MyView.java` - マイビュー
- E-44: `core/src/main/java/hudson/model/AllView.java` - 全ビュー
- E-45: `core/src/main/java/hudson/cli/CLICommand.java` - CLIコマンド基盤
- E-46: `core/src/main/java/hudson/cli/BuildCommand.java` - ビルドコマンド
- E-47: `core/src/main/java/hudson/cli/CreateJobCommand.java` - ジョブ作成コマンド
- E-48: `core/src/main/java/hudson/cli/ConnectNodeCommand.java` - ノード接続コマンド
- E-49: `core/src/main/java/hudson/cli/InstallPluginCommand.java` - プラグインインストールコマンド
- E-50: `core/src/main/java/hudson/cli/GroovyCommand.java` - Groovyコマンド
- E-51: `core/src/main/java/jenkins/model/GlobalConfiguration.java` - グローバル設定
- E-52: `core/src/main/java/hudson/model/ManagementLink.java` - 管理リンク
- E-53: `core/src/main/java/hudson/model/AdministrativeMonitor.java` - 管理モニター
- E-54: `core/src/main/java/hudson/model/LoadStatistics.java` - ロード統計
- E-55: `core/src/main/java/hudson/ProxyConfiguration.java` - プロキシ設定
- E-56: `core/src/main/java/hudson/Extension.java` - 拡張アノテーション
- E-57: `core/src/main/java/hudson/ExtensionPoint.java` - 拡張ポイント
- E-58: `core/src/main/java/hudson/ExtensionList.java` - 拡張リスト
- E-59: `core/src/main/java/hudson/model/Descriptor.java` - ディスクリプター
- E-60: `core/src/main/java/hudson/model/RootAction.java` - ルートアクション
- E-61: `core/src/main/java/hudson/model/ParameterDefinition.java` - パラメータ定義
- E-62: `core/src/main/java/hudson/FilePath.java` - ファイルパス操作
- E-63: `core/src/main/java/hudson/Launcher.java` - ランチャー
- E-64: `core/src/main/java/hudson/EnvVars.java` - 環境変数
- E-65: `core/src/main/java/hudson/XmlFile.java` - XMLファイル操作
- E-66: `core/src/main/java/hudson/util/FormValidation.java` - フォームバリデーション
- E-67: `core/src/main/java/hudson/model/Api.java` - REST API
- E-68: `core/src/main/java/hudson/model/Label.java` - ラベル
- E-69: `core/src/main/java/hudson/model/LoadBalancer.java` - 負荷分散
- E-70: `core/src/main/java/hudson/init/InitMilestone.java` - 初期化マイルストーン
- E-71: `README.md` - プロジェクト概要
- E-72: `pom.xml` - プロジェクト構成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jenkins本体 | E-01, E-71 | ○ |
| C-02 | プラグインマネージャー | E-02 | ○ |
| C-03 | アップデートセンター | E-03 | ○ |
| C-04 | ジョブ（Job） | E-04 | ○ |
| C-05 | フリースタイルプロジェクト | E-05 | ○ |
| C-06 | ビルド（Build） | E-06, E-07 | ○ |
| C-07 | キュー管理 | E-08 | ○ |
| C-08 | エグゼキューター | E-09 | ○ |
| C-09 | コントローラーノード | E-01 | ○ |
| C-10 | エージェントノード | E-10, E-11 | ○ |
| C-11 | クラウドプロビジョニング | E-12, E-13 | ○ |
| C-12 | コンピューター管理 | E-14, E-15 | ○ |
| C-13 | ノードモニター | E-16 | ○ |
| C-14 | ビルドステップ | E-17, E-18 | ○ |
| C-15 | シェルスクリプト実行 | E-19 | ○ |
| C-16 | バッチファイル実行 | E-20 | ○ |
| C-17 | Mavenビルド | E-21 | ○ |
| C-18 | 成果物アーカイブ | E-22 | ○ |
| C-19 | フィンガープリント | E-23, E-24 | ○ |
| C-20 | ビルドトリガー | E-25 | ○ |
| C-21 | ビルドラッパー | E-26 | ○ |
| C-22 | ログローテーション | E-27 | ○ |
| C-23 | SCMトリガー | E-28 | ○ |
| C-24 | タイマートリガー | E-29 | ○ |
| C-25 | SCM連携 | E-30 | ○ |
| C-26 | 変更ログ | E-31 | ○ |
| C-27 | リポジトリブラウザ | E-32 | ○ |
| C-28 | 認証（SecurityRealm） | E-33 | ○ |
| C-29 | 認可（AuthorizationStrategy） | E-34 | ○ |
| C-30 | ユーザー管理 | E-35 | ○ |
| C-31 | 権限管理 | E-36, E-37 | ○ |
| C-32 | APIトークン | E-38 | ○ |
| C-33 | CSRF保護 | E-39 | ○ |
| C-34 | 機密情報管理 | E-40 | ○ |
| C-35 | ビュー管理 | E-41 | ○ |
| C-36 | リストビュー | E-42 | ○ |
| C-37 | マイビュー | E-43 | ○ |
| C-38 | ダッシュボード | E-44 | ○ |
| C-39 | CLIコマンド基盤 | E-45 | ○ |
| C-40 | ビルドコマンド | E-46 | ○ |
| C-41 | ジョブ管理コマンド | E-47 | ○ |
| C-42 | ノード管理コマンド | E-48 | ○ |
| C-43 | プラグイン管理コマンド | E-49 | ○ |
| C-44 | Groovyコンソール | E-50 | ○ |
| C-45 | システム設定 | E-51 | ○ |
| C-46 | 管理画面 | E-52 | ○ |
| C-47 | 管理モニター | E-53 | ○ |
| C-48 | ロード統計 | E-54 | ○ |
| C-49 | プロキシ設定 | E-55 | ○ |
| C-50 | ログ管理 | E-01 | ○ |
| C-51 | 拡張機構 | E-56, E-57, E-58 | ○ |
| C-52 | Descriptor | E-59 | ○ |
| C-53 | ルートアクション | E-60 | ○ |
| C-54 | パラメータ定義 | E-61 | ○ |
| C-55 | 文字列パラメータ | E-61 | ○ |
| C-56 | 選択パラメータ | E-61 | ○ |
| C-57 | ブールパラメータ | E-61 | ○ |
| C-58 | ファイルパラメータ | E-61 | ○ |
| C-59 | パスワードパラメータ | E-61 | ○ |
| C-60 | ファイル操作 | E-62 | ○ |
| C-61 | ランチャー | E-63 | ○ |
| C-62 | 環境変数 | E-64 | ○ |
| C-63 | XMLファイル操作 | E-65 | ○ |
| C-64 | フォームバリデーション | E-66 | ○ |
| C-65 | REST API | E-67 | ○ |
| C-66 | RSSフィード | E-01 | ○ |
| C-67 | WebSocket | E-72 | ○ |
| C-68 | ラベル管理 | E-68 | ○ |
| C-69 | 負荷分散 | E-69 | ○ |
| C-70 | 初期化フレームワーク | E-70 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての機能について対応するソースコードファイルが存在することを確認しました

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全機能がソースコードに基づいており、高い信頼性を持つ
- 注意点：プラグインによって提供される追加機能は本一覧に含まれていません。Jenkinsはプラグイン拡張性が高いため、実運用環境ではプラグインごとの機能も確認が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] 機能一覧の各項目がソースコードの実装と一致しているか確認
- [ ] カテゴリ分類が適切か確認
- [ ] 説明文が機能の役割を正確に表現しているか確認
- [ ] プラグインによる追加機能が必要な場合は別途ドキュメント化を検討
- [ ] 備考欄のクラス参照が最新のソースコードと一致しているか確認
