# 機能設計書 14-ビルドステップ

## 概要

本ドキュメントは、Jenkinsにおけるビルドステップ（BuildStep/Builder）機能の設計について記述する。この機能は、ビルドプロセスを構成する個々のステップを定義・実行するための基盤フレームワークを提供する。

### 本機能の処理概要

ビルドステップ機能は、Jenkinsのビルドプロセスにおいて実際の処理を実行するための抽象化レイヤーを提供する。BuildStepインターフェースがビルドステップの基本契約を定義し、Builderクラスがその具体的な実装基底クラスとなる。シェルスクリプト実行、Maven/Antビルド、ファイル操作など、様々なビルド処理がこのフレームワーク上に実装される。

**業務上の目的・背景**：CI/CDパイプラインでは、ソースコードのビルド、テスト実行、成果物生成など複数の処理ステップを順次実行する必要がある。ビルドステップフレームワークにより、これらの処理を標準化されたインターフェースで実装・管理でき、プラグインによる拡張も容易になる。

**機能の利用シーン**：
- フリースタイルプロジェクトでのビルドステップ設定
- シェルスクリプト、バッチファイル、Maven/Antなどのビルドツール実行
- カスタムビルド処理のプラグイン開発
- ビルド前処理（prebuild）とメイン処理（perform）の分離実行

**主要な処理内容**：
1. BuildStepインターフェースによるビルドステップ契約の定義
2. Builderクラスによるビルダー実装の基底クラス提供
3. BuildStepMonitorによる並行ビルド時の同期制御
4. Descriptorパターンによる設定UI・永続化のサポート
5. Extensionアノテーションによるプラグイン登録メカニズム

**関連システム・外部連携**：Launcher経由でのプロセス実行、VirtualChannel経由でのリモートノード実行。

**権限による制御**：Job.CONFIGURE権限でビルドステップの設定変更が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ジョブ設定 | 主画面 | ビルドステップの追加・編集・削除 |

## 機能種別

フレームワーク / 拡張ポイント

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| build | AbstractBuild | Yes | 実行中のビルドオブジェクト | - |
| launcher | Launcher | Yes | プロセス起動用オブジェクト | - |
| listener | BuildListener | Yes | ビルドログ出力用リスナー | - |

### 入力データソース

- Project.getBuilders(): プロジェクトに設定されたBuilderリスト
- config.xml: ビルドステップ設定の永続化ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | boolean | true=成功、false=失敗（非推奨、AbortException推奨） |
| Action | Action | ビルド結果に付与するアクション（テストレポート等） |

### 出力先

- BuildListener: コンソールログへの出力
- Build.getActions(): ビルド結果へのAction追加

## 処理フロー

### 処理シーケンス

```
1. Build実行開始
   └─ Executor.run()からビルド処理開始
2. prebuild()フェーズ
   └─ 各BuildStepのprebuild()を順次呼び出し
   └─ falseが返されたら即座にビルド中断
3. perform()フェーズ
   └─ BuildStepMonitorに基づく同期待機
   └─ 各BuildStepのperform()を順次呼び出し
   └─ falseまたはAbortExceptionでビルド失敗
4. Post-buildアクション
   └─ Publisher（Recorder/Notifier）の実行
5. ビルド完了
   └─ getProjectActions()で結果アクション収集
```

### フローチャート

```mermaid
flowchart TD
    A[Build開始] --> B[prebuildフェーズ]
    B --> C{各BuildStep.prebuild}
    C -->|true| D{次のBuildStepあり?}
    C -->|false| E[ビルド中断]
    D -->|Yes| C
    D -->|No| F[performフェーズ]
    F --> G{BuildStepMonitor確認}
    G -->|BUILD| H[前ビルド完了待機]
    G -->|STEP| I[前ステップ完了待機]
    G -->|NONE| J[即座に実行]
    H --> J
    I --> J
    J --> K{BuildStep.perform}
    K -->|true| L{次のBuildStepあり?}
    K -->|false/Exception| M[ビルド失敗]
    L -->|Yes| G
    L -->|No| N[Post-buildアクション]
    N --> O[ビルド完了]
    E --> O
    M --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | prebuild順次実行 | prebuild()はfalse返却で即座に中断 | prebuildフェーズ |
| BR-14-02 | BuildStepMonitorデフォルト | BuildStep.getRequiredMonitorService()のデフォルトはBUILD | 未オーバーライド時 |
| BR-14-03 | BuilderのMonitorデフォルト | Builder.getRequiredMonitorService()のデフォルトはNONE | Builder実装時 |
| BR-14-04 | AbortException推奨 | 戻り値falseよりAbortExceptionスローを推奨 | エラー通知時 |
| BR-14-05 | XStream永続化 | BuildStepはProjectの一部としてXStreamで永続化 | 設定保存時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースではなく、XMLファイルベースの設定永続化を使用。

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ビルドステップ保存 | jobs/{jobName}/config.xml | UPDATE | BuildStepリストの永続化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AbortException | ビルドステップが明示的に中断 | ビルド失敗、エラーメッセージ出力 |
| - | InterruptedException | ユーザーによるビルド中断 | ビルド中断、後続ステップスキップ |
| - | IOException | I/Oエラー発生 | ビルド失敗、エラーメッセージ出力 |

### リトライ仕様

リトライは各BuildStep実装の責任。フレームワークとしてのリトライ機構なし。

## トランザクション仕様

- BuildStepMonitorによる並行ビルド時の同期制御
- CheckPointによる明示的な同期ポイント設定

## パフォーマンス要件

特になし（各BuildStep実装依存）。

## セキュリティ考慮事項

- Jenkins.getAuthentication2()による認証コンテキスト確認
- ACL.SYSTEM2の場合はACL.impersonate2でANONYMOUSに切り替え推奨
- QueueItemAuthenticatorによるビルド実行時認証

## 備考

- Builderはビルド本体を実行するステップ（コンパイル、テスト等）
- Publisherはビルド後処理を実行するステップ（通知、レポート生成等）
  - Recorder: ビルド結果を変更する可能性があるPublisher
  - Notifier: ビルド結果を報告するだけのPublisher

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BuildStepインターフェースとBuilderクラスの関係を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BuildStep.java | `core/src/main/java/hudson/tasks/BuildStep.java` | ビルドステップインターフェース |
| 1-2 | Builder.java | `core/src/main/java/hudson/tasks/Builder.java` | ビルダー基底クラス |
| 1-3 | BuildStepMonitor.java | `core/src/main/java/hudson/tasks/BuildStepMonitor.java` | 同期制御列挙型 |

**読解のコツ**: BuildStepはインターフェース、BuilderはBuildStepCompatibilityLayerを継承しDescribableを実装。Descriptorパターンに注目。

#### Step 2: コアメソッドを理解する

prebuild()とperform()のシグネチャと契約を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BuildStep.prebuild() | `core/src/main/java/hudson/tasks/BuildStep.java` | 事前処理メソッド（91行目） |
| 2-2 | BuildStep.perform() | `core/src/main/java/hudson/tasks/BuildStep.java` | メイン処理メソッド（129行目） |

**主要処理フロー**:
- **91行目**: prebuild(AbstractBuild, BuildListener) - ビルド開始前に呼び出し
- **129行目**: perform(AbstractBuild, Launcher, BuildListener) - メイン処理実行

#### Step 3: 同期制御を理解する

BuildStepMonitorによる並行ビルド制御を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | getRequiredMonitorService() | `core/src/main/java/hudson/tasks/BuildStep.java` | 同期要求メソッド（220-222行目） |
| 3-2 | Builder.getRequiredMonitorService() | `core/src/main/java/hudson/tasks/Builder.java` | Builderのデフォルト（64-66行目） |

**主要処理フロー**:
- **220-222行目**: BuildStepのデフォルトはBuildStepMonitor.BUILD
- **64-66行目**: BuilderのデフォルトはBuildStepMonitor.NONE

#### Step 4: 拡張メカニズムを理解する

Descriptorパターンとextension pointを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Builder.all() | `core/src/main/java/hudson/tasks/Builder.java` | 全Builder取得（77-79行目） |
| 4-2 | getProjectActions() | `core/src/main/java/hudson/tasks/BuildStep.java` | プロジェクトアクション（159-160行目） |

**主要処理フロー**:
- **77-79行目**: Jenkins.get().getDescriptorList(Builder.class)で全Builder取得
- **159-160行目**: getProjectActions()でプロジェクト画面へのアクション追加

### プログラム呼び出し階層図

```
AbstractBuild.run() [ビルド実行]
    │
    ├─ [prebuildフェーズ]
    │      │
    │      └─ BuildStep.prebuild(build, listener)
    │             │
    │             └─ [各Builder実装]
    │
    └─ [performフェーズ]
           │
           ├─ BuildStepMonitor.perform() [同期制御]
           │      │
           │      ├─ BUILD: 前ビルド完了待機
           │      ├─ STEP: 前ステップ完了待機
           │      └─ NONE: 即座に実行
           │
           └─ BuildStep.perform(build, launcher, listener)
                  │
                  ├─ Shell.perform() [シェル実行]
                  ├─ Maven.perform() [Maven実行]
                  └─ [各Builder実装]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

config.xml ────────────▶ Project.getBuilders()
  (Builder設定)                 │
                               ▼
AbstractBuild ─────────▶ BuildStep.prebuild() ─────────▶ boolean (継続可否)
                               │
                               ▼
Launcher ──────────────▶ BuildStep.perform() ──────────▶ boolean (成功/失敗)
  (プロセス起動)               │                        Action (結果アクション)
                               │
BuildListener ─────────▶      │ ──────────────────────▶ ConsoleLog
  (ログ出力)                   │
                               ▼
                        getProjectActions() ───────────▶ Project画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BuildStep.java | `core/src/main/java/hudson/tasks/BuildStep.java` | ソース | ビルドステップインターフェース |
| Builder.java | `core/src/main/java/hudson/tasks/Builder.java` | ソース | ビルダー基底クラス |
| BuildStepMonitor.java | `core/src/main/java/hudson/tasks/BuildStepMonitor.java` | ソース | 同期制御列挙型 |
| BuildStepCompatibilityLayer.java | `core/src/main/java/hudson/tasks/BuildStepCompatibilityLayer.java` | ソース | 互換性レイヤー |
| Publisher.java | `core/src/main/java/hudson/tasks/Publisher.java` | ソース | ビルド後処理基底クラス |
| Recorder.java | `core/src/main/java/hudson/tasks/Recorder.java` | ソース | 結果変更Publisher |
| Notifier.java | `core/src/main/java/hudson/tasks/Notifier.java` | ソース | 通知Publisher |
| BuildStepDescriptor.java | `core/src/main/java/hudson/tasks/BuildStepDescriptor.java` | ソース | BuildStep用Descriptor |
| Shell.java | `core/src/main/java/hudson/tasks/Shell.java` | ソース | シェル実行Builder実装 |
| Maven.java | `core/src/main/java/hudson/tasks/Maven.java` | ソース | Maven実行Builder実装 |
