# 機能設計書 16-バッチファイル実行

## 概要

本ドキュメントは、Jenkinsにおけるバッチファイル実行（BatchFile）機能の設計について記述する。この機能は、Windows環境でバッチファイル（.bat）を実行するビルドステップを提供する。

### 本機能の処理概要

バッチファイル実行機能は、ビルドステップとしてWindowsバッチコマンドを実行する。ユーザーが入力したスクリプトを一時ファイルとして保存し、cmd.exeで実行する。

**業務上の目的・背景**：Windows環境のCI/CDでは、バッチファイルによるビルド・テスト・デプロイ処理が必要になる。バッチファイル実行機能により、これらの処理をJenkinsジョブに組み込むことができる。

**機能の利用シーン**：
- MSBuildによるVisual Studioプロジェクトのビルド
- PowerShellスクリプトの呼び出し
- Windowsサービスの操作
- ファイル操作、レジストリ操作
- .NETアプリケーションのデプロイ

**主要な処理内容**：
1. CommandInterpreter基底クラスによる共通処理の継承
2. スクリプト内容の改行コード変換（Windows形式CRLF）
3. 一時バッチファイル（.bat）の生成
4. buildCommandLine()でcmd /c call実行コマンド構築
5. 終了コード保持のためのexit %ERRORLEVEL%追加
6. 終了コードに基づくビルド結果判定

**関連システム・外部連携**：Windows cmd.exe、環境変数。

**権限による制御**：Job.CONFIGURE権限でビルドステップの設定変更が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ジョブ設定 | 主画面 | バッチファイルビルドステップの追加・編集 |

## 機能種別

ビルドステップ / プロセス実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| command | String | Yes | 実行するバッチコマンド | - |
| unstableReturn | Integer | No | UNSTABLEとみなす終了コード | Integer範囲内 |
| configuredLocalRules | List | No | 環境変数フィルタルール | - |

### 入力データソース

- ジョブ設定画面からのユーザー入力
- config.xml: ビルドステップ設定の永続化

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 終了コード | int | バッチファイルの終了コード |
| 標準出力 | String | コンソールログへの出力 |
| 標準エラー | String | コンソールログへの出力 |

### 出力先

- BuildListener: コンソールログへの出力
- ビルド結果: SUCCESS/UNSTABLE/FAILUREの判定

## 処理フロー

### 処理シーケンス

```
1. BatchFile.perform()呼び出し（CommandInterpreterから継承）
2. getContents()でスクリプト内容取得
   └─ 改行コードをWindows形式（CRLF）に変換
   └─ "exit %ERRORLEVEL%"を末尾に追加
3. 一時ファイル作成（.bat拡張子）
4. buildCommandLine()で実行コマンド構築
   └─ ["cmd", "/c", "call", script.getRemote()]
5. Launcher.launch()でプロセス起動
6. 終了コード判定
```

### フローチャート

```mermaid
flowchart TD
    A[BatchFile.perform開始] --> B[getContents]
    B --> C[改行コード変換CRLF]
    C --> D[exit %ERRORLEVEL%追加]
    D --> E[一時ファイル作成.bat]
    E --> F[buildCommandLine]
    F --> G[cmd /c call実行]
    G --> H[Launcher.launch]
    H --> I{終了コード?}
    I -->|0| J[SUCCESS]
    I -->|unstableReturn| K[UNSTABLE]
    I -->|その他| L[FAILURE]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-16-01 | 実行コマンド | cmd /c callでバッチファイルを実行 | 常時 |
| BR-16-02 | 終了コード保持 | スクリプト末尾にexit %ERRORLEVEL%を追加 | 常時 |
| BR-16-03 | 改行コード | Windows形式（CRLF）に変換 | 常時 |
| BR-16-04 | ファイル拡張子 | .bat拡張子で一時ファイル作成 | 常時 |
| BR-16-05 | 終了コード範囲 | unstableReturnはInteger範囲で設定可能 | バリデーション時 |

### 計算ロジック

- スクリプト内容: `command + "\r\nexit %ERRORLEVEL%"`
- 改行変換: `LineEndingConversion.convertEOL(..., EOLType.Windows)`

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースではなく、XMLファイルベースの設定永続化を使用。

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ビルドステップ保存 | jobs/{jobName}/config.xml | UPDATE | BatchFileステップ設定の永続化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了コード | プロセスエラー | バッチファイルがエラー終了 | ビルド失敗 |
| IOException | I/Oエラー | 一時ファイル作成失敗 | ビルド失敗 |

### リトライ仕様

リトライはユーザーによる手動再実行のみ。

## トランザクション仕様

特になし。

## パフォーマンス要件

特になし。

## セキュリティ考慮事項

- 環境変数フィルタルールで機密情報の制御が可能

## 備考

- @Symbol("batchFile")でPipeline DSLからはbatchFileとして参照可能
- Shellとの違い: 実行コマンド、改行コード、ファイル拡張子、終了コード処理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BatchFile.java | `core/src/main/java/hudson/tasks/BatchFile.java` | バッチファイル実行ビルドステップ |

#### Step 2: 主要メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | buildCommandLine() | `core/src/main/java/hudson/tasks/BatchFile.java` | 実行コマンド構築（73-75行目） |
| 2-2 | getContents() | `core/src/main/java/hudson/tasks/BatchFile.java` | スクリプト内容取得（78-80行目） |
| 2-3 | getFileExtension() | `core/src/main/java/hudson/tasks/BatchFile.java` | ファイル拡張子（83-85行目） |

**主要処理フロー**:
- **73-75行目**: `["cmd", "/c", "call", script.getRemote()]`
- **78-80行目**: `command + "\r\nexit %ERRORLEVEL%"`をWindows改行に変換
- **83-85行目**: `.bat`拡張子

### プログラム呼び出し階層図

```
AbstractBuild.run()
    │
    └─ BatchFile.perform() [CommandInterpreterから継承]
           │
           ├─ getContents() [BatchFile.java:78-80]
           │
           ├─ createScriptFile() [CommandInterpreter]
           │      │
           │      └─ getFileExtension() → ".bat"
           │
           ├─ buildCommandLine() [BatchFile.java:73-75]
           │      │
           │      └─ ["cmd", "/c", "call", *.bat]
           │
           └─ Launcher.launch()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BatchFile.java | `core/src/main/java/hudson/tasks/BatchFile.java` | ソース | バッチファイル実行ビルドステップ |
| CommandInterpreter.java | `core/src/main/java/hudson/tasks/CommandInterpreter.java` | ソース | コマンド実行基底クラス |
| LineEndingConversion.java | `core/src/main/java/hudson/util/LineEndingConversion.java` | ソース | 改行コード変換ユーティリティ |
