# 機能設計書 18-成果物アーカイブ

## 概要

本ドキュメントは、Jenkinsにおける成果物アーカイブ（ArtifactArchiver）機能の設計について記述する。この機能は、ビルド成果物をJenkinsのアーカイブディレクトリに保存し、後からダウンロード可能にするビルド後処理を提供する。

### 本機能の処理概要

成果物アーカイブ機能は、ビルド後処理（Recorder）としてワークスペース内のファイルをビルド成果物としてアーカイブする。Antスタイルのグロブパターンでファイルを指定し、ビルドごとの成果物ディレクトリにコピーする。

**業務上の目的・背景**：CI/CDパイプラインでは、ビルドで生成されたJARファイル、WARファイル、実行可能ファイル、テストレポートなどを保存し、後続の処理や手動ダウンロードに利用する必要がある。成果物アーカイブ機能により、これらのファイルをビルドに紐づけて永続化できる。

**機能の利用シーン**：
- Mavenビルドで生成されたJAR/WARファイルの保存
- テストレポート（HTML、XML）の保存
- ログファイル、設定ファイルの保存
- デプロイ用パッケージの一時保管
- ビルド間でのファイル受け渡し

**主要な処理内容**：
1. Antスタイルグロブパターンによるファイルマッチング
2. ListFilesでワークスペースからファイル一覧取得
3. ArtifactManagerによるファイルアーカイブ
4. オプションでFingerprinterによるフィンガープリント記録
5. BuildDiscarderとの連携による古いビルド成果物の自動削除

**関連システム・外部連携**：ArtifactManager、Fingerprinter、BuildDiscarder。

**権限による制御**：Job.CONFIGURE権限でビルドステップの設定変更が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ジョブ設定 | 主画面 | 成果物アーカイブ設定の追加・編集 |
| 10 | ビルド詳細 | 結果表示画面 | アーカイブ済み成果物の表示・ダウンロード |

## 機能種別

ビルド後処理 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| artifacts | String | Yes | アーカイブするファイルパターン | 空不可 |
| excludes | String | No | 除外するファイルパターン | - |
| allowEmptyArchive | boolean | No | マッチ0件でも失敗しない | - |
| onlyIfSuccessful | boolean | No | SUCCESS/UNSTABLEの場合のみアーカイブ | - |
| fingerprint | boolean | No | フィンガープリントを記録 | - |
| defaultExcludes | boolean | No | Antデフォルト除外を適用 | デフォルトtrue |
| caseSensitive | boolean | No | 大文字小文字を区別 | デフォルトtrue |
| followSymlinks | boolean | No | シンボリックリンクを追跡 | デフォルトtrue |

### 入力データソース

- ジョブ設定画面からのユーザー入力
- ワークスペースファイルシステム

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アーカイブファイル | Files | $JENKINS_HOME/jobs/{job}/builds/{build}/archive/ 配下 |
| Fingerprint | Fingerprint | fingerprint=true時に生成 |

### 出力先

- ビルドアーカイブディレクトリ
- Fingerprints（オプション）

## 処理フロー

### 処理シーケンス

```
1. ArtifactArchiver.perform()呼び出し
2. onlyIfSuccessfulチェック
   └─ Result.UNSTABLE未満なら処理スキップ
3. 環境変数によるパターン展開
4. ListFiles.invoke()でファイル一覧取得
   └─ FileSetによるAntパターンマッチング
5. ファイルが存在する場合
   └─ ArtifactManager.archive()でアーカイブ
   └─ fingerprint=trueならFingerprinter実行
6. ファイルが存在しない場合
   └─ allowEmptyArchive=trueなら警告のみ
   └─ allowEmptyArchive=falseならAbortException
```

### フローチャート

```mermaid
flowchart TD
    A[perform開始] --> B{artifacts空?}
    B -->|Yes| C[AbortException]
    B -->|No| D{onlyIfSuccessful?}
    D -->|Yes| E{Result >= UNSTABLE?}
    E -->|No| F[スキップ]
    E -->|Yes| G[ListFiles実行]
    D -->|No| G
    G --> H{ファイルあり?}
    H -->|Yes| I[ArtifactManager.archive]
    I --> J{fingerprint?}
    J -->|Yes| K[Fingerprinter実行]
    J -->|No| L[完了]
    K --> L
    H -->|No| M{allowEmptyArchive?}
    M -->|Yes| N[警告出力]
    M -->|No| O[AbortException]
    N --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | 空パターン禁止 | artifacts空文字列はAbortException | 常時 |
| BR-18-02 | 成功時のみ | onlyIfSuccessful=trueでResult.UNSTABLE未満はスキップ | 設定時 |
| BR-18-03 | 空アーカイブ許可 | allowEmptyArchive=falseでマッチ0件はAbortException | 設定時 |
| BR-18-04 | デフォルト除外 | defaultExcludes=trueでAntデフォルト除外パターン適用 | デフォルト |
| BR-18-05 | シンボリックリンク | followSymlinks=trueでシンボリックリンクを追跡 | デフォルト |

### 計算ロジック

- パターンマッチング: Ant FileSetによるグロブパターン
- パス正規化: File.separatorCharを'/'に置換

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースではなく、ファイルシステムとXMLファイルベースの設定永続化を使用。

| 操作 | 対象 | 操作種別 | 概要 |
|-----|-----|---------|------|
| アーカイブ | builds/{build}/archive/ | INSERT | 成果物ファイルの保存 |
| 設定保存 | jobs/{job}/config.xml | UPDATE | ArtifactArchiver設定の永続化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AbortException | artifacts空 | ビルド失敗 |
| - | AbortException | マッチ0件（allowEmptyArchive=false） | ビルド失敗 |
| - | AccessDeniedException | アクセス権限なし | AbortException変換、ビルド失敗 |

### リトライ仕様

リトライはユーザーによる手動再実行のみ。

## トランザクション仕様

- BuildStepMonitor.NONEで排他制御なし

## パフォーマンス要件

特になし。

## セキュリティ考慮事項

- MasterToSlaveFileCallableでセキュアなリモート呼び出し
- AccessDeniedException発生時の適切なエラーハンドリング

## 備考

- @Symbol("archiveArtifacts")でPipeline DSLからはarchiveArtifactsとして参照可能
- SimpleBuildStepを実装しており、Pipeline互換
- MigratorでlatestOnly設定からLogRotatorへの自動移行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArtifactArchiver.java | `core/src/main/java/hudson/tasks/ArtifactArchiver.java` | 成果物アーカイブRecorder |

#### Step 2: perform()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | perform() | `core/src/main/java/hudson/tasks/ArtifactArchiver.java` | メイン処理（237-293行目） |

**主要処理フロー**:
- **238-240行目**: artifacts空チェック
- **242-246行目**: onlyIfSuccessfulチェック
- **255行目**: ListFiles.invoke()でファイル一覧取得
- **257行目**: ArtifactManager.archive()でアーカイブ
- **258-264行目**: fingerprint=trueでFingerprinter実行
- **277-281行目**: allowEmptyArchiveに基づく空アーカイブ処理

#### Step 3: ListFilesを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ListFiles | `core/src/main/java/hudson/tasks/ArtifactArchiver.java` 内部クラス | ファイル一覧取得（295-324行目） |

**主要処理フロー**:
- **313-316行目**: FileSet作成とオプション設定
- **318-321行目**: ディレクトリスキャンとパス変換

### プログラム呼び出し階層図

```
AbstractBuild.run()
    │
    └─ ArtifactArchiver.perform()
           │
           ├─ [onlyIfSuccessfulチェック]
           │
           ├─ ListFiles.invoke()
           │      │
           │      └─ Util.createFileSet() → FileSet
           │             │
           │             └─ DirectoryScanner.getIncludedFiles()
           │
           ├─ ArtifactManager.archive()
           │
           └─ [fingerprint=true]
                  │
                  └─ Fingerprinter.perform()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArtifactArchiver.java | `core/src/main/java/hudson/tasks/ArtifactArchiver.java` | ソース | 成果物アーカイブRecorder |
| Recorder.java | `core/src/main/java/hudson/tasks/Recorder.java` | ソース | 結果変更Publisher基底クラス |
| SimpleBuildStep.java | `core/src/main/java/jenkins/tasks/SimpleBuildStep.java` | ソース | Pipeline互換インターフェース |
| ArtifactManager.java | `core/src/main/java/jenkins/model/ArtifactManager.java` | ソース | アーカイブ管理抽象クラス |
| Fingerprinter.java | `core/src/main/java/hudson/tasks/Fingerprinter.java` | ソース | フィンガープリント記録 |
| LogRotator.java | `core/src/main/java/hudson/tasks/LogRotator.java` | ソース | ビルド破棄設定 |
