# 機能設計書 21-ビルドラッパー

## 概要

本ドキュメントは、Jenkinsのビルドラッパー（BuildWrapper）機能の設計仕様を定義する。ビルドラッパーは、ビルド処理の前後にセットアップ・ティアダウン処理を挿入するための拡張ポイントを提供する。

### 本機能の処理概要

ビルドラッパーは、ビルド実行のライフサイクルに介入し、環境設定やリソースの準備・後片付けを行うための抽象化レイヤーを提供する機能である。

**業務上の目的・背景**：CI/CDパイプラインでは、ビルド実行前に特定の環境設定（Xディスプレイの設定、アプリケーションサーバーの起動、認証情報の注入など）が必要となるケースが多い。また、ビルド完了後にはこれらのリソースの後片付けが必要である。ビルドラッパーは、このようなセットアップ/ティアダウンのパターンをプラグインとして実装可能にする拡張ポイントを提供する。

**機能の利用シーン**：
- Xvfb（仮想フレームバッファ）を使用したGUIテストの実行
- Dockerコンテナ内でのビルド実行
- 環境変数の動的設定
- 機密情報（シークレット）のビルド環境への注入
- ツールのインストールやパス設定

**主要な処理内容**：
1. ビルド開始前の環境セットアップ（`setUp`メソッド）
2. ビルド完了後のティアダウン処理（`tearDown`メソッド）
3. Launcherのデコレーション（sudo/chroot等の実行環境変更）
4. ロガーのデコレーション（パスワードマスキング等）
5. SCMチェックアウト前の前処理（ワークスペースクリーンアップ等）
6. ビルド変数の追加・機密変数の定義

**関連システム・外部連携**：プラグインシステムとの連携が主要。各種プラグイン（Credentials Binding、Xvfb、Docker等）がBuildWrapperを拡張して実装される。

**権限による制御**：BuildWrapperの設定は、ジョブの設定権限を持つユーザーのみが変更可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | ジョブ設定 | 主画面 | BuildWrapperの設定・編集 |

## 機能種別

拡張ポイント / ビルドライフサイクル管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| build | AbstractBuild | Yes | 実行中のビルドオブジェクト | null不可 |
| launcher | Launcher | Yes | プロセス起動用のランチャー | null不可 |
| listener | BuildListener | Yes | ログ出力用リスナー | null不可 |

### 入力データソース

ジョブ設定画面からの設定値。各BuildWrapper実装固有のパラメータはDescriptorを通じて設定される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Environment | BuildWrapper.Environment | セットアップ結果を保持し、tearDownを実行するためのオブジェクト |
| decoratedLauncher | Launcher | デコレートされたランチャー（オプション） |
| decoratedLogger | OutputStream | デコレートされたロガー（オプション） |

### 出力先

ビルド実行環境への環境変数注入、ランチャー修飾、ログ出力修飾として反映。

## 処理フロー

### 処理シーケンス

```
1. ビルド開始
   └─ BuildWrapperのリストを取得
2. decorateLauncher呼び出し（各BuildWrapper）
   └─ Launcherを修飾（sudo/chroot等の適用）
3. decorateLogger呼び出し（各BuildWrapper）
   └─ ログ出力をフィルタリング（パスワードマスク等）
4. preCheckout呼び出し（各BuildWrapper）
   └─ SCMチェックアウト前の前処理
5. SCMチェックアウト実行
6. setUp呼び出し（各BuildWrapper）
   └─ 環境をセットアップしEnvironmentオブジェクトを返却
7. ビルドステップ実行
8. tearDown呼び出し（各Environment、逆順）
   └─ リソースのクリーンアップ
9. ビルド完了
```

### フローチャート

```mermaid
flowchart TD
    A[ビルド開始] --> B[BuildWrapper.decorateLauncher]
    B --> C[BuildWrapper.decorateLogger]
    C --> D[BuildWrapper.preCheckout]
    D --> E[SCMチェックアウト]
    E --> F[BuildWrapper.setUp]
    F --> G{setUp成功?}
    G -->|Yes| H[ビルドステップ実行]
    G -->|No| I[ビルド中止]
    H --> J[Environment.tearDown]
    I --> J
    J --> K[ビルド完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | セットアップ失敗時の中止 | setUpがnullを返した場合、ビルドは中止される | setUp実行時 |
| BR-002 | ティアダウンの保証 | tearDownはビルド失敗時も必ず呼び出される | ビルド終了時 |
| BR-003 | 逆順ティアダウン | 複数BuildWrapperのtearDownは登録の逆順で実行 | ティアダウン時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | config.xml | INSERT/UPDATE | ジョブ設定としてXMLに永続化 |

### テーブル別操作詳細

#### config.xml（ジョブ設定ファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | buildWrappers | BuildWrapperの設定値リスト | XMLシリアライズ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IOException | セットアップ中のI/Oエラー | ビルド中止、ログ出力 |
| - | InterruptedException | ユーザーによる中断 | ビルド中止、例外伝播 |
| - | RunnerAbortedException | 致命的エラー検出時 | スタックトレース抑制、ビルド中止 |

### リトライ仕様

BuildWrapper自体にリトライ機能はない。各プラグイン実装に委ねられる。

## トランザクション仕様

ビルド実行はトランザクション管理されない。各BuildWrapperのsetUp/tearDownは独立して実行される。

## パフォーマンス要件

- setUpは10秒以内に完了することが推奨される
- decorateLauncher/decorateLoggerは同期処理のため、高速な処理が求められる

## セキュリティ考慮事項

- `makeSensitiveBuildVariables`で機密変数を登録することで、ログマスキングが可能
- Launcherデコレーションで権限昇格（sudo等）する場合は、セキュリティ上の影響を考慮
- ジョブ設定権限を持つユーザーのみがBuildWrapperを設定可能

## 備考

- BuildWrapperはDescribableインターフェースを実装し、ジョブ設定画面でのUI表示をサポート
- ExtensionPointとして実装されており、プラグインによる拡張が可能
- ユーザーの同意（チェックボックス）が必要な設計となっている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BuildWrapperの基本構造とEnvironmentクラスの関係を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BuildWrapper.java | `core/src/main/java/hudson/tasks/BuildWrapper.java` | 抽象クラスの構造、Environmentネストクラスの役割 |

**読解のコツ**: BuildWrapperはabstractクラスであり、内部にEnvironmentというabstractネストクラスを持つ。Environmentはビルドセットアップの結果を保持し、tearDownの責務を持つ。

#### Step 2: エントリーポイントを理解する

ビルド実行時にBuildWrapperがどのように呼び出されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BuildWrapper.java | `core/src/main/java/hudson/tasks/BuildWrapper.java` | setUp、decorateLauncher、decorateLoggerの呼び出しタイミング |

**主要処理フロー**:
1. **152-159行目**: `setUp(AbstractBuild, Launcher, BuildListener)` - メインのセットアップメソッド。Environmentオブジェクトを返却
2. **209-211行目**: `decorateLauncher` - Launcherをデコレートするフック（デフォルトはno-op）
3. **236-238行目**: `decorateLogger` - ロガーをデコレートするフック（デフォルトはno-op）
4. **263-264行目**: `preCheckout` - SCMチェックアウト前のフック（デフォルトはno-op）

#### Step 3: 環境クリーンアップを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BuildWrapper.java | `core/src/main/java/hudson/tasks/BuildWrapper.java` | Environmentクラスのteardownメソッド |

**主要処理フロー**:
- **113-118行目**: `Environment.tearDown` - ビルド完了後のクリーンアップ。ビルド失敗時も呼び出される

#### Step 4: 拡張機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | BuildWrapper.java | `core/src/main/java/hudson/tasks/BuildWrapper.java` | makeBuildVariables、makeSensitiveBuildVariables、getProjectActions |

**主要処理フロー**:
- **310-312行目**: `makeBuildVariables` - ビルド変数の追加
- **326-328行目**: `makeSensitiveBuildVariables` - 機密変数の定義
- **291-296行目**: `getProjectActions` - ジョブページに表示するアクション

### プログラム呼び出し階層図

```
AbstractBuild.run()
    │
    ├─ BuildWrapper.decorateLauncher()
    │      └─ Launcherの修飾（環境変更、sudo等）
    │
    ├─ BuildWrapper.decorateLogger()
    │      └─ ログ出力のフィルタリング
    │
    ├─ BuildWrapper.preCheckout()
    │      └─ ワークスペース前処理
    │
    ├─ SCM.checkout()
    │
    ├─ BuildWrapper.setUp()
    │      └─ Environment オブジェクトを生成
    │
    ├─ Builder.perform() [各ビルドステップ]
    │
    └─ Environment.tearDown()
           └─ リソースクリーンアップ
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ジョブ設定           BuildWrapper                    ビルド環境
(config.xml) ───▶   ├─ decorateLauncher ───▶      修飾されたLauncher
                    ├─ decorateLogger ───▶        フィルタ付きLogger
                    ├─ setUp ───▶                 Environmentオブジェクト
                    └─ makeBuildVariables ───▶    環境変数
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BuildWrapper.java | `core/src/main/java/hudson/tasks/BuildWrapper.java` | ソース | ビルドラッパーの抽象基底クラス |
| Environment.java | `core/src/main/java/hudson/model/Environment.java` | ソース | 環境設定の基底クラス |
| Launcher.java | `core/src/main/java/hudson/Launcher.java` | ソース | プロセス起動用ランチャー |
| BuildListener.java | `core/src/main/java/hudson/model/BuildListener.java` | ソース | ビルドリスナーインターフェース |
| AbstractBuild.java | `core/src/main/java/hudson/model/AbstractBuild.java` | ソース | ビルド実行の基底クラス |
| ConsoleLogFilter.java | `core/src/main/java/hudson/console/ConsoleLogFilter.java` | ソース | コンソールログフィルタ |
