# 機能設計書 3-アップデートセンター

## 概要

本ドキュメントは、Jenkinsの更新管理機能であるアップデートセンター（hudson.model.UpdateCenter）の機能設計を記述する。Jenkinsおよびプラグインの更新情報を取得・適用し、システムを最新の状態に保つための中核機能である。

### 本機能の処理概要

アップデートセンターは、外部の更新サイト（UpdateSite）から最新のプラグイン情報を取得し、プラグインのダウンロード・インストールを制御する。

**業務上の目的・背景**：Jenkinsとプラグインを最新バージョンに保つことは、セキュリティ脆弱性の修正、新機能の利用、バグ修正のために不可欠である。アップデートセンターは、このプロセスを自動化・簡素化することで、管理者の運用負荷を軽減する。

**機能の利用シーン**：プラグインの新規インストール時、既存プラグインの更新確認時、セキュリティアドバイザリへの対応時、Jenkins本体のアップグレード時。

**主要な処理内容**：
1. UpdateSiteからのメタデータ（update-center.json）取得
2. 利用可能なプラグインと更新情報の管理
3. プラグインダウンロードジョブの管理とキュー制御
4. ダウンロード進捗のトラッキング
5. ダウンロード完了後の配置とインストール処理
6. 再起動要否の判定と通知

**関連システム・外部連携**：公式UpdateSite（updates.jenkins.io）、HTTPプロキシ（ProxyConfiguration）、ファイルシステム。

**権限による制御**：ADMINISTER権限を持つユーザーのみがプラグインのインストール・更新操作を実行可能。更新情報の参照は一般ユーザーでも可能な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | プラグイン管理トップ | 参照画面 | 更新情報の表示 |
| 39 | 利用可能なプラグイン | 主画面 | プラグイン情報の取得 |
| 40 | 更新可能なプラグイン | 主画面 | 更新情報の取得 |
| 42 | 更新センター | 主画面 | プラグインダウンロード・インストール状況の表示 |

## 機能種別

管理機能 / 更新管理 / ダウンロード制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| site | UpdateSite | Yes | 更新サイト情報 | 有効なURL |
| plugin | String | Yes | プラグイン名（インストール時） | 有効なプラグインID |
| version | String | No | 指定バージョン | バージョン文字列 |
| dynamicLoad | boolean | No | 動的ロード試行フラグ | true/false |

### 入力データソース

- update-center.json: 更新サイトからダウンロードされるメタデータ
- $JENKINS_HOME/updates/: ローカルキャッシュされた更新情報
- Web画面: プラグイン管理画面からの操作
- REST API: updateCenter/api経由のリクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| jobs | Vector<UpdateCenterJob> | 実行中・完了済みのジョブ一覧 |
| sites | PersistedList<UpdateSite> | 登録済み更新サイト |
| requiresRestart | boolean | 再起動が必要かどうか |
| connectionStatus | ConnectionStatus | 接続状態 |

### 出力先

- plugins ディレクトリ: ダウンロードしたプラグイン
- Webインターフェース: 進捗・結果表示
- REST API: ジョブ状態のJSON

## 処理フロー

### 処理シーケンス

```
1. 更新サイト情報の取得
   ├─ UpdateSite.updateDirectly() または updateDirectlyNow()
   ├─ update-center.json のダウンロード
   └─ JSON解析とData オブジェクト生成
2. プラグインインストール要求
   ├─ InstallationJob 生成
   ├─ installerService キューに追加
   └─ 実行開始
3. ダウンロード実行
   ├─ URLからファイル取得
   ├─ ハッシュ検証
   └─ 一時ファイルに保存
4. インストール実行
   ├─ plugins ディレクトリに配置
   ├─ 依存プラグインの自動インストール
   └─ 動的ロード試行または再起動フラグ設定
```

### フローチャート

```mermaid
flowchart TD
    A[更新確認開始] --> B[UpdateSite.getData呼び出し]
    B --> C{キャッシュ有効?}
    C -->|Yes| D[キャッシュからData取得]
    C -->|No| E[update-center.json ダウンロード]
    E --> F[JSON解析]
    F --> G[利用可能プラグイン一覧生成]
    D --> G
    G --> H[更新可能プラグイン抽出]
    H --> I[UI表示]

    J[インストール要求] --> K[InstallationJob生成]
    K --> L[依存関係解決]
    L --> M[installerService実行]
    M --> N[ダウンロード]
    N --> O{成功?}
    O -->|Yes| P[plugins配置]
    O -->|No| Q[エラー記録]
    P --> R{動的ロード可能?}
    R -->|Yes| S[動的ロード]
    R -->|No| T[再起動フラグ設定]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 単一スレッド実行 | インストールは一度に1つずつ実行 | インストール時 |
| BR-002 | 依存自動解決 | 依存プラグインを自動的にインストール | インストール時 |
| BR-003 | ハッシュ検証 | ダウンロードファイルのSHA-256検証 | ダウンロード後 |
| BR-004 | 署名検証 | プラグインの署名を検証（設定による） | インストール前 |
| BR-005 | キャッシュ制御 | 一定期間メタデータをキャッシュ | メタデータ取得時 |

### 計算ロジック

- バージョン比較: VersionNumber.isNewerThan()で更新判定
- 依存関係解決: UpdateSite.Plugin.getNeededDependencies()

## データベース操作仕様

ファイルベースの永続化を使用。

### ファイル操作一覧

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キャッシュ保存 | updates/*.json | 書き込み | メタデータのローカルキャッシュ |
| ダウンロード | plugins/*.jpi.tmp | 書き込み | 一時ダウンロードファイル |
| 配置 | plugins/*.jpi | リネーム | インストール完了 |
| 設定保存 | hudson.model.UpdateCenter.xml | 書き込み | 更新サイト設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | UnknownHostException | 更新サイトに接続不可 | ネットワーク設定確認 |
| - | SSLHandshakeException | SSL証明書エラー | 証明書確認、プロキシ設定 |
| - | IOException | ダウンロード失敗 | リトライ、ネットワーク確認 |
| - | VerificationException | ハッシュ不一致 | 再ダウンロード |

### リトライ仕様

ダウンロード失敗時の自動リトライは行わず、ユーザーに再実行を促す。メタデータ取得は設定可能なリトライ回数に従う。

## トランザクション仕様

ダウンロードは一時ファイル（.tmp）に書き込み、完了後にリネームすることでアトミック性を確保。

## パフォーマンス要件

- メタデータ取得: 数秒（ネットワーク依存）
- プラグインダウンロード: サイズとネットワーク速度に依存
- 読み取りタイムアウト: 60秒（PLUGIN_DOWNLOAD_READ_TIMEOUT）

## セキュリティ考慮事項

- HTTPS通信: 更新サイトへの接続は原則HTTPS
- ハッシュ検証: ダウンロードファイルの整合性確認
- 署名検証: プラグインの署名を検証可能
- 権限チェック: ADMINISTER権限必須

## 備考

- デフォルト更新サイトID: "default"（ID_DEFAULT定数）
- 更新サイトURL: https://updates.jenkins.io/（システムプロパティで変更可能）
- 接続状態の確認機能あり（ConnectionStatus enum）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

UpdateCenterとUpdateSiteの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | jobsフィールド（202行目）、sitesフィールド（213行目）を確認 |
| 1-2 | UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | Dataクラス、Pluginクラスの構造 |

**読解のコツ**: UpdateCenterは「更新処理の制御」、UpdateSiteは「更新情報の保持」という役割分担を意識する。

#### Step 2: エントリーポイントを理解する

更新センターの生成と初期化を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | createUpdateCenter()（287-300行目）でカスタム実装対応を確認 |

**主要処理フロー**:
1. **273-275行目**: デフォルトコンストラクタでUpdateCenterConfiguration設定
2. **287-300行目**: カスタムクラス指定時の処理分岐
3. **190-197行目**: installerServiceとupdateServiceの初期化

#### Step 3: ジョブ管理を理解する

インストールジョブのライフサイクルを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | UpdateCenterJob内部クラス、InstallationJob内部クラス |

#### Step 4: 接続状態管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ConnectionStatus enum（240-271行目）の各状態の意味 |

### プログラム呼び出し階層図

```
UpdateCenter
    │
    ├─ sites (PersistedList<UpdateSite>)
    │      └─ UpdateSite.getData()
    │             └─ Data (プラグイン情報)
    │                    └─ Plugin (個別プラグイン情報)
    │
    ├─ jobs (Vector<UpdateCenterJob>)
    │      ├─ InstallationJob
    │      │      └─ ダウンロード・配置処理
    │      ├─ DownloadJob
    │      └─ RestartJob
    │
    └─ installerService (ExecutorService)
           └─ 単一スレッドでジョブ実行
```

### データフロー図

```
[入力]                      [処理]                           [出力]

update-center.json ───────▶ JSON解析 ──────────────────▶ UpdateSite.Data
                                │
                                ▼
インストール要求 ─────────▶ InstallationJob生成 ─────▶ キュー追加
                                │
                                ▼
ダウンロードURL ──────────▶ HTTPダウンロード ─────────▶ .jpi.tmp
                                │
                                ▼
.jpi.tmp ─────────────────▶ ハッシュ検証・リネーム ───▶ plugins/*.jpi
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | 更新センターコアクラス |
| UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | ソース | 更新サイト情報管理 |
| DownloadService.java | `core/src/main/java/hudson/model/DownloadService.java` | ソース | ダウンロードサービス |
| ProxyConfiguration.java | `core/src/main/java/hudson/ProxyConfiguration.java` | ソース | プロキシ設定 |
| index.jelly | `core/src/main/resources/hudson/model/UpdateCenter/index.jelly` | テンプレート | 更新センター画面 |
