# 機能設計書 38-ダッシュボード

## 概要

本ドキュメントは、Jenkinsにおけるダッシュボード（AllView）機能の設計を記載したものである。AllViewは全てのジョブを表示するビューであり、Jenkinsのメインページとして機能する。

### 本機能の処理概要

本機能は、ViewGroupに含まれる全てのジョブを表示する特殊なビューを提供する。デフォルトのプライマリビューとして設定されることが多い。

**業務上の目的・背景**：Jenkinsのトップページでは、全てのジョブを概観できることが重要である。AllViewは設定なしで全ジョブを表示するシンプルなビューであり、Jenkins導入直後から利用可能。名前が「all」の場合はローカライズされた表示名が使用され、多言語対応が可能。

**機能の利用シーン**：
- Jenkinsのデフォルトトップページとして全ジョブを表示
- プライマリビューとして設定し、基準となるビューを提供
- 新規ジョブ作成のベース画面として使用
- 全体のジョブ状況を一覧で把握

**主要な処理内容**：
1. 全ジョブの一覧取得（フィルタリングなし）
2. ローカライズされた表示名の提供
3. 新規ジョブ作成機能の提供
4. 編集不可（isEditable() = false）の維持

**関連システム・外部連携**：Viewの基底クラスを継承。ViewGroupに1つのみ存在可能。JENKINS-38606対策として旧バージョンからの名前マイグレーションをサポート。

**権限による制御**：特別な権限制御なし。ジョブの表示は各ジョブのACLに従う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ダッシュボード | 主画面 | 全ジョブの表示、ナビゲーション |
| 21 | 新しいビューの作成 | 作成画面 | AllViewの新規作成 |

## 機能種別

UI管理 / メインページ / 全ジョブ表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | ビュー名 | Jenkins.checkGoodName() |

### 入力データソース

- ViewGroup: 親コンテナから全ジョブを取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| items | Collection<TopLevelItem> | 全ジョブ一覧 |
| displayName | String | ローカライズされた表示名または指定名 |

### 出力先

- HTMLレスポンス: ジョブ一覧テーブル
- JSON/XML: REST APIレスポンス

## 処理フロー

### 処理シーケンス

```
1. getItems()呼び出し
   └─ ビューに含まれるジョブの取得要求
2. 全ジョブ取得
   └─ getOwner().getItemGroup().getItems()で全ジョブを返却
3. 結果返却
   └─ フィルタリングなしで全ジョブを返却
```

### フローチャート

```mermaid
flowchart TD
    A[getItems呼出] --> B[ItemGroup.getItems取得]
    B --> C[全ジョブを返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-01 | ViewGroup制限 | 各ViewGroupにAllViewは1つのみ | isApplicableIn() |
| BR-38-02 | 編集不可 | isEditable()はfalse固定 | 常時 |
| BR-38-03 | 全包含 | contains()は常にtrue | 常時 |
| BR-38-04 | ローカライズ名 | name="all"の場合は多言語表示名を使用 | getDisplayName() |
| BR-38-05 | JENKINS-38606対策 | 旧ローカライズ名から"all"への自動マイグレーション | migrateLegacyPrimaryAllViewLocalizedName() |

### 計算ロジック

表示名判定: `DEFAULT_VIEW_NAME.equals(name) ? Messages.Hudson_ViewName() : name`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| ビュー作成 | config.xml | UPDATE | ViewGroup設定にAllViewを追加 |
| 名前マイグレーション | config.xml | UPDATE | name="all"に変更、primaryView更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | AllViewは単純な構造のため特別なエラーは少ない | - |

### リトライ仕様

getItems()はステートレスな読み取り操作であり、リトライは安全。

## トランザクション仕様

AllViewは設定を持たないため、トランザクション管理は不要。

## パフォーマンス要件

- getItems()は直接getOwner().getItemGroup().getItems()を呼び出すため高速
- フィルタリングがないため、大規模環境でも効率的

## セキュリティ考慮事項

- 各ジョブの表示はジョブ固有のACLに従う
- AllView自体には特別なセキュリティ制限はない

## 備考

- @Symbol("all")により、JenkinsfileからallViewとして参照可能
- DEFAULT_VIEW_NAME = "all"がローカライズ判定の基準
- JENKINS-38606: 旧バージョンでローカライズされた名前で保存されたAllViewを修正
- システムプロパティhudson.model.AllView.JENKINS-38606=falseで移行を無効化可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: AllViewの構造を理解する

全ジョブ表示ビューのシンプルな構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AllView.java | `core/src/main/java/hudson/model/AllView.java` | クラス全体 |

**主要処理フロー**:
- **54行目**: AllViewクラス定義（View継承）
- **63行目**: DEFAULT_VIEW_NAME = "all"定義
- **70-73行目**: コンストラクタ（@DataBoundConstructor）
- **81-83行目**: isEditable() - 常にfalse
- **86-88行目**: contains() - 常にtrue
- **91-93行目**: getDisplayName() - ローカライズ判定
- **97-103行目**: doCreateItem() - ジョブ作成（ViewGroupに委譲）
- **106-108行目**: getItems() - 全ジョブを返却
- **111-113行目**: getPostConstructLandingPage() - 空文字

**読解のコツ**: AllViewはcontains()がtrue固定、getItems()がフィルタなしという極めてシンプルな実装。isEditable()がfalseなので設定画面は表示されない。

#### Step 2: JENKINS-38606対策を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AllView.java | `core/src/main/java/hudson/model/AllView.java` | migrateLegacyPrimaryAllViewLocalizedName()静的メソッド |

**主要処理フロー**:
- **156-193行目**: migrateLegacyPrimaryAllViewLocalizedName() - 旧名からの移行
- **158-161行目**: "all"の場合は移行不要
- **162行目**: システムプロパティで移行無効化可能
- **180-189行目**: ロケール別にMessages._Hudson_ViewName()と比較して移行

#### Step 3: Descriptorを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AllView.java | `core/src/main/java/hudson/model/AllView.java` | DescriptorImpl内部クラス |

**主要処理フロー**:
- **195-212行目**: DescriptorImpl
- **197-205行目**: isApplicableIn() - 既存AllViewがある場合はfalse
- **209-211行目**: getDisplayName() - Messages.Hudson_ViewName()を返却

### プログラム呼び出し階層図

```
AllView.getItems()
    │
    └─ getOwner().getItemGroup().getItems()
           │
           └─ ItemGroup.getItems() [全ジョブ取得]
                  │
                  └─ Collection<TopLevelItem>
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ViewGroup ─────────────▶ AllView.getItems() ─────────────▶ Collection<TopLevelItem>
      │                        │
      └─ ItemGroup ───────────▶│
                               ▼
                        getItems()呼出
                               │
                               ▼
                        全ジョブ返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AllView.java | `core/src/main/java/hudson/model/AllView.java` | ソース | AllView実装 |
| View.java | `core/src/main/java/hudson/model/View.java` | ソース | ビューの基底クラス |
| ViewGroup.java | `core/src/main/java/hudson/model/ViewGroup.java` | ソース | ビューのコンテナインターフェース |
| view/main.jelly | `core/src/main/resources/hudson/model/AllView/main.jelly` | ビュー | メイン表示画面 |
| view/newViewDetail.jelly | `core/src/main/resources/hudson/model/AllView/newViewDetail.jelly` | ビュー | 新規作成時の説明 |
| Messages.properties | `core/src/main/resources/hudson/model/Messages.properties` | リソース | ローカライズ文字列 |
