# 機能設計書 40-ビルドコマンド

## 概要

本ドキュメントは、JenkinsにおけるBuildCommand（ビルドコマンド）機能の設計を記載したものである。ビルドコマンドは、CLIからジョブを実行するためのコマンドを提供する。

### 本機能の処理概要

本機能は、コマンドラインからJenkinsジョブのビルドを開始し、オプションで完了を待機したりコンソール出力を表示したりする機能を提供する。

**業務上の目的・背景**：CI/CDパイプラインでは、外部スクリプトや他のジョブからJenkinsジョブを起動する需要が高い。ビルドコマンドにより、コマンドラインから簡単にジョブを実行でき、パラメータの指定、SCM変更チェック、完了待機など豊富なオプションが利用できる。これにより、自動化スクリプトの柔軟性が向上する。

**機能の利用シーン**：
- スクリプトからのジョブ自動実行
- 別のJenkinsジョブからのジョブ起動
- パラメータ付きビルドの実行
- SCM変更がある場合のみビルド実行
- ビルド完了までの待機とコンソール出力の表示

**主要な処理内容**：
1. ジョブの指定と権限チェック（Item.BUILD）
2. パラメータの解析と検証
3. SCM変更チェック（オプション）
4. ビルドのスケジューリング
5. 完了待機とコンソール出力表示（オプション）

**関連システム・外部連携**：CLICommand基盤を継承。ParametersDefinitionPropertyでパラメータを取得。SCMTriggerItemでSCMポーリングを実行。

**権限による制御**：Item.BUILD権限が必要。ジョブが無効または未保存の場合はビルド不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （画面なし） | - | CLIコマンドのため画面なし |

## 機能種別

CLI機能 / ビルド実行 / ジョブ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| JOB | Job<?,?> | Yes | ビルド対象のジョブ名 | 存在するジョブ |
| -f | boolean | No | ビルド進捗をフォロー（中断は渡さない） | - |
| -s | boolean | No | ビルド完了まで待機（中断をビルドに渡す） | - |
| -w | boolean | No | ビルド開始まで待機 | - |
| -c | boolean | No | SCM変更がある場合のみビルド | - |
| -p | Map<String,String> | No | パラメータ（key=value形式） | パラメータ定義と一致 |
| -v | boolean | No | コンソール出力を表示（-sと併用） | - |

### 入力データソース

- CLIクライアント（jenkins-cli.jar）からの引数
- ジョブのParametersDefinitionProperty

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| exitCode | int | ビルド結果に基づく終了コード |
| stdout | PrintStream | ビルド開始・完了メッセージ、コンソール出力 |

### 終了コード詳細

| コード | 意味 |
|-------|------|
| 0 | ビルド成功（SUCCESS） |
| 0 | -cでSCM変更なし（ビルドスキップ） |
| Result.ordinal | ビルド結果に応じた値（UNSTABLE=1, FAILURE=2等） |
| 125 | -fで中断された場合 |

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ job.checkPermission(Item.BUILD)
2. パラメータ処理
   └─ -pオプションからParametersActionを生成
3. SCMチェック（-cオプション時）
   └─ SCMTriggerItem.poll()でSCM変更を確認
4. ビルド可能性チェック
   └─ job.isBuildable()で無効・未保存をチェック
5. ビルドスケジューリング
   └─ ParameterizedJobMixIn.scheduleBuild2()
6. 待機処理（-w, -s, -fオプション時）
   └─ QueueTaskFuture.waitForStart()またはget()
7. コンソール出力（-vオプション時）
   └─ Run.writeWholeLogTo(stdout)
8. 終了コード返却
   └─ Result.ordinalを返却
```

### フローチャート

```mermaid
flowchart TD
    A[run開始] --> B[Item.BUILDチェック]
    B --> C{パラメータあり?}
    C -->|Yes| D[ParametersAction生成]
    C -->|No| E{-cオプション?}
    D --> E
    E -->|Yes| F[SCMポーリング]
    F --> G{変更あり?}
    G -->|No| H[終了コード0で返却]
    G -->|Yes| I{ビルド可能?}
    E -->|No| I
    I -->|No| J[IllegalStateException]
    I -->|Yes| K[scheduleBuild2]
    K --> L{-w/-s/-f?}
    L -->|Yes| M[waitForStart]
    L -->|No| N[終了コード0で返却]
    M --> O{-s/-f?}
    O -->|Yes| P{-v?}
    P -->|Yes| Q[コンソール出力]
    Q --> R[get待機]
    P -->|No| R
    R --> S[Result.ordinal返却]
    O -->|No| T[終了コード0で返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | 権限必須 | Item.BUILD権限が必要 | 常時 |
| BR-40-02 | パラメータ検証 | 未定義パラメータはエラー、類似名をサジェスト | -pオプション時 |
| BR-40-03 | デフォルト値 | 未指定パラメータはデフォルト値を使用 | パラメータ化ジョブ |
| BR-40-04 | ビルド不可判定 | 無効または未保存のジョブはビルド不可 | 常時 |
| BR-40-05 | 中断伝播 | -sで中断するとビルドもキャンセル、-fは中断しない | -s/-fオプション時 |

### 計算ロジック

終了コード計算: `build.getResult().ordinal`
- SUCCESS = 0
- UNSTABLE = 1
- FAILURE = 2
- NOT_BUILT = 3
- ABORTED = 4

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| ビルド追加 | キュー | INSERT | ビルドリクエストをキューに追加 |
| ビルド結果 | ビルドXML | INSERT | ビルド完了時に結果を保存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 2 | CmdLineException | 未定義パラメータ | パラメータ名を確認 |
| 4 | IllegalStateException | ビルド不可（無効/未保存） | ジョブを有効化/保存 |
| 4 | IllegalStateException | スケジューリング拒否 | 拡張機能を確認 |
| 5 | AbortException | SCMなしで-cオプション | -cオプションを外す |
| 5 | AbortException | コンソール出力読込失敗 | リトライ |
| 5 | AbortException | 中断 | 再実行 |

### リトライ仕様

コンソール出力の読込は最大retryCnt回（デフォルト10回）リトライ。ログファイル生成の遅延に対応。

## トランザクション仕様

ビルドのスケジューリングはキューへの追加のみ。実際のビルド実行はエグゼキュータが非同期で処理。

## パフォーマンス要件

- スケジューリングは即座に完了
- -s/-fオプション時はビルド完了まで待機するため、ビルド時間に依存
- -vオプション時はログをストリーミング

## セキュリティ考慮事項

- Item.BUILD権限で保護
- ビルドの原因（CLICause）にユーザー名を記録
- パラメータ値はログに出力される可能性があるため機密情報に注意

## 備考

- @Extensionでコマンドとして登録
- CLICauseはUserIdCauseを継承し、CLI経由のビルド開始を記録
- SCMDecisionHandlerでポーリング拒否が可能
- retryCntは@Deprecatedだが後方互換性のため残存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: BuildCommandの構造を理解する

ビルドコマンドのフィールドとオプション定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BuildCommand.java | `core/src/main/java/hudson/cli/BuildCommand.java` | クラス全体 |

**主要処理フロー**:
- **68行目**: BuildCommandクラス定義（CLICommand継承）
- **74-75行目**: job引数（@Argument、必須）
- **77-78行目**: -fオプション（follow）
- **80-81行目**: -sオプション（sync）
- **83-84行目**: -wオプション（wait）
- **86-87行目**: -cオプション（checkSCM）
- **89-90行目**: -pオプション（parameters）
- **92-93行目**: -vオプション（consoleOutput）

**読解のコツ**: args4jの@Argument/@Optionアノテーションでコマンドライン引数を定義。Jobの解決はargs4jのOptionHandlerで自動的に行われる。

#### Step 2: run()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BuildCommand.java | `core/src/main/java/hudson/cli/BuildCommand.java` | run()メソッド |

**主要処理フロー**:
- **101-102行目**: Item.BUILD権限チェック
- **104-143行目**: パラメータ処理とParametersAction生成
- **145-155行目**: SCMチェック（-cオプション）
- **157-165行目**: ビルド可能性チェック
- **167-168行目**: scheduleBuild2でビルドスケジューリング
- **170-176行目**: 開始待機（-w/-s/-f）
- **178-216行目**: 完了待機とコンソール出力（-s/-f）

#### Step 3: CLICauseを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BuildCommand.java | `core/src/main/java/hudson/cli/BuildCommand.java` | CLICause内部クラス |

**主要処理フロー**:
- **240-284行目**: CLICause内部クラス（UserIdCause継承）
- **248-249行目**: コンストラクタでstartedByを設定
- **252-257行目**: getShortDescription() - 開始ユーザー表示
- **259-263行目**: print() - ハイパーリンク付き出力

### プログラム呼び出し階層図

```
jenkins-cli.jar build <JOB> [-f] [-s] [-w] [-c] [-p key=value] [-v]
    │
    └─ BuildCommand.run()
           │
           ├─ job.checkPermission(Item.BUILD)
           │
           ├─ [パラメータ処理]
           │      ├─ ParametersDefinitionProperty取得
           │      ├─ 各パラメータのParameterValue生成
           │      └─ デフォルト値補完
           │
           ├─ [-cオプション]
           │      └─ SCMTriggerItem.poll()
           │             └─ SCMDecisionHandler.firstShouldPollVeto()
           │
           ├─ job.isBuildable()チェック
           │
           ├─ ParameterizedJobMixIn.scheduleBuild2()
           │      └─ CLICause追加
           │
           └─ [-w/-s/-f]
                  ├─ QueueTaskFuture.waitForStart()
                  │
                  └─ [-s/-f]
                         ├─ [-v] Run.writeWholeLogTo(stdout)
                         │
                         └─ QueueTaskFuture.get()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

JOB ───────────────────▶ BuildCommand.run() ──────────────▶ exitCode
-f/-s/-w/-c/-p/-v ─────▶        │                         stdout
                               │
            ┌──────────────────┴──────────────────┐
            ▼                                     ▼
     パラメータ処理                         SCMチェック
            │                                     │
            ▼                                     ▼
     ParametersAction                    変更有無判定
            │                                     │
            └────────────────┬────────────────────┘
                             ▼
                    scheduleBuild2()
                             │
                             ▼
                    QueueTaskFuture
                             │
               ┌─────────────┴─────────────┐
               ▼                           ▼
        waitForStart()              [-s/-f] get()
               │                           │
               ▼                           ▼
        "Started..."                Result.ordinal
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BuildCommand.java | `core/src/main/java/hudson/cli/BuildCommand.java` | ソース | ビルドコマンド実装 |
| CLICommand.java | `core/src/main/java/hudson/cli/CLICommand.java` | ソース | CLIコマンド基底クラス |
| ParameterizedJobMixIn.java | `core/src/main/java/jenkins/model/ParameterizedJobMixIn.java` | ソース | パラメータ化ジョブ支援 |
| ParametersDefinitionProperty.java | `core/src/main/java/hudson/model/ParametersDefinitionProperty.java` | ソース | パラメータ定義 |
| SCMTriggerItem.java | `core/src/main/java/jenkins/triggers/SCMTriggerItem.java` | ソース | SCMポーリング |
| SCMDecisionHandler.java | `core/src/main/java/jenkins/scm/SCMDecisionHandler.java` | ソース | ポーリング判定 |
| CauseAction.java | `core/src/main/java/hudson/model/CauseAction.java` | ソース | ビルド原因 |
| Messages.properties | `core/src/main/resources/hudson/cli/Messages.properties` | リソース | メッセージ定義 |
