# 機能設計書 46-管理画面

## 概要

本ドキュメントは、JenkinsのManage Jenkins（Jenkinsの管理）画面機能の設計を記載する。

### 本機能の処理概要

管理画面は、Jenkinsのシステム管理機能へのエントリーポイントを提供する画面である。ManagementLink拡張ポイントにより、コアおよびプラグインが提供する管理機能へのリンクをカテゴリ別に表示する。

**業務上の目的・背景**：Jenkinsの管理機能は多岐にわたるため、それらを一覧できる集約画面が必要である。管理者は管理画面から各種設定、システム情報、トラブルシューティングツールにアクセスできる。

**機能の利用シーン**：
- 日常的なJenkins管理作業の起点
- プラグイン管理、セキュリティ設定、ノード管理への遷移
- システム状態の確認
- 管理モニターの警告確認

**主要な処理内容**：
1. ManagementLink拡張の一覧表示
2. カテゴリ（CONFIGURATION, SECURITY, STATUS, TROUBLESHOOTING, TOOLS, MISC）別のグループ化
3. 各リンクへの権限チェック
4. バッジ表示（警告数等）

**関連システム・外部連携**：全てのManagementLink拡張を統合して表示。

**権限による制御**：各ManagementLinkはgetRequiredPermission()で必要な権限を定義。管理画面自体にはJenkins.MANAGEまたはJenkins.SYSTEM_READ権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | Jenkinsの管理 | 主画面 | 管理機能への遷移リンク一覧表示 |

## 機能種別

ナビゲーション / ダッシュボード

## 入力仕様

### 入力パラメータ

管理画面自体は入力パラメータを持たないナビゲーション画面である。

### 入力データソース

- ManagementLink.all()から取得される全ManagementLink拡張

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リンク一覧 | List<ManagementLink> | カテゴリ別に分類された管理リンク |
| バッジ | Badge | 各リンクに付随する警告バッジ等 |

### 出力先

- Web UI（管理画面HTML）

## 処理フロー

### 処理シーケンス

```
1. 管理画面アクセス
2. 権限チェック
   └─ Jenkins.MANAGEまたはJenkins.SYSTEM_READ
3. ManagementLink.all()取得
4. 各リンクに対してループ
   └─ getRequiredPermission()で権限チェック
   └─ getCategory()でカテゴリ取得
   └─ getBadge()でバッジ取得（オプション）
5. カテゴリ別にグループ化
6. HTMLレンダリング
```

### フローチャート

```mermaid
flowchart TD
    A[管理画面アクセス] --> B[権限チェック]
    B -->|権限あり| C[ManagementLink.all()取得]
    B -->|権限なし| D[エラー: 権限不足]
    C --> E[各リンクをループ]
    E --> F{権限あり?}
    F -->|Yes| G[カテゴリ取得]
    F -->|No| H[スキップ]
    G --> I[バッジ取得]
    I --> J[カテゴリ別グループに追加]
    H --> K{全リンク処理完了?}
    J --> K
    K -->|No| E
    K -->|Yes| L[HTMLレンダリング]
    L --> M[画面表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | カテゴリ分類 | 全ManagementLinkは6カテゴリに分類される | 全リンク |
| BR-46-02 | 権限フィルタ | ユーザーに権限がないリンクは表示されない | 全リンク |
| BR-46-03 | バッジ表示 | getBadge()が非nullの場合、バッジを表示 | オプション |
| BR-46-04 | 確認ダイアログ | getRequiresConfirmation()=trueの場合、クリック時に確認 | 一部リンク |
| BR-46-05 | POSTリンク | getRequiresPOST()=trueの場合、POSTメソッドでリクエスト | 一部リンク |

### カテゴリ定義

| カテゴリ | 説明 | 例 |
|---------|------|-----|
| CONFIGURATION | 設定ページ | システム設定、グローバルツール設定 |
| SECURITY | セキュリティ関連 | セキュリティ設定、認証領域 |
| STATUS | 状態情報 | システム情報、ロード統計 |
| TROUBLESHOOTING | トラブルシューティング | システムログ、診断ツール |
| TOOLS | 管理ツール | CLI、スクリプトコンソール |
| MISC | その他 | その他の管理機能 |

## データベース操作仕様

管理画面自体はデータベース操作を行わない。各リンク先で操作が行われる。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AccessDeniedException | 権限不足 | 管理画面へのアクセス権限がない | 管理者に権限付与を依頼 |

## トランザクション仕様

該当なし（読み取り専用のナビゲーション画面）

## パフォーマンス要件

- 管理画面表示: 1秒以内

## セキュリティ考慮事項

- 管理画面アクセスにはJenkins.MANAGEまたはJenkins.SYSTEM_READ権限が必要
- 各管理リンクは個別の権限チェックを実施
- 確認ダイアログとPOSTリクエストによるCSRF保護

## 備考

- プラグインはManagementLinkを継承して独自の管理リンクを追加可能
- @Extensionアノテーションで自動登録
- アイコンはSVG形式を推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ManagementLink基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ManagementLink.java | `core/src/main/java/hudson/model/ManagementLink.java` | 管理リンクの基底クラス |
| 1-2 | ManageJenkinsAction.java | `core/src/main/java/hudson/model/ManageJenkinsAction.java` | 管理画面のアクションクラス |

**主要処理フロー（ManagementLink）**:
- **58行目**: ExtensionPointを実装
- **69-71行目**: getIconFileName() - アイコン取得（null可）
- **79-81行目**: getDescription() - 説明文取得
- **90-91行目**: getUrlName() - リンクURL取得
- **100-102行目**: getRequiresConfirmation() - 確認ダイアログ要否
- **115-117行目**: all() - 全ManagementLinkの取得
- **126-128行目**: getRequiredPermission() - 必要権限取得
- **136-138行目**: getRequiresPOST() - POSTメソッド要否
- **158-165行目**: getCategory() - カテゴリ取得
- **172-206行目**: Category enum定義
- **224-226行目**: getBadge() - バッジ取得

### プログラム呼び出し階層図

```
/manage （管理画面URL）
    │
    ├─ ManageJenkinsAction
    │      ├─ 権限チェック (Jenkins.MANAGE/SYSTEM_READ)
    │      └─ index.jelly レンダリング
    │
    └─ ManagementLink.all()
           │
           ├─ ConfigureLink (CONFIGURATION)
           │      └─ /configure
           │
           ├─ SecurityLink (SECURITY)
           │      └─ /configureSecurity
           │
           ├─ SystemInfoLink (STATUS)
           │      └─ /systemInfo
           │
           ├─ SystemLogLink (TROUBLESHOOTING)
           │      └─ /log
           │
           ├─ CliLink (TOOLS)
           │      └─ /cli
           │
           ├─ PluginsLink (CONFIGURATION)
           │      └─ /pluginManager
           │
           └─ ... (その他のManagementLink)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ManagementLink.java | `core/src/main/java/hudson/model/ManagementLink.java` | ソース | 管理リンク基底クラス |
| ManageJenkinsAction.java | `core/src/main/java/hudson/model/ManageJenkinsAction.java` | ソース | 管理画面アクション |
| Badge.java | `core/src/main/java/jenkins/management/Badge.java` | ソース | バッジクラス |
| ConfigureLink.java | `core/src/main/java/jenkins/management/ConfigureLink.java` | ソース | 設定リンク |
| PluginsLink.java | `core/src/main/java/jenkins/management/PluginsLink.java` | ソース | プラグインリンク |
| NodesLink.java | `core/src/main/java/jenkins/management/NodesLink.java` | ソース | ノードリンク |
| SystemLogLink.java | `core/src/main/java/jenkins/management/SystemLogLink.java` | ソース | システムログリンク |
| CliLink.java | `core/src/main/java/jenkins/management/CliLink.java` | ソース | CLIリンク |
