# 機能設計書 47-管理モニター

## 概要

本ドキュメントは、JenkinsのAdministrative Monitor（管理モニター）機能の設計を記載する。

### 本機能の処理概要

管理モニターは、Jenkinsのシステム状態を監視し、管理者の対応が必要な問題を検知・通知する機能を提供する。セキュリティ問題、設定エラー、リソース不足などの警告を管理画面に表示する。

**業務上の目的・背景**：Jenkinsの安定運用には、システムの問題を早期に検知して対処することが重要である。管理モニターは、問題を自動検知して管理者に通知することで、システムの健全性を維持する。

**機能の利用シーン**：
- セキュリティ脆弱性の警告表示
- ディスク容量不足の通知
- 古いデータや設定の警告
- 推奨設定変更の通知
- セットアップウィザードの完了確認

**主要な処理内容**：
1. 問題の検知（isActivated()による状態チェック）
2. 警告メッセージの表示（message.jelly）
3. 警告の無効化（ユーザーによる手動無効化）
4. セキュリティ/非セキュリティの分類

**関連システム・外部連携**：管理画面（Manage Jenkins）に警告を表示。ヘッダーにも警告数を表示。

**権限による制御**：デフォルトでJenkins.ADMINISTER権限が必要。一部のモニターはJenkins.SYSTEM_READやJenkins.MANAGE権限でも表示可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | Jenkinsの管理 | 主画面 | 管理モニター警告の表示・操作 |

## 機能種別

監視 / 通知 / システムヘルスチェック

## 入力仕様

### 入力パラメータ

管理モニター自体は入力パラメータを持たない。各モニターが独自に監視対象を定義する。

#### doDisable アクション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| （なし） | - | - | POSTリクエストで無効化を実行 | - |

### 入力データソース

- Jenkinsの内部状態
- システムリソース状態
- 設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 警告メッセージ | HTML | message.jellyでレンダリングされる警告表示 |
| 有効/無効状態 | boolean | isEnabled()の結果 |
| 活性化状態 | boolean | isActivated()の結果 |
| セキュリティフラグ | boolean | isSecurity()の結果 |

### 出力先

- Web UI（管理画面に警告表示）
- Web UI（ヘッダーに警告数バッジ表示）

## 処理フロー

### 処理シーケンス

```
1. Jenkinsインスタンス初期化
2. AdministrativeMonitor拡張の発見
   └─ ExtensionList<AdministrativeMonitor>の収集
3. 各モニターの状態チェック
   └─ isEnabled() - ユーザーによる無効化確認
   └─ isActivated() - 問題検知状態の確認
4. 管理画面表示
   └─ 有効かつ活性化されたモニターのmessage.jellyを表示
5. ヘッダーバッジ表示
   └─ セキュリティ/非セキュリティの警告数を集計
```

### フローチャート

```mermaid
flowchart TD
    A[管理画面/ヘッダー描画] --> B[AdministrativeMonitor.all()取得]
    B --> C[各モニターをループ]
    C --> D{isEnabled()?}
    D -->|No| E[スキップ（無効化済み）]
    D -->|Yes| F{isActivated()?}
    F -->|No| G[スキップ（問題なし）]
    F -->|Yes| H{権限チェック}
    H -->|権限あり| I[message.jelly表示]
    H -->|権限なし| G
    I --> J{isSecurity()?}
    J -->|Yes| K[セキュリティ警告カウント++]
    J -->|No| L[通常警告カウント++]
    K --> M{全モニター処理完了?}
    L --> M
    E --> M
    G --> M
    M -->|No| C
    M -->|Yes| N[警告数バッジ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | 無効化永続化 | ユーザーが無効化したモニターはJenkins設定に保存される | doDisable実行時 |
| BR-47-02 | セキュリティ分類 | isSecurity()=trueのモニターは別アイコンで警告表示 | 全モニター |
| BR-47-03 | 権限レベル | 各モニターはgetRequiredPermission()で表示権限を定義 | 全モニター |
| BR-47-04 | 一意ID | 各モニターはidで一意に識別される | 全モニター |

### 主要な管理モニター

| モニター名 | 説明 | isSecurity |
|-----------|------|------------|
| HudsonHomeDiskUsageMonitor | JENKINS_HOMEのディスク使用量警告 | No |
| OldDataMonitor | 古いデータの存在警告 | No |
| RootUrlNotSetMonitor | Jenkins URLが未設定の警告 | No |
| SecurityIsOffMonitor | セキュリティが無効の警告 | Yes |
| ReverseProxySetupMonitor | リバースプロキシ設定問題の警告 | No |
| UpdateSiteWarningsMonitor | プラグイン脆弱性の警告 | Yes |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 無効化 | $JENKINS_HOME/config.xml | UPDATE | disabledAdministrativeMonitorsに追加 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AccessDeniedException | 権限不足 | モニターの表示/無効化権限がない | 管理者に権限付与を依頼 |

## トランザクション仕様

モニターの状態チェックは読み取り専用。無効化操作はJenkins設定ファイルへの書き込みを伴う。

## パフォーマンス要件

- モニター状態チェック: 各モニターの実装に依存
- 全モニターの一括チェック: 2秒以内（推奨）

## セキュリティ考慮事項

- モニターの表示にはgetRequiredPermission()で定義された権限が必要
- 無効化操作にはJenkins.ADMINISTER権限が必須
- セキュリティ関連のモニターは優先的に表示

## 備考

- プラグインはAdministrativeMonitorを継承して独自のモニターを追加可能
- @Extensionアノテーションで自動登録
- AsynchronousAdministrativeMonitorで非同期監視も可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: AdministrativeMonitor基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | 管理モニターの基底クラス |

**主要処理フロー（AdministrativeMonitor）**:
- **90行目**: ExtensionPointとStaplerProxyを実装
- **98行目**: id - モニターの一意識別子
- **100-106行目**: コンストラクタ（id設定）
- **111-113行目**: getUrl() - モニターURL
- **128-138行目**: disable() - 無効化処理
- **147-149行目**: isEnabled() - 有効/無効チェック
- **159行目**: isActivated() - 活性化状態（抽象メソッド）
- **173-175行目**: isSecurity() - セキュリティフラグ
- **180-184行目**: doDisable() - 無効化アクション（POST）
- **208-211行目**: getRequiredPermission() - 必要権限
- **265-267行目**: all() - 全モニター取得

### プログラム呼び出し階層図

```
Jenkins 管理画面 / ヘッダー
    │
    ├─ AdministrativeMonitor.all()
    │      └─ ExtensionList<AdministrativeMonitor>
    │
    └─ 各モニターに対して
           ├─ isEnabled() → disabledAdministrativeMonitors確認
           ├─ isActivated() → 問題検知状態確認
           ├─ hasRequiredPermission() → 表示権限確認
           ├─ isSecurity() → セキュリティ分類
           └─ message.jellyレンダリング

無効化操作
    │
    └─ doDisable(StaplerRequest, StaplerResponse)
           ├─ Jenkins.checkPermission(ADMINISTER)
           ├─ disable(true)
           │      └─ Jenkins.setDisabledAdministrativeMonitors()
           └─ jenkins.save()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 管理モニター基底クラス |
| HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | ソース | ディスク使用量モニター |
| OldDataMonitor.java | `core/src/main/java/hudson/diagnosis/OldDataMonitor.java` | ソース | 古いデータモニター |
| ReverseProxySetupMonitor.java | `core/src/main/java/hudson/diagnosis/ReverseProxySetupMonitor.java` | ソース | リバースプロキシモニター |
| RootUrlNotSetMonitor.java | `core/src/main/java/jenkins/diagnostics/RootUrlNotSetMonitor.java` | ソース | URLモニター |
| SecurityIsOffMonitor.java | `core/src/main/java/jenkins/diagnostics/SecurityIsOffMonitor.java` | ソース | セキュリティモニター |
| UpdateSiteWarningsMonitor.java | `core/src/main/java/jenkins/security/UpdateSiteWarningsMonitor.java` | ソース | プラグイン脆弱性モニター |
| AsynchronousAdministrativeMonitor.java | `core/src/main/java/jenkins/management/AsynchronousAdministrativeMonitor.java` | ソース | 非同期モニター基底 |
