# 機能設計書 5-フリースタイルプロジェクト

## 概要

本ドキュメントは、Jenkinsの汎用ビルドジョブであるフリースタイルプロジェクト（hudson.model.FreeStyleProject）の機能設計を記述する。柔軟に設定可能な汎用ビルドジョブとして、最も基本的かつ広く使用されるジョブタイプである。

### 本機能の処理概要

FreeStyleProjectは、シェルスクリプト、バッチファイル、Maven、Antなど様々なビルドステップを自由に組み合わせて実行できる汎用的なプロジェクトタイプである。

**業務上の目的・背景**：開発プロジェクトにはビルド手順が異なる多様なタイプが存在する。フリースタイルプロジェクトは、特定のビルドツールに縛られず、柔軟にビルドプロセスを定義できることで、あらゆるプロジェクトのCI/CDに対応する。

**機能の利用シーン**：シンプルなビルドジョブの作成、シェルスクリプトによる独自ビルド、複数のビルドステップの組み合わせ、レガシーシステムのビルド自動化など。

**主要な処理内容**：
1. プロジェクトの作成・設定管理
2. SCM（ソースコード管理）との連携設定
3. ビルドトリガーの設定（定期実行、SCM変更検知等）
4. ビルドステップの定義と実行
5. ビルド後処理（成果物アーカイブ、通知等）
6. FreeStyleBuildオブジェクトの生成と管理

**関連システム・外部連携**：SCM（Git、SVN等）、ビルドツール（Maven、Gradle、Ant等）、成果物リポジトリ、通知システム。

**権限による制御**：Item.CREATE（作成）、Item.CONFIGURE（設定）、Item.BUILD（ビルド実行）、Item.DELETE（削除）の各権限で制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 新規ジョブ作成 | 主画面 | フリースタイルプロジェクトタイプの選択 |
| 11 | ジョブ詳細 | 主画面 | プロジェクトの詳細情報表示 |
| 12 | ジョブ設定 | 主画面 | プロジェクト設定の表示・編集 |

## 機能種別

ジョブ管理 / プロジェクトタイプ / ビルド実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | プロジェクト名 | 空白・特殊文字制限 |
| description | String | No | プロジェクトの説明 | なし |
| scm | SCM | No | ソースコード管理設定 | SCM実装クラス |
| triggers | List<Trigger> | No | ビルドトリガー一覧 | なし |
| builders | List<Builder> | No | ビルドステップ一覧 | なし |
| publishers | List<Publisher> | No | ビルド後処理一覧 | なし |
| buildWrappers | Map<Descriptor, BuildWrapper> | No | ビルドラッパー | なし |

### 入力データソース

- config.xml: プロジェクト設定ファイル
- Web画面: プロジェクト設定画面からのフォーム入力
- REST API: /job/{name}/config.xml
- CLI: create-job コマンド

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| builds | RunList<FreeStyleBuild> | ビルド履歴 |
| lastBuild | FreeStyleBuild | 最新ビルド |
| workspace | FilePath | ワークスペースパス |
| scmCheckoutStrategy | SCMCheckoutStrategy | チェックアウト戦略 |

### 出力先

- config.xml: プロジェクト設定
- builds/: ビルド履歴ディレクトリ
- workspace/: ワークスペースディレクトリ
- Webインターフェース: プロジェクト画面
- REST API: /job/{name}/api/json

## 処理フロー

### 処理シーケンス

```
1. プロジェクト作成
   ├─ DescriptorImpl.newInstance() でインスタンス生成
   ├─ 親ItemGroupへの登録
   └─ config.xml 保存
2. ビルド実行
   ├─ FreeStyleBuild インスタンス生成
   ├─ SCMチェックアウト
   ├─ BuildWrapper.setUp() 実行
   ├─ 各Builder.perform() 実行
   ├─ Recorder/Notifier.perform() 実行
   └─ BuildWrapper.tearDown() 実行
3. 設定変更
   ├─ フォームデータ受信
   ├─ 各Describableの更新
   └─ config.xml 保存
```

### フローチャート

```mermaid
flowchart TD
    A[新規プロジェクト作成] --> B[DescriptorImpl.newInstance]
    B --> C[FreeStyleProject生成]
    C --> D[親ItemGroupに登録]
    D --> E[config.xml保存]

    F[ビルド開始] --> G[FreeStyleBuild生成]
    G --> H[SCMチェックアウト]
    H --> I[preBuild実行]
    I --> J[BuildWrapper.setUp]
    J --> K{各Builder実行}
    K -->|成功| L[次のBuilder]
    K -->|失敗| M[結果FAILURE設定]
    L --> K
    K -->|完了| N[Publisher実行]
    M --> N
    N --> O[BuildWrapper.tearDown]
    O --> P[ビルド完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ビルドステップ順次実行 | Builderは定義順に順次実行 | ビルド実行時 |
| BR-002 | 失敗時中断 | Builder失敗時は後続処理をスキップ | ビルド実行時 |
| BR-003 | Publisher常時実行 | Publisherはビルド結果に関わらず実行 | ビルド後処理時 |
| BR-004 | ワークスペース分離 | プロジェクト毎に独立したワークスペース | 常時 |

### 計算ロジック

- ビルドクラス決定: getBuildClass() で FreeStyleBuild.class を返却

## データベース操作仕様

ファイルベースの永続化を使用。

### ファイル操作一覧

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | jobs/{name}/config.xml | 書き込み | プロジェクト設定 |
| ビルド保存 | jobs/{name}/builds/{number}/ | 書き込み | ビルド結果 |
| ワークスペース | workspace/{name}/ | 読み書き | ビルド作業領域 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AbortException | ビルドステップ失敗 | ビルドログ確認 |
| - | InterruptedException | ビルド中断 | 中断原因確認 |
| - | IOException | ファイルI/Oエラー | ディスク容量・権限確認 |

### リトライ仕様

SCMチェックアウト失敗時はscmCheckoutRetryCount設定に従いリトライ。

## トランザクション仕様

ビルド実行はアトミックではなく、中断時は実行済みステップの結果が残る。

## パフォーマンス要件

- ビルド開始: 数秒以内
- ビルド時間: ビルドステップ内容に依存
- 同時実行: エグゼキュータ数に依存

## セキュリティ考慮事項

- シェルスクリプト実行: 任意コード実行可能のため管理者注意
- 認証情報: Credentials Pluginによる安全な管理を推奨
- ワークスペース: 機密情報の残留に注意

## 備考

- シンボル名: @Symbol({"freeStyle", "freeStyleJob"})
- カテゴリ: StandaloneProjectsCategory
- アイコン: symbol-freestyle-project
- Pipeline Pluginが推奨される場合もあるが、シンプルなジョブにはFreeStyleProjectが適切

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス階層を理解する

FreeStyleProjectの継承関係を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FreeStyleProject.java | `core/src/main/java/hudson/model/FreeStyleProject.java` | クラス定義（43行目）でProject<FreeStyleProject, FreeStyleBuild>を継承していることを確認 |
| 1-2 | Project.java | `core/src/main/java/hudson/model/Project.java` | 親クラスの構造 |

**読解のコツ**: FreeStyleProjectは非常にシンプルなクラス（約125行）。ほとんどの機能は親クラスProjectとAbstractProjectに実装されている。

#### Step 2: インスタンス生成を理解する

プロジェクト生成の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FreeStyleProject.java | `core/src/main/java/hudson/model/FreeStyleProject.java` | コンストラクタ（49-55行目）を確認 |
| 2-2 | FreeStyleProject.java | `core/src/main/java/hudson/model/FreeStyleProject.java` | DescriptorImpl.newInstance()（93-95行目）を確認 |

**主要処理フロー**:
1. **49-51行目**: 非推奨コンストラクタ（Jenkins直接指定）
2. **53-55行目**: ItemGroup指定のコンストラクタ
3. **57-60行目**: getBuildClass()でFreeStyleBuild.classを返却

#### Step 3: Descriptorを理解する

プロジェクトのメタデータ管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FreeStyleProject.java | `core/src/main/java/hudson/model/FreeStyleProject.java` | DescriptorImpl（79-123行目）の各メソッド |

**主要処理フロー**:
- **86-89行目**: getDisplayName()でメッセージリソースから表示名取得
- **93-95行目**: newInstance()でプロジェクトインスタンス生成
- **98-100行目**: getDescription()で説明文取得
- **103-105行目**: getCategoryId()でカテゴリID取得
- **108-110行目**: getIconFilePathPattern()でアイコンパス取得
- **113-115行目**: getIconClassName()でアイコンクラス名取得

### プログラム呼び出し階層図

```
FreeStyleProject
    │
    └─ extends Project<FreeStyleProject, FreeStyleBuild>
           │
           └─ extends AbstractProject<FreeStyleProject, FreeStyleBuild>
                  │
                  └─ extends Job<FreeStyleProject, FreeStyleBuild>
                         │
                         └─ extends AbstractItem
                                │
                                └─ implements TopLevelItem
```

### データフロー図

```
[入力]                      [処理]                           [出力]

設定フォーム ────────────▶ Stapler binding ──────────▶ FreeStyleProjectオブジェクト
                                │
                                ▼
ビルド要求 ─────────────▶ scheduleBuild() ───────────▶ Queue.Item
                                │
                                ▼
Queue.Item ─────────────▶ FreeStyleBuild生成 ────────▶ ビルド実行
                                │
                                ▼
Builder群 ──────────────▶ 順次perform() ─────────────▶ ビルド結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FreeStyleProject.java | `core/src/main/java/hudson/model/FreeStyleProject.java` | ソース | フリースタイルプロジェクト実装 |
| FreeStyleBuild.java | `core/src/main/java/hudson/model/FreeStyleBuild.java` | ソース | ビルド実行クラス |
| Project.java | `core/src/main/java/hudson/model/Project.java` | ソース | プロジェクト基底クラス |
| AbstractProject.java | `core/src/main/java/hudson/model/AbstractProject.java` | ソース | 抽象プロジェクトクラス |
| Builder.java | `core/src/main/java/hudson/tasks/Builder.java` | ソース | ビルドステップ基底クラス |
| Publisher.java | `core/src/main/java/hudson/tasks/Publisher.java` | ソース | パブリッシャー基底クラス |
| configure-entries.jelly | `core/src/main/resources/hudson/model/FreeStyleProject/configure-entries.jelly` | テンプレート | 設定画面パーツ |
