# 機能設計書 54-パラメータ定義

## 概要

本ドキュメントは、Jenkinsのパラメータ定義（ParameterDefinition）機能の設計を記述する。パラメータ定義は、ビルド実行時にユーザーが入力する値の型と制約を定義するための基盤クラスであり、パラメータ化ビルドの中核を担う。

### 本機能の処理概要

**業務上の目的・背景**：CI/CDパイプラインでは、同じジョブを異なる設定で実行したい場面が頻繁にある。例えば、テスト対象のブランチ名、デプロイ先の環境（staging/production）、ビルドオプションなどを実行時に指定したい。パラメータ定義により、ジョブ設定で入力項目を定義し、ビルド開始時にユーザーから値を受け取る仕組みを提供する。これにより、1つのジョブ定義で多様なビルドシナリオに対応できる。

**機能の利用シーン**：
- ジョブ設定でビルドパラメータを定義する際
- ビルド実行前にユーザーがパラメータ値を入力する際
- Pipeline/DSLからパラメータを参照する際
- CLIやREST APIからパラメータ付きビルドを実行する際

**主要な処理内容**：
1. パラメータの名前・説明・デフォルト値の定義
2. 設定フォーム（config.jelly）でのパラメータ定義UI提供
3. 入力フォーム（index.jelly）でのパラメータ値入力UI提供
4. フォーム送信からのParameterValue生成（`createValue()`）
5. CLIからのParameterValue生成
6. デフォルト値の提供（`getDefaultParameterValue()`）
7. 入力値のバリデーション（`isValid()`）

**関連システム・外部連携**：
- ParametersDefinitionProperty: ジョブにパラメータ定義を関連付けるプロパティ
- ParameterValue: 実際のパラメータ値を保持するクラス
- Stapler: フォームデータバインディング
- CLI: コマンドラインからのパラメータ指定

**権限による制御**：パラメータ入力にはJob.BUILD権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | ジョブ設定 | 主機能 | パラメータ定義の追加・編集 |
| 20 | パラメータ入力 | 主機能 | ビルドパラメータの入力フォーム表示 |

## 機能種別

データ定義 / フォーム処理 / ファクトリ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | パラメータの名前 | 非null |
| description | String | No | パラメータの説明 | - |
| req | StaplerRequest2 | No | フォーム送信リクエスト | - |
| jo | JSONObject | No | フォームから送信されたJSONデータ | - |

### 入力データソース

- ジョブ設定画面: パラメータ定義のconfig.jelly
- ビルド実行画面: パラメータ入力のindex.jelly
- CLI: `build`コマンドの`-p`オプション
- REST API: /build?delay=0sec&parameter=value形式

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| name | String | パラメータ名 |
| description | String | パラメータの説明文 |
| type | String | パラメータ型（クラス名のSimpleName） |
| defaultParameterValue | ParameterValue | デフォルト値 |

### 出力先

- XMLファイル: ジョブのconfig.xml内に永続化
- ParameterValue: ビルド実行時のパラメータ値として使用
- 環境変数: ビルド中に`$パラメータ名`で参照可能

## 処理フロー

### 処理シーケンス

```
1. ジョブ設定でパラメータ定義を追加
   └─ ParameterDescriptorからconfig.jellyを表示
2. パラメータ定義の保存
   └─ ジョブのconfig.xmlに永続化
3. ビルド実行時のパラメータ入力
   └─ ParameterDescriptor.getValuePage()でindex.jellyを表示
4. フォーム送信処理
   └─ ParameterDefinition.createValue(req, jo)でParameterValue生成
5. ビルドへのパラメータ渡し
   └─ ParametersActionとしてビルドに関連付け
6. ビルド中のパラメータ参照
   └─ EnvVars経由で環境変数として利用可能
```

### フローチャート

```mermaid
flowchart TD
    A[ビルド実行リクエスト] --> B{パラメータ定義あり?}
    B -->|No| C[即時ビルド開始]
    B -->|Yes| D[パラメータ入力画面表示]
    D --> E[index.jelly表示]
    E --> F[ユーザーが値を入力]
    F --> G[フォーム送信]
    G --> H[createValue呼び出し]
    H --> I[ParameterValue生成]
    I --> J{isValid?}
    J -->|No| K[エラー表示]
    J -->|Yes| L[ParametersAction作成]
    K --> E
    L --> M[ビルド開始]
    M --> N[EnvVarsに展開]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-01 | 名前必須 | パラメータ名は非null | 常時 |
| BR-54-02 | 名前一意性 | 同一ジョブ内でパラメータ名は一意推奨 | ジョブ設定時 |
| BR-54-03 | デフォルト値利用 | 入力がない場合はデフォルト値を使用 | パラメータ入力時 |
| BR-54-04 | 説明書式 | descriptionはMarkupFormatterで変換される | 表示時 |

### 計算ロジック

ParameterValue生成:
- フォーム送信: `createValue(StaplerRequest2, JSONObject)`
- GET/CLI: `createValue(StaplerRequest2)` または `createValue(String)`
- デフォルト: `getDefaultParameterValue()`

## データベース操作仕様

本機能はデータベースを直接操作しない。

### ファイル永続化

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パラメータ定義保存 | `jobs/{jobName}/config.xml` | WRITE | ParametersDefinitionProperty内に保存 |
| パラメータ定義読込 | `jobs/{jobName}/config.xml` | READ | ジョブ読み込み時に復元 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IllegalArgumentException | パラメータ名がnull | 例外スロー |
| - | AbortException | CLI入力がサポートされていないパラメータ型 | エラーメッセージ表示 |
| - | IllegalStateException | 必須パラメータが入力されていない | ビルド中止 |

### リトライ仕様

リトライは行わない。入力エラー時はフォームを再表示。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- パラメータ定義の取得: O(n)（定義数に比例）
- createValue処理: O(1)

## セキュリティ考慮事項

- パラメータ値はビルドログに出力される可能性がある
- 機密情報はPasswordParameterDefinitionを使用すべき
- XStream永続化により、パラメータ定義はconfig.xmlに平文で保存される

## 備考

- ParameterDefinitionはXStreamでシリアライズされるため、フィールド変更時は互換性に注意
- `equals()`と`hashCode()`はXML比較で実装されている
- `@ExportedBean`により、REST APIで公開される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ParameterDefinitionの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ParameterDefinition.java | `core/src/main/java/hudson/model/ParameterDefinition.java` | 抽象基底クラスの構造、name/descriptionフィールド |
| 1-2 | SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | 単純型パラメータの基底クラス |
| 1-3 | ParameterValue.java | `core/src/main/java/hudson/model/ParameterValue.java` | パラメータ値の基底クラス |

**読解のコツ**: ParameterDefinition（定義）とParameterValue（値）の関係は、型と値の関係に相当する。定義は設定として保存され、値はビルドごとに生成される。

#### Step 2: エントリーポイントを理解する

パラメータ値の生成フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ParameterDefinition.java | `core/src/main/java/hudson/model/ParameterDefinition.java` | createValue()メソッド群 |

**主要処理フロー**:
1. **107-112行目**: コンストラクタでnameを必須チェック
2. **187-210行目**: `createValue(StaplerRequest2, JSONObject)`でフォームからParameterValue生成
3. **228-250行目**: `createValue(StaplerRequest2)`でGETクエリからParameterValue生成
4. **265-268行目**: `createValue(CLICommand, String)`でCLIからParameterValue生成
5. **276-280行目**: `getDefaultParameterValue()`でデフォルト値を返却

#### Step 3: Descriptorを理解する

パラメータ定義のメタデータ管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ParameterDefinition.java | `core/src/main/java/hudson/model/ParameterDefinition.java` | ParameterDescriptor内部クラス |

**主要処理フロー**:
- **331-357行目**: ParameterDescriptorの定義
- **348-350行目**: `getValuePage()`でindex.jellyパスを返却
- **319-321行目**: `all()`で全ParameterDescriptorを取得

#### Step 4: SimpleParameterDefinitionを理解する

単純型パラメータの共通処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | 文字列からParameterValue生成 |

**主要処理フロー**:
- **31行目**: `createValue(String)`抽象メソッドの定義
- **33-43行目**: `createValue(StaplerRequest2)`でGETパラメータから値取得
- **45-48行目**: `createValue(CLICommand, String)`でCLIから値取得

### プログラム呼び出し階層図

```
ビルド実行リクエスト
    │
    ├─ ParametersDefinitionProperty.getParameterDefinitions()
    │      │
    │      └─ List<ParameterDefinition>を取得
    │
    ├─ パラメータ入力画面
    │      │
    │      └─ ParameterDescriptor.getValuePage()
    │             └─ index.jelly表示
    │
    └─ フォーム送信
           │
           └─ ParameterDefinition.createValue(req, jo)
                  │
                  └─ ParameterValue生成
                         │
                         └─ ParametersAction作成
```

### データフロー図

```
[入力]                    [処理]                         [出力]

config.jelly          ParameterDefinition              config.xml
(パラメータ定義) ───▶  (設定保存)              ───▶    (永続化)
                            │
                            ▼
index.jelly           ParameterDefinition              ParameterValue
(パラメータ入力) ───▶  .createValue()          ───▶    (ビルドに渡す)
                            │
                            ▼
                     ParametersAction               EnvVars
                     (ビルドに関連付け)    ───▶    (環境変数化)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ParameterDefinition.java | `core/src/main/java/hudson/model/ParameterDefinition.java` | ソース | パラメータ定義基底クラス |
| SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | ソース | 単純型パラメータ基底クラス |
| ParameterValue.java | `core/src/main/java/hudson/model/ParameterValue.java` | ソース | パラメータ値基底クラス |
| ParametersDefinitionProperty.java | `core/src/main/java/hudson/model/ParametersDefinitionProperty.java` | ソース | ジョブへの関連付け |
| ParametersAction.java | `core/src/main/java/hudson/model/ParametersAction.java` | ソース | ビルドへのパラメータ関連付け |
| StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | ソース | 文字列パラメータ実装例 |
