# 機能設計書 55-文字列パラメータ

## 概要

本ドキュメントは、Jenkinsの文字列パラメータ（StringParameterDefinition）機能の設計を記述する。文字列パラメータは、最も基本的なパラメータ型であり、単一行のテキスト値をビルドパラメータとして受け取るための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：ビルド実行時に柔軟な文字列入力を受け付けることで、ブランチ名、バージョン番号、環境名、オプション文字列など、様々な用途に対応できる汎用的なパラメータを提供する。最も頻繁に使用されるパラメータ型であり、多くのユースケースをカバーする。

**機能の利用シーン**：
- Gitブランチ名やタグ名を指定してビルドする際
- バージョン番号やリリース名を入力する際
- 環境変数として任意の文字列を渡す際
- 設定ファイルパスやURLを指定する際

**主要な処理内容**：
1. パラメータ名とデフォルト値の設定
2. オプショナルなトリム処理の設定
3. ビルド実行時のテキスト入力フィールド表示
4. 入力値またはデフォルト値からStringParameterValue生成
5. 必要に応じた前後空白のトリム

**関連システム・外部連携**：
- SimpleParameterDefinition: 親クラス
- StringParameterValue: 実際の値を保持するクラス
- Pipeline DSL: `string`または`stringParam`シンボルで参照

**権限による制御**：パラメータ入力にはJob.BUILD権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | ジョブ設定 | 主機能 | 文字列パラメータの定義 |
| 20 | パラメータ入力 | 主機能 | 文字列入力フィールドの表示 |

## 機能種別

データ入力 / パラメータ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | パラメータの名前 | 非null |
| defaultValue | String | No | デフォルト値 | 空文字はnullに変換 |
| description | String | No | パラメータの説明 | - |
| trim | boolean | No | 前後空白をトリムするか（デフォルト: false） | - |

### 入力データソース

- ジョブ設定画面: StringParameterDefinitionのconfig.jelly
- ビルド実行画面: StringParameterDefinitionのindex.jelly
- CLI/REST API: 文字列形式のパラメータ値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| StringParameterValue | StringParameterValue | パラメータ値オブジェクト |
| value | String | 実際の文字列値（トリム適用後） |

### 出力先

- XMLファイル: ジョブのconfig.xml内に定義を永続化
- StringParameterValue: ビルドのParametersActionに格納
- 環境変数: ビルド中に`$パラメータ名`で参照可能

## 処理フロー

### 処理シーケンス

```
1. ジョブ設定でStringParameterDefinitionを追加
   └─ name, defaultValue, description, trimを設定
2. パラメータ定義の保存
   └─ ジョブのconfig.xmlに永続化
3. ビルド実行時のパラメータ入力
   └─ テキスト入力フィールドにデフォルト値を表示
4. ユーザー入力処理
   └─ createValue(req, jo)でStringParameterValue生成
5. トリム処理
   └─ trim=trueの場合、前後空白を除去
6. ビルドへのパラメータ渡し
   └─ ParametersAction経由でビルドに関連付け
```

### フローチャート

```mermaid
flowchart TD
    A[パラメータ入力画面] --> B[テキストフィールド表示]
    B --> C{ユーザー入力?}
    C -->|Yes| D[入力値を取得]
    C -->|No| E[デフォルト値を使用]
    D --> F{trim=true?}
    E --> F
    F -->|Yes| G[前後空白をトリム]
    F -->|No| H[そのまま使用]
    G --> I[StringParameterValue生成]
    H --> I
    I --> J[ビルドに渡す]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | デフォルト値変換 | 空文字列はnullに変換（Util.fixEmpty） | 設定保存時 |
| BR-55-02 | トリム処理 | trim=trueの場合のみ前後空白除去 | ParameterValue生成時 |
| BR-55-03 | 設定値トリム維持 | config.xmlのdefaultValueはトリムしない | 永続化時 |
| BR-55-04 | ビルド値トリム | getDefaultValue4Build()でビルド用にトリム適用 | ビルド実行時 |

### 計算ロジック

トリム処理:
- `trim=true`かつ値がnullでない場合: `value.trim()`を適用
- `trim=false`の場合: 値をそのまま使用

## データベース操作仕様

本機能はデータベースを直接操作しない。

### ファイル永続化

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パラメータ定義保存 | `jobs/{jobName}/config.xml` | WRITE | StringParameterDefinitionとして保存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IllegalArgumentException | パラメータ名がnull | 例外スロー（親クラスで処理） |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- createValue処理: O(1)（単純な文字列処理）

## セキュリティ考慮事項

- 文字列パラメータはビルドログに出力される可能性がある
- 機密情報にはPasswordParameterDefinitionを使用すべき
- XSS対策としてHTMLエスケープは表示時に実施

## 備考

- Pipeline DSLでは`string(name: 'BRANCH', defaultValue: 'main', description: 'Branch to build')`で定義
- `@Symbol({"string", "stringParam"})`で両方のシンボル名をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、StringParameterDefinitionのフィールド構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | クラス定義、defaultValue/trimフィールド |
| 1-2 | SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | 親クラスの機能 |

**読解のコツ**: StringParameterDefinitionは`SimpleParameterDefinition`を継承し、`createValue(String)`を実装している。これがCLI/GETでの値生成を担う。

#### Step 2: エントリーポイントを理解する

コンストラクタと値生成メソッドを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | コンストラクタ、createValue()メソッド |

**主要処理フロー**:
1. **52-55行目**: `@DataBoundConstructor`付きコンストラクタ（name必須）
2. **102-105行目**: `setDefaultValue()`でデフォルト値設定（Util.fixEmpty適用）
3. **150-157行目**: `createValue(StaplerRequest2, JSONObject)`でフォームから値生成
4. **160-166行目**: `createValue(String)`で文字列から値生成
5. **127-133行目**: `getDefaultParameterValue()`でデフォルト値のStringParameterValue生成

#### Step 3: トリム処理を理解する

トリム機能の実装詳細を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | isTrim()、トリム処理箇所 |

**主要処理フロー**:
- **114-116行目**: `isTrim()`でトリム設定を取得
- **121-124行目**: `setTrim()`でトリム設定を変更
- **129-131行目**: `getDefaultParameterValue()`内でトリム適用
- **152-154行目**: `createValue(req, jo)`内でトリム適用
- **162-164行目**: `createValue(String)`内でトリム適用
- **94-100行目**: `getDefaultValue4Build()`でビルド用のトリム適用値を返却

#### Step 4: Descriptorを理解する

パラメータ型のメタデータを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | DescriptorImpl内部クラス |

**主要処理フロー**:
- **135-147行目**: `DescriptorImpl`クラスの定義
- **135行目**: `@Extension @Symbol({"string", "stringParam"})`でシンボル名定義
- **137-141行目**: `getDisplayName()`で表示名返却
- **143-146行目**: `getHelpFile()`でヘルプファイルパス返却

### プログラム呼び出し階層図

```
パラメータ入力フォーム送信
    │
    ├─ StringParameterDefinition.createValue(req, jo)
    │      │
    │      └─ req.bindJSON(StringParameterValue.class, jo)
    │             │
    │             └─ StringParameterValue生成
    │
    ├─ isTrim()判定
    │      │
    │      └─ true: StringParameterValue.doTrim()
    │
    └─ setDescription()
           │
           └─ 説明文を設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テキストフィールド     StringParameterDefinition       StringParameterValue
(index.jelly)  ───▶    .createValue()          ───▶    .value
      │                      │                              │
      ▼                      ▼                              ▼
String入力値            trim判定                       環境変数
                            │                         $パラメータ名
                            ▼
                     .doTrim()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | ソース | 文字列パラメータ定義 |
| StringParameterValue.java | `core/src/main/java/hudson/model/StringParameterValue.java` | ソース | 文字列パラメータ値 |
| SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | ソース | 親クラス |
| config.jelly | `core/src/main/resources/hudson/model/StringParameterDefinition/config.jelly` | ビュー | 設定フォーム |
| index.jelly | `core/src/main/resources/hudson/model/StringParameterDefinition/index.jelly` | ビュー | 入力フォーム |
| help-defaultValue.html | `core/src/main/resources/hudson/model/StringParameterDefinition/help-defaultValue.html` | ヘルプ | デフォルト値のヘルプ |
| help-trim.html | `core/src/main/resources/hudson/model/StringParameterDefinition/help-trim.html` | ヘルプ | トリムオプションのヘルプ |
