# 機能設計書 57-ブールパラメータ

## 概要

本ドキュメントは、Jenkinsのブールパラメータ（BooleanParameterDefinition）機能の設計を記述する。ブールパラメータは、真偽値（true/false）をビルドパラメータとして受け取るための機能を提供し、チェックボックス形式で表示される。

### 本機能の処理概要

**業務上の目的・背景**：ビルド実行時に、特定のオプションの有効/無効を切り替えたい場面がある。例えば、テストのスキップ、デバッグモードの有効化、特定ステップの実行/非実行などを制御する際に使用する。シンプルなON/OFF選択により、直感的な操作が可能となる。

**機能の利用シーン**：
- テスト実行のスキップを制御する際（skipTests）
- デバッグモードを有効化する際（debug）
- 本番環境へのデプロイ確認フラグとして（confirmDeploy）
- オプショナルなビルドステップの有効化（enableOptionalStep）

**主要な処理内容**：
1. パラメータ名とデフォルト値（true/false）の設定
2. チェックボックス形式の入力UI表示
3. チェック状態からBooleanParameterValue生成
4. 文字列（"true"/"false"）からのブール値パース

**関連システム・外部連携**：
- SimpleParameterDefinition: 親クラス
- BooleanParameterValue: 実際の値を保持するクラス
- Pipeline DSL: `booleanParam`シンボルで参照

**権限による制御**：パラメータ入力にはJob.BUILD権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | ジョブ設定 | 主機能 | ブールパラメータの定義 |
| 20 | パラメータ入力 | 主機能 | チェックボックスの表示 |

## 機能種別

データ入力 / パラメータ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | パラメータの名前 | 非null |
| defaultValue | boolean | No | デフォルト値（デフォルト: false） | - |
| description | String | No | パラメータの説明 | - |

### 入力データソース

- ジョブ設定画面: BooleanParameterDefinitionのconfig.jelly
- ビルド実行画面: BooleanParameterDefinitionのindex.jelly（チェックボックス）
- CLI/REST API: "true"または"false"文字列

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| BooleanParameterValue | BooleanParameterValue | パラメータ値オブジェクト |
| value | boolean | 実際の真偽値 |

### 出力先

- XMLファイル: ジョブのconfig.xml内に定義を永続化
- BooleanParameterValue: ビルドのParametersActionに格納
- 環境変数: ビルド中に`$パラメータ名`で"true"または"false"として参照可能

## 処理フロー

### 処理シーケンス

```
1. ジョブ設定でBooleanParameterDefinitionを追加
   └─ name, defaultValue, descriptionを設定
2. パラメータ定義の保存
   └─ ジョブのconfig.xmlに永続化
3. ビルド実行時のパラメータ入力
   └─ チェックボックスにデフォルト値を反映して表示
4. ユーザー入力処理
   └─ createValue(req, jo)でBooleanParameterValue生成
5. ビルドへのパラメータ渡し
   └─ ParametersAction経由でビルドに関連付け
```

### フローチャート

```mermaid
flowchart TD
    A[パラメータ入力画面] --> B[チェックボックス表示]
    B --> C{チェック状態?}
    C -->|チェック済み| D[value = true]
    C -->|未チェック| E[value = false]
    D --> F[BooleanParameterValue生成]
    E --> F
    F --> G[ビルドに渡す]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-01 | デフォルト値 | デフォルト値が未設定の場合はfalse | 常時 |
| BR-57-02 | 文字列パース | "true"（大文字小文字区別なし）のみtrue、それ以外はfalse | CLI/API入力時 |
| BR-57-03 | 環境変数表現 | 環境変数では"true"または"false"文字列として表現 | ビルド実行時 |

### 計算ロジック

文字列からのブール値変換:
- `Boolean.parseBoolean(value)`: "true"（ignoreCase）→true、それ以外→false

## データベース操作仕様

本機能はデータベースを直接操作しない。

### ファイル永続化

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パラメータ定義保存 | `jobs/{jobName}/config.xml` | WRITE | BooleanParameterDefinitionとして保存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IllegalArgumentException | パラメータ名がnull | 例外スロー（親クラスで処理） |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- createValue処理: O(1)（単純な真偽値処理）

## セキュリティ考慮事項

- ブール値は機密性が低いため、特別なセキュリティ考慮は不要
- 値はビルドログに出力される可能性がある

## 備考

- Pipeline DSLでは`booleanParam(name: 'DEBUG', defaultValue: false, description: 'Enable debug mode')`で定義
- Javaの予約語「boolean」を避けるため、`@Symbol("booleanParam")`を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、BooleanParameterDefinitionのフィールド構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BooleanParameterDefinition.java | `core/src/main/java/hudson/model/BooleanParameterDefinition.java` | クラス定義、defaultValueフィールド |
| 1-2 | SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | 親クラスの機能 |

**読解のコツ**: BooleanParameterDefinitionは`SimpleParameterDefinition`を継承し、`createValue(String)`を実装している。

#### Step 2: エントリーポイントを理解する

コンストラクタと値生成メソッドを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BooleanParameterDefinition.java | `core/src/main/java/hudson/model/BooleanParameterDefinition.java` | コンストラクタ、createValue()メソッド |

**主要処理フロー**:
1. **49-52行目**: `@DataBoundConstructor`付きコンストラクタ（name必須）
2. **54-58行目**: 3引数コンストラクタ（name, defaultValue, description）
3. **76-79行目**: `setDefaultValue()`でデフォルト値設定
4. **82-86行目**: `createValue(StaplerRequest2, JSONObject)`でフォームから値生成
5. **89-91行目**: `createValue(String)`で文字列から値生成（Boolean.parseBoolean使用）
6. **94-96行目**: `getDefaultParameterValue()`でデフォルト値のBooleanParameterValue生成

#### Step 3: Descriptorを理解する

パラメータ型のメタデータを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BooleanParameterDefinition.java | `core/src/main/java/hudson/model/BooleanParameterDefinition.java` | DescriptorImpl内部クラス |

**主要処理フロー**:
- **127行目**: `@Extension @Symbol("booleanParam")`でシンボル名定義
- **125-126行目コメント**: Javaの予約語"boolean"を避けて"booleanParam"を使用
- **129-133行目**: `getDisplayName()`で表示名返却
- **135-138行目**: `getHelpFile()`でヘルプファイルパス返却

#### Step 4: equals/hashCodeを理解する

オブジェクト比較の実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | BooleanParameterDefinition.java | `core/src/main/java/hudson/model/BooleanParameterDefinition.java` | equals()、hashCode()メソッド |

**主要処理フロー**:
- **98-104行目**: `hashCode()`でname, description, defaultValueのハッシュ計算
- **106-123行目**: `equals()`でフィールド比較

### プログラム呼び出し階層図

```
パラメータ入力フォーム送信
    │
    ├─ BooleanParameterDefinition.createValue(req, jo)
    │      │
    │      └─ req.bindJSON(BooleanParameterValue.class, jo)
    │             │
    │             └─ BooleanParameterValue生成
    │
    └─ setDescription()
           │
           └─ 説明文を設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

チェックボックス       BooleanParameterDefinition      BooleanParameterValue
(index.jelly)  ───▶    .createValue()          ───▶    .value (boolean)
      │                      │                              │
      ▼                      ▼                              ▼
true/false             bindJSON()                      環境変数
                                                      $パラメータ名="true"/"false"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BooleanParameterDefinition.java | `core/src/main/java/hudson/model/BooleanParameterDefinition.java` | ソース | ブールパラメータ定義 |
| BooleanParameterValue.java | `core/src/main/java/hudson/model/BooleanParameterValue.java` | ソース | ブールパラメータ値 |
| SimpleParameterDefinition.java | `core/src/main/java/hudson/model/SimpleParameterDefinition.java` | ソース | 親クラス |
| config.jelly | `core/src/main/resources/hudson/model/BooleanParameterDefinition/config.jelly` | ビュー | 設定フォーム |
| index.jelly | `core/src/main/resources/hudson/model/BooleanParameterDefinition/index.jelly` | ビュー | 入力フォーム（チェックボックス） |
| help-defaultValue.html | `core/src/main/resources/hudson/model/BooleanParameterDefinition/help-defaultValue.html` | ヘルプ | デフォルト値のヘルプ |
