# 機能設計書 6-ビルド（Build）

## 概要

本ドキュメントは、Jenkinsのビルド実行結果を表現するビルド（hudson.model.Build, hudson.model.Run）の機能設計を記述する。ジョブの実行結果とその履歴を管理する基本単位である。

### 本機能の処理概要

Buildクラス（およびその基底クラスRun）は、Jobの1回の実行を表現するオブジェクトである。ビルドの開始から終了までのライフサイクル、結果、ログ、成果物を管理する。

**業務上の目的・背景**：CI/CDにおいて、各ビルドの結果を記録・追跡することは品質管理の根幹である。ビルド履歴により、問題の発生時点の特定、回帰テストの確認、デプロイ判断の根拠が得られる。

**機能の利用シーン**：ビルド実行中の進捗確認、ビルド結果の参照、コンソール出力の閲覧、成果物のダウンロード、ビルド履歴の分析、問題発生時の原因調査など。

**主要な処理内容**：
1. ビルド実行のライフサイクル管理（NOT_STARTED→BUILDING→POST_PRODUCTION→COMPLETED）
2. ビルドログ（コンソール出力）の記録
3. ビルド結果（SUCCESS, UNSTABLE, FAILURE, ABORTED等）の管理
4. ビルド成果物（Artifact）の管理
5. ビルド時間・所要時間の記録
6. ビルドアクション（テスト結果、カバレッジ等）の管理

**関連システム・外部連携**：成果物リポジトリ、テストレポートツール、通知システム。

**権限による制御**：Run.DELETE（ビルド削除）、Run.UPDATE（ビルド更新）等の権限で制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ジョブ詳細 | 参照画面 | ビルド履歴の表示 |
| 13 | ビルド時間傾向 | 参照画面 | ビルド履歴データの取得 |
| 14 | ビルド詳細 | 主画面 | ビルド結果の詳細表示 |
| 15 | コンソール出力 | 主画面 | ビルドログのリアルタイム表示 |
| 16 | コンソール出力（フル） | 主画面 | ビルドログの全件表示 |
| 17 | ビルド設定 | 主画面 | ビルド設定（説明等）の編集 |
| 18 | ビルド削除確認 | 主画面 | ビルド削除の確認処理 |
| 19 | 成果物一覧 | 参照画面 | ビルド成果物の一覧表示 |
| 44 | ユーザー詳細 | 参照画面 | ユーザーに関連するビルド履歴 |
| 45 | ユーザービルド一覧 | 参照画面 | ユーザーが実行したビルドの一覧 |
| 67 | フィンガープリント詳細 | 参照画面 | 関連ビルドの表示 |
| 77 | ビルド一覧（View） | 参照画面 | View内ジョブのビルド一覧 |

## 機能種別

実行結果管理 / ビルド履歴 / ログ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| project | Project | Yes | 親プロジェクト | 有効なProject |
| timestamp | Calendar | No | ビルド開始日時 | なし |
| buildDir | File | No | ビルドディレクトリ（ロード時） | 有効なパス |

### 入力データソース

- builds/{number}/build.xml: ビルド設定ファイル
- builds/{number}/log: コンソールログ
- builds/{number}/changelog.xml: 変更ログ
- Queue.Item: キューからのビルド開始情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| number | int | ビルド番号 |
| result | Result | ビルド結果 |
| timestamp | long | 開始日時（エポックミリ秒） |
| duration | long | 所要時間（ミリ秒） |
| description | String | ビルドの説明 |
| displayName | String | 表示名 |
| keepLog | boolean | ログ保持フラグ |
| artifacts | List<Artifact> | 成果物一覧 |

### 出力先

- builds/{number}/build.xml: ビルド設定
- builds/{number}/log: コンソールログ
- builds/{number}/archive/: 成果物アーカイブ
- Webインターフェース: ビルド詳細画面
- REST API: /job/{name}/{number}/api/json

## 処理フロー

### 処理シーケンス

```
1. ビルド開始
   ├─ Run インスタンス生成
   ├─ state = NOT_STARTED
   ├─ ビルドディレクトリ作成
   └─ RunListener.fireStarted() 通知
2. ビルド実行
   ├─ state = BUILDING
   ├─ 各ビルドステップ実行
   ├─ ログ出力（ConsoleLogWriter）
   └─ result 設定
3. ビルド完了
   ├─ state = POST_PRODUCTION
   ├─ 後処理実行
   ├─ RunListener.fireCompleted() 通知
   └─ state = COMPLETED
4. 永続化
   ├─ build.xml 保存
   ├─ ログファイルクローズ
   └─ RunListener.fireFinalized() 通知
```

### フローチャート

```mermaid
flowchart TD
    A[ビルド開始] --> B[Run生成]
    B --> C[state = NOT_STARTED]
    C --> D[ディレクトリ作成]
    D --> E[RunListener.fireStarted]
    E --> F[state = BUILDING]
    F --> G{ビルドステップ実行}
    G -->|成功| H[次のステップ]
    G -->|失敗| I[result = FAILURE]
    H --> G
    G -->|完了| J[state = POST_PRODUCTION]
    I --> J
    J --> K[後処理実行]
    K --> L[RunListener.fireCompleted]
    L --> M[state = COMPLETED]
    M --> N[build.xml保存]
    N --> O[RunListener.fireFinalized]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 結果不変性 | COMPLETED後はresultを変更不可 | ビルド完了後 |
| BR-002 | 番号一意性 | ビルド番号はジョブ内で一意 | 常時 |
| BR-003 | ログ保持 | keepLog=trueのビルドは自動削除対象外 | ログローテーション時 |
| BR-004 | 状態遷移 | 定義された順序でのみ状態遷移可能 | 常時 |

### 計算ロジック

- 所要時間: ビルド完了時刻 - 開始時刻
- 推定残り時間: 過去のビルド時間から推定

## データベース操作仕様

ファイルベースの永続化を使用。

### ファイル操作一覧

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | builds/{number}/build.xml | 書き込み | ビルド情報保存 |
| ログ出力 | builds/{number}/log | 追記 | コンソールログ |
| 成果物保存 | builds/{number}/archive/ | 書き込み | 成果物アーカイブ |
| 変更ログ | builds/{number}/changelog.xml | 書き込み | SCM変更情報 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AbortException | ビルドステップ失敗 | 原因特定・修正 |
| - | InterruptedException | ビルド中断 | 中断理由確認 |
| - | IOException | ログ書き込み失敗 | ディスク確認 |

### リトライ仕様

ビルド失敗時の自動リトライはなし。手動での再実行が必要。

## トランザクション仕様

ビルド実行はアトミックではない。中断時は中間状態が残る可能性がある。

## パフォーマンス要件

- ログ出力: リアルタイムストリーミング
- 成果物保存: ファイルサイズ・数に依存
- ビルドロード: LazyLoadingで効率化

## セキュリティ考慮事項

- ログに機密情報が含まれる可能性: マスキング処理推奨
- 成果物アクセス制御: 権限に基づく
- ビルド削除権限: Run.DELETE権限必須

## 備考

- Run.State enum: NOT_STARTED, BUILDING, POST_PRODUCTION, COMPLETED
- Result enum: SUCCESS, UNSTABLE, FAILURE, NOT_BUILT, ABORTED
- ArtifactManagerで成果物の保存戦略をカスタマイズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Runクラスの主要フィールドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | クラス定義（169-170行目）、number（187行目）、result（222行目）、timestamp（207行目）、duration（273行目）を確認 |
| 1-2 | Run.java | `core/src/main/java/hudson/model/Run.java` | State enum（245-268行目）を確認 |

**読解のコツ**: Runは抽象クラス。Buildはその具象実装で、さらにビルドステップの実行ロジックを追加している。

#### Step 2: ビルドライフサイクルを理解する

状態遷移とリスナー通知を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | State enumの各状態の意味（245-268行目） |
| 2-2 | Build.java | `core/src/main/java/hudson/model/Build.java` | run()メソッド（113-115行目）、BuildExecution内部クラス（136行目以降） |

**主要処理フロー**:
1. **Run.java 176行目**: QUEUE_ID_UNKNOWNの定義
2. **Run.java 187行目**: ビルド番号（number）
3. **Run.java 192行目**: queueIdでQueue.Itemとの関連
4. **Build.java 143-175行目**: doRun()でビルドステップ実行

#### Step 3: ビルドステップ実行を理解する

Build.BuildExecutionの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Build.java | `core/src/main/java/hudson/model/Build.java` | BuildExecution.doRun()（143-175行目） |

**主要処理フロー**:
- **144-147行目**: preBuild()でビルダーとパブリッシャーの事前処理
- **151-162行目**: BuildWrapperのsetUp()実行
- **164-165行目**: build()で各Builderを実行
- **178-183行目**: post2()でパブリッシャー実行

### プログラム呼び出し階層図

```
Build<P, B>
    │
    └─ extends AbstractBuild<P, B>
           │
           └─ extends Run<P, B>
                  │
                  ├─ number (ビルド番号)
                  ├─ result (ビルド結果)
                  ├─ timestamp (開始日時)
                  ├─ duration (所要時間)
                  └─ state (状態)
                         ├─ NOT_STARTED
                         ├─ BUILDING
                         ├─ POST_PRODUCTION
                         └─ COMPLETED
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Queue.Item ─────────────▶ Run生成 ────────────────────▶ builds/{number}/
                                │
                                ▼
ビルドステップ ─────────▶ BuildExecution ──────────────▶ コンソールログ
                                │
                                ▼
ビルド結果 ─────────────▶ Result設定 ──────────────────▶ build.xml
                                │
                                ▼
成果物 ─────────────────▶ ArtifactManager ─────────────▶ archive/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド基底クラス |
| Build.java | `core/src/main/java/hudson/model/Build.java` | ソース | ビルド実装クラス |
| AbstractBuild.java | `core/src/main/java/hudson/model/AbstractBuild.java` | ソース | 抽象ビルドクラス |
| Result.java | `core/src/main/java/hudson/model/Result.java` | ソース | ビルド結果enum |
| RunListener.java | `core/src/main/java/hudson/model/listeners/RunListener.java` | ソース | ビルドリスナー |
| ArtifactManager.java | `core/src/main/java/jenkins/model/ArtifactManager.java` | ソース | 成果物管理 |
| index.jelly | `core/src/main/resources/hudson/model/Run/index.jelly` | テンプレート | ビルド詳細画面 |
| console.jelly | `core/src/main/resources/hudson/model/Run/console.jelly` | テンプレート | コンソール画面 |
