# 機能設計書 66-RSSフィード

## 概要

本ドキュメントは、Jenkins におけるビルド結果の RSS フィード配信機能の設計について記述する。

### 本機能の処理概要

RSSフィード機能は、Jenkins のビルド結果を RSS/Atom 形式で配信し、フィードリーダーやその他のツールからビルド状況を監視できるようにする機能である。

**業務上の目的・背景**：CI/CD システムの監視において、ビルド結果をリアルタイムに把握することは重要である。RSS フィードは標準化されたフォーマットであり、様々なフィードリーダー、監視ツール、通知システムと連携できる。これにより、チームメンバーは自分の好みのツールでビルド状況を追跡でき、問題の早期発見に役立つ。

**機能の利用シーン**：
- フィードリーダーでのビルド結果監視
- 外部監視システムとの連携
- ダッシュボードへのビルド状況表示
- メール通知システムとの連携
- モバイルアプリでのビルド状況確認

**主要な処理内容**：
1. ビルド結果の RSS/Atom フォーマットへの変換
2. FeedAdapter によるカスタマイズ可能なフィード生成
3. Atom/RSS 2.0 形式の選択対応
4. Content-Type の適切な設定
5. Jelly テンプレートによるフィード出力

**関連システム・外部連携**：
- Stapler: Web フレームワーク
- RunList: ビルド履歴の取得
- FeedAdapter: フィードエントリーのカスタマイズ
- Jelly: テンプレートエンジン

**権限による制御**：RSS フィードへのアクセスは Jenkins の認証・認可システムに統合されており、ユーザーの権限に応じてアクセス可能なビルド情報が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | API情報 | 補助機能 | RSS フィード情報の説明 |

## 機能種別

データ配信 / 通知

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| flavor | String | No | フィード形式（atom/rss2）、デフォルトは atom | atom または rss2 |

### 入力データソース

- RunList（ビルド履歴）
- Job/View などのモデルオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Atom フィード | application/atom+xml | Atom 1.0 形式のフィード |
| RSS フィード | text/xml | RSS 2.0 形式のフィード |

### 出力先

- HTTP レスポンスボディ

## 処理フロー

### 処理シーケンス

```
1. フィードリクエストの受信
   └─ /rss, /rssFailed, /rssAll などのエンドポイント

2. パラメータの取得
   └─ flavor パラメータで形式を決定（デフォルト atom）

3. フィードエントリーの収集
   └─ RunList からビルド履歴を取得
   └─ FeedAdapter でエントリー情報を抽出

4. Jelly テンプレートの実行
   └─ atom.jelly または rss2.jelly を選択
   └─ フィードデータをテンプレートに渡す

5. レスポンスの出力
   └─ Content-Type の設定
   └─ フィード XML の出力
```

### フローチャート

```mermaid
flowchart TD
    A[フィードリクエスト] --> B[flavor パラメータ取得]
    B --> C{flavor の値}
    C -->|atom| D[Atom 形式選択]
    C -->|rss2/other| E[RSS 形式選択]
    D --> F[Content-Type: application/atom+xml]
    E --> G[Content-Type: text/xml]
    F --> H[RunList 取得]
    G --> H
    H --> I[FeedAdapter でエントリー変換]
    I --> J[Jelly テンプレート実行]
    J --> K[フィード XML 出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | デフォルト形式 | flavor 未指定時は Atom 形式 | flavor パラメータなし |
| BR-66-02 | パス検証 | flavor にパス区切りを含む場合は除去 | セキュリティ対策 |
| BR-66-03 | Atom Content-Type | Atom 形式は application/atom+xml | flavor=atom |
| BR-66-04 | RSS Content-Type | RSS 形式は text/xml | flavor=rss2 等 |
| BR-66-05 | UTF-8 エンコーディング | 出力は UTF-8 | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（RSS フィード機能はデータベースを直接操作しない、読み取り専用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOException | 入出力エラー | テンプレート処理失敗 | エラーログ出力、500 エラー |
| ServletException | サーブレットエラー | リクエスト処理失敗 | エラーログ出力、500 エラー |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- フィードエントリー数は適切に制限する
- 大量のビルド履歴がある場合の対策

## セキュリティ考慮事項

- flavor パラメータのパストラバーサル対策
- 認証・認可との統合
- フィード URL の保護

## 備考

- RSS クラスは static メソッドのみを提供するユーティリティクラス
- Run.FEED_ADAPTER がデフォルトの FeedAdapter 実装を提供
- カスタム FeedAdapter で出力内容をカスタマイズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RSS.java | `core/src/main/java/hudson/model/RSS.java` | RSS クラスの基本構造（46-150行目） |

**読解のコツ**: RSS クラスは static メソッドのみを持つユーティリティクラス。forwardToRss() が中核メソッド。

#### Step 2: フィード転送処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RSS.java | `core/src/main/java/hudson/model/RSS.java` | forwardToRss() メソッド（61-78行目） |

**主要処理フロー**:
1. **62-65行目**: リクエスト属性にフィードデータを設定
2. **67-68行目**: flavor パラメータの取得（デフォルト atom）
3. **69行目**: パストラバーサル対策（'/' を '_' に置換）
4. **71-75行目**: Content-Type の設定
5. **77行目**: Jelly テンプレートへの転送

#### Step 3: rss() ヘルパーメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RSS.java | `core/src/main/java/hudson/model/RSS.java` | rss() メソッド（103-136行目） |

**主要処理フロー**:
- **103-105行目**: rss() - RunList を使用した簡易版
- **133-136行目**: rss() with FeedAdapter - カスタムアダプター対応版
- **134行目**: デフォルト FeedAdapter として Run.FEED_ADAPTER を使用

### プログラム呼び出し階層図

```
RSS 操作
    │
    ├─ rss(req, rsp, title, url, runList)
    │      └─ rss(req, rsp, title, url, runList, null) (104行目)
    │
    ├─ rss(req, rsp, title, url, runList, feedAdapter)
    │      └─ forwardToRss() (135行目)
    │
    └─ forwardToRss(title, url, entries, adapter, req, rsp)
           ├─ req.setAttribute() (62-65行目)
           ├─ flavor 取得・検証 (67-69行目)
           ├─ Content-Type 設定 (71-75行目)
           └─ req.getView().forward() (77行目)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

RunList ──────────────▶ rss() メソッド
                              │
                              ▼
FeedAdapter ──────────▶ forwardToRss()
                              │
                              ▼
flavor パラメータ ────▶ Content-Type 決定
                              │
                              ▼
                       リクエスト属性設定
                              │
                              ▼
                       Jelly テンプレート ─────▶ atom.jelly / rss2.jelly
                              │
                              ▼
                       フィード XML ───────────▶ HTTP レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RSS.java | `core/src/main/java/hudson/model/RSS.java` | ソース | RSS フィード生成の主要クラス |
| FeedAdapter.java | `core/src/main/java/hudson/FeedAdapter.java` | ソース | フィードエントリーのアダプターインターフェース |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | FEED_ADAPTER 実装を提供 |
| RunList.java | `core/src/main/java/hudson/util/RunList.java` | ソース | ビルド履歴の管理 |
| atom.jelly | `core/src/main/resources/hudson/atom.jelly` | テンプレート | Atom フィード出力 |
| rss2.jelly | `core/src/main/resources/hudson/rss2.jelly` | テンプレート | RSS 2.0 フィード出力 |
