# 機能設計書 7-キュー管理

## 概要

本ドキュメントは、Jenkinsのビルドスケジューリングと待機キューを管理するキュー管理機能（hudson.model.Queue）の機能設計を記述する。ビルドの実行順序制御とリソース割り当ての中核機能である。

### 本機能の処理概要

Queueクラスは、ビルドキューの管理を担い、実行可能なタスク（Task）を追跡し、利用可能なエグゼキュータにタスクを割り当てる。

**業務上の目的・背景**：複数のビルド要求が同時に発生した場合、適切な順序でリソースを割り当てる必要がある。キュー管理は、ビルドの待機、優先順位制御、リソース競合の解決を行い、効率的なビルド実行を実現する。

**機能の利用シーン**：ビルドのスケジューリング時、キュー状態の確認時、ビルドのキャンセル時、リソース待ちの確認時、ビルド優先順位の調整時。

**主要な処理内容**：
1. ビルドタスクのキューへの追加（scheduleBuild）
2. 待機リスト（waitingList）での待機時間管理
3. ブロックされたプロジェクト（blockedProjects）の管理
4. ビルド可能アイテム（buildables）の管理
5. 保留中アイテム（pendings）の管理
6. エグゼキュータへのジョブ割り当て（JobOffer）
7. キューの永続化と復元

**関連システム・外部連携**：Executor（ビルド実行）、Node（ノード管理）、LoadBalancer（負荷分散）。

**権限による制御**：Item.CANCEL（ビルドキャンセル）権限でキューからの削除が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ダッシュボード（View一覧） | 参照画面 | ビルドキューの状態表示 |
| 20 | パラメータ入力 | 遷移先画面 | ビルドキューへの追加 |
| 35 | 安全な再起動 | 参照画面 | 実行中ジョブの完了待機 |

## 機能種別

スケジューリング / キュー管理 / リソース割り当て

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| task | Task | Yes | 実行するタスク | 有効なTask実装 |
| quietPeriod | int | No | 待機時間（秒） | 0以上 |
| cause | Cause | No | ビルド原因 | なし |
| actions | List<Action> | No | 追加アクション | なし |

### 入力データソース

- queue.xml: キューの永続化ファイル
- ビルド要求: scheduleBuild()の呼び出し
- トリガー: SCMトリガー、タイマートリガー等

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| waitingList | Set<WaitingItem> | 待機中アイテム |
| blockedProjects | ItemList<BlockedItem> | ブロック中アイテム |
| buildables | ItemList<BuildableItem> | ビルド可能アイテム |
| pendings | ItemList<BuildableItem> | 保留中アイテム |

### 出力先

- queue.xml: キュー状態の永続化
- Webインターフェース: ビルドキュー表示
- REST API: /queue/api/json

## 処理フロー

### 処理シーケンス

```
1. ビルドスケジュール
   ├─ schedule2() でタスクをキューに追加
   ├─ WaitingItem 生成
   └─ waitingList に追加
2. 待機時間経過
   ├─ WaitingItem を blockedProjects または buildables に移動
   └─ CauseOfBlockage をチェック
3. ブロック解除
   ├─ blockedProjects から buildables に移動
   └─ ビルド可能状態に
4. エグゼキュータ割り当て
   ├─ JobOffer でエグゼキュータが空きを通知
   ├─ MappingWorksheet でマッチング
   └─ pendings に移動してビルド開始
5. ビルド完了/キャンセル
   ├─ キューから削除
   └─ leftItems に一時保持
```

### フローチャート

```mermaid
flowchart TD
    A[scheduleBuild要求] --> B[WaitingItem生成]
    B --> C[waitingList追加]
    C --> D{待機時間経過?}
    D -->|No| C
    D -->|Yes| E{ブロック条件?}
    E -->|あり| F[blockedProjects]
    E -->|なし| G[buildables]
    F --> H{ブロック解除?}
    H -->|No| F
    H -->|Yes| G
    G --> I{Executor空き?}
    I -->|No| G
    I -->|Yes| J[pendings]
    J --> K[Executor.start]
    K --> L[ビルド実行]
    L --> M[leftItems]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 待機時間 | quietPeriod経過まで実行開始しない | スケジュール直後 |
| BR-002 | 同一タスク統合 | 同じタスクの重複スケジュールは統合可能 | FoldableAction |
| BR-003 | リソース排他 | 必要なResourceをロックして競合防止 | ビルド開始時 |
| BR-004 | ラベルマッチング | タスクのラベルに合致するノードのみ割り当て | 割り当て時 |
| BR-005 | ブロック理由 | CauseOfBlockageで待機理由を提供 | 待機中 |

### 計算ロジック

- 待機時間計算: スケジュール時刻 + quietPeriod
- 優先順位: QueueSorterによるカスタマイズ可能

## データベース操作仕様

ファイルベースの永続化を使用。

### ファイル操作一覧

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キュー保存 | queue.xml | 書き込み | キュー状態の永続化 |
| キュー復元 | queue.xml | 読み取り | 起動時のキュー復元 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CauseOfBlockage | ビルドブロック | 原因解消を待機 |
| - | AccessDeniedException | キャンセル権限なし | 権限付与 |
| - | IOException | queue.xml読み書き失敗 | ファイルシステム確認 |

### リトライ仕様

キューからの再実行は手動で行う。自動リトライなし。

## トランザクション仕様

キュー操作はReentrantLockで排他制御。queue.xmlへの保存はアトミック。

## パフォーマンス要件

- スケジュール応答: ミリ秒オーダー
- キュー監視: 定期的なmaintain()呼び出し
- 大量キュー: 数百〜数千アイテムに対応

## セキュリティ考慮事項

- キャンセル権限: Item.CANCEL必須
- 認証情報: QueueItemAuthenticatorで実行時認証管理
- 表示制御: 権限に基づくキュー表示フィルタ

## 備考

- キューアイテムには一意のID（long）が割り当てられる
- leftItemsはキャッシュで5分間保持
- ConsistentHashによるノード選択がデフォルト

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Queueクラスの主要なコレクションフィールドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Queue.java | `core/src/main/java/hudson/model/Queue.java` | waitingList（193行目）、blockedProjects（202行目）、buildables（209行目）、pendings（215行目）を確認 |
| 1-2 | Queue.java | `core/src/main/java/hudson/model/Queue.java` | leftItems（224行目）のキャッシュ設定を確認 |

**読解のコツ**: キューの4つの状態（waiting→blocked/buildable→pending→left）を意識してフィールドを読む。

#### Step 2: ジョブオファーを理解する

エグゼキュータとのマッチングメカニズムを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Queue.java | `core/src/main/java/hudson/model/Queue.java` | JobOffer内部クラス（235行目以降）の構造 |
| 2-2 | Queue.java | `core/src/main/java/hudson/model/Queue.java` | getCauseOfBlockage()（274行目以降）でブロック理由を確認 |

**主要処理フロー**:
1. **235-236行目**: JobOfferクラスとexecutorフィールド
2. **241行目**: workUnitフィールドで割り当てられたワーク管理
3. **248-253行目**: set()でワークユニット設定とExecutor開始
4. **274-300行目**: getCauseOfBlockage()でノード能力チェック

#### Step 3: アイテム状態遷移を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Queue.java | `core/src/main/java/hudson/model/Queue.java` | Itemクラス階層（WaitingItem, BlockedItem, BuildableItem）を確認 |

### プログラム呼び出し階層図

```
Queue
    │
    ├─ waitingList (Set<WaitingItem>)
    │      └─ 待機時間経過待ち
    │
    ├─ blockedProjects (ItemList<BlockedItem>)
    │      └─ リソース/条件待ち
    │
    ├─ buildables (ItemList<BuildableItem>)
    │      └─ Executor待ち
    │
    ├─ pendings (ItemList<BuildableItem>)
    │      └─ 実行開始待ち
    │
    └─ leftItems (Cache<Long, LeftItem>)
           └─ 完了/キャンセル済み（5分キャッシュ）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

scheduleBuild() ─────────▶ WaitingItem生成 ───────────▶ waitingList
                                │
                                ▼ (quietPeriod経過)
                          ┌─────┴─────┐
                          ▼           ▼
             blockedProjects    buildables
                          │           │
                          └─────┬─────┘
                                ▼ (Executor空き)
                           pendings
                                │
                                ▼
                           Executor.start()
                                │
                                ▼
                           leftItems
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Queue.java | `core/src/main/java/hudson/model/Queue.java` | ソース | キュー管理コアクラス |
| LoadBalancer.java | `core/src/main/java/hudson/model/LoadBalancer.java` | ソース | 負荷分散戦略 |
| QueueTaskDispatcher.java | `core/src/main/java/hudson/model/queue/QueueTaskDispatcher.java` | ソース | タスクディスパッチャー |
| CauseOfBlockage.java | `core/src/main/java/hudson/model/queue/CauseOfBlockage.java` | ソース | ブロック理由 |
| QueueListener.java | `core/src/main/java/hudson/model/queue/QueueListener.java` | ソース | キューリスナー |
| QueueSorter.java | `core/src/main/java/hudson/model/queue/QueueSorter.java` | ソース | キューソート戦略 |
| index.jelly | `core/src/main/resources/hudson/model/Queue/index.jelly` | テンプレート | キュー表示画面 |
