# 機能設計書 70-初期化フレームワーク

## 概要

本ドキュメントは、Jenkins の起動時初期化処理を管理するフレームワーク（InitMilestone、Initializer）の設計について記述する。

### 本機能の処理概要

初期化フレームワークは、Jenkins 起動時の各種初期化処理を順序立てて実行するための基盤機能である。マイルストーンによる段階的な初期化と、アノテーションベースの初期化タスク定義を提供する。

**業務上の目的・背景**：Jenkins の起動処理は、プラグインの読み込み、設定ファイルの読み込み、ジョブの読み込みなど、多数の初期化タスクで構成される。これらのタスクには依存関係があり、適切な順序で実行する必要がある。初期化フレームワークは、タスク間の依存関係を宣言的に定義し、Reactor パターンで効率的に実行することで、起動時間の短縮と安定した初期化を実現する。

**機能の利用シーン**：
- Jenkins コア起動時の初期化
- プラグインの初期化処理
- 設定ファイルの読み込み
- ジョブと履歴データの読み込み
- 拡張ポイントの初期化
- 起動後のカスタム初期化処理

**主要な処理内容**：
1. InitMilestone による初期化段階の定義
2. @Initializer アノテーションによるタスク登録
3. 依存関係（before/after/requires/attains）の解決
4. Reactor パターンによるタスク実行
5. 致命的エラー時の起動中止
6. 初期化進捗の追跡

**関連システム・外部連携**：
- Reactor: タスク依存関係の解決と実行
- PluginManager: プラグイン読み込み
- Jenkins: コア初期化
- annotation-indexer: アノテーションベースのタスク検出

**権限による制御**：初期化フレームワーク自体には権限制御はない（起動時処理のため）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | 起動時処理のため画面操作なし |

## 機能種別

システム基盤 / 起動制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| after | InitMilestone | No | このマイルストーン後に実行 | 有効な InitMilestone |
| before | InitMilestone | No | このマイルストーン前に実行 | 有効な InitMilestone |
| requires | String[] | No | 必要なマイルストーン名 | - |
| attains | String[] | No | 達成するマイルストーン名 | - |
| fatal | boolean | No | 失敗時に起動中止（デフォルト true） | - |

### 入力データソース

- @Initializer アノテーション付きメソッド
- InitMilestone 列挙型

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| milestone | InitMilestone | 達成されたマイルストーン |

### 出力先

- Jenkins 初期化状態
- 起動ログ

## 処理フロー

### 処理シーケンス

```
1. InitMilestone の順序付け
   └─ ordering() で STARTED → COMPLETED の順序を定義

2. @Initializer アノテーションの検出
   └─ annotation-indexer でアノテーション付きメソッドを検出

3. 依存関係の解決
   └─ after/before/requires/attains から依存グラフを構築

4. タスクの実行
   └─ Reactor でタスクを順次実行
   └─ マイルストーンごとに処理を区切る

5. エラーハンドリング
   └─ fatal=true のタスク失敗時は起動中止
   └─ fatal=false のタスク失敗時は警告ログ出力

6. 完了通知
   └─ COMPLETED マイルストーン達成で初期化完了
```

### フローチャート

```mermaid
flowchart TD
    A[Jenkins 起動] --> B[STARTED]
    B --> C[PLUGINS_LISTED]
    C --> D[PLUGINS_PREPARED]
    D --> E[PLUGINS_STARTED]
    E --> F[EXTENSIONS_AUGMENTED]
    F --> G[SYSTEM_CONFIG_LOADED]
    G --> H[SYSTEM_CONFIG_ADAPTED]
    H --> I[JOB_LOADED]
    I --> J[JOB_CONFIG_ADAPTED]
    J --> K[COMPLETED]

    subgraph 各マイルストーン間
        L[@Initializer タスク]
        M{fatal?}
        N[次のマイルストーンへ]
        O[起動中止]
        P[警告ログ]

        L --> M
        M -->|成功| N
        M -->|失敗&true| O
        M -->|失敗&false| P
        P --> N
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-70-01 | マイルストーン順序 | STARTED から COMPLETED まで順番に達成される | 常時 |
| BR-70-02 | 致命的エラー | fatal=true のタスク失敗は起動を中止させる | デフォルト |
| BR-70-03 | 非致命的エラー | fatal=false のタスク失敗は警告のみ | 明示指定時 |
| BR-70-04 | インスタンスメソッド | インスタンスメソッドの @Initializer は @Extension クラスで PLUGINS_PREPARED 以降 | インスタンスメソッド使用時 |

### 計算ロジック

**マイルストーン順序**:
1. STARTED - 初期化開始
2. PLUGINS_LISTED - プラグインメタデータ検査完了
3. PLUGINS_PREPARED - プラグインクラスローダー準備完了
4. PLUGINS_STARTED - プラグイン実行開始、拡張ポイント読み込み完了
5. EXTENSIONS_AUGMENTED - プログラム的な拡張ポイント追加完了
6. SYSTEM_CONFIG_LOADED - システム設定読み込み完了
7. SYSTEM_CONFIG_ADAPTED - システム設定適用完了
8. JOB_LOADED - ジョブ・ビルド履歴読み込み完了
9. JOB_CONFIG_ADAPTED - ジョブ設定適用完了
10. COMPLETED - 初期化完了（GroovyInitScript 含む）

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（初期化フレームワーク自体はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RuntimeException | 実行時エラー | 初期化タスクでの例外 | fatal に応じて起動中止または警告 |

### リトライ仕様

リトライなし。失敗時は fatal の設定に応じて処理。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 起動時間の短縮のため、可能な限り並列実行
- 依存関係を考慮した最適な実行順序

## セキュリティ考慮事項

- 初期化タスクはシステム権限で実行される
- プラグインの初期化タスクは信頼されるコードとして扱われる

## 備考

- InitMilestone は Milestone インターフェースを実装する列挙型
- @Initializer は @Indexed アノテーションで自動検出される
- Reactor ライブラリ（org.jvnet.hudson.reactor）を使用
- GroovyInitScript は COMPLETED マイルストーンで実行される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: マイルストーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InitMilestone.java | `core/src/main/java/hudson/init/InitMilestone.java` | InitMilestone 列挙型の構造（56-145行目） |

**読解のコツ**: InitMilestone は Milestone インターフェースを実装する列挙型。各マイルストーンは message フィールドを持ち、進捗表示に使用される。

#### Step 2: アノテーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Initializer.java | `core/src/main/java/hudson/init/Initializer.java` | @Initializer アノテーションの構造（61-105行目） |

**主要処理フロー**:
1. **69行目**: after() - 実行前提マイルストーン（デフォルト STARTED）
2. **78行目**: before() - 実行期限マイルストーン（デフォルト COMPLETED）
3. **83行目**: requires() - 必要なカスタムマイルストーン
4. **91行目**: attains() - 達成するカスタムマイルストーン
5. **97行目**: displayName() - 進捗表示用の名前
6. **104行目**: fatal() - 失敗時の動作（デフォルト true）

#### Step 3: マイルストーン順序を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | InitMilestone.java | `core/src/main/java/hudson/init/InitMilestone.java` | ordering() メソッド（132-138行目） |

**主要処理フロー**:
- **133行目**: TaskGraphBuilder の生成
- **134行目**: values() で全マイルストーンを取得
- **135-136行目**: 連続するマイルストーン間にダミータスクを追加

### プログラム呼び出し階層図

```
Jenkins 起動
    │
    ├─ InitMilestone.ordering()
    │      └─ TaskGraphBuilder でマイルストーン間の依存関係を定義
    │
    ├─ @Initializer アノテーション検出
    │      └─ annotation-indexer でメソッドを検出
    │
    ├─ Reactor 構築
    │      ├─ after/before から依存関係設定
    │      └─ requires/attains からカスタム依存関係設定
    │
    └─ Reactor.execute()
           │
           ├─ STARTED
           │      └─ @Initializer(after=STARTED) タスク実行
           │
           ├─ PLUGINS_LISTED
           │      └─ プラグインメタデータ検査
           │
           ├─ PLUGINS_PREPARED
           │      └─ クラスローダー準備
           │
           ├─ PLUGINS_STARTED
           │      └─ 拡張ポイント読み込み
           │
           ├─ EXTENSIONS_AUGMENTED
           │      └─ プログラム的拡張追加
           │
           ├─ SYSTEM_CONFIG_LOADED
           │      └─ システム設定読み込み
           │
           ├─ SYSTEM_CONFIG_ADAPTED
           │      └─ 設定適用（CasC等）
           │
           ├─ JOB_LOADED
           │      └─ ジョブ・ビルド履歴読み込み
           │
           ├─ JOB_CONFIG_ADAPTED
           │      └─ ジョブ設定適用
           │
           └─ COMPLETED
                  └─ GroovyInitScript 実行
```

### データフロー図

```
[入力]                      [処理]                           [出力]

@Initializer ────────▶ annotation-indexer ────▶ タスク検出
                              │
                              ▼
InitMilestone ───────▶ ordering() ────────────▶ マイルストーン順序
                              │
                              ▼
                       Reactor 構築
                              │
                              ▼
after/before ────────▶ 依存関係解決 ──────────▶ タスク実行順序
                              │
                              ▼
                       タスク実行
                              │
                              ▼
fatal 設定 ──────────▶ エラーハンドリング ───▶ 起動継続/中止
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InitMilestone.java | `core/src/main/java/hudson/init/InitMilestone.java` | ソース | 初期化マイルストーン定義 |
| Initializer.java | `core/src/main/java/hudson/init/Initializer.java` | ソース | 初期化タスクアノテーション |
| InitializerFinder.java | `core/src/main/java/hudson/init/InitializerFinder.java` | ソース | アノテーション検出 |
| InitReactorRunner.java | `core/src/main/java/hudson/init/InitReactorRunner.java` | ソース | Reactor 実行制御 |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | 起動処理の呼び出し元 |
| GroovyInitScript.java | `core/src/main/java/hudson/init/impl/GroovyInitScript.java` | ソース | Groovy 初期化スクリプト |
