# 機能設計書 9-コントローラーノード

## 概要

本ドキュメントは、Jenkinsのマスターノード（コントローラーノード）の機能設計を記述する。全体の管理とジョブのスケジューリングを担当し、Jenkinsシステムの中心として機能する。

### 本機能の処理概要

コントローラーノードは、jenkins.model.Jenkinsクラス自体がNodeを継承しており、ビルトインノードとしても機能する。システム全体の管理機能と、オプションでビルド実行機能の両方を持つ。

**業務上の目的・背景**：Jenkinsシステムでは、全体を統括するコントローラー（旧称マスター）が必要である。コントローラーはジョブの設定管理、スケジューリング、UIの提供を行い、必要に応じてビルド実行も担う。小規模環境ではコントローラーのみでCI/CDを運用することも可能。

**機能の利用シーン**：Jenkinsシステムの管理、ジョブ設定、ビルドのスケジューリング、小規模プロジェクトでのビルド実行、エージェントが不要な軽量タスクの実行。

**主要な処理内容**：
1. システム全体の設定管理（config.xml）
2. ジョブ・ビュー・ノードの管理
3. ビルドキューの管理とスケジューリング
4. ビルトインノードとしてのエグゼキュータ提供
5. Webインターフェースの提供
6. プラグイン管理
7. セキュリティ（認証・認可）の管理

**関連システム・外部連携**：エージェントノード、プラグイン、外部SCM、認証プロバイダー。

**権限による制御**：ADMINISTER権限でシステム設定変更、各Item権限でジョブ操作。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | システム設定 | 主画面 | コア設定の管理 |
| 30 | エグゼキュータ設定 | 主画面 | マスターノード設定 |
| 31 | システム情報 | 参照画面 | システム情報の表示 |

## 機能種別

ノード管理 / システム管理 / ビルド実行基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| numExecutors | int | No | ビルトインノードのエグゼキュータ数 | 0以上 |
| mode | Mode | No | ジョブ割り当てモード（NORMAL/EXCLUSIVE） | enum値 |
| label | String | No | ノードラベル | 空白区切り文字列 |

### 入力データソース

- config.xml: システム設定ファイル
- Web画面: 管理画面からの設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| numExecutors | int | エグゼキュータ数 |
| mode | Mode | 割り当てモード |
| labelString | String | ラベル文字列 |
| nodeProperties | List<NodeProperty> | ノードプロパティ |

### 出力先

- config.xml: 設定の永続化
- Webインターフェース: 管理画面
- REST API: /api/json

## 処理フロー

### 処理シーケンス

```
1. Jenkins起動
   ├─ Jenkinsインスタンス生成
   ├─ ビルトインノードとして自身を登録
   └─ エグゼキュータ生成（numExecutors分）
2. ビルド受け入れ
   ├─ mode に基づくジョブフィルタリング
   ├─ label マッチング
   └─ エグゼキュータへの割り当て
3. 設定変更
   ├─ numExecutors 変更時はエグゼキュータ調整
   └─ mode/label 変更の反映
```

### フローチャート

```mermaid
flowchart TD
    A[Jenkins起動] --> B[Jenkinsインスタンス生成]
    B --> C[ビルトインノード初期化]
    C --> D[エグゼキュータ生成]
    D --> E[サービス開始]

    F[ビルド要求] --> G{mode確認}
    G -->|NORMAL| H[すべてのジョブ受け入れ]
    G -->|EXCLUSIVE| I{ラベルマッチ?}
    I -->|Yes| H
    I -->|No| J[拒否]
    H --> K[エグゼキュータ割り当て]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ビルトイン実行 | numExecutors=0でビルド実行無効化 | 常時 |
| BR-002 | EXCLUSIVE モード | ラベル指定ジョブのみ受け入れ | mode=EXCLUSIVE時 |
| BR-003 | 自己参照防止 | コントローラーは自身をslaveとして登録不可 | ノード登録時 |
| BR-004 | 名前規約 | ビルトインノードの名前は空文字列 | 常時 |

### 計算ロジック

- ラベルマッチング: Label.matches(Node)によるマッチング

## データベース操作仕様

ファイルベースの永続化を使用。

### ファイル操作一覧

| 操作 | 対象ファイル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | config.xml | 書き込み | システム設定全体 |
| 設定読込 | config.xml | 読み取り | 起動時の設定復元 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FormException | 無効な設定値 | 正しい値を入力 |
| - | IOException | 設定保存失敗 | ファイルシステム確認 |

### リトライ仕様

設定エラーは即時フィードバック。リトライなし。

## トランザクション仕様

設定変更はconfig.xmlへのアトミック書き込み。

## パフォーマンス要件

- エグゼキュータ調整: 即時反映
- 設定保存: 数百ミリ秒以内

## セキュリティ考慮事項

- 設定変更: ADMINISTER権限必須
- ビルト実行: ジョブ権限に依存
- セキュリティ推奨: numExecutors=0で専用エージェント使用

## 備考

- 2016年に"master"から"controller"/"built-in"への名称変更
- nodeRenameMigrationNeededフラグで移行状態管理
- JenkinsクラスはNodeを間接的に実装（AbstractCIBase経由）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Jenkinsクラスのノード機能を理解する

JenkinsがNodeとして機能する部分を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | numExecutors（400行目）、mode（405行目）、label（667行目）を確認 |
| 1-2 | AbstractCIBase.java | `core/src/main/java/hudson/model/AbstractCIBase.java` | JenkinsがNodeインターフェースを実装する基盤 |

**読解のコツ**: JenkinsクラスはAbstractCIBaseを継承し、Node関連メソッドの多くはそこで実装されている。

#### Step 2: ビルトインノードの特殊性を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | nodeNameAndSelfLabelOverride（669行目）でノード名のオーバーライド |

**主要処理フロー**:
1. **400行目**: numExecutors（デフォルト2）
2. **405行目**: mode（デフォルトNORMAL）
3. **667行目**: label（空白区切りのラベル）
4. **669行目**: ノード名のシステムプロパティによるオーバーライド

#### Step 3: エグゼキュータ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | setNumExecutors()メソッドでのエグゼキュータ数変更処理 |

### プログラム呼び出し階層図

```
Jenkins (コントローラーノード)
    │
    ├─ extends AbstractCIBase
    │      └─ implements Node (間接的)
    │
    ├─ numExecutors (ビルトインエグゼキュータ数)
    │      └─ デフォルト2
    │
    ├─ mode (NORMAL/EXCLUSIVE)
    │      └─ ジョブ割り当て戦略
    │
    ├─ label (ノードラベル)
    │      └─ ジョブマッチング用
    │
    └─ nodeProperties (ノードプロパティ)
           └─ 環境変数等の設定
```

### データフロー図

```
[入力]                      [処理]                           [出力]

config.xml ─────────────▶ 設定読み込み ──────────────▶ Jenkins設定
                                │
                                ▼
numExecutors ───────────▶ エグゼキュータ生成 ────────▶ Computer.executors
                                │
                                ▼
ビルド要求 ─────────────▶ mode/labelチェック ────────▶ 受け入れ/拒否
                                │
                                ▼
受け入れ ──────────────▶ Executor割り当て ──────────▶ ビルド実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | コントローラー実装 |
| AbstractCIBase.java | `core/src/main/java/hudson/model/AbstractCIBase.java` | ソース | CI基盤クラス |
| Node.java | `core/src/main/java/hudson/model/Node.java` | ソース | ノードインターフェース |
| Computer.java | `core/src/main/java/hudson/model/Computer.java` | ソース | コンピューター管理 |
| configure.jelly | `core/src/main/resources/jenkins/model/Jenkins/configure.jelly` | テンプレート | 設定画面 |
